package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteWebCacheCustomRule invokes the ddoscoo.DeleteWebCacheCustomRule API synchronously
func (client *Client) DeleteWebCacheCustomRule(request *DeleteWebCacheCustomRuleRequest) (response *DeleteWebCacheCustomRuleResponse, err error) {
	response = CreateDeleteWebCacheCustomRuleResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteWebCacheCustomRuleWithChan invokes the ddoscoo.DeleteWebCacheCustomRule API asynchronously
func (client *Client) DeleteWebCacheCustomRuleWithChan(request *DeleteWebCacheCustomRuleRequest) (<-chan *DeleteWebCacheCustomRuleResponse, <-chan error) {
	responseChan := make(chan *DeleteWebCacheCustomRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteWebCacheCustomRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteWebCacheCustomRuleWithCallback invokes the ddoscoo.DeleteWebCacheCustomRule API asynchronously
func (client *Client) DeleteWebCacheCustomRuleWithCallback(request *DeleteWebCacheCustomRuleRequest, callback func(response *DeleteWebCacheCustomRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteWebCacheCustomRuleResponse
		var err error
		defer close(result)
		response, err = client.DeleteWebCacheCustomRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteWebCacheCustomRuleRequest is the request struct for api DeleteWebCacheCustomRule
type DeleteWebCacheCustomRuleRequest struct {
	*requests.RpcRequest
	ResourceGroupId string    `position:"Query" name:"ResourceGroupId"`
	SourceIp        string    `position:"Query" name:"SourceIp"`
	RuleNames       *[]string `position:"Query" name:"RuleNames"  type:"Repeated"`
	Domain          string    `position:"Query" name:"Domain"`
}

// DeleteWebCacheCustomRuleResponse is the response struct for api DeleteWebCacheCustomRule
type DeleteWebCacheCustomRuleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteWebCacheCustomRuleRequest creates a request to invoke DeleteWebCacheCustomRule API
func CreateDeleteWebCacheCustomRuleRequest() (request *DeleteWebCacheCustomRuleRequest) {
	request = &DeleteWebCacheCustomRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "DeleteWebCacheCustomRule", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteWebCacheCustomRuleResponse creates a response to parse from DeleteWebCacheCustomRule response
func CreateDeleteWebCacheCustomRuleResponse() (response *DeleteWebCacheCustomRuleResponse) {
	response = &DeleteWebCacheCustomRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
