package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ConfigNetworkRules invokes the ddoscoo.ConfigNetworkRules API synchronously
func (client *Client) ConfigNetworkRules(request *ConfigNetworkRulesRequest) (response *ConfigNetworkRulesResponse, err error) {
	response = CreateConfigNetworkRulesResponse()
	err = client.DoAction(request, response)
	return
}

// ConfigNetworkRulesWithChan invokes the ddoscoo.ConfigNetworkRules API asynchronously
func (client *Client) ConfigNetworkRulesWithChan(request *ConfigNetworkRulesRequest) (<-chan *ConfigNetworkRulesResponse, <-chan error) {
	responseChan := make(chan *ConfigNetworkRulesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ConfigNetworkRules(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ConfigNetworkRulesWithCallback invokes the ddoscoo.ConfigNetworkRules API asynchronously
func (client *Client) ConfigNetworkRulesWithCallback(request *ConfigNetworkRulesRequest, callback func(response *ConfigNetworkRulesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ConfigNetworkRulesResponse
		var err error
		defer close(result)
		response, err = client.ConfigNetworkRules(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ConfigNetworkRulesRequest is the request struct for api ConfigNetworkRules
type ConfigNetworkRulesRequest struct {
	*requests.RpcRequest
	NetworkRules string `position:"Query" name:"NetworkRules"`
	SourceIp     string `position:"Query" name:"SourceIp"`
}

// ConfigNetworkRulesResponse is the response struct for api ConfigNetworkRules
type ConfigNetworkRulesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateConfigNetworkRulesRequest creates a request to invoke ConfigNetworkRules API
func CreateConfigNetworkRulesRequest() (request *ConfigNetworkRulesRequest) {
	request = &ConfigNetworkRulesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "ConfigNetworkRules", "", "")
	request.Method = requests.POST
	return
}

// CreateConfigNetworkRulesResponse creates a response to parse from ConfigNetworkRules response
func CreateConfigNetworkRulesResponse() (response *ConfigNetworkRulesResponse) {
	response = &ConfigNetworkRulesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
