package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeUserDcdnIpaStatus invokes the dcdn.DescribeUserDcdnIpaStatus API synchronously
func (client *Client) DescribeUserDcdnIpaStatus(request *DescribeUserDcdnIpaStatusRequest) (response *DescribeUserDcdnIpaStatusResponse, err error) {
	response = CreateDescribeUserDcdnIpaStatusResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeUserDcdnIpaStatusWithChan invokes the dcdn.DescribeUserDcdnIpaStatus API asynchronously
func (client *Client) DescribeUserDcdnIpaStatusWithChan(request *DescribeUserDcdnIpaStatusRequest) (<-chan *DescribeUserDcdnIpaStatusResponse, <-chan error) {
	responseChan := make(chan *DescribeUserDcdnIpaStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeUserDcdnIpaStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeUserDcdnIpaStatusWithCallback invokes the dcdn.DescribeUserDcdnIpaStatus API asynchronously
func (client *Client) DescribeUserDcdnIpaStatusWithCallback(request *DescribeUserDcdnIpaStatusRequest, callback func(response *DescribeUserDcdnIpaStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeUserDcdnIpaStatusResponse
		var err error
		defer close(result)
		response, err = client.DescribeUserDcdnIpaStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeUserDcdnIpaStatusRequest is the request struct for api DescribeUserDcdnIpaStatus
type DescribeUserDcdnIpaStatusRequest struct {
	*requests.RpcRequest
	OwnerId       requests.Integer `position:"Query" name:"OwnerId"`
	SecurityToken string           `position:"Query" name:"SecurityToken"`
}

// DescribeUserDcdnIpaStatusResponse is the response struct for api DescribeUserDcdnIpaStatus
type DescribeUserDcdnIpaStatusResponse struct {
	*responses.BaseResponse
	InDebt        bool   `json:"InDebt" xml:"InDebt"`
	OnService     bool   `json:"OnService" xml:"OnService"`
	RequestId     string `json:"RequestId" xml:"RequestId"`
	InDebtOverdue bool   `json:"InDebtOverdue" xml:"InDebtOverdue"`
	Enabled       bool   `json:"Enabled" xml:"Enabled"`
}

// CreateDescribeUserDcdnIpaStatusRequest creates a request to invoke DescribeUserDcdnIpaStatus API
func CreateDescribeUserDcdnIpaStatusRequest() (request *DescribeUserDcdnIpaStatusRequest) {
	request = &DescribeUserDcdnIpaStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DescribeUserDcdnIpaStatus", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeUserDcdnIpaStatusResponse creates a response to parse from DescribeUserDcdnIpaStatus response
func CreateDescribeUserDcdnIpaStatusResponse() (response *DescribeUserDcdnIpaStatusResponse) {
	response = &DescribeUserDcdnIpaStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
