package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDcdnWafPolicyValidDomains invokes the dcdn.DescribeDcdnWafPolicyValidDomains API synchronously
func (client *Client) DescribeDcdnWafPolicyValidDomains(request *DescribeDcdnWafPolicyValidDomainsRequest) (response *DescribeDcdnWafPolicyValidDomainsResponse, err error) {
	response = CreateDescribeDcdnWafPolicyValidDomainsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDcdnWafPolicyValidDomainsWithChan invokes the dcdn.DescribeDcdnWafPolicyValidDomains API asynchronously
func (client *Client) DescribeDcdnWafPolicyValidDomainsWithChan(request *DescribeDcdnWafPolicyValidDomainsRequest) (<-chan *DescribeDcdnWafPolicyValidDomainsResponse, <-chan error) {
	responseChan := make(chan *DescribeDcdnWafPolicyValidDomainsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDcdnWafPolicyValidDomains(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDcdnWafPolicyValidDomainsWithCallback invokes the dcdn.DescribeDcdnWafPolicyValidDomains API asynchronously
func (client *Client) DescribeDcdnWafPolicyValidDomainsWithCallback(request *DescribeDcdnWafPolicyValidDomainsRequest, callback func(response *DescribeDcdnWafPolicyValidDomainsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDcdnWafPolicyValidDomainsResponse
		var err error
		defer close(result)
		response, err = client.DescribeDcdnWafPolicyValidDomains(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDcdnWafPolicyValidDomainsRequest is the request struct for api DescribeDcdnWafPolicyValidDomains
type DescribeDcdnWafPolicyValidDomainsRequest struct {
	*requests.RpcRequest
	DefenseScene   string           `position:"Query" name:"DefenseScene"`
	DomainNameLike string           `position:"Query" name:"DomainNameLike"`
	PageSize       requests.Integer `position:"Query" name:"PageSize"`
	PageNumber     requests.Integer `position:"Query" name:"PageNumber"`
}

// DescribeDcdnWafPolicyValidDomainsResponse is the response struct for api DescribeDcdnWafPolicyValidDomains
type DescribeDcdnWafPolicyValidDomainsResponse struct {
	*responses.BaseResponse
	PageSize   int          `json:"PageSize" xml:"PageSize"`
	RequestId  string       `json:"RequestId" xml:"RequestId"`
	PageNumber int          `json:"PageNumber" xml:"PageNumber"`
	TotalCount int          `json:"TotalCount" xml:"TotalCount"`
	Domains    []DomainItem `json:"Domains" xml:"Domains"`
}

// CreateDescribeDcdnWafPolicyValidDomainsRequest creates a request to invoke DescribeDcdnWafPolicyValidDomains API
func CreateDescribeDcdnWafPolicyValidDomainsRequest() (request *DescribeDcdnWafPolicyValidDomainsRequest) {
	request = &DescribeDcdnWafPolicyValidDomainsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DescribeDcdnWafPolicyValidDomains", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDcdnWafPolicyValidDomainsResponse creates a response to parse from DescribeDcdnWafPolicyValidDomains response
func CreateDescribeDcdnWafPolicyValidDomainsResponse() (response *DescribeDcdnWafPolicyValidDomainsResponse) {
	response = &DescribeDcdnWafPolicyValidDomainsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
