package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateNodeOwner invokes the dataworks_public.UpdateNodeOwner API synchronously
func (client *Client) UpdateNodeOwner(request *UpdateNodeOwnerRequest) (response *UpdateNodeOwnerResponse, err error) {
	response = CreateUpdateNodeOwnerResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateNodeOwnerWithChan invokes the dataworks_public.UpdateNodeOwner API asynchronously
func (client *Client) UpdateNodeOwnerWithChan(request *UpdateNodeOwnerRequest) (<-chan *UpdateNodeOwnerResponse, <-chan error) {
	responseChan := make(chan *UpdateNodeOwnerResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateNodeOwner(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateNodeOwnerWithCallback invokes the dataworks_public.UpdateNodeOwner API asynchronously
func (client *Client) UpdateNodeOwnerWithCallback(request *UpdateNodeOwnerRequest, callback func(response *UpdateNodeOwnerResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateNodeOwnerResponse
		var err error
		defer close(result)
		response, err = client.UpdateNodeOwner(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateNodeOwnerRequest is the request struct for api UpdateNodeOwner
type UpdateNodeOwnerRequest struct {
	*requests.RpcRequest
	ProjectEnv string           `position:"Body" name:"ProjectEnv"`
	NodeId     requests.Integer `position:"Body" name:"NodeId"`
	UserId     string           `position:"Body" name:"UserId"`
}

// UpdateNodeOwnerResponse is the response struct for api UpdateNodeOwner
type UpdateNodeOwnerResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateNodeOwnerRequest creates a request to invoke UpdateNodeOwner API
func CreateUpdateNodeOwnerRequest() (request *UpdateNodeOwnerRequest) {
	request = &UpdateNodeOwnerRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "UpdateNodeOwner", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateNodeOwnerResponse creates a response to parse from UpdateNodeOwner response
func CreateUpdateNodeOwnerResponse() (response *UpdateNodeOwnerResponse) {
	response = &UpdateNodeOwnerResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
