package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// OfflineNode invokes the dataworks_public.OfflineNode API synchronously
func (client *Client) OfflineNode(request *OfflineNodeRequest) (response *OfflineNodeResponse, err error) {
	response = CreateOfflineNodeResponse()
	err = client.DoAction(request, response)
	return
}

// OfflineNodeWithChan invokes the dataworks_public.OfflineNode API asynchronously
func (client *Client) OfflineNodeWithChan(request *OfflineNodeRequest) (<-chan *OfflineNodeResponse, <-chan error) {
	responseChan := make(chan *OfflineNodeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.OfflineNode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// OfflineNodeWithCallback invokes the dataworks_public.OfflineNode API asynchronously
func (client *Client) OfflineNodeWithCallback(request *OfflineNodeRequest, callback func(response *OfflineNodeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *OfflineNodeResponse
		var err error
		defer close(result)
		response, err = client.OfflineNode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// OfflineNodeRequest is the request struct for api OfflineNode
type OfflineNodeRequest struct {
	*requests.RpcRequest
	NodeId    requests.Integer `position:"Body" name:"NodeId"`
	ProjectId requests.Integer `position:"Body" name:"ProjectId"`
}

// OfflineNodeResponse is the response struct for api OfflineNode
type OfflineNodeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   string `json:"Success" xml:"Success"`
}

// CreateOfflineNodeRequest creates a request to invoke OfflineNode API
func CreateOfflineNodeRequest() (request *OfflineNodeRequest) {
	request = &OfflineNodeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "OfflineNode", "", "")
	request.Method = requests.POST
	return
}

// CreateOfflineNodeResponse creates a response to parse from OfflineNode response
func CreateOfflineNodeResponse() (response *OfflineNodeResponse) {
	response = &OfflineNodeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
