package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetBaseline invokes the dataworks_public.GetBaseline API synchronously
func (client *Client) GetBaseline(request *GetBaselineRequest) (response *GetBaselineResponse, err error) {
	response = CreateGetBaselineResponse()
	err = client.DoAction(request, response)
	return
}

// GetBaselineWithChan invokes the dataworks_public.GetBaseline API asynchronously
func (client *Client) GetBaselineWithChan(request *GetBaselineRequest) (<-chan *GetBaselineResponse, <-chan error) {
	responseChan := make(chan *GetBaselineResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetBaseline(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetBaselineWithCallback invokes the dataworks_public.GetBaseline API asynchronously
func (client *Client) GetBaselineWithCallback(request *GetBaselineRequest, callback func(response *GetBaselineResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetBaselineResponse
		var err error
		defer close(result)
		response, err = client.GetBaseline(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetBaselineRequest is the request struct for api GetBaseline
type GetBaselineRequest struct {
	*requests.RpcRequest
	ProjectId  requests.Integer `position:"Body" name:"ProjectId"`
	BaselineId requests.Integer `position:"Body" name:"BaselineId"`
}

// GetBaselineResponse is the response struct for api GetBaseline
type GetBaselineResponse struct {
	*responses.BaseResponse
	Success             bool   `json:"Success" xml:"Success"`
	ErrorCode           string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage        string `json:"ErrorMessage" xml:"ErrorMessage"`
	HttpStatusCode      int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	RequestId           string `json:"RequestId" xml:"RequestId"`
	DynamicErrorCode    string `json:"DynamicErrorCode" xml:"DynamicErrorCode"`
	DynamicErrorMessage string `json:"DynamicErrorMessage" xml:"DynamicErrorMessage"`
	Data                Data   `json:"Data" xml:"Data"`
}

// CreateGetBaselineRequest creates a request to invoke GetBaseline API
func CreateGetBaselineRequest() (request *GetBaselineRequest) {
	request = &GetBaselineRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "GetBaseline", "", "")
	request.Method = requests.POST
	return
}

// CreateGetBaselineResponse creates a response to parse from GetBaseline response
func CreateGetBaselineResponse() (response *GetBaselineResponse) {
	response = &GetBaselineResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
