package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ChangeResourceManagerResourceGroup invokes the dataworks_public.ChangeResourceManagerResourceGroup API synchronously
func (client *Client) ChangeResourceManagerResourceGroup(request *ChangeResourceManagerResourceGroupRequest) (response *ChangeResourceManagerResourceGroupResponse, err error) {
	response = CreateChangeResourceManagerResourceGroupResponse()
	err = client.DoAction(request, response)
	return
}

// ChangeResourceManagerResourceGroupWithChan invokes the dataworks_public.ChangeResourceManagerResourceGroup API asynchronously
func (client *Client) ChangeResourceManagerResourceGroupWithChan(request *ChangeResourceManagerResourceGroupRequest) (<-chan *ChangeResourceManagerResourceGroupResponse, <-chan error) {
	responseChan := make(chan *ChangeResourceManagerResourceGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ChangeResourceManagerResourceGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ChangeResourceManagerResourceGroupWithCallback invokes the dataworks_public.ChangeResourceManagerResourceGroup API asynchronously
func (client *Client) ChangeResourceManagerResourceGroupWithCallback(request *ChangeResourceManagerResourceGroupRequest, callback func(response *ChangeResourceManagerResourceGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ChangeResourceManagerResourceGroupResponse
		var err error
		defer close(result)
		response, err = client.ChangeResourceManagerResourceGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ChangeResourceManagerResourceGroupRequest is the request struct for api ChangeResourceManagerResourceGroup
type ChangeResourceManagerResourceGroupRequest struct {
	*requests.RpcRequest
	ResourceId                     string `position:"Query" name:"ResourceId"`
	ResourceType                   string `position:"Query" name:"ResourceType"`
	ResourceManagerResourceGroupId string `position:"Query" name:"ResourceManagerResourceGroupId"`
}

// ChangeResourceManagerResourceGroupResponse is the response struct for api ChangeResourceManagerResourceGroup
type ChangeResourceManagerResourceGroupResponse struct {
	*responses.BaseResponse
	Data           bool   `json:"Data" xml:"Data"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Success        bool   `json:"Success" xml:"Success"`
}

// CreateChangeResourceManagerResourceGroupRequest creates a request to invoke ChangeResourceManagerResourceGroup API
func CreateChangeResourceManagerResourceGroupRequest() (request *ChangeResourceManagerResourceGroupRequest) {
	request = &ChangeResourceManagerResourceGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "ChangeResourceManagerResourceGroup", "", "")
	request.Method = requests.POST
	return
}

// CreateChangeResourceManagerResourceGroupResponse creates a response to parse from ChangeResourceManagerResourceGroup response
func CreateChangeResourceManagerResourceGroupResponse() (response *ChangeResourceManagerResourceGroupResponse) {
	response = &ChangeResourceManagerResourceGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
