package config

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateDeliveryChannel invokes the config.UpdateDeliveryChannel API synchronously
func (client *Client) UpdateDeliveryChannel(request *UpdateDeliveryChannelRequest) (response *UpdateDeliveryChannelResponse, err error) {
	response = CreateUpdateDeliveryChannelResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateDeliveryChannelWithChan invokes the config.UpdateDeliveryChannel API asynchronously
func (client *Client) UpdateDeliveryChannelWithChan(request *UpdateDeliveryChannelRequest) (<-chan *UpdateDeliveryChannelResponse, <-chan error) {
	responseChan := make(chan *UpdateDeliveryChannelResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateDeliveryChannel(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateDeliveryChannelWithCallback invokes the config.UpdateDeliveryChannel API asynchronously
func (client *Client) UpdateDeliveryChannelWithCallback(request *UpdateDeliveryChannelRequest, callback func(response *UpdateDeliveryChannelResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateDeliveryChannelResponse
		var err error
		defer close(result)
		response, err = client.UpdateDeliveryChannel(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateDeliveryChannelRequest is the request struct for api UpdateDeliveryChannel
type UpdateDeliveryChannelRequest struct {
	*requests.RpcRequest
	NonCompliantNotification            requests.Boolean `position:"Body" name:"NonCompliantNotification"`
	ClientToken                         string           `position:"Body" name:"ClientToken"`
	ConfigurationSnapshot               requests.Boolean `position:"Body" name:"ConfigurationSnapshot"`
	Description                         string           `position:"Body" name:"Description"`
	DeliveryChannelTargetArn            string           `position:"Body" name:"DeliveryChannelTargetArn"`
	DeliveryChannelCondition            string           `position:"Body" name:"DeliveryChannelCondition"`
	ConfigurationItemChangeNotification requests.Boolean `position:"Body" name:"ConfigurationItemChangeNotification"`
	DeliveryChannelAssumeRoleArn        string           `position:"Body" name:"DeliveryChannelAssumeRoleArn"`
	DeliveryChannelName                 string           `position:"Body" name:"DeliveryChannelName"`
	DeliveryChannelId                   string           `position:"Body" name:"DeliveryChannelId"`
	OversizedDataOSSTargetArn           string           `position:"Body" name:"OversizedDataOSSTargetArn"`
	Status                              requests.Integer `position:"Body" name:"Status"`
}

// UpdateDeliveryChannelResponse is the response struct for api UpdateDeliveryChannel
type UpdateDeliveryChannelResponse struct {
	*responses.BaseResponse
	RequestId         string `json:"RequestId" xml:"RequestId"`
	DeliveryChannelId string `json:"DeliveryChannelId" xml:"DeliveryChannelId"`
}

// CreateUpdateDeliveryChannelRequest creates a request to invoke UpdateDeliveryChannel API
func CreateUpdateDeliveryChannelRequest() (request *UpdateDeliveryChannelRequest) {
	request = &UpdateDeliveryChannelRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Config", "2020-09-07", "UpdateDeliveryChannel", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateDeliveryChannelResponse creates a response to parse from UpdateDeliveryChannel response
func CreateUpdateDeliveryChannelResponse() (response *UpdateDeliveryChannelResponse) {
	response = &UpdateDeliveryChannelResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
