package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteApgroupConfig invokes the cloudwf.DeleteApgroupConfig API synchronously
// api document: https://help.aliyun.com/api/cloudwf/deleteapgroupconfig.html
func (client *Client) DeleteApgroupConfig(request *DeleteApgroupConfigRequest) (response *DeleteApgroupConfigResponse, err error) {
	response = CreateDeleteApgroupConfigResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteApgroupConfigWithChan invokes the cloudwf.DeleteApgroupConfig API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/deleteapgroupconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteApgroupConfigWithChan(request *DeleteApgroupConfigRequest) (<-chan *DeleteApgroupConfigResponse, <-chan error) {
	responseChan := make(chan *DeleteApgroupConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteApgroupConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteApgroupConfigWithCallback invokes the cloudwf.DeleteApgroupConfig API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/deleteapgroupconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteApgroupConfigWithCallback(request *DeleteApgroupConfigRequest, callback func(response *DeleteApgroupConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteApgroupConfigResponse
		var err error
		defer close(result)
		response, err = client.DeleteApgroupConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteApgroupConfigRequest is the request struct for api DeleteApgroupConfig
type DeleteApgroupConfigRequest struct {
	*requests.RpcRequest
	Id requests.Integer `position:"Query" name:"Id"`
}

// DeleteApgroupConfigResponse is the response struct for api DeleteApgroupConfig
type DeleteApgroupConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateDeleteApgroupConfigRequest creates a request to invoke DeleteApgroupConfig API
func CreateDeleteApgroupConfigRequest() (request *DeleteApgroupConfigRequest) {
	request = &DeleteApgroupConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "DeleteApgroupConfig", "cloudwf", "openAPI")
	return
}

// CreateDeleteApgroupConfigResponse creates a response to parse from DeleteApgroupConfig response
func CreateDeleteApgroupConfigResponse() (response *DeleteApgroupConfigResponse) {
	response = &DeleteApgroupConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
