package cloudesl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// VerifyNotificationConfig invokes the cloudesl.VerifyNotificationConfig API synchronously
func (client *Client) VerifyNotificationConfig(request *VerifyNotificationConfigRequest) (response *VerifyNotificationConfigResponse, err error) {
	response = CreateVerifyNotificationConfigResponse()
	err = client.DoAction(request, response)
	return
}

// VerifyNotificationConfigWithChan invokes the cloudesl.VerifyNotificationConfig API asynchronously
func (client *Client) VerifyNotificationConfigWithChan(request *VerifyNotificationConfigRequest) (<-chan *VerifyNotificationConfigResponse, <-chan error) {
	responseChan := make(chan *VerifyNotificationConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.VerifyNotificationConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// VerifyNotificationConfigWithCallback invokes the cloudesl.VerifyNotificationConfig API asynchronously
func (client *Client) VerifyNotificationConfigWithCallback(request *VerifyNotificationConfigRequest, callback func(response *VerifyNotificationConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *VerifyNotificationConfigResponse
		var err error
		defer close(result)
		response, err = client.VerifyNotificationConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// VerifyNotificationConfigRequest is the request struct for api VerifyNotificationConfig
type VerifyNotificationConfigRequest struct {
	*requests.RpcRequest
	GroupId  string `position:"Body" name:"GroupId"`
	Endpoint string `position:"Body" name:"Endpoint"`
	Topic    string `position:"Body" name:"Topic"`
	Tag      string `position:"Body" name:"Tag"`
}

// VerifyNotificationConfigResponse is the response struct for api VerifyNotificationConfig
type VerifyNotificationConfigResponse struct {
	*responses.BaseResponse
	RequestId        string `json:"RequestId" xml:"RequestId"`
	ErrorMessage     string `json:"ErrorMessage" xml:"ErrorMessage"`
	Success          bool   `json:"Success" xml:"Success"`
	ErrorCode        string `json:"ErrorCode" xml:"ErrorCode"`
	Code             string `json:"Code" xml:"Code"`
	Message          string `json:"Message" xml:"Message"`
	DynamicMessage   string `json:"DynamicMessage" xml:"DynamicMessage"`
	DynamicCode      string `json:"DynamicCode" xml:"DynamicCode"`
	Result           bool   `json:"Result" xml:"Result"`
	SendTime         string `json:"SendTime" xml:"SendTime"`
	ExceptionMessage string `json:"ExceptionMessage" xml:"ExceptionMessage"`
}

// CreateVerifyNotificationConfigRequest creates a request to invoke VerifyNotificationConfig API
func CreateVerifyNotificationConfigRequest() (request *VerifyNotificationConfigRequest) {
	request = &VerifyNotificationConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudesl", "2020-02-01", "VerifyNotificationConfig", "", "")
	request.Method = requests.POST
	return
}

// CreateVerifyNotificationConfigResponse creates a response to parse from VerifyNotificationConfig response
func CreateVerifyNotificationConfigResponse() (response *VerifyNotificationConfigResponse) {
	response = &VerifyNotificationConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
