package cloudesl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeItemMaterials invokes the cloudesl.DescribeItemMaterials API synchronously
func (client *Client) DescribeItemMaterials(request *DescribeItemMaterialsRequest) (response *DescribeItemMaterialsResponse, err error) {
	response = CreateDescribeItemMaterialsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeItemMaterialsWithChan invokes the cloudesl.DescribeItemMaterials API asynchronously
func (client *Client) DescribeItemMaterialsWithChan(request *DescribeItemMaterialsRequest) (<-chan *DescribeItemMaterialsResponse, <-chan error) {
	responseChan := make(chan *DescribeItemMaterialsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeItemMaterials(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeItemMaterialsWithCallback invokes the cloudesl.DescribeItemMaterials API asynchronously
func (client *Client) DescribeItemMaterialsWithCallback(request *DescribeItemMaterialsRequest, callback func(response *DescribeItemMaterialsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeItemMaterialsResponse
		var err error
		defer close(result)
		response, err = client.DescribeItemMaterials(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeItemMaterialsRequest is the request struct for api DescribeItemMaterials
type DescribeItemMaterialsRequest struct {
	*requests.RpcRequest
	MaterialName string           `position:"Body" name:"MaterialName"`
	MaterialId   string           `position:"Body" name:"MaterialId"`
	PageNumber   requests.Integer `position:"Body" name:"PageNumber"`
	PageSize     requests.Integer `position:"Body" name:"PageSize"`
	BarCode      string           `position:"Body" name:"BarCode"`
	ItemName     string           `position:"Body" name:"ItemName"`
}

// DescribeItemMaterialsResponse is the response struct for api DescribeItemMaterials
type DescribeItemMaterialsResponse struct {
	*responses.BaseResponse
	TotalCount     int                `json:"TotalCount" xml:"TotalCount"`
	PageNumber     int                `json:"PageNumber" xml:"PageNumber"`
	PageSize       int                `json:"PageSize" xml:"PageSize"`
	RequestId      string             `json:"RequestId" xml:"RequestId"`
	Success        bool               `json:"Success" xml:"Success"`
	Message        string             `json:"Message" xml:"Message"`
	ErrorCode      string             `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage   string             `json:"ErrorMessage" xml:"ErrorMessage"`
	Code           string             `json:"Code" xml:"Code"`
	DynamicCode    string             `json:"DynamicCode" xml:"DynamicCode"`
	DynamicMessage string             `json:"DynamicMessage" xml:"DynamicMessage"`
	Materials      []ItemMaterialInfo `json:"Materials" xml:"Materials"`
}

// CreateDescribeItemMaterialsRequest creates a request to invoke DescribeItemMaterials API
func CreateDescribeItemMaterialsRequest() (request *DescribeItemMaterialsRequest) {
	request = &DescribeItemMaterialsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudesl", "2020-02-01", "DescribeItemMaterials", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeItemMaterialsResponse creates a response to parse from DescribeItemMaterials response
func CreateDescribeItemMaterialsResponse() (response *DescribeItemMaterialsResponse) {
	response = &DescribeItemMaterialsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
