package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ValidNotInUsePhoneNumber invokes the cloudcallcenter.ValidNotInUsePhoneNumber API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/validnotinusephonenumber.html
func (client *Client) ValidNotInUsePhoneNumber(request *ValidNotInUsePhoneNumberRequest) (response *ValidNotInUsePhoneNumberResponse, err error) {
	response = CreateValidNotInUsePhoneNumberResponse()
	err = client.DoAction(request, response)
	return
}

// ValidNotInUsePhoneNumberWithChan invokes the cloudcallcenter.ValidNotInUsePhoneNumber API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/validnotinusephonenumber.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ValidNotInUsePhoneNumberWithChan(request *ValidNotInUsePhoneNumberRequest) (<-chan *ValidNotInUsePhoneNumberResponse, <-chan error) {
	responseChan := make(chan *ValidNotInUsePhoneNumberResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ValidNotInUsePhoneNumber(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ValidNotInUsePhoneNumberWithCallback invokes the cloudcallcenter.ValidNotInUsePhoneNumber API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/validnotinusephonenumber.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ValidNotInUsePhoneNumberWithCallback(request *ValidNotInUsePhoneNumberRequest, callback func(response *ValidNotInUsePhoneNumberResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ValidNotInUsePhoneNumberResponse
		var err error
		defer close(result)
		response, err = client.ValidNotInUsePhoneNumber(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ValidNotInUsePhoneNumberRequest is the request struct for api ValidNotInUsePhoneNumber
type ValidNotInUsePhoneNumberRequest struct {
	*requests.RpcRequest
	PhoneNumber string `position:"Query" name:"PhoneNumber"`
}

// ValidNotInUsePhoneNumberResponse is the response struct for api ValidNotInUsePhoneNumber
type ValidNotInUsePhoneNumberResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	IsNotInUse     bool   `json:"IsNotInUse" xml:"IsNotInUse"`
}

// CreateValidNotInUsePhoneNumberRequest creates a request to invoke ValidNotInUsePhoneNumber API
func CreateValidNotInUsePhoneNumberRequest() (request *ValidNotInUsePhoneNumberRequest) {
	request = &ValidNotInUsePhoneNumberRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "ValidNotInUsePhoneNumber", "", "")
	request.Method = requests.POST
	return
}

// CreateValidNotInUsePhoneNumberResponse creates a response to parse from ValidNotInUsePhoneNumber response
func CreateValidNotInUsePhoneNumberResponse() (response *ValidNotInUsePhoneNumberResponse) {
	response = &ValidNotInUsePhoneNumberResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
