package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GenerateAgentStatisticReport invokes the cloudcallcenter.GenerateAgentStatisticReport API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/generateagentstatisticreport.html
func (client *Client) GenerateAgentStatisticReport(request *GenerateAgentStatisticReportRequest) (response *GenerateAgentStatisticReportResponse, err error) {
	response = CreateGenerateAgentStatisticReportResponse()
	err = client.DoAction(request, response)
	return
}

// GenerateAgentStatisticReportWithChan invokes the cloudcallcenter.GenerateAgentStatisticReport API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/generateagentstatisticreport.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GenerateAgentStatisticReportWithChan(request *GenerateAgentStatisticReportRequest) (<-chan *GenerateAgentStatisticReportResponse, <-chan error) {
	responseChan := make(chan *GenerateAgentStatisticReportResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GenerateAgentStatisticReport(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GenerateAgentStatisticReportWithCallback invokes the cloudcallcenter.GenerateAgentStatisticReport API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/generateagentstatisticreport.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GenerateAgentStatisticReportWithCallback(request *GenerateAgentStatisticReportRequest, callback func(response *GenerateAgentStatisticReportResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GenerateAgentStatisticReportResponse
		var err error
		defer close(result)
		response, err = client.GenerateAgentStatisticReport(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GenerateAgentStatisticReportRequest is the request struct for api GenerateAgentStatisticReport
type GenerateAgentStatisticReportRequest struct {
	*requests.RpcRequest
	AgentId    string           `position:"Query" name:"AgentId"`
	InstanceId string           `position:"Query" name:"InstanceId"`
	EndDate    string           `position:"Query" name:"EndDate"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	StartDate  string           `position:"Query" name:"StartDate"`
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
}

// GenerateAgentStatisticReportResponse is the response struct for api GenerateAgentStatisticReport
type GenerateAgentStatisticReportResponse struct {
	*responses.BaseResponse
	RequestId      string                                 `json:"RequestId" xml:"RequestId"`
	Success        bool                                   `json:"Success" xml:"Success"`
	Code           string                                 `json:"Code" xml:"Code"`
	Message        string                                 `json:"Message" xml:"Message"`
	HttpStatusCode int                                    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	DataList       DataListInGenerateAgentStatisticReport `json:"DataList" xml:"DataList"`
}

// CreateGenerateAgentStatisticReportRequest creates a request to invoke GenerateAgentStatisticReport API
func CreateGenerateAgentStatisticReportRequest() (request *GenerateAgentStatisticReportRequest) {
	request = &GenerateAgentStatisticReportRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "GenerateAgentStatisticReport", "", "")
	request.Method = requests.POST
	return
}

// CreateGenerateAgentStatisticReportResponse creates a response to parse from GenerateAgentStatisticReport response
func CreateGenerateAgentStatisticReportResponse() (response *GenerateAgentStatisticReportResponse) {
	response = &GenerateAgentStatisticReportResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
