package cloudapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddIpControlPolicyItem invokes the cloudapi.AddIpControlPolicyItem API synchronously
func (client *Client) AddIpControlPolicyItem(request *AddIpControlPolicyItemRequest) (response *AddIpControlPolicyItemResponse, err error) {
	response = CreateAddIpControlPolicyItemResponse()
	err = client.DoAction(request, response)
	return
}

// AddIpControlPolicyItemWithChan invokes the cloudapi.AddIpControlPolicyItem API asynchronously
func (client *Client) AddIpControlPolicyItemWithChan(request *AddIpControlPolicyItemRequest) (<-chan *AddIpControlPolicyItemResponse, <-chan error) {
	responseChan := make(chan *AddIpControlPolicyItemResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddIpControlPolicyItem(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddIpControlPolicyItemWithCallback invokes the cloudapi.AddIpControlPolicyItem API asynchronously
func (client *Client) AddIpControlPolicyItemWithCallback(request *AddIpControlPolicyItemRequest, callback func(response *AddIpControlPolicyItemResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddIpControlPolicyItemResponse
		var err error
		defer close(result)
		response, err = client.AddIpControlPolicyItem(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddIpControlPolicyItemRequest is the request struct for api AddIpControlPolicyItem
type AddIpControlPolicyItemRequest struct {
	*requests.RpcRequest
	IpControlId   string `position:"Query" name:"IpControlId"`
	SecurityToken string `position:"Query" name:"SecurityToken"`
	AppId         string `position:"Query" name:"AppId"`
	CidrIp        string `position:"Query" name:"CidrIp"`
}

// AddIpControlPolicyItemResponse is the response struct for api AddIpControlPolicyItem
type AddIpControlPolicyItemResponse struct {
	*responses.BaseResponse
	PolicyItemId string `json:"PolicyItemId" xml:"PolicyItemId"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
}

// CreateAddIpControlPolicyItemRequest creates a request to invoke AddIpControlPolicyItem API
func CreateAddIpControlPolicyItemRequest() (request *AddIpControlPolicyItemRequest) {
	request = &AddIpControlPolicyItemRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudAPI", "2016-07-14", "AddIpControlPolicyItem", "apigateway", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddIpControlPolicyItemResponse creates a response to parse from AddIpControlPolicyItem response
func CreateAddIpControlPolicyItemResponse() (response *AddIpControlPolicyItemResponse) {
	response = &AddIpControlPolicyItemResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
