package cdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DisableRealtimeLogDelivery invokes the cdn.DisableRealtimeLogDelivery API synchronously
func (client *Client) DisableRealtimeLogDelivery(request *DisableRealtimeLogDeliveryRequest) (response *DisableRealtimeLogDeliveryResponse, err error) {
	response = CreateDisableRealtimeLogDeliveryResponse()
	err = client.DoAction(request, response)
	return
}

// DisableRealtimeLogDeliveryWithChan invokes the cdn.DisableRealtimeLogDelivery API asynchronously
func (client *Client) DisableRealtimeLogDeliveryWithChan(request *DisableRealtimeLogDeliveryRequest) (<-chan *DisableRealtimeLogDeliveryResponse, <-chan error) {
	responseChan := make(chan *DisableRealtimeLogDeliveryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DisableRealtimeLogDelivery(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DisableRealtimeLogDeliveryWithCallback invokes the cdn.DisableRealtimeLogDelivery API asynchronously
func (client *Client) DisableRealtimeLogDeliveryWithCallback(request *DisableRealtimeLogDeliveryRequest, callback func(response *DisableRealtimeLogDeliveryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DisableRealtimeLogDeliveryResponse
		var err error
		defer close(result)
		response, err = client.DisableRealtimeLogDelivery(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DisableRealtimeLogDeliveryRequest is the request struct for api DisableRealtimeLogDelivery
type DisableRealtimeLogDeliveryRequest struct {
	*requests.RpcRequest
	Domain string `position:"Query" name:"Domain"`
}

// DisableRealtimeLogDeliveryResponse is the response struct for api DisableRealtimeLogDelivery
type DisableRealtimeLogDeliveryResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDisableRealtimeLogDeliveryRequest creates a request to invoke DisableRealtimeLogDelivery API
func CreateDisableRealtimeLogDeliveryRequest() (request *DisableRealtimeLogDeliveryRequest) {
	request = &DisableRealtimeLogDeliveryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cdn", "2018-05-10", "DisableRealtimeLogDelivery", "", "")
	request.Method = requests.GET
	return
}

// CreateDisableRealtimeLogDeliveryResponse creates a response to parse from DisableRealtimeLogDelivery response
func CreateDisableRealtimeLogDeliveryResponse() (response *DisableRealtimeLogDeliveryResponse) {
	response = &DisableRealtimeLogDeliveryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
