package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UnregisterDevice invokes the ccc.UnregisterDevice API synchronously
func (client *Client) UnregisterDevice(request *UnregisterDeviceRequest) (response *UnregisterDeviceResponse, err error) {
	response = CreateUnregisterDeviceResponse()
	err = client.DoAction(request, response)
	return
}

// UnregisterDeviceWithChan invokes the ccc.UnregisterDevice API asynchronously
func (client *Client) UnregisterDeviceWithChan(request *UnregisterDeviceRequest) (<-chan *UnregisterDeviceResponse, <-chan error) {
	responseChan := make(chan *UnregisterDeviceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UnregisterDevice(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UnregisterDeviceWithCallback invokes the ccc.UnregisterDevice API asynchronously
func (client *Client) UnregisterDeviceWithCallback(request *UnregisterDeviceRequest, callback func(response *UnregisterDeviceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UnregisterDeviceResponse
		var err error
		defer close(result)
		response, err = client.UnregisterDevice(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UnregisterDeviceRequest is the request struct for api UnregisterDevice
type UnregisterDeviceRequest struct {
	*requests.RpcRequest
	UserId     string `position:"Query" name:"UserId"`
	InstanceId string `position:"Query" name:"InstanceId"`
}

// UnregisterDeviceResponse is the response struct for api UnregisterDevice
type UnregisterDeviceResponse struct {
	*responses.BaseResponse
	Code           string `json:"Code" xml:"Code"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
}

// CreateUnregisterDeviceRequest creates a request to invoke UnregisterDevice API
func CreateUnregisterDeviceRequest() (request *UnregisterDeviceRequest) {
	request = &UnregisterDeviceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2020-07-01", "UnregisterDevice", "", "")
	request.Method = requests.POST
	return
}

// CreateUnregisterDeviceResponse creates a response to parse from UnregisterDevice response
func CreateUnregisterDeviceResponse() (response *UnregisterDeviceResponse) {
	response = &UnregisterDeviceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
