package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetHistoricalCampaignReport invokes the ccc.GetHistoricalCampaignReport API synchronously
func (client *Client) GetHistoricalCampaignReport(request *GetHistoricalCampaignReportRequest) (response *GetHistoricalCampaignReportResponse, err error) {
	response = CreateGetHistoricalCampaignReportResponse()
	err = client.DoAction(request, response)
	return
}

// GetHistoricalCampaignReportWithChan invokes the ccc.GetHistoricalCampaignReport API asynchronously
func (client *Client) GetHistoricalCampaignReportWithChan(request *GetHistoricalCampaignReportRequest) (<-chan *GetHistoricalCampaignReportResponse, <-chan error) {
	responseChan := make(chan *GetHistoricalCampaignReportResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetHistoricalCampaignReport(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetHistoricalCampaignReportWithCallback invokes the ccc.GetHistoricalCampaignReport API asynchronously
func (client *Client) GetHistoricalCampaignReportWithCallback(request *GetHistoricalCampaignReportRequest, callback func(response *GetHistoricalCampaignReportResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetHistoricalCampaignReportResponse
		var err error
		defer close(result)
		response, err = client.GetHistoricalCampaignReport(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetHistoricalCampaignReportRequest is the request struct for api GetHistoricalCampaignReport
type GetHistoricalCampaignReportRequest struct {
	*requests.RpcRequest
	CampaignId string `position:"Query" name:"CampaignId"`
	InstanceId string `position:"Query" name:"InstanceId"`
}

// GetHistoricalCampaignReportResponse is the response struct for api GetHistoricalCampaignReport
type GetHistoricalCampaignReportResponse struct {
	*responses.BaseResponse
	Code           string `json:"Code" xml:"Code"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Data           Data   `json:"Data" xml:"Data"`
}

// CreateGetHistoricalCampaignReportRequest creates a request to invoke GetHistoricalCampaignReport API
func CreateGetHistoricalCampaignReportRequest() (request *GetHistoricalCampaignReportRequest) {
	request = &GetHistoricalCampaignReportRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2020-07-01", "GetHistoricalCampaignReport", "", "")
	request.Method = requests.GET
	return
}

// CreateGetHistoricalCampaignReportResponse creates a response to parse from GetHistoricalCampaignReport response
func CreateGetHistoricalCampaignReportResponse() (response *GetHistoricalCampaignReportResponse) {
	response = &GetHistoricalCampaignReportResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
