package cbn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListGrantVSwitchEnis invokes the cbn.ListGrantVSwitchEnis API synchronously
func (client *Client) ListGrantVSwitchEnis(request *ListGrantVSwitchEnisRequest) (response *ListGrantVSwitchEnisResponse, err error) {
	response = CreateListGrantVSwitchEnisResponse()
	err = client.DoAction(request, response)
	return
}

// ListGrantVSwitchEnisWithChan invokes the cbn.ListGrantVSwitchEnis API asynchronously
func (client *Client) ListGrantVSwitchEnisWithChan(request *ListGrantVSwitchEnisRequest) (<-chan *ListGrantVSwitchEnisResponse, <-chan error) {
	responseChan := make(chan *ListGrantVSwitchEnisResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListGrantVSwitchEnis(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListGrantVSwitchEnisWithCallback invokes the cbn.ListGrantVSwitchEnis API asynchronously
func (client *Client) ListGrantVSwitchEnisWithCallback(request *ListGrantVSwitchEnisRequest, callback func(response *ListGrantVSwitchEnisResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListGrantVSwitchEnisResponse
		var err error
		defer close(result)
		response, err = client.ListGrantVSwitchEnis(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListGrantVSwitchEnisRequest is the request struct for api ListGrantVSwitchEnis
type ListGrantVSwitchEnisRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	CenId                string           `position:"Query" name:"CenId"`
	PageNumber           requests.Integer `position:"Query" name:"PageNumber"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	Version              string           `position:"Query" name:"Version"`
	VSwitchId            string           `position:"Query" name:"VSwitchId"`
	VpcId                string           `position:"Query" name:"VpcId"`
}

// ListGrantVSwitchEnisResponse is the response struct for api ListGrantVSwitchEnis
type ListGrantVSwitchEnisResponse struct {
	*responses.BaseResponse
	RequestId        string            `json:"RequestId" xml:"RequestId"`
	TotalCount       string            `json:"TotalCount" xml:"TotalCount"`
	GrantVSwitchEnis []GrantVSwitchEni `json:"GrantVSwitchEnis" xml:"GrantVSwitchEnis"`
}

// CreateListGrantVSwitchEnisRequest creates a request to invoke ListGrantVSwitchEnis API
func CreateListGrantVSwitchEnisRequest() (request *ListGrantVSwitchEnisRequest) {
	request = &ListGrantVSwitchEnisRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cbn", "2017-09-12", "ListGrantVSwitchEnis", "", "")
	request.Method = requests.POST
	return
}

// CreateListGrantVSwitchEnisResponse creates a response to parse from ListGrantVSwitchEnis response
func CreateListGrantVSwitchEnisResponse() (response *ListGrantVSwitchEnisResponse) {
	response = &ListGrantVSwitchEnisResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
