package cbn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeCenGeographicSpanRemainingBandwidth invokes the cbn.DescribeCenGeographicSpanRemainingBandwidth API synchronously
func (client *Client) DescribeCenGeographicSpanRemainingBandwidth(request *DescribeCenGeographicSpanRemainingBandwidthRequest) (response *DescribeCenGeographicSpanRemainingBandwidthResponse, err error) {
	response = CreateDescribeCenGeographicSpanRemainingBandwidthResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeCenGeographicSpanRemainingBandwidthWithChan invokes the cbn.DescribeCenGeographicSpanRemainingBandwidth API asynchronously
func (client *Client) DescribeCenGeographicSpanRemainingBandwidthWithChan(request *DescribeCenGeographicSpanRemainingBandwidthRequest) (<-chan *DescribeCenGeographicSpanRemainingBandwidthResponse, <-chan error) {
	responseChan := make(chan *DescribeCenGeographicSpanRemainingBandwidthResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeCenGeographicSpanRemainingBandwidth(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeCenGeographicSpanRemainingBandwidthWithCallback invokes the cbn.DescribeCenGeographicSpanRemainingBandwidth API asynchronously
func (client *Client) DescribeCenGeographicSpanRemainingBandwidthWithCallback(request *DescribeCenGeographicSpanRemainingBandwidthRequest, callback func(response *DescribeCenGeographicSpanRemainingBandwidthResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeCenGeographicSpanRemainingBandwidthResponse
		var err error
		defer close(result)
		response, err = client.DescribeCenGeographicSpanRemainingBandwidth(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeCenGeographicSpanRemainingBandwidthRequest is the request struct for api DescribeCenGeographicSpanRemainingBandwidth
type DescribeCenGeographicSpanRemainingBandwidthRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	CenId                string           `position:"Query" name:"CenId"`
	PageNumber           requests.Integer `position:"Query" name:"PageNumber"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	GeographicRegionBId  string           `position:"Query" name:"GeographicRegionBId"`
	GeographicRegionAId  string           `position:"Query" name:"GeographicRegionAId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	Version              string           `position:"Query" name:"Version"`
}

// DescribeCenGeographicSpanRemainingBandwidthResponse is the response struct for api DescribeCenGeographicSpanRemainingBandwidth
type DescribeCenGeographicSpanRemainingBandwidthResponse struct {
	*responses.BaseResponse
	RemainingBandwidth int64  `json:"RemainingBandwidth" xml:"RemainingBandwidth"`
	RequestId          string `json:"RequestId" xml:"RequestId"`
}

// CreateDescribeCenGeographicSpanRemainingBandwidthRequest creates a request to invoke DescribeCenGeographicSpanRemainingBandwidth API
func CreateDescribeCenGeographicSpanRemainingBandwidthRequest() (request *DescribeCenGeographicSpanRemainingBandwidthRequest) {
	request = &DescribeCenGeographicSpanRemainingBandwidthRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cbn", "2017-09-12", "DescribeCenGeographicSpanRemainingBandwidth", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeCenGeographicSpanRemainingBandwidthResponse creates a response to parse from DescribeCenGeographicSpanRemainingBandwidth response
func CreateDescribeCenGeographicSpanRemainingBandwidthResponse() (response *DescribeCenGeographicSpanRemainingBandwidthResponse) {
	response = &DescribeCenGeographicSpanRemainingBandwidthResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
