package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteSourceMap invokes the arms.DeleteSourceMap API synchronously
func (client *Client) DeleteSourceMap(request *DeleteSourceMapRequest) (response *DeleteSourceMapResponse, err error) {
	response = CreateDeleteSourceMapResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteSourceMapWithChan invokes the arms.DeleteSourceMap API asynchronously
func (client *Client) DeleteSourceMapWithChan(request *DeleteSourceMapRequest) (<-chan *DeleteSourceMapResponse, <-chan error) {
	responseChan := make(chan *DeleteSourceMapResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteSourceMap(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteSourceMapWithCallback invokes the arms.DeleteSourceMap API asynchronously
func (client *Client) DeleteSourceMapWithCallback(request *DeleteSourceMapRequest, callback func(response *DeleteSourceMapResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteSourceMapResponse
		var err error
		defer close(result)
		response, err = client.DeleteSourceMap(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteSourceMapRequest is the request struct for api DeleteSourceMap
type DeleteSourceMapRequest struct {
	*requests.RpcRequest
	FidList *[]string `position:"Query" name:"FidList"  type:"Json"`
	Pid     string    `position:"Query" name:"Pid"`
}

// DeleteSourceMapResponse is the response struct for api DeleteSourceMap
type DeleteSourceMapResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateDeleteSourceMapRequest creates a request to invoke DeleteSourceMap API
func CreateDeleteSourceMapRequest() (request *DeleteSourceMapRequest) {
	request = &DeleteSourceMapRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-08-08", "DeleteSourceMap", "arms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteSourceMapResponse creates a response to parse from DeleteSourceMap response
func CreateDeleteSourceMapResponse() (response *DeleteSourceMapResponse) {
	response = &DeleteSourceMapResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
