package amp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AAA invokes the amp.AAA API synchronously
func (client *Client) AAA(request *AAARequest) (response *AAAResponse, err error) {
	response = CreateAAAResponse()
	err = client.DoAction(request, response)
	return
}

// AAAWithChan invokes the amp.AAA API asynchronously
func (client *Client) AAAWithChan(request *AAARequest) (<-chan *AAAResponse, <-chan error) {
	responseChan := make(chan *AAAResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AAA(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AAAWithCallback invokes the amp.AAA API asynchronously
func (client *Client) AAAWithCallback(request *AAARequest, callback func(response *AAAResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AAAResponse
		var err error
		defer close(result)
		response, err = client.AAA(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AAARequest is the request struct for api AAA
type AAARequest struct {
	*requests.RoaRequest
}

// AAAResponse is the response struct for api AAA
type AAAResponse struct {
	*responses.BaseResponse
	RequestId string `json:"requestId" xml:"requestId"`
}

// CreateAAARequest creates a request to invoke AAA API
func CreateAAARequest() (request *AAARequest) {
	request = &AAARequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("amp", "2020-07-08", "AAA", "/aa", "ServiceCode", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAAAResponse creates a response to parse from AAA response
func CreateAAAResponse() (response *AAAResponse) {
	response = &AAAResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
