package alinlp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetTsChEcom invokes the alinlp.GetTsChEcom API synchronously
func (client *Client) GetTsChEcom(request *GetTsChEcomRequest) (response *GetTsChEcomResponse, err error) {
	response = CreateGetTsChEcomResponse()
	err = client.DoAction(request, response)
	return
}

// GetTsChEcomWithChan invokes the alinlp.GetTsChEcom API asynchronously
func (client *Client) GetTsChEcomWithChan(request *GetTsChEcomRequest) (<-chan *GetTsChEcomResponse, <-chan error) {
	responseChan := make(chan *GetTsChEcomResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetTsChEcom(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetTsChEcomWithCallback invokes the alinlp.GetTsChEcom API asynchronously
func (client *Client) GetTsChEcomWithCallback(request *GetTsChEcomRequest, callback func(response *GetTsChEcomResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetTsChEcomResponse
		var err error
		defer close(result)
		response, err = client.GetTsChEcom(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetTsChEcomRequest is the request struct for api GetTsChEcom
type GetTsChEcomRequest struct {
	*requests.RpcRequest
	Type        string `position:"Body" name:"Type"`
	ServiceCode string `position:"Body" name:"ServiceCode"`
	OriginT     string `position:"Body" name:"OriginT"`
	OriginQ     string `position:"Body" name:"OriginQ"`
}

// GetTsChEcomResponse is the response struct for api GetTsChEcom
type GetTsChEcomResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateGetTsChEcomRequest creates a request to invoke GetTsChEcom API
func CreateGetTsChEcomRequest() (request *GetTsChEcomRequest) {
	request = &GetTsChEcomRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("alinlp", "2020-06-29", "GetTsChEcom", "", "")
	request.Method = requests.POST
	return
}

// CreateGetTsChEcomResponse creates a response to parse from GetTsChEcom response
func CreateGetTsChEcomResponse() (response *GetTsChEcomResponse) {
	response = &GetTsChEcomResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
