package aiworkspace

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetDefaultWorkspace invokes the aiworkspace.GetDefaultWorkspace API synchronously
func (client *Client) GetDefaultWorkspace(request *GetDefaultWorkspaceRequest) (response *GetDefaultWorkspaceResponse, err error) {
	response = CreateGetDefaultWorkspaceResponse()
	err = client.DoAction(request, response)
	return
}

// GetDefaultWorkspaceWithChan invokes the aiworkspace.GetDefaultWorkspace API asynchronously
func (client *Client) GetDefaultWorkspaceWithChan(request *GetDefaultWorkspaceRequest) (<-chan *GetDefaultWorkspaceResponse, <-chan error) {
	responseChan := make(chan *GetDefaultWorkspaceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetDefaultWorkspace(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetDefaultWorkspaceWithCallback invokes the aiworkspace.GetDefaultWorkspace API asynchronously
func (client *Client) GetDefaultWorkspaceWithCallback(request *GetDefaultWorkspaceRequest, callback func(response *GetDefaultWorkspaceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetDefaultWorkspaceResponse
		var err error
		defer close(result)
		response, err = client.GetDefaultWorkspace(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetDefaultWorkspaceRequest is the request struct for api GetDefaultWorkspace
type GetDefaultWorkspaceRequest struct {
	*requests.RoaRequest
	Verbose string `position:"Query" name:"Verbose"`
}

// GetDefaultWorkspaceResponse is the response struct for api GetDefaultWorkspace
type GetDefaultWorkspaceResponse struct {
	*responses.BaseResponse
	RequestId       string           `json:"RequestId" xml:"RequestId"`
	WorkspaceId     string           `json:"WorkspaceId" xml:"WorkspaceId"`
	WorkspaceName   string           `json:"WorkspaceName" xml:"WorkspaceName"`
	GmtCreateTime   string           `json:"GmtCreateTime" xml:"GmtCreateTime"`
	GmtModifiedTime string           `json:"GmtModifiedTime" xml:"GmtModifiedTime"`
	DisplayName     string           `json:"DisplayName" xml:"DisplayName"`
	Description     string           `json:"Description" xml:"Description"`
	Creator         string           `json:"Creator" xml:"Creator"`
	Status          string           `json:"Status" xml:"Status"`
	EnvTypes        []string         `json:"EnvTypes" xml:"EnvTypes"`
	Owner           Owner            `json:"Owner" xml:"Owner"`
	Conditions      []ConditionsItem `json:"Conditions" xml:"Conditions"`
}

// CreateGetDefaultWorkspaceRequest creates a request to invoke GetDefaultWorkspace API
func CreateGetDefaultWorkspaceRequest() (request *GetDefaultWorkspaceRequest) {
	request = &GetDefaultWorkspaceRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("AIWorkSpace", "2021-02-04", "GetDefaultWorkspace", "/api/v1/defaultWorkspaces", "", "")
	request.Method = requests.GET
	return
}

// CreateGetDefaultWorkspaceResponse creates a response to parse from GetDefaultWorkspace response
func CreateGetDefaultWorkspaceResponse() (response *GetDefaultWorkspaceResponse) {
	response = &GetDefaultWorkspaceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
