package actiontrail

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetAccessKeyLastUsedEvents invokes the actiontrail.GetAccessKeyLastUsedEvents API synchronously
func (client *Client) GetAccessKeyLastUsedEvents(request *GetAccessKeyLastUsedEventsRequest) (response *GetAccessKeyLastUsedEventsResponse, err error) {
	response = CreateGetAccessKeyLastUsedEventsResponse()
	err = client.DoAction(request, response)
	return
}

// GetAccessKeyLastUsedEventsWithChan invokes the actiontrail.GetAccessKeyLastUsedEvents API asynchronously
func (client *Client) GetAccessKeyLastUsedEventsWithChan(request *GetAccessKeyLastUsedEventsRequest) (<-chan *GetAccessKeyLastUsedEventsResponse, <-chan error) {
	responseChan := make(chan *GetAccessKeyLastUsedEventsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetAccessKeyLastUsedEvents(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetAccessKeyLastUsedEventsWithCallback invokes the actiontrail.GetAccessKeyLastUsedEvents API asynchronously
func (client *Client) GetAccessKeyLastUsedEventsWithCallback(request *GetAccessKeyLastUsedEventsRequest, callback func(response *GetAccessKeyLastUsedEventsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetAccessKeyLastUsedEventsResponse
		var err error
		defer close(result)
		response, err = client.GetAccessKeyLastUsedEvents(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetAccessKeyLastUsedEventsRequest is the request struct for api GetAccessKeyLastUsedEvents
type GetAccessKeyLastUsedEventsRequest struct {
	*requests.RpcRequest
	AccessKey   string `position:"Query" name:"AccessKey"`
	NextToken   string `position:"Query" name:"NextToken"`
	PageSize    string `position:"Query" name:"PageSize"`
	ServiceName string `position:"Query" name:"ServiceName"`
}

// GetAccessKeyLastUsedEventsResponse is the response struct for api GetAccessKeyLastUsedEvents
type GetAccessKeyLastUsedEventsResponse struct {
	*responses.BaseResponse
	RequestId string       `json:"RequestId" xml:"RequestId"`
	NextToken string       `json:"NextToken" xml:"NextToken"`
	Events    []EventsItem `json:"Events" xml:"Events"`
}

// CreateGetAccessKeyLastUsedEventsRequest creates a request to invoke GetAccessKeyLastUsedEvents API
func CreateGetAccessKeyLastUsedEventsRequest() (request *GetAccessKeyLastUsedEventsRequest) {
	request = &GetAccessKeyLastUsedEventsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Actiontrail", "2020-07-06", "GetAccessKeyLastUsedEvents", "", "")
	request.Method = requests.POST
	return
}

// CreateGetAccessKeyLastUsedEventsResponse creates a response to parse from GetAccessKeyLastUsedEvents response
func CreateGetAccessKeyLastUsedEventsResponse() (response *GetAccessKeyLastUsedEventsResponse) {
	response = &GetAccessKeyLastUsedEventsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
