package network

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// PerimeterAssociableResourceTypesClient is the network Client
type PerimeterAssociableResourceTypesClient struct {
	BaseClient
}

// NewPerimeterAssociableResourceTypesClient creates an instance of the PerimeterAssociableResourceTypesClient client.
func NewPerimeterAssociableResourceTypesClient(subscriptionID string) PerimeterAssociableResourceTypesClient {
	return NewPerimeterAssociableResourceTypesClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewPerimeterAssociableResourceTypesClientWithBaseURI creates an instance of the
// PerimeterAssociableResourceTypesClient client using a custom endpoint.  Use this when interacting with an Azure
// cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewPerimeterAssociableResourceTypesClientWithBaseURI(baseURI string, subscriptionID string) PerimeterAssociableResourceTypesClient {
	return PerimeterAssociableResourceTypesClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// Get gets the list of resources that are onboarded with NSP. These resources can be associated with a network
// security perimeter
// Parameters:
// location - the location of the where the association is present.
func (client PerimeterAssociableResourceTypesClient) Get(ctx context.Context, location string) (result PerimeterAssociableResourcesListResult, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PerimeterAssociableResourceTypesClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetPreparer(ctx, location)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.PerimeterAssociableResourceTypesClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "network.PerimeterAssociableResourceTypesClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "network.PerimeterAssociableResourceTypesClient", "Get", resp, "Failure responding to request")
		return
	}

	return
}

// GetPreparer prepares the Get request.
func (client PerimeterAssociableResourceTypesClient) GetPreparer(ctx context.Context, location string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"location":       autorest.Encode("path", location),
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-03-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Network/locations/{location}/perimeterAssociableResourceTypes", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client PerimeterAssociableResourceTypesClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client PerimeterAssociableResourceTypesClient) GetResponder(resp *http.Response) (result PerimeterAssociableResourcesListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
