package logzapi

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/preview/logz/mgmt/2020-10-01-preview/logz"
	"github.com/Azure/go-autorest/autorest"
)

// MonitorsClientAPI contains the set of methods on the MonitorsClient type.
type MonitorsClientAPI interface {
	Create(ctx context.Context, resourceGroupName string, monitorName string, body *logz.MonitorResource) (result logz.MonitorsCreateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, monitorName string) (result logz.MonitorsDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, monitorName string) (result logz.MonitorResource, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result logz.MonitorResourceListResponsePage, err error)
	ListByResourceGroupComplete(ctx context.Context, resourceGroupName string) (result logz.MonitorResourceListResponseIterator, err error)
	ListBySubscription(ctx context.Context) (result logz.MonitorResourceListResponsePage, err error)
	ListBySubscriptionComplete(ctx context.Context) (result logz.MonitorResourceListResponseIterator, err error)
	ListMonitoredResources(ctx context.Context, resourceGroupName string, monitorName string) (result logz.MonitoredResourceListResponsePage, err error)
	ListMonitoredResourcesComplete(ctx context.Context, resourceGroupName string, monitorName string) (result logz.MonitoredResourceListResponseIterator, err error)
	ListUserRoles(ctx context.Context, resourceGroupName string, monitorName string, body *logz.UserRoleRequest) (result logz.UserRoleListResponsePage, err error)
	ListUserRolesComplete(ctx context.Context, resourceGroupName string, monitorName string, body *logz.UserRoleRequest) (result logz.UserRoleListResponseIterator, err error)
	Update(ctx context.Context, resourceGroupName string, monitorName string, body *logz.MonitorResourceUpdateParameters) (result logz.MonitorResource, err error)
}

var _ MonitorsClientAPI = (*logz.MonitorsClient)(nil)

// OperationsClientAPI contains the set of methods on the OperationsClient type.
type OperationsClientAPI interface {
	List(ctx context.Context) (result logz.OperationListResultPage, err error)
	ListComplete(ctx context.Context) (result logz.OperationListResultIterator, err error)
}

var _ OperationsClientAPI = (*logz.OperationsClient)(nil)

// TagRulesClientAPI contains the set of methods on the TagRulesClient type.
type TagRulesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, monitorName string, ruleSetName string, body *logz.MonitoringTagRules) (result logz.MonitoringTagRules, err error)
	Delete(ctx context.Context, resourceGroupName string, monitorName string, ruleSetName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, monitorName string, ruleSetName string) (result logz.MonitoringTagRules, err error)
	List(ctx context.Context, resourceGroupName string, monitorName string) (result logz.MonitoringTagRulesListResponsePage, err error)
	ListComplete(ctx context.Context, resourceGroupName string, monitorName string) (result logz.MonitoringTagRulesListResponseIterator, err error)
}

var _ TagRulesClientAPI = (*logz.TagRulesClient)(nil)

// SingleSignOnClientAPI contains the set of methods on the SingleSignOnClient type.
type SingleSignOnClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, monitorName string, configurationName string, body *logz.SingleSignOnResource) (result logz.SingleSignOnCreateOrUpdateFuture, err error)
	Get(ctx context.Context, resourceGroupName string, monitorName string, configurationName string) (result logz.SingleSignOnResource, err error)
	List(ctx context.Context, resourceGroupName string, monitorName string) (result logz.SingleSignOnResourceListResponsePage, err error)
	ListComplete(ctx context.Context, resourceGroupName string, monitorName string) (result logz.SingleSignOnResourceListResponseIterator, err error)
}

var _ SingleSignOnClientAPI = (*logz.SingleSignOnClient)(nil)

// SubAccountClientAPI contains the set of methods on the SubAccountClient type.
type SubAccountClientAPI interface {
	Create(ctx context.Context, resourceGroupName string, monitorName string, subAccountName string, body *logz.MonitorResource) (result logz.SubAccountCreateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, monitorName string, subAccountName string) (result logz.SubAccountDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, monitorName string, subAccountName string) (result logz.MonitorResource, err error)
	List(ctx context.Context, resourceGroupName string, monitorName string) (result logz.MonitorResourceListResponsePage, err error)
	ListComplete(ctx context.Context, resourceGroupName string, monitorName string) (result logz.MonitorResourceListResponseIterator, err error)
	ListMonitoredResources(ctx context.Context, resourceGroupName string, monitorName string, subAccountName string) (result logz.MonitoredResourceListResponsePage, err error)
	ListMonitoredResourcesComplete(ctx context.Context, resourceGroupName string, monitorName string, subAccountName string) (result logz.MonitoredResourceListResponseIterator, err error)
	ListVMHosts(ctx context.Context, resourceGroupName string, monitorName string, subAccountName string) (result logz.VMResourcesListResponsePage, err error)
	ListVMHostsComplete(ctx context.Context, resourceGroupName string, monitorName string, subAccountName string) (result logz.VMResourcesListResponseIterator, err error)
	ListVMHostUpdate(ctx context.Context, resourceGroupName string, monitorName string, subAccountName string, body *logz.VMHostUpdateRequest) (result logz.VMResourcesListResponsePage, err error)
	ListVMHostUpdateComplete(ctx context.Context, resourceGroupName string, monitorName string, subAccountName string, body *logz.VMHostUpdateRequest) (result logz.VMResourcesListResponseIterator, err error)
	Update(ctx context.Context, resourceGroupName string, monitorName string, subAccountName string, body *logz.MonitorResourceUpdateParameters) (result logz.MonitorResource, err error)
	VMHostPayload(ctx context.Context, resourceGroupName string, monitorName string, subAccountName string) (result logz.VMExtensionPayload, err error)
}

var _ SubAccountClientAPI = (*logz.SubAccountClient)(nil)

// SubAccountTagRulesClientAPI contains the set of methods on the SubAccountTagRulesClient type.
type SubAccountTagRulesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, monitorName string, subAccountName string, ruleSetName string, body *logz.MonitoringTagRules) (result logz.MonitoringTagRules, err error)
	Delete(ctx context.Context, resourceGroupName string, monitorName string, subAccountName string, ruleSetName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, monitorName string, subAccountName string, ruleSetName string) (result logz.MonitoringTagRules, err error)
	List(ctx context.Context, resourceGroupName string, monitorName string, subAccountName string) (result logz.MonitoringTagRulesListResponsePage, err error)
	ListComplete(ctx context.Context, resourceGroupName string, monitorName string, subAccountName string) (result logz.MonitoringTagRulesListResponseIterator, err error)
}

var _ SubAccountTagRulesClientAPI = (*logz.SubAccountTagRulesClient)(nil)

// MonitorClientAPI contains the set of methods on the MonitorClient type.
type MonitorClientAPI interface {
	ListVMHosts(ctx context.Context, resourceGroupName string, monitorName string) (result logz.VMResourcesListResponsePage, err error)
	ListVMHostsComplete(ctx context.Context, resourceGroupName string, monitorName string) (result logz.VMResourcesListResponseIterator, err error)
	ListVMHostUpdate(ctx context.Context, resourceGroupName string, monitorName string, body *logz.VMHostUpdateRequest) (result logz.VMResourcesListResponsePage, err error)
	ListVMHostUpdateComplete(ctx context.Context, resourceGroupName string, monitorName string, body *logz.VMHostUpdateRequest) (result logz.VMResourcesListResponseIterator, err error)
	VMHostPayload(ctx context.Context, resourceGroupName string, monitorName string) (result logz.VMExtensionPayload, err error)
}

var _ MonitorClientAPI = (*logz.MonitorClient)(nil)
