//go:build go1.16
// +build go1.16

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armmonitor

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"reflect"
)

// ActivityLogAlertsClientListByResourceGroupPager provides operations for iterating over paged responses.
type ActivityLogAlertsClientListByResourceGroupPager struct {
	client    *ActivityLogAlertsClient
	current   ActivityLogAlertsClientListByResourceGroupResponse
	err       error
	requester func(context.Context) (*policy.Request, error)
	advancer  func(context.Context, ActivityLogAlertsClientListByResourceGroupResponse) (*policy.Request, error)
}

// Err returns the last error encountered while paging.
func (p *ActivityLogAlertsClientListByResourceGroupPager) Err() error {
	return p.err
}

// NextPage returns true if the pager advanced to the next page.
// Returns false if there are no more pages or an error occurred.
func (p *ActivityLogAlertsClientListByResourceGroupPager) NextPage(ctx context.Context) bool {
	var req *policy.Request
	var err error
	if !reflect.ValueOf(p.current).IsZero() {
		if p.current.AlertRuleList.NextLink == nil || len(*p.current.AlertRuleList.NextLink) == 0 {
			return false
		}
		req, err = p.advancer(ctx, p.current)
	} else {
		req, err = p.requester(ctx)
	}
	if err != nil {
		p.err = err
		return false
	}
	resp, err := p.client.pl.Do(req)
	if err != nil {
		p.err = err
		return false
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		p.err = runtime.NewResponseError(resp)
		return false
	}
	result, err := p.client.listByResourceGroupHandleResponse(resp)
	if err != nil {
		p.err = err
		return false
	}
	p.current = result
	return true
}

// PageResponse returns the current ActivityLogAlertsClientListByResourceGroupResponse page.
func (p *ActivityLogAlertsClientListByResourceGroupPager) PageResponse() ActivityLogAlertsClientListByResourceGroupResponse {
	return p.current
}

// ActivityLogAlertsClientListBySubscriptionIDPager provides operations for iterating over paged responses.
type ActivityLogAlertsClientListBySubscriptionIDPager struct {
	client    *ActivityLogAlertsClient
	current   ActivityLogAlertsClientListBySubscriptionIDResponse
	err       error
	requester func(context.Context) (*policy.Request, error)
	advancer  func(context.Context, ActivityLogAlertsClientListBySubscriptionIDResponse) (*policy.Request, error)
}

// Err returns the last error encountered while paging.
func (p *ActivityLogAlertsClientListBySubscriptionIDPager) Err() error {
	return p.err
}

// NextPage returns true if the pager advanced to the next page.
// Returns false if there are no more pages or an error occurred.
func (p *ActivityLogAlertsClientListBySubscriptionIDPager) NextPage(ctx context.Context) bool {
	var req *policy.Request
	var err error
	if !reflect.ValueOf(p.current).IsZero() {
		if p.current.AlertRuleList.NextLink == nil || len(*p.current.AlertRuleList.NextLink) == 0 {
			return false
		}
		req, err = p.advancer(ctx, p.current)
	} else {
		req, err = p.requester(ctx)
	}
	if err != nil {
		p.err = err
		return false
	}
	resp, err := p.client.pl.Do(req)
	if err != nil {
		p.err = err
		return false
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		p.err = runtime.NewResponseError(resp)
		return false
	}
	result, err := p.client.listBySubscriptionIDHandleResponse(resp)
	if err != nil {
		p.err = err
		return false
	}
	p.current = result
	return true
}

// PageResponse returns the current ActivityLogAlertsClientListBySubscriptionIDResponse page.
func (p *ActivityLogAlertsClientListBySubscriptionIDPager) PageResponse() ActivityLogAlertsClientListBySubscriptionIDResponse {
	return p.current
}

// ActivityLogsClientListPager provides operations for iterating over paged responses.
type ActivityLogsClientListPager struct {
	client    *ActivityLogsClient
	current   ActivityLogsClientListResponse
	err       error
	requester func(context.Context) (*policy.Request, error)
	advancer  func(context.Context, ActivityLogsClientListResponse) (*policy.Request, error)
}

// Err returns the last error encountered while paging.
func (p *ActivityLogsClientListPager) Err() error {
	return p.err
}

// NextPage returns true if the pager advanced to the next page.
// Returns false if there are no more pages or an error occurred.
func (p *ActivityLogsClientListPager) NextPage(ctx context.Context) bool {
	var req *policy.Request
	var err error
	if !reflect.ValueOf(p.current).IsZero() {
		if p.current.EventDataCollection.NextLink == nil || len(*p.current.EventDataCollection.NextLink) == 0 {
			return false
		}
		req, err = p.advancer(ctx, p.current)
	} else {
		req, err = p.requester(ctx)
	}
	if err != nil {
		p.err = err
		return false
	}
	resp, err := p.client.pl.Do(req)
	if err != nil {
		p.err = err
		return false
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		p.err = runtime.NewResponseError(resp)
		return false
	}
	result, err := p.client.listHandleResponse(resp)
	if err != nil {
		p.err = err
		return false
	}
	p.current = result
	return true
}

// PageResponse returns the current ActivityLogsClientListResponse page.
func (p *ActivityLogsClientListPager) PageResponse() ActivityLogsClientListResponse {
	return p.current
}

// AutoscaleSettingsClientListByResourceGroupPager provides operations for iterating over paged responses.
type AutoscaleSettingsClientListByResourceGroupPager struct {
	client    *AutoscaleSettingsClient
	current   AutoscaleSettingsClientListByResourceGroupResponse
	err       error
	requester func(context.Context) (*policy.Request, error)
	advancer  func(context.Context, AutoscaleSettingsClientListByResourceGroupResponse) (*policy.Request, error)
}

// Err returns the last error encountered while paging.
func (p *AutoscaleSettingsClientListByResourceGroupPager) Err() error {
	return p.err
}

// NextPage returns true if the pager advanced to the next page.
// Returns false if there are no more pages or an error occurred.
func (p *AutoscaleSettingsClientListByResourceGroupPager) NextPage(ctx context.Context) bool {
	var req *policy.Request
	var err error
	if !reflect.ValueOf(p.current).IsZero() {
		if p.current.AutoscaleSettingResourceCollection.NextLink == nil || len(*p.current.AutoscaleSettingResourceCollection.NextLink) == 0 {
			return false
		}
		req, err = p.advancer(ctx, p.current)
	} else {
		req, err = p.requester(ctx)
	}
	if err != nil {
		p.err = err
		return false
	}
	resp, err := p.client.pl.Do(req)
	if err != nil {
		p.err = err
		return false
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		p.err = runtime.NewResponseError(resp)
		return false
	}
	result, err := p.client.listByResourceGroupHandleResponse(resp)
	if err != nil {
		p.err = err
		return false
	}
	p.current = result
	return true
}

// PageResponse returns the current AutoscaleSettingsClientListByResourceGroupResponse page.
func (p *AutoscaleSettingsClientListByResourceGroupPager) PageResponse() AutoscaleSettingsClientListByResourceGroupResponse {
	return p.current
}

// AutoscaleSettingsClientListBySubscriptionPager provides operations for iterating over paged responses.
type AutoscaleSettingsClientListBySubscriptionPager struct {
	client    *AutoscaleSettingsClient
	current   AutoscaleSettingsClientListBySubscriptionResponse
	err       error
	requester func(context.Context) (*policy.Request, error)
	advancer  func(context.Context, AutoscaleSettingsClientListBySubscriptionResponse) (*policy.Request, error)
}

// Err returns the last error encountered while paging.
func (p *AutoscaleSettingsClientListBySubscriptionPager) Err() error {
	return p.err
}

// NextPage returns true if the pager advanced to the next page.
// Returns false if there are no more pages or an error occurred.
func (p *AutoscaleSettingsClientListBySubscriptionPager) NextPage(ctx context.Context) bool {
	var req *policy.Request
	var err error
	if !reflect.ValueOf(p.current).IsZero() {
		if p.current.AutoscaleSettingResourceCollection.NextLink == nil || len(*p.current.AutoscaleSettingResourceCollection.NextLink) == 0 {
			return false
		}
		req, err = p.advancer(ctx, p.current)
	} else {
		req, err = p.requester(ctx)
	}
	if err != nil {
		p.err = err
		return false
	}
	resp, err := p.client.pl.Do(req)
	if err != nil {
		p.err = err
		return false
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		p.err = runtime.NewResponseError(resp)
		return false
	}
	result, err := p.client.listBySubscriptionHandleResponse(resp)
	if err != nil {
		p.err = err
		return false
	}
	p.current = result
	return true
}

// PageResponse returns the current AutoscaleSettingsClientListBySubscriptionResponse page.
func (p *AutoscaleSettingsClientListBySubscriptionPager) PageResponse() AutoscaleSettingsClientListBySubscriptionResponse {
	return p.current
}

// DataCollectionEndpointsClientListByResourceGroupPager provides operations for iterating over paged responses.
type DataCollectionEndpointsClientListByResourceGroupPager struct {
	client    *DataCollectionEndpointsClient
	current   DataCollectionEndpointsClientListByResourceGroupResponse
	err       error
	requester func(context.Context) (*policy.Request, error)
	advancer  func(context.Context, DataCollectionEndpointsClientListByResourceGroupResponse) (*policy.Request, error)
}

// Err returns the last error encountered while paging.
func (p *DataCollectionEndpointsClientListByResourceGroupPager) Err() error {
	return p.err
}

// NextPage returns true if the pager advanced to the next page.
// Returns false if there are no more pages or an error occurred.
func (p *DataCollectionEndpointsClientListByResourceGroupPager) NextPage(ctx context.Context) bool {
	var req *policy.Request
	var err error
	if !reflect.ValueOf(p.current).IsZero() {
		if p.current.DataCollectionEndpointResourceListResult.NextLink == nil || len(*p.current.DataCollectionEndpointResourceListResult.NextLink) == 0 {
			return false
		}
		req, err = p.advancer(ctx, p.current)
	} else {
		req, err = p.requester(ctx)
	}
	if err != nil {
		p.err = err
		return false
	}
	resp, err := p.client.pl.Do(req)
	if err != nil {
		p.err = err
		return false
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		p.err = runtime.NewResponseError(resp)
		return false
	}
	result, err := p.client.listByResourceGroupHandleResponse(resp)
	if err != nil {
		p.err = err
		return false
	}
	p.current = result
	return true
}

// PageResponse returns the current DataCollectionEndpointsClientListByResourceGroupResponse page.
func (p *DataCollectionEndpointsClientListByResourceGroupPager) PageResponse() DataCollectionEndpointsClientListByResourceGroupResponse {
	return p.current
}

// DataCollectionEndpointsClientListBySubscriptionPager provides operations for iterating over paged responses.
type DataCollectionEndpointsClientListBySubscriptionPager struct {
	client    *DataCollectionEndpointsClient
	current   DataCollectionEndpointsClientListBySubscriptionResponse
	err       error
	requester func(context.Context) (*policy.Request, error)
	advancer  func(context.Context, DataCollectionEndpointsClientListBySubscriptionResponse) (*policy.Request, error)
}

// Err returns the last error encountered while paging.
func (p *DataCollectionEndpointsClientListBySubscriptionPager) Err() error {
	return p.err
}

// NextPage returns true if the pager advanced to the next page.
// Returns false if there are no more pages or an error occurred.
func (p *DataCollectionEndpointsClientListBySubscriptionPager) NextPage(ctx context.Context) bool {
	var req *policy.Request
	var err error
	if !reflect.ValueOf(p.current).IsZero() {
		if p.current.DataCollectionEndpointResourceListResult.NextLink == nil || len(*p.current.DataCollectionEndpointResourceListResult.NextLink) == 0 {
			return false
		}
		req, err = p.advancer(ctx, p.current)
	} else {
		req, err = p.requester(ctx)
	}
	if err != nil {
		p.err = err
		return false
	}
	resp, err := p.client.pl.Do(req)
	if err != nil {
		p.err = err
		return false
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		p.err = runtime.NewResponseError(resp)
		return false
	}
	result, err := p.client.listBySubscriptionHandleResponse(resp)
	if err != nil {
		p.err = err
		return false
	}
	p.current = result
	return true
}

// PageResponse returns the current DataCollectionEndpointsClientListBySubscriptionResponse page.
func (p *DataCollectionEndpointsClientListBySubscriptionPager) PageResponse() DataCollectionEndpointsClientListBySubscriptionResponse {
	return p.current
}

// DataCollectionRuleAssociationsClientListByResourcePager provides operations for iterating over paged responses.
type DataCollectionRuleAssociationsClientListByResourcePager struct {
	client    *DataCollectionRuleAssociationsClient
	current   DataCollectionRuleAssociationsClientListByResourceResponse
	err       error
	requester func(context.Context) (*policy.Request, error)
	advancer  func(context.Context, DataCollectionRuleAssociationsClientListByResourceResponse) (*policy.Request, error)
}

// Err returns the last error encountered while paging.
func (p *DataCollectionRuleAssociationsClientListByResourcePager) Err() error {
	return p.err
}

// NextPage returns true if the pager advanced to the next page.
// Returns false if there are no more pages or an error occurred.
func (p *DataCollectionRuleAssociationsClientListByResourcePager) NextPage(ctx context.Context) bool {
	var req *policy.Request
	var err error
	if !reflect.ValueOf(p.current).IsZero() {
		if p.current.DataCollectionRuleAssociationProxyOnlyResourceListResult.NextLink == nil || len(*p.current.DataCollectionRuleAssociationProxyOnlyResourceListResult.NextLink) == 0 {
			return false
		}
		req, err = p.advancer(ctx, p.current)
	} else {
		req, err = p.requester(ctx)
	}
	if err != nil {
		p.err = err
		return false
	}
	resp, err := p.client.pl.Do(req)
	if err != nil {
		p.err = err
		return false
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		p.err = runtime.NewResponseError(resp)
		return false
	}
	result, err := p.client.listByResourceHandleResponse(resp)
	if err != nil {
		p.err = err
		return false
	}
	p.current = result
	return true
}

// PageResponse returns the current DataCollectionRuleAssociationsClientListByResourceResponse page.
func (p *DataCollectionRuleAssociationsClientListByResourcePager) PageResponse() DataCollectionRuleAssociationsClientListByResourceResponse {
	return p.current
}

// DataCollectionRuleAssociationsClientListByRulePager provides operations for iterating over paged responses.
type DataCollectionRuleAssociationsClientListByRulePager struct {
	client    *DataCollectionRuleAssociationsClient
	current   DataCollectionRuleAssociationsClientListByRuleResponse
	err       error
	requester func(context.Context) (*policy.Request, error)
	advancer  func(context.Context, DataCollectionRuleAssociationsClientListByRuleResponse) (*policy.Request, error)
}

// Err returns the last error encountered while paging.
func (p *DataCollectionRuleAssociationsClientListByRulePager) Err() error {
	return p.err
}

// NextPage returns true if the pager advanced to the next page.
// Returns false if there are no more pages or an error occurred.
func (p *DataCollectionRuleAssociationsClientListByRulePager) NextPage(ctx context.Context) bool {
	var req *policy.Request
	var err error
	if !reflect.ValueOf(p.current).IsZero() {
		if p.current.DataCollectionRuleAssociationProxyOnlyResourceListResult.NextLink == nil || len(*p.current.DataCollectionRuleAssociationProxyOnlyResourceListResult.NextLink) == 0 {
			return false
		}
		req, err = p.advancer(ctx, p.current)
	} else {
		req, err = p.requester(ctx)
	}
	if err != nil {
		p.err = err
		return false
	}
	resp, err := p.client.pl.Do(req)
	if err != nil {
		p.err = err
		return false
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		p.err = runtime.NewResponseError(resp)
		return false
	}
	result, err := p.client.listByRuleHandleResponse(resp)
	if err != nil {
		p.err = err
		return false
	}
	p.current = result
	return true
}

// PageResponse returns the current DataCollectionRuleAssociationsClientListByRuleResponse page.
func (p *DataCollectionRuleAssociationsClientListByRulePager) PageResponse() DataCollectionRuleAssociationsClientListByRuleResponse {
	return p.current
}

// DataCollectionRulesClientListByResourceGroupPager provides operations for iterating over paged responses.
type DataCollectionRulesClientListByResourceGroupPager struct {
	client    *DataCollectionRulesClient
	current   DataCollectionRulesClientListByResourceGroupResponse
	err       error
	requester func(context.Context) (*policy.Request, error)
	advancer  func(context.Context, DataCollectionRulesClientListByResourceGroupResponse) (*policy.Request, error)
}

// Err returns the last error encountered while paging.
func (p *DataCollectionRulesClientListByResourceGroupPager) Err() error {
	return p.err
}

// NextPage returns true if the pager advanced to the next page.
// Returns false if there are no more pages or an error occurred.
func (p *DataCollectionRulesClientListByResourceGroupPager) NextPage(ctx context.Context) bool {
	var req *policy.Request
	var err error
	if !reflect.ValueOf(p.current).IsZero() {
		if p.current.DataCollectionRuleResourceListResult.NextLink == nil || len(*p.current.DataCollectionRuleResourceListResult.NextLink) == 0 {
			return false
		}
		req, err = p.advancer(ctx, p.current)
	} else {
		req, err = p.requester(ctx)
	}
	if err != nil {
		p.err = err
		return false
	}
	resp, err := p.client.pl.Do(req)
	if err != nil {
		p.err = err
		return false
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		p.err = runtime.NewResponseError(resp)
		return false
	}
	result, err := p.client.listByResourceGroupHandleResponse(resp)
	if err != nil {
		p.err = err
		return false
	}
	p.current = result
	return true
}

// PageResponse returns the current DataCollectionRulesClientListByResourceGroupResponse page.
func (p *DataCollectionRulesClientListByResourceGroupPager) PageResponse() DataCollectionRulesClientListByResourceGroupResponse {
	return p.current
}

// DataCollectionRulesClientListBySubscriptionPager provides operations for iterating over paged responses.
type DataCollectionRulesClientListBySubscriptionPager struct {
	client    *DataCollectionRulesClient
	current   DataCollectionRulesClientListBySubscriptionResponse
	err       error
	requester func(context.Context) (*policy.Request, error)
	advancer  func(context.Context, DataCollectionRulesClientListBySubscriptionResponse) (*policy.Request, error)
}

// Err returns the last error encountered while paging.
func (p *DataCollectionRulesClientListBySubscriptionPager) Err() error {
	return p.err
}

// NextPage returns true if the pager advanced to the next page.
// Returns false if there are no more pages or an error occurred.
func (p *DataCollectionRulesClientListBySubscriptionPager) NextPage(ctx context.Context) bool {
	var req *policy.Request
	var err error
	if !reflect.ValueOf(p.current).IsZero() {
		if p.current.DataCollectionRuleResourceListResult.NextLink == nil || len(*p.current.DataCollectionRuleResourceListResult.NextLink) == 0 {
			return false
		}
		req, err = p.advancer(ctx, p.current)
	} else {
		req, err = p.requester(ctx)
	}
	if err != nil {
		p.err = err
		return false
	}
	resp, err := p.client.pl.Do(req)
	if err != nil {
		p.err = err
		return false
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		p.err = runtime.NewResponseError(resp)
		return false
	}
	result, err := p.client.listBySubscriptionHandleResponse(resp)
	if err != nil {
		p.err = err
		return false
	}
	p.current = result
	return true
}

// PageResponse returns the current DataCollectionRulesClientListBySubscriptionResponse page.
func (p *DataCollectionRulesClientListBySubscriptionPager) PageResponse() DataCollectionRulesClientListBySubscriptionResponse {
	return p.current
}

// PrivateEndpointConnectionsClientListByPrivateLinkScopePager provides operations for iterating over paged responses.
type PrivateEndpointConnectionsClientListByPrivateLinkScopePager struct {
	client    *PrivateEndpointConnectionsClient
	current   PrivateEndpointConnectionsClientListByPrivateLinkScopeResponse
	err       error
	requester func(context.Context) (*policy.Request, error)
	advancer  func(context.Context, PrivateEndpointConnectionsClientListByPrivateLinkScopeResponse) (*policy.Request, error)
}

// Err returns the last error encountered while paging.
func (p *PrivateEndpointConnectionsClientListByPrivateLinkScopePager) Err() error {
	return p.err
}

// NextPage returns true if the pager advanced to the next page.
// Returns false if there are no more pages or an error occurred.
func (p *PrivateEndpointConnectionsClientListByPrivateLinkScopePager) NextPage(ctx context.Context) bool {
	var req *policy.Request
	var err error
	if !reflect.ValueOf(p.current).IsZero() {
		if p.current.PrivateEndpointConnectionListResult.NextLink == nil || len(*p.current.PrivateEndpointConnectionListResult.NextLink) == 0 {
			return false
		}
		req, err = p.advancer(ctx, p.current)
	} else {
		req, err = p.requester(ctx)
	}
	if err != nil {
		p.err = err
		return false
	}
	resp, err := p.client.pl.Do(req)
	if err != nil {
		p.err = err
		return false
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		p.err = runtime.NewResponseError(resp)
		return false
	}
	result, err := p.client.listByPrivateLinkScopeHandleResponse(resp)
	if err != nil {
		p.err = err
		return false
	}
	p.current = result
	return true
}

// PageResponse returns the current PrivateEndpointConnectionsClientListByPrivateLinkScopeResponse page.
func (p *PrivateEndpointConnectionsClientListByPrivateLinkScopePager) PageResponse() PrivateEndpointConnectionsClientListByPrivateLinkScopeResponse {
	return p.current
}

// PrivateLinkResourcesClientListByPrivateLinkScopePager provides operations for iterating over paged responses.
type PrivateLinkResourcesClientListByPrivateLinkScopePager struct {
	client    *PrivateLinkResourcesClient
	current   PrivateLinkResourcesClientListByPrivateLinkScopeResponse
	err       error
	requester func(context.Context) (*policy.Request, error)
	advancer  func(context.Context, PrivateLinkResourcesClientListByPrivateLinkScopeResponse) (*policy.Request, error)
}

// Err returns the last error encountered while paging.
func (p *PrivateLinkResourcesClientListByPrivateLinkScopePager) Err() error {
	return p.err
}

// NextPage returns true if the pager advanced to the next page.
// Returns false if there are no more pages or an error occurred.
func (p *PrivateLinkResourcesClientListByPrivateLinkScopePager) NextPage(ctx context.Context) bool {
	var req *policy.Request
	var err error
	if !reflect.ValueOf(p.current).IsZero() {
		if p.current.PrivateLinkResourceListResult.NextLink == nil || len(*p.current.PrivateLinkResourceListResult.NextLink) == 0 {
			return false
		}
		req, err = p.advancer(ctx, p.current)
	} else {
		req, err = p.requester(ctx)
	}
	if err != nil {
		p.err = err
		return false
	}
	resp, err := p.client.pl.Do(req)
	if err != nil {
		p.err = err
		return false
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		p.err = runtime.NewResponseError(resp)
		return false
	}
	result, err := p.client.listByPrivateLinkScopeHandleResponse(resp)
	if err != nil {
		p.err = err
		return false
	}
	p.current = result
	return true
}

// PageResponse returns the current PrivateLinkResourcesClientListByPrivateLinkScopeResponse page.
func (p *PrivateLinkResourcesClientListByPrivateLinkScopePager) PageResponse() PrivateLinkResourcesClientListByPrivateLinkScopeResponse {
	return p.current
}

// PrivateLinkScopedResourcesClientListByPrivateLinkScopePager provides operations for iterating over paged responses.
type PrivateLinkScopedResourcesClientListByPrivateLinkScopePager struct {
	client    *PrivateLinkScopedResourcesClient
	current   PrivateLinkScopedResourcesClientListByPrivateLinkScopeResponse
	err       error
	requester func(context.Context) (*policy.Request, error)
	advancer  func(context.Context, PrivateLinkScopedResourcesClientListByPrivateLinkScopeResponse) (*policy.Request, error)
}

// Err returns the last error encountered while paging.
func (p *PrivateLinkScopedResourcesClientListByPrivateLinkScopePager) Err() error {
	return p.err
}

// NextPage returns true if the pager advanced to the next page.
// Returns false if there are no more pages or an error occurred.
func (p *PrivateLinkScopedResourcesClientListByPrivateLinkScopePager) NextPage(ctx context.Context) bool {
	var req *policy.Request
	var err error
	if !reflect.ValueOf(p.current).IsZero() {
		if p.current.ScopedResourceListResult.NextLink == nil || len(*p.current.ScopedResourceListResult.NextLink) == 0 {
			return false
		}
		req, err = p.advancer(ctx, p.current)
	} else {
		req, err = p.requester(ctx)
	}
	if err != nil {
		p.err = err
		return false
	}
	resp, err := p.client.pl.Do(req)
	if err != nil {
		p.err = err
		return false
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		p.err = runtime.NewResponseError(resp)
		return false
	}
	result, err := p.client.listByPrivateLinkScopeHandleResponse(resp)
	if err != nil {
		p.err = err
		return false
	}
	p.current = result
	return true
}

// PageResponse returns the current PrivateLinkScopedResourcesClientListByPrivateLinkScopeResponse page.
func (p *PrivateLinkScopedResourcesClientListByPrivateLinkScopePager) PageResponse() PrivateLinkScopedResourcesClientListByPrivateLinkScopeResponse {
	return p.current
}

// PrivateLinkScopesClientListByResourceGroupPager provides operations for iterating over paged responses.
type PrivateLinkScopesClientListByResourceGroupPager struct {
	client    *PrivateLinkScopesClient
	current   PrivateLinkScopesClientListByResourceGroupResponse
	err       error
	requester func(context.Context) (*policy.Request, error)
	advancer  func(context.Context, PrivateLinkScopesClientListByResourceGroupResponse) (*policy.Request, error)
}

// Err returns the last error encountered while paging.
func (p *PrivateLinkScopesClientListByResourceGroupPager) Err() error {
	return p.err
}

// NextPage returns true if the pager advanced to the next page.
// Returns false if there are no more pages or an error occurred.
func (p *PrivateLinkScopesClientListByResourceGroupPager) NextPage(ctx context.Context) bool {
	var req *policy.Request
	var err error
	if !reflect.ValueOf(p.current).IsZero() {
		if p.current.AzureMonitorPrivateLinkScopeListResult.NextLink == nil || len(*p.current.AzureMonitorPrivateLinkScopeListResult.NextLink) == 0 {
			return false
		}
		req, err = p.advancer(ctx, p.current)
	} else {
		req, err = p.requester(ctx)
	}
	if err != nil {
		p.err = err
		return false
	}
	resp, err := p.client.pl.Do(req)
	if err != nil {
		p.err = err
		return false
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		p.err = runtime.NewResponseError(resp)
		return false
	}
	result, err := p.client.listByResourceGroupHandleResponse(resp)
	if err != nil {
		p.err = err
		return false
	}
	p.current = result
	return true
}

// PageResponse returns the current PrivateLinkScopesClientListByResourceGroupResponse page.
func (p *PrivateLinkScopesClientListByResourceGroupPager) PageResponse() PrivateLinkScopesClientListByResourceGroupResponse {
	return p.current
}

// PrivateLinkScopesClientListPager provides operations for iterating over paged responses.
type PrivateLinkScopesClientListPager struct {
	client    *PrivateLinkScopesClient
	current   PrivateLinkScopesClientListResponse
	err       error
	requester func(context.Context) (*policy.Request, error)
	advancer  func(context.Context, PrivateLinkScopesClientListResponse) (*policy.Request, error)
}

// Err returns the last error encountered while paging.
func (p *PrivateLinkScopesClientListPager) Err() error {
	return p.err
}

// NextPage returns true if the pager advanced to the next page.
// Returns false if there are no more pages or an error occurred.
func (p *PrivateLinkScopesClientListPager) NextPage(ctx context.Context) bool {
	var req *policy.Request
	var err error
	if !reflect.ValueOf(p.current).IsZero() {
		if p.current.AzureMonitorPrivateLinkScopeListResult.NextLink == nil || len(*p.current.AzureMonitorPrivateLinkScopeListResult.NextLink) == 0 {
			return false
		}
		req, err = p.advancer(ctx, p.current)
	} else {
		req, err = p.requester(ctx)
	}
	if err != nil {
		p.err = err
		return false
	}
	resp, err := p.client.pl.Do(req)
	if err != nil {
		p.err = err
		return false
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		p.err = runtime.NewResponseError(resp)
		return false
	}
	result, err := p.client.listHandleResponse(resp)
	if err != nil {
		p.err = err
		return false
	}
	p.current = result
	return true
}

// PageResponse returns the current PrivateLinkScopesClientListResponse page.
func (p *PrivateLinkScopesClientListPager) PageResponse() PrivateLinkScopesClientListResponse {
	return p.current
}

// TenantActivityLogsClientListPager provides operations for iterating over paged responses.
type TenantActivityLogsClientListPager struct {
	client    *TenantActivityLogsClient
	current   TenantActivityLogsClientListResponse
	err       error
	requester func(context.Context) (*policy.Request, error)
	advancer  func(context.Context, TenantActivityLogsClientListResponse) (*policy.Request, error)
}

// Err returns the last error encountered while paging.
func (p *TenantActivityLogsClientListPager) Err() error {
	return p.err
}

// NextPage returns true if the pager advanced to the next page.
// Returns false if there are no more pages or an error occurred.
func (p *TenantActivityLogsClientListPager) NextPage(ctx context.Context) bool {
	var req *policy.Request
	var err error
	if !reflect.ValueOf(p.current).IsZero() {
		if p.current.EventDataCollection.NextLink == nil || len(*p.current.EventDataCollection.NextLink) == 0 {
			return false
		}
		req, err = p.advancer(ctx, p.current)
	} else {
		req, err = p.requester(ctx)
	}
	if err != nil {
		p.err = err
		return false
	}
	resp, err := p.client.pl.Do(req)
	if err != nil {
		p.err = err
		return false
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		p.err = runtime.NewResponseError(resp)
		return false
	}
	result, err := p.client.listHandleResponse(resp)
	if err != nil {
		p.err = err
		return false
	}
	p.current = result
	return true
}

// PageResponse returns the current TenantActivityLogsClientListResponse page.
func (p *TenantActivityLogsClientListPager) PageResponse() TenantActivityLogsClientListResponse {
	return p.current
}
