# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
from bitarray import bitarray
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

class openconfig_telemetry_types(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-telemetry-types - based on the path /openconfig-telemetry-types. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This module defines type and identities used by the OpenConfig
telemetry model.
  """
  _pyangbind_elements = {}

  

class yc_config_openconfig_telemetry__telemetry_system_sensor_groups_sensor_group_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-telemetry - based on the path /telemetry-system/sensor-groups/sensor-group/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration parameters relating to the
telemetry sensor grouping
  """
  __slots__ = ('_path_helper', '_extmethods', '__sensor_group_id',)

  _yang_name = 'config'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__sensor_group_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="sensor-group-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='string', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['telemetry-system', 'sensor-groups', 'sensor-group', 'config']

  def _get_sensor_group_id(self):
    """
    Getter method for sensor_group_id, mapped from YANG variable /telemetry_system/sensor_groups/sensor_group/config/sensor_group_id (string)

    YANG Description: Name or identifier for the sensor group itself.
Will be referenced by other configuration specifying a
sensor group
    """
    return self.__sensor_group_id
      
  def _set_sensor_group_id(self, v, load=False):
    """
    Setter method for sensor_group_id, mapped from YANG variable /telemetry_system/sensor_groups/sensor_group/config/sensor_group_id (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_sensor_group_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_sensor_group_id() directly.

    YANG Description: Name or identifier for the sensor group itself.
Will be referenced by other configuration specifying a
sensor group
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="sensor-group-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """sensor_group_id must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="sensor-group-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='string', is_config=True)""",
        })

    self.__sensor_group_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_sensor_group_id(self):
    self.__sensor_group_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="sensor-group-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='string', is_config=True)

  sensor_group_id = __builtin__.property(_get_sensor_group_id, _set_sensor_group_id)


  _pyangbind_elements = OrderedDict([('sensor_group_id', sensor_group_id), ])


class yc_state_openconfig_telemetry__telemetry_system_sensor_groups_sensor_group_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-telemetry - based on the path /telemetry-system/sensor-groups/sensor-group/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: State information relating to the telemetry
sensor group
  """
  __slots__ = ('_path_helper', '_extmethods', '__sensor_group_id',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__sensor_group_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="sensor-group-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='string', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['telemetry-system', 'sensor-groups', 'sensor-group', 'state']

  def _get_sensor_group_id(self):
    """
    Getter method for sensor_group_id, mapped from YANG variable /telemetry_system/sensor_groups/sensor_group/state/sensor_group_id (string)

    YANG Description: Name or identifier for the sensor group itself.
Will be referenced by other configuration specifying a
sensor group
    """
    return self.__sensor_group_id
      
  def _set_sensor_group_id(self, v, load=False):
    """
    Setter method for sensor_group_id, mapped from YANG variable /telemetry_system/sensor_groups/sensor_group/state/sensor_group_id (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_sensor_group_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_sensor_group_id() directly.

    YANG Description: Name or identifier for the sensor group itself.
Will be referenced by other configuration specifying a
sensor group
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="sensor-group-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """sensor_group_id must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="sensor-group-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='string', is_config=False)""",
        })

    self.__sensor_group_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_sensor_group_id(self):
    self.__sensor_group_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="sensor-group-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='string', is_config=False)

  sensor_group_id = __builtin__.property(_get_sensor_group_id)


  _pyangbind_elements = OrderedDict([('sensor_group_id', sensor_group_id), ])


class yc_config_openconfig_telemetry__telemetry_system_sensor_groups_sensor_group_sensor_paths_sensor_path_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-telemetry - based on the path /telemetry-system/sensor-groups/sensor-group/sensor-paths/sensor-path/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration parameters to configure a set
of data model paths as a sensor grouping
  """
  __slots__ = ('_path_helper', '_extmethods', '__path','__exclude_filter',)

  _yang_name = 'config'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__path = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="path", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='string', is_config=True)
    self.__exclude_filter = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="exclude-filter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='string', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['telemetry-system', 'sensor-groups', 'sensor-group', 'sensor-paths', 'sensor-path', 'config']

  def _get_path(self):
    """
    Getter method for path, mapped from YANG variable /telemetry_system/sensor_groups/sensor_group/sensor_paths/sensor_path/config/path (string)

    YANG Description: Path to a section of operational state of interest
(the sensor).
    """
    return self.__path
      
  def _set_path(self, v, load=False):
    """
    Setter method for path, mapped from YANG variable /telemetry_system/sensor_groups/sensor_group/sensor_paths/sensor_path/config/path (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_path is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_path() directly.

    YANG Description: Path to a section of operational state of interest
(the sensor).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="path", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """path must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="path", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='string', is_config=True)""",
        })

    self.__path = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_path(self):
    self.__path = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="path", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='string', is_config=True)


  def _get_exclude_filter(self):
    """
    Getter method for exclude_filter, mapped from YANG variable /telemetry_system/sensor_groups/sensor_group/sensor_paths/sensor_path/config/exclude_filter (string)

    YANG Description: Filter to exclude certain values out of the state
values
    """
    return self.__exclude_filter
      
  def _set_exclude_filter(self, v, load=False):
    """
    Setter method for exclude_filter, mapped from YANG variable /telemetry_system/sensor_groups/sensor_group/sensor_paths/sensor_path/config/exclude_filter (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_exclude_filter is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_exclude_filter() directly.

    YANG Description: Filter to exclude certain values out of the state
values
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="exclude-filter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """exclude_filter must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="exclude-filter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='string', is_config=True)""",
        })

    self.__exclude_filter = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_exclude_filter(self):
    self.__exclude_filter = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="exclude-filter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='string', is_config=True)

  path = __builtin__.property(_get_path, _set_path)
  exclude_filter = __builtin__.property(_get_exclude_filter, _set_exclude_filter)


  _pyangbind_elements = OrderedDict([('path', path), ('exclude_filter', exclude_filter), ])


class yc_state_openconfig_telemetry__telemetry_system_sensor_groups_sensor_group_sensor_paths_sensor_path_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-telemetry - based on the path /telemetry-system/sensor-groups/sensor-group/sensor-paths/sensor-path/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration parameters to configure a set
of data model paths as a sensor grouping
  """
  __slots__ = ('_path_helper', '_extmethods', '__path','__exclude_filter',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__path = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="path", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='string', is_config=False)
    self.__exclude_filter = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="exclude-filter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='string', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['telemetry-system', 'sensor-groups', 'sensor-group', 'sensor-paths', 'sensor-path', 'state']

  def _get_path(self):
    """
    Getter method for path, mapped from YANG variable /telemetry_system/sensor_groups/sensor_group/sensor_paths/sensor_path/state/path (string)

    YANG Description: Path to a section of operational state of interest
(the sensor).
    """
    return self.__path
      
  def _set_path(self, v, load=False):
    """
    Setter method for path, mapped from YANG variable /telemetry_system/sensor_groups/sensor_group/sensor_paths/sensor_path/state/path (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_path is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_path() directly.

    YANG Description: Path to a section of operational state of interest
(the sensor).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="path", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """path must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="path", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='string', is_config=False)""",
        })

    self.__path = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_path(self):
    self.__path = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="path", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='string', is_config=False)


  def _get_exclude_filter(self):
    """
    Getter method for exclude_filter, mapped from YANG variable /telemetry_system/sensor_groups/sensor_group/sensor_paths/sensor_path/state/exclude_filter (string)

    YANG Description: Filter to exclude certain values out of the state
values
    """
    return self.__exclude_filter
      
  def _set_exclude_filter(self, v, load=False):
    """
    Setter method for exclude_filter, mapped from YANG variable /telemetry_system/sensor_groups/sensor_group/sensor_paths/sensor_path/state/exclude_filter (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_exclude_filter is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_exclude_filter() directly.

    YANG Description: Filter to exclude certain values out of the state
values
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="exclude-filter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """exclude_filter must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="exclude-filter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='string', is_config=False)""",
        })

    self.__exclude_filter = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_exclude_filter(self):
    self.__exclude_filter = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="exclude-filter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='string', is_config=False)

  path = __builtin__.property(_get_path)
  exclude_filter = __builtin__.property(_get_exclude_filter)


  _pyangbind_elements = OrderedDict([('path', path), ('exclude_filter', exclude_filter), ])


class yc_sensor_path_openconfig_telemetry__telemetry_system_sensor_groups_sensor_group_sensor_paths_sensor_path(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-telemetry - based on the path /telemetry-system/sensor-groups/sensor-group/sensor-paths/sensor-path. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of paths in the model which together
comprise a sensor grouping. Filters for each path
to exclude items are also provided.
  """
  __slots__ = ('_path_helper', '_extmethods', '__path','__config','__state',)

  _yang_name = 'sensor-path'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__path = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="path", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_telemetry__telemetry_system_sensor_groups_sensor_group_sensor_paths_sensor_path_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_telemetry__telemetry_system_sensor_groups_sensor_group_sensor_paths_sensor_path_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['telemetry-system', 'sensor-groups', 'sensor-group', 'sensor-paths', 'sensor-path']

  def _get_path(self):
    """
    Getter method for path, mapped from YANG variable /telemetry_system/sensor_groups/sensor_group/sensor_paths/sensor_path/path (leafref)

    YANG Description: Reference to the path of interest
    """
    return self.__path
      
  def _set_path(self, v, load=False):
    """
    Setter method for path, mapped from YANG variable /telemetry_system/sensor_groups/sensor_group/sensor_paths/sensor_path/path (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_path is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_path() directly.

    YANG Description: Reference to the path of interest
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="path", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """path must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="path", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='leafref', is_config=True)""",
        })

    self.__path = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_path(self):
    self.__path = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="path", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /telemetry_system/sensor_groups/sensor_group/sensor_paths/sensor_path/config (container)

    YANG Description: Configuration parameters to configure a set
of data model paths as a sensor grouping
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /telemetry_system/sensor_groups/sensor_group/sensor_paths/sensor_path/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration parameters to configure a set
of data model paths as a sensor grouping
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_telemetry__telemetry_system_sensor_groups_sensor_group_sensor_paths_sensor_path_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_telemetry__telemetry_system_sensor_groups_sensor_group_sensor_paths_sensor_path_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_telemetry__telemetry_system_sensor_groups_sensor_group_sensor_paths_sensor_path_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /telemetry_system/sensor_groups/sensor_group/sensor_paths/sensor_path/state (container)

    YANG Description: Configuration parameters to configure a set
of data model paths as a sensor grouping
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /telemetry_system/sensor_groups/sensor_group/sensor_paths/sensor_path/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Configuration parameters to configure a set
of data model paths as a sensor grouping
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_telemetry__telemetry_system_sensor_groups_sensor_group_sensor_paths_sensor_path_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_telemetry__telemetry_system_sensor_groups_sensor_group_sensor_paths_sensor_path_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_telemetry__telemetry_system_sensor_groups_sensor_group_sensor_paths_sensor_path_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)

  path = __builtin__.property(_get_path, _set_path)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('path', path), ('config', config), ('state', state), ])


class yc_sensor_paths_openconfig_telemetry__telemetry_system_sensor_groups_sensor_group_sensor_paths(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-telemetry - based on the path /telemetry-system/sensor-groups/sensor-group/sensor-paths. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Top level container to hold a set of sensor
paths grouped together
  """
  __slots__ = ('_path_helper', '_extmethods', '__sensor_path',)

  _yang_name = 'sensor-paths'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__sensor_path = YANGDynClass(base=YANGListType("path",yc_sensor_path_openconfig_telemetry__telemetry_system_sensor_groups_sensor_group_sensor_paths_sensor_path, yang_name="sensor-path", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='path', extensions=None), is_container='list', yang_name="sensor-path", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['telemetry-system', 'sensor-groups', 'sensor-group', 'sensor-paths']

  def _get_sensor_path(self):
    """
    Getter method for sensor_path, mapped from YANG variable /telemetry_system/sensor_groups/sensor_group/sensor_paths/sensor_path (list)

    YANG Description: List of paths in the model which together
comprise a sensor grouping. Filters for each path
to exclude items are also provided.
    """
    return self.__sensor_path
      
  def _set_sensor_path(self, v, load=False):
    """
    Setter method for sensor_path, mapped from YANG variable /telemetry_system/sensor_groups/sensor_group/sensor_paths/sensor_path (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_sensor_path is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_sensor_path() directly.

    YANG Description: List of paths in the model which together
comprise a sensor grouping. Filters for each path
to exclude items are also provided.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("path",yc_sensor_path_openconfig_telemetry__telemetry_system_sensor_groups_sensor_group_sensor_paths_sensor_path, yang_name="sensor-path", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='path', extensions=None), is_container='list', yang_name="sensor-path", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """sensor_path must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("path",yc_sensor_path_openconfig_telemetry__telemetry_system_sensor_groups_sensor_group_sensor_paths_sensor_path, yang_name="sensor-path", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='path', extensions=None), is_container='list', yang_name="sensor-path", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='list', is_config=True)""",
        })

    self.__sensor_path = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_sensor_path(self):
    self.__sensor_path = YANGDynClass(base=YANGListType("path",yc_sensor_path_openconfig_telemetry__telemetry_system_sensor_groups_sensor_group_sensor_paths_sensor_path, yang_name="sensor-path", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='path', extensions=None), is_container='list', yang_name="sensor-path", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='list', is_config=True)

  sensor_path = __builtin__.property(_get_sensor_path, _set_sensor_path)


  _pyangbind_elements = OrderedDict([('sensor_path', sensor_path), ])


class yc_sensor_group_openconfig_telemetry__telemetry_system_sensor_groups_sensor_group(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-telemetry - based on the path /telemetry-system/sensor-groups/sensor-group. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of telemetry sensory groups on the local
system, where a sensor grouping represents a resuable
grouping of multiple paths and exclude filters.
  """
  __slots__ = ('_path_helper', '_extmethods', '__sensor_group_id','__config','__state','__sensor_paths',)

  _yang_name = 'sensor-group'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__sensor_group_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="sensor-group-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_telemetry__telemetry_system_sensor_groups_sensor_group_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_telemetry__telemetry_system_sensor_groups_sensor_group_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)
    self.__sensor_paths = YANGDynClass(base=yc_sensor_paths_openconfig_telemetry__telemetry_system_sensor_groups_sensor_group_sensor_paths, is_container='container', yang_name="sensor-paths", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['telemetry-system', 'sensor-groups', 'sensor-group']

  def _get_sensor_group_id(self):
    """
    Getter method for sensor_group_id, mapped from YANG variable /telemetry_system/sensor_groups/sensor_group/sensor_group_id (leafref)

    YANG Description: Reference to the name or identifier of the
sensor grouping
    """
    return self.__sensor_group_id
      
  def _set_sensor_group_id(self, v, load=False):
    """
    Setter method for sensor_group_id, mapped from YANG variable /telemetry_system/sensor_groups/sensor_group/sensor_group_id (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_sensor_group_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_sensor_group_id() directly.

    YANG Description: Reference to the name or identifier of the
sensor grouping
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="sensor-group-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """sensor_group_id must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="sensor-group-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='leafref', is_config=True)""",
        })

    self.__sensor_group_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_sensor_group_id(self):
    self.__sensor_group_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="sensor-group-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /telemetry_system/sensor_groups/sensor_group/config (container)

    YANG Description: Configuration parameters relating to the
telemetry sensor grouping
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /telemetry_system/sensor_groups/sensor_group/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration parameters relating to the
telemetry sensor grouping
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_telemetry__telemetry_system_sensor_groups_sensor_group_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_telemetry__telemetry_system_sensor_groups_sensor_group_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_telemetry__telemetry_system_sensor_groups_sensor_group_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /telemetry_system/sensor_groups/sensor_group/state (container)

    YANG Description: State information relating to the telemetry
sensor group
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /telemetry_system/sensor_groups/sensor_group/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: State information relating to the telemetry
sensor group
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_telemetry__telemetry_system_sensor_groups_sensor_group_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_telemetry__telemetry_system_sensor_groups_sensor_group_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_telemetry__telemetry_system_sensor_groups_sensor_group_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)


  def _get_sensor_paths(self):
    """
    Getter method for sensor_paths, mapped from YANG variable /telemetry_system/sensor_groups/sensor_group/sensor_paths (container)

    YANG Description: Top level container to hold a set of sensor
paths grouped together
    """
    return self.__sensor_paths
      
  def _set_sensor_paths(self, v, load=False):
    """
    Setter method for sensor_paths, mapped from YANG variable /telemetry_system/sensor_groups/sensor_group/sensor_paths (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_sensor_paths is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_sensor_paths() directly.

    YANG Description: Top level container to hold a set of sensor
paths grouped together
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_sensor_paths_openconfig_telemetry__telemetry_system_sensor_groups_sensor_group_sensor_paths, is_container='container', yang_name="sensor-paths", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """sensor_paths must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_sensor_paths_openconfig_telemetry__telemetry_system_sensor_groups_sensor_group_sensor_paths, is_container='container', yang_name="sensor-paths", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)""",
        })

    self.__sensor_paths = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_sensor_paths(self):
    self.__sensor_paths = YANGDynClass(base=yc_sensor_paths_openconfig_telemetry__telemetry_system_sensor_groups_sensor_group_sensor_paths, is_container='container', yang_name="sensor-paths", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)

  sensor_group_id = __builtin__.property(_get_sensor_group_id, _set_sensor_group_id)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)
  sensor_paths = __builtin__.property(_get_sensor_paths, _set_sensor_paths)


  _pyangbind_elements = OrderedDict([('sensor_group_id', sensor_group_id), ('config', config), ('state', state), ('sensor_paths', sensor_paths), ])


class yc_sensor_groups_openconfig_telemetry__telemetry_system_sensor_groups(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-telemetry - based on the path /telemetry-system/sensor-groups. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Top level container for sensor-groups.
  """
  __slots__ = ('_path_helper', '_extmethods', '__sensor_group',)

  _yang_name = 'sensor-groups'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__sensor_group = YANGDynClass(base=YANGListType("sensor_group_id",yc_sensor_group_openconfig_telemetry__telemetry_system_sensor_groups_sensor_group, yang_name="sensor-group", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='sensor-group-id', extensions=None), is_container='list', yang_name="sensor-group", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['telemetry-system', 'sensor-groups']

  def _get_sensor_group(self):
    """
    Getter method for sensor_group, mapped from YANG variable /telemetry_system/sensor_groups/sensor_group (list)

    YANG Description: List of telemetry sensory groups on the local
system, where a sensor grouping represents a resuable
grouping of multiple paths and exclude filters.
    """
    return self.__sensor_group
      
  def _set_sensor_group(self, v, load=False):
    """
    Setter method for sensor_group, mapped from YANG variable /telemetry_system/sensor_groups/sensor_group (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_sensor_group is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_sensor_group() directly.

    YANG Description: List of telemetry sensory groups on the local
system, where a sensor grouping represents a resuable
grouping of multiple paths and exclude filters.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("sensor_group_id",yc_sensor_group_openconfig_telemetry__telemetry_system_sensor_groups_sensor_group, yang_name="sensor-group", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='sensor-group-id', extensions=None), is_container='list', yang_name="sensor-group", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """sensor_group must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("sensor_group_id",yc_sensor_group_openconfig_telemetry__telemetry_system_sensor_groups_sensor_group, yang_name="sensor-group", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='sensor-group-id', extensions=None), is_container='list', yang_name="sensor-group", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='list', is_config=True)""",
        })

    self.__sensor_group = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_sensor_group(self):
    self.__sensor_group = YANGDynClass(base=YANGListType("sensor_group_id",yc_sensor_group_openconfig_telemetry__telemetry_system_sensor_groups_sensor_group, yang_name="sensor-group", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='sensor-group-id', extensions=None), is_container='list', yang_name="sensor-group", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='list', is_config=True)

  sensor_group = __builtin__.property(_get_sensor_group, _set_sensor_group)


  _pyangbind_elements = OrderedDict([('sensor_group', sensor_group), ])


class yc_config_openconfig_telemetry__telemetry_system_destination_groups_destination_group_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-telemetry - based on the path /telemetry-system/destination-groups/destination-group/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Top level config container for destination groups
  """
  __slots__ = ('_path_helper', '_extmethods', '__group_id',)

  _yang_name = 'config'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__group_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="group-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='string', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['telemetry-system', 'destination-groups', 'destination-group', 'config']

  def _get_group_id(self):
    """
    Getter method for group_id, mapped from YANG variable /telemetry_system/destination_groups/destination_group/config/group_id (string)

    YANG Description: Unique identifier for the destination group
    """
    return self.__group_id
      
  def _set_group_id(self, v, load=False):
    """
    Setter method for group_id, mapped from YANG variable /telemetry_system/destination_groups/destination_group/config/group_id (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_group_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_group_id() directly.

    YANG Description: Unique identifier for the destination group
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="group-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """group_id must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="group-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='string', is_config=True)""",
        })

    self.__group_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_group_id(self):
    self.__group_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="group-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='string', is_config=True)

  group_id = __builtin__.property(_get_group_id, _set_group_id)


  _pyangbind_elements = OrderedDict([('group_id', group_id), ])


class yc_state_openconfig_telemetry__telemetry_system_destination_groups_destination_group_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-telemetry - based on the path /telemetry-system/destination-groups/destination-group/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Top level state container for destination groups
  """
  __slots__ = ('_path_helper', '_extmethods', '__group_id',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__group_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="group-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='string', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['telemetry-system', 'destination-groups', 'destination-group', 'state']

  def _get_group_id(self):
    """
    Getter method for group_id, mapped from YANG variable /telemetry_system/destination_groups/destination_group/state/group_id (string)

    YANG Description: Unique identifier for destination group
    """
    return self.__group_id
      
  def _set_group_id(self, v, load=False):
    """
    Setter method for group_id, mapped from YANG variable /telemetry_system/destination_groups/destination_group/state/group_id (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_group_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_group_id() directly.

    YANG Description: Unique identifier for destination group
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="group-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """group_id must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="group-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='string', is_config=False)""",
        })

    self.__group_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_group_id(self):
    self.__group_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="group-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='string', is_config=False)

  group_id = __builtin__.property(_get_group_id)


  _pyangbind_elements = OrderedDict([('group_id', group_id), ])


class yc_config_openconfig_telemetry__telemetry_system_destination_groups_destination_group_destinations_destination_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-telemetry - based on the path /telemetry-system/destination-groups/destination-group/destinations/destination/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration parameters relating to
telemetry destinations
  """
  __slots__ = ('_path_helper', '_extmethods', '__destination_address','__destination_port',)

  _yang_name = 'config'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__destination_address = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="destination-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='oc-inet:ip-address', is_config=True)
    self.__destination_port = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="destination-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='uint16', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['telemetry-system', 'destination-groups', 'destination-group', 'destinations', 'destination', 'config']

  def _get_destination_address(self):
    """
    Getter method for destination_address, mapped from YANG variable /telemetry_system/destination_groups/destination_group/destinations/destination/config/destination_address (oc-inet:ip-address)

    YANG Description: IP address of the telemetry stream destination
    """
    return self.__destination_address
      
  def _set_destination_address(self, v, load=False):
    """
    Setter method for destination_address, mapped from YANG variable /telemetry_system/destination_groups/destination_group/destinations/destination/config/destination_address (oc-inet:ip-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_destination_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_destination_address() directly.

    YANG Description: IP address of the telemetry stream destination
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="destination-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='oc-inet:ip-address', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """destination_address must be of a type compatible with oc-inet:ip-address""",
          'defined-type': "oc-inet:ip-address",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="destination-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='oc-inet:ip-address', is_config=True)""",
        })

    self.__destination_address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_destination_address(self):
    self.__destination_address = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="destination-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='oc-inet:ip-address', is_config=True)


  def _get_destination_port(self):
    """
    Getter method for destination_port, mapped from YANG variable /telemetry_system/destination_groups/destination_group/destinations/destination/config/destination_port (uint16)

    YANG Description: Protocol (udp or tcp) port number for the telemetry
stream destination
    """
    return self.__destination_port
      
  def _set_destination_port(self, v, load=False):
    """
    Setter method for destination_port, mapped from YANG variable /telemetry_system/destination_groups/destination_group/destinations/destination/config/destination_port (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_destination_port is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_destination_port() directly.

    YANG Description: Protocol (udp or tcp) port number for the telemetry
stream destination
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="destination-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='uint16', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """destination_port must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="destination-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='uint16', is_config=True)""",
        })

    self.__destination_port = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_destination_port(self):
    self.__destination_port = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="destination-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='uint16', is_config=True)

  destination_address = __builtin__.property(_get_destination_address, _set_destination_address)
  destination_port = __builtin__.property(_get_destination_port, _set_destination_port)


  _pyangbind_elements = OrderedDict([('destination_address', destination_address), ('destination_port', destination_port), ])


class yc_state_openconfig_telemetry__telemetry_system_destination_groups_destination_group_destinations_destination_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-telemetry - based on the path /telemetry-system/destination-groups/destination-group/destinations/destination/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: State information associated with
telemetry destinations
  """
  __slots__ = ('_path_helper', '_extmethods', '__destination_address','__destination_port',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__destination_address = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="destination-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='oc-inet:ip-address', is_config=False)
    self.__destination_port = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="destination-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='uint16', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['telemetry-system', 'destination-groups', 'destination-group', 'destinations', 'destination', 'state']

  def _get_destination_address(self):
    """
    Getter method for destination_address, mapped from YANG variable /telemetry_system/destination_groups/destination_group/destinations/destination/state/destination_address (oc-inet:ip-address)

    YANG Description: IP address of the telemetry stream destination
    """
    return self.__destination_address
      
  def _set_destination_address(self, v, load=False):
    """
    Setter method for destination_address, mapped from YANG variable /telemetry_system/destination_groups/destination_group/destinations/destination/state/destination_address (oc-inet:ip-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_destination_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_destination_address() directly.

    YANG Description: IP address of the telemetry stream destination
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="destination-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='oc-inet:ip-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """destination_address must be of a type compatible with oc-inet:ip-address""",
          'defined-type': "oc-inet:ip-address",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="destination-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='oc-inet:ip-address', is_config=False)""",
        })

    self.__destination_address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_destination_address(self):
    self.__destination_address = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="destination-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='oc-inet:ip-address', is_config=False)


  def _get_destination_port(self):
    """
    Getter method for destination_port, mapped from YANG variable /telemetry_system/destination_groups/destination_group/destinations/destination/state/destination_port (uint16)

    YANG Description: Protocol (udp or tcp) port number for the telemetry
stream destination
    """
    return self.__destination_port
      
  def _set_destination_port(self, v, load=False):
    """
    Setter method for destination_port, mapped from YANG variable /telemetry_system/destination_groups/destination_group/destinations/destination/state/destination_port (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_destination_port is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_destination_port() directly.

    YANG Description: Protocol (udp or tcp) port number for the telemetry
stream destination
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="destination-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='uint16', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """destination_port must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="destination-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='uint16', is_config=False)""",
        })

    self.__destination_port = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_destination_port(self):
    self.__destination_port = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="destination-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='uint16', is_config=False)

  destination_address = __builtin__.property(_get_destination_address)
  destination_port = __builtin__.property(_get_destination_port)


  _pyangbind_elements = OrderedDict([('destination_address', destination_address), ('destination_port', destination_port), ])


class yc_destination_openconfig_telemetry__telemetry_system_destination_groups_destination_group_destinations_destination(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-telemetry - based on the path /telemetry-system/destination-groups/destination-group/destinations/destination. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of telemetry stream destinations
  """
  __slots__ = ('_path_helper', '_extmethods', '__destination_address','__destination_port','__config','__state',)

  _yang_name = 'destination'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__destination_address = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="destination-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='leafref', is_config=True)
    self.__destination_port = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="destination-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_telemetry__telemetry_system_destination_groups_destination_group_destinations_destination_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_telemetry__telemetry_system_destination_groups_destination_group_destinations_destination_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['telemetry-system', 'destination-groups', 'destination-group', 'destinations', 'destination']

  def _get_destination_address(self):
    """
    Getter method for destination_address, mapped from YANG variable /telemetry_system/destination_groups/destination_group/destinations/destination/destination_address (leafref)

    YANG Description: Reference to the destination address of the
telemetry stream
    """
    return self.__destination_address
      
  def _set_destination_address(self, v, load=False):
    """
    Setter method for destination_address, mapped from YANG variable /telemetry_system/destination_groups/destination_group/destinations/destination/destination_address (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_destination_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_destination_address() directly.

    YANG Description: Reference to the destination address of the
telemetry stream
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="destination-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """destination_address must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="destination-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='leafref', is_config=True)""",
        })

    self.__destination_address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_destination_address(self):
    self.__destination_address = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="destination-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='leafref', is_config=True)


  def _get_destination_port(self):
    """
    Getter method for destination_port, mapped from YANG variable /telemetry_system/destination_groups/destination_group/destinations/destination/destination_port (leafref)

    YANG Description: Reference to the port number of the stream
destination
    """
    return self.__destination_port
      
  def _set_destination_port(self, v, load=False):
    """
    Setter method for destination_port, mapped from YANG variable /telemetry_system/destination_groups/destination_group/destinations/destination/destination_port (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_destination_port is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_destination_port() directly.

    YANG Description: Reference to the port number of the stream
destination
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="destination-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """destination_port must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="destination-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='leafref', is_config=True)""",
        })

    self.__destination_port = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_destination_port(self):
    self.__destination_port = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="destination-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /telemetry_system/destination_groups/destination_group/destinations/destination/config (container)

    YANG Description: Configuration parameters relating to
telemetry destinations
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /telemetry_system/destination_groups/destination_group/destinations/destination/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration parameters relating to
telemetry destinations
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_telemetry__telemetry_system_destination_groups_destination_group_destinations_destination_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_telemetry__telemetry_system_destination_groups_destination_group_destinations_destination_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_telemetry__telemetry_system_destination_groups_destination_group_destinations_destination_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /telemetry_system/destination_groups/destination_group/destinations/destination/state (container)

    YANG Description: State information associated with
telemetry destinations
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /telemetry_system/destination_groups/destination_group/destinations/destination/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: State information associated with
telemetry destinations
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_telemetry__telemetry_system_destination_groups_destination_group_destinations_destination_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_telemetry__telemetry_system_destination_groups_destination_group_destinations_destination_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_telemetry__telemetry_system_destination_groups_destination_group_destinations_destination_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)

  destination_address = __builtin__.property(_get_destination_address, _set_destination_address)
  destination_port = __builtin__.property(_get_destination_port, _set_destination_port)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('destination_address', destination_address), ('destination_port', destination_port), ('config', config), ('state', state), ])


class yc_destinations_openconfig_telemetry__telemetry_system_destination_groups_destination_group_destinations(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-telemetry - based on the path /telemetry-system/destination-groups/destination-group/destinations. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: The destination container lists the destination
information such as IP address and port of the
telemetry messages from the network element.
  """
  __slots__ = ('_path_helper', '_extmethods', '__destination',)

  _yang_name = 'destinations'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__destination = YANGDynClass(base=YANGListType("destination_address destination_port",yc_destination_openconfig_telemetry__telemetry_system_destination_groups_destination_group_destinations_destination, yang_name="destination", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='destination-address destination-port', extensions=None), is_container='list', yang_name="destination", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['telemetry-system', 'destination-groups', 'destination-group', 'destinations']

  def _get_destination(self):
    """
    Getter method for destination, mapped from YANG variable /telemetry_system/destination_groups/destination_group/destinations/destination (list)

    YANG Description: List of telemetry stream destinations
    """
    return self.__destination
      
  def _set_destination(self, v, load=False):
    """
    Setter method for destination, mapped from YANG variable /telemetry_system/destination_groups/destination_group/destinations/destination (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_destination is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_destination() directly.

    YANG Description: List of telemetry stream destinations
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("destination_address destination_port",yc_destination_openconfig_telemetry__telemetry_system_destination_groups_destination_group_destinations_destination, yang_name="destination", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='destination-address destination-port', extensions=None), is_container='list', yang_name="destination", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """destination must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("destination_address destination_port",yc_destination_openconfig_telemetry__telemetry_system_destination_groups_destination_group_destinations_destination, yang_name="destination", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='destination-address destination-port', extensions=None), is_container='list', yang_name="destination", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='list', is_config=True)""",
        })

    self.__destination = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_destination(self):
    self.__destination = YANGDynClass(base=YANGListType("destination_address destination_port",yc_destination_openconfig_telemetry__telemetry_system_destination_groups_destination_group_destinations_destination, yang_name="destination", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='destination-address destination-port', extensions=None), is_container='list', yang_name="destination", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='list', is_config=True)

  destination = __builtin__.property(_get_destination, _set_destination)


  _pyangbind_elements = OrderedDict([('destination', destination), ])


class yc_destination_group_openconfig_telemetry__telemetry_system_destination_groups_destination_group(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-telemetry - based on the path /telemetry-system/destination-groups/destination-group. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of destination-groups. Destination groups allow the
reuse of common telemetry destinations across the
telemetry configuration. An operator references a
set of destinations via the configurable
destination-group-identifier.

A destination group may contain one or more telemetry
destinations
  """
  __slots__ = ('_path_helper', '_extmethods', '__group_id','__config','__state','__destinations',)

  _yang_name = 'destination-group'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__group_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="group-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_telemetry__telemetry_system_destination_groups_destination_group_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_telemetry__telemetry_system_destination_groups_destination_group_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)
    self.__destinations = YANGDynClass(base=yc_destinations_openconfig_telemetry__telemetry_system_destination_groups_destination_group_destinations, is_container='container', yang_name="destinations", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['telemetry-system', 'destination-groups', 'destination-group']

  def _get_group_id(self):
    """
    Getter method for group_id, mapped from YANG variable /telemetry_system/destination_groups/destination_group/group_id (leafref)

    YANG Description: Unique identifier for the destination group
    """
    return self.__group_id
      
  def _set_group_id(self, v, load=False):
    """
    Setter method for group_id, mapped from YANG variable /telemetry_system/destination_groups/destination_group/group_id (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_group_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_group_id() directly.

    YANG Description: Unique identifier for the destination group
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="group-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """group_id must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="group-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='leafref', is_config=True)""",
        })

    self.__group_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_group_id(self):
    self.__group_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="group-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /telemetry_system/destination_groups/destination_group/config (container)

    YANG Description: Top level config container for destination groups
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /telemetry_system/destination_groups/destination_group/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Top level config container for destination groups
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_telemetry__telemetry_system_destination_groups_destination_group_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_telemetry__telemetry_system_destination_groups_destination_group_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_telemetry__telemetry_system_destination_groups_destination_group_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /telemetry_system/destination_groups/destination_group/state (container)

    YANG Description: Top level state container for destination groups
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /telemetry_system/destination_groups/destination_group/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Top level state container for destination groups
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_telemetry__telemetry_system_destination_groups_destination_group_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_telemetry__telemetry_system_destination_groups_destination_group_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_telemetry__telemetry_system_destination_groups_destination_group_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)


  def _get_destinations(self):
    """
    Getter method for destinations, mapped from YANG variable /telemetry_system/destination_groups/destination_group/destinations (container)

    YANG Description: The destination container lists the destination
information such as IP address and port of the
telemetry messages from the network element.
    """
    return self.__destinations
      
  def _set_destinations(self, v, load=False):
    """
    Setter method for destinations, mapped from YANG variable /telemetry_system/destination_groups/destination_group/destinations (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_destinations is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_destinations() directly.

    YANG Description: The destination container lists the destination
information such as IP address and port of the
telemetry messages from the network element.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_destinations_openconfig_telemetry__telemetry_system_destination_groups_destination_group_destinations, is_container='container', yang_name="destinations", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """destinations must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_destinations_openconfig_telemetry__telemetry_system_destination_groups_destination_group_destinations, is_container='container', yang_name="destinations", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)""",
        })

    self.__destinations = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_destinations(self):
    self.__destinations = YANGDynClass(base=yc_destinations_openconfig_telemetry__telemetry_system_destination_groups_destination_group_destinations, is_container='container', yang_name="destinations", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)

  group_id = __builtin__.property(_get_group_id, _set_group_id)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)
  destinations = __builtin__.property(_get_destinations, _set_destinations)


  _pyangbind_elements = OrderedDict([('group_id', group_id), ('config', config), ('state', state), ('destinations', destinations), ])


class yc_destination_groups_openconfig_telemetry__telemetry_system_destination_groups(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-telemetry - based on the path /telemetry-system/destination-groups. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Top level container for destination group configuration
and state.
  """
  __slots__ = ('_path_helper', '_extmethods', '__destination_group',)

  _yang_name = 'destination-groups'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__destination_group = YANGDynClass(base=YANGListType("group_id",yc_destination_group_openconfig_telemetry__telemetry_system_destination_groups_destination_group, yang_name="destination-group", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='group-id', extensions=None), is_container='list', yang_name="destination-group", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['telemetry-system', 'destination-groups']

  def _get_destination_group(self):
    """
    Getter method for destination_group, mapped from YANG variable /telemetry_system/destination_groups/destination_group (list)

    YANG Description: List of destination-groups. Destination groups allow the
reuse of common telemetry destinations across the
telemetry configuration. An operator references a
set of destinations via the configurable
destination-group-identifier.

A destination group may contain one or more telemetry
destinations
    """
    return self.__destination_group
      
  def _set_destination_group(self, v, load=False):
    """
    Setter method for destination_group, mapped from YANG variable /telemetry_system/destination_groups/destination_group (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_destination_group is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_destination_group() directly.

    YANG Description: List of destination-groups. Destination groups allow the
reuse of common telemetry destinations across the
telemetry configuration. An operator references a
set of destinations via the configurable
destination-group-identifier.

A destination group may contain one or more telemetry
destinations
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("group_id",yc_destination_group_openconfig_telemetry__telemetry_system_destination_groups_destination_group, yang_name="destination-group", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='group-id', extensions=None), is_container='list', yang_name="destination-group", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """destination_group must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("group_id",yc_destination_group_openconfig_telemetry__telemetry_system_destination_groups_destination_group, yang_name="destination-group", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='group-id', extensions=None), is_container='list', yang_name="destination-group", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='list', is_config=True)""",
        })

    self.__destination_group = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_destination_group(self):
    self.__destination_group = YANGDynClass(base=YANGListType("group_id",yc_destination_group_openconfig_telemetry__telemetry_system_destination_groups_destination_group, yang_name="destination-group", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='group-id', extensions=None), is_container='list', yang_name="destination-group", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='list', is_config=True)

  destination_group = __builtin__.property(_get_destination_group, _set_destination_group)


  _pyangbind_elements = OrderedDict([('destination_group', destination_group), ])


class yc_config_openconfig_telemetry__telemetry_system_subscriptions_persistent_subscriptions_persistent_subscription_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-telemetry - based on the path /telemetry-system/subscriptions/persistent-subscriptions/persistent-subscription/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Config parameters relating to the telemetry
subscriptions on the local device
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__local_source_address','__originated_qos_marking','__protocol','__encoding',)

  _yang_name = 'config'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='string', is_config=True)
    self.__local_source_address = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="local-source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='oc-inet:ip-address', is_config=True)
    self.__originated_qos_marking = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="originated-qos-marking", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='oc-inet:dscp', is_config=True)
    self.__protocol = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'STREAM_SSH': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:STREAM_SSH': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'STREAM_GRPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:STREAM_GRPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'STREAM_JSON_RPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:STREAM_JSON_RPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'STREAM_THRIFT_RPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:STREAM_THRIFT_RPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'STREAM_WEBSOCKET_RPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:STREAM_WEBSOCKET_RPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}},), is_leaf=True, yang_name="protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='identityref', is_config=True)
    self.__encoding = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ENC_XML': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:ENC_XML': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'ENC_JSON_IETF': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:ENC_JSON_IETF': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'ENC_PROTO3': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:ENC_PROTO3': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}},), is_leaf=True, yang_name="encoding", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='identityref', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['telemetry-system', 'subscriptions', 'persistent-subscriptions', 'persistent-subscription', 'config']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /telemetry_system/subscriptions/persistent_subscriptions/persistent_subscription/config/name (string)

    YANG Description: User configured identifier of the telemetry
subscription. This value is used primarily for
subscriptions configured locally on the network
element.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /telemetry_system/subscriptions/persistent_subscriptions/persistent_subscription/config/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: User configured identifier of the telemetry
subscription. This value is used primarily for
subscriptions configured locally on the network
element.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='string', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='string', is_config=True)


  def _get_local_source_address(self):
    """
    Getter method for local_source_address, mapped from YANG variable /telemetry_system/subscriptions/persistent_subscriptions/persistent_subscription/config/local_source_address (oc-inet:ip-address)

    YANG Description: The IP address which will be the source of packets from
the device to a telemetry collector destination.
    """
    return self.__local_source_address
      
  def _set_local_source_address(self, v, load=False):
    """
    Setter method for local_source_address, mapped from YANG variable /telemetry_system/subscriptions/persistent_subscriptions/persistent_subscription/config/local_source_address (oc-inet:ip-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_local_source_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_local_source_address() directly.

    YANG Description: The IP address which will be the source of packets from
the device to a telemetry collector destination.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="local-source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='oc-inet:ip-address', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """local_source_address must be of a type compatible with oc-inet:ip-address""",
          'defined-type': "oc-inet:ip-address",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="local-source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='oc-inet:ip-address', is_config=True)""",
        })

    self.__local_source_address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_local_source_address(self):
    self.__local_source_address = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="local-source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='oc-inet:ip-address', is_config=True)


  def _get_originated_qos_marking(self):
    """
    Getter method for originated_qos_marking, mapped from YANG variable /telemetry_system/subscriptions/persistent_subscriptions/persistent_subscription/config/originated_qos_marking (oc-inet:dscp)

    YANG Description: DSCP marking of packets generated by the telemetry
subsystem on the network device.
    """
    return self.__originated_qos_marking
      
  def _set_originated_qos_marking(self, v, load=False):
    """
    Setter method for originated_qos_marking, mapped from YANG variable /telemetry_system/subscriptions/persistent_subscriptions/persistent_subscription/config/originated_qos_marking (oc-inet:dscp)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_originated_qos_marking is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_originated_qos_marking() directly.

    YANG Description: DSCP marking of packets generated by the telemetry
subsystem on the network device.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="originated-qos-marking", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='oc-inet:dscp', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """originated_qos_marking must be of a type compatible with oc-inet:dscp""",
          'defined-type': "oc-inet:dscp",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="originated-qos-marking", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='oc-inet:dscp', is_config=True)""",
        })

    self.__originated_qos_marking = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_originated_qos_marking(self):
    self.__originated_qos_marking = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="originated-qos-marking", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='oc-inet:dscp', is_config=True)


  def _get_protocol(self):
    """
    Getter method for protocol, mapped from YANG variable /telemetry_system/subscriptions/persistent_subscriptions/persistent_subscription/config/protocol (identityref)

    YANG Description: Selection of the transport protocol for the telemetry
stream.
    """
    return self.__protocol
      
  def _set_protocol(self, v, load=False):
    """
    Setter method for protocol, mapped from YANG variable /telemetry_system/subscriptions/persistent_subscriptions/persistent_subscription/config/protocol (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_protocol is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_protocol() directly.

    YANG Description: Selection of the transport protocol for the telemetry
stream.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'STREAM_SSH': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:STREAM_SSH': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'STREAM_GRPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:STREAM_GRPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'STREAM_JSON_RPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:STREAM_JSON_RPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'STREAM_THRIFT_RPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:STREAM_THRIFT_RPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'STREAM_WEBSOCKET_RPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:STREAM_WEBSOCKET_RPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}},), is_leaf=True, yang_name="protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='identityref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """protocol must be of a type compatible with identityref""",
          'defined-type': "openconfig-telemetry:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'STREAM_SSH': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:STREAM_SSH': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'STREAM_GRPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:STREAM_GRPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'STREAM_JSON_RPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:STREAM_JSON_RPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'STREAM_THRIFT_RPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:STREAM_THRIFT_RPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'STREAM_WEBSOCKET_RPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:STREAM_WEBSOCKET_RPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}},), is_leaf=True, yang_name="protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='identityref', is_config=True)""",
        })

    self.__protocol = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_protocol(self):
    self.__protocol = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'STREAM_SSH': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:STREAM_SSH': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'STREAM_GRPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:STREAM_GRPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'STREAM_JSON_RPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:STREAM_JSON_RPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'STREAM_THRIFT_RPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:STREAM_THRIFT_RPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'STREAM_WEBSOCKET_RPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:STREAM_WEBSOCKET_RPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}},), is_leaf=True, yang_name="protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='identityref', is_config=True)


  def _get_encoding(self):
    """
    Getter method for encoding, mapped from YANG variable /telemetry_system/subscriptions/persistent_subscriptions/persistent_subscription/config/encoding (identityref)

    YANG Description: Selection of the specific encoding or RPC framework
for telemetry messages to and from the network element.
    """
    return self.__encoding
      
  def _set_encoding(self, v, load=False):
    """
    Setter method for encoding, mapped from YANG variable /telemetry_system/subscriptions/persistent_subscriptions/persistent_subscription/config/encoding (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_encoding is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_encoding() directly.

    YANG Description: Selection of the specific encoding or RPC framework
for telemetry messages to and from the network element.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ENC_XML': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:ENC_XML': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'ENC_JSON_IETF': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:ENC_JSON_IETF': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'ENC_PROTO3': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:ENC_PROTO3': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}},), is_leaf=True, yang_name="encoding", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='identityref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """encoding must be of a type compatible with identityref""",
          'defined-type': "openconfig-telemetry:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ENC_XML': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:ENC_XML': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'ENC_JSON_IETF': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:ENC_JSON_IETF': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'ENC_PROTO3': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:ENC_PROTO3': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}},), is_leaf=True, yang_name="encoding", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='identityref', is_config=True)""",
        })

    self.__encoding = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_encoding(self):
    self.__encoding = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ENC_XML': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:ENC_XML': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'ENC_JSON_IETF': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:ENC_JSON_IETF': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'ENC_PROTO3': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:ENC_PROTO3': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}},), is_leaf=True, yang_name="encoding", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='identityref', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  local_source_address = __builtin__.property(_get_local_source_address, _set_local_source_address)
  originated_qos_marking = __builtin__.property(_get_originated_qos_marking, _set_originated_qos_marking)
  protocol = __builtin__.property(_get_protocol, _set_protocol)
  encoding = __builtin__.property(_get_encoding, _set_encoding)


  _pyangbind_elements = OrderedDict([('name', name), ('local_source_address', local_source_address), ('originated_qos_marking', originated_qos_marking), ('protocol', protocol), ('encoding', encoding), ])


class yc_state_openconfig_telemetry__telemetry_system_subscriptions_persistent_subscriptions_persistent_subscription_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-telemetry - based on the path /telemetry-system/subscriptions/persistent-subscriptions/persistent-subscription/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: State parameters relating to the telemetry
subscriptions on the local device
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__id','__local_source_address','__originated_qos_marking','__protocol','__encoding',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='string', is_config=False)
    self.__id = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='uint64', is_config=False)
    self.__local_source_address = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="local-source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='oc-inet:ip-address', is_config=False)
    self.__originated_qos_marking = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="originated-qos-marking", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='oc-inet:dscp', is_config=False)
    self.__protocol = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'STREAM_SSH': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:STREAM_SSH': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'STREAM_GRPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:STREAM_GRPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'STREAM_JSON_RPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:STREAM_JSON_RPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'STREAM_THRIFT_RPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:STREAM_THRIFT_RPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'STREAM_WEBSOCKET_RPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:STREAM_WEBSOCKET_RPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}},), is_leaf=True, yang_name="protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='identityref', is_config=False)
    self.__encoding = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ENC_XML': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:ENC_XML': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'ENC_JSON_IETF': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:ENC_JSON_IETF': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'ENC_PROTO3': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:ENC_PROTO3': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}},), is_leaf=True, yang_name="encoding", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='identityref', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['telemetry-system', 'subscriptions', 'persistent-subscriptions', 'persistent-subscription', 'state']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /telemetry_system/subscriptions/persistent_subscriptions/persistent_subscription/state/name (string)

    YANG Description: User configured identifier of the telemetry
subscription. This value is used primarily for
subscriptions configured locally on the network
element.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /telemetry_system/subscriptions/persistent_subscriptions/persistent_subscription/state/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: User configured identifier of the telemetry
subscription. This value is used primarily for
subscriptions configured locally on the network
element.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='string', is_config=False)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='string', is_config=False)


  def _get_id(self):
    """
    Getter method for id, mapped from YANG variable /telemetry_system/subscriptions/persistent_subscriptions/persistent_subscription/state/id (uint64)

    YANG Description: System generated identifer of the telemetry
subscription.
    """
    return self.__id
      
  def _set_id(self, v, load=False):
    """
    Setter method for id, mapped from YANG variable /telemetry_system/subscriptions/persistent_subscriptions/persistent_subscription/state/id (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_id() directly.

    YANG Description: System generated identifer of the telemetry
subscription.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """id must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='uint64', is_config=False)""",
        })

    self.__id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_id(self):
    self.__id = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='uint64', is_config=False)


  def _get_local_source_address(self):
    """
    Getter method for local_source_address, mapped from YANG variable /telemetry_system/subscriptions/persistent_subscriptions/persistent_subscription/state/local_source_address (oc-inet:ip-address)

    YANG Description: The IP address which will be the source of packets from
the device to a telemetry collector destination.
    """
    return self.__local_source_address
      
  def _set_local_source_address(self, v, load=False):
    """
    Setter method for local_source_address, mapped from YANG variable /telemetry_system/subscriptions/persistent_subscriptions/persistent_subscription/state/local_source_address (oc-inet:ip-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_local_source_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_local_source_address() directly.

    YANG Description: The IP address which will be the source of packets from
the device to a telemetry collector destination.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="local-source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='oc-inet:ip-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """local_source_address must be of a type compatible with oc-inet:ip-address""",
          'defined-type': "oc-inet:ip-address",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="local-source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='oc-inet:ip-address', is_config=False)""",
        })

    self.__local_source_address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_local_source_address(self):
    self.__local_source_address = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="local-source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='oc-inet:ip-address', is_config=False)


  def _get_originated_qos_marking(self):
    """
    Getter method for originated_qos_marking, mapped from YANG variable /telemetry_system/subscriptions/persistent_subscriptions/persistent_subscription/state/originated_qos_marking (oc-inet:dscp)

    YANG Description: DSCP marking of packets generated by the telemetry
subsystem on the network device.
    """
    return self.__originated_qos_marking
      
  def _set_originated_qos_marking(self, v, load=False):
    """
    Setter method for originated_qos_marking, mapped from YANG variable /telemetry_system/subscriptions/persistent_subscriptions/persistent_subscription/state/originated_qos_marking (oc-inet:dscp)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_originated_qos_marking is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_originated_qos_marking() directly.

    YANG Description: DSCP marking of packets generated by the telemetry
subsystem on the network device.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="originated-qos-marking", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='oc-inet:dscp', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """originated_qos_marking must be of a type compatible with oc-inet:dscp""",
          'defined-type': "oc-inet:dscp",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="originated-qos-marking", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='oc-inet:dscp', is_config=False)""",
        })

    self.__originated_qos_marking = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_originated_qos_marking(self):
    self.__originated_qos_marking = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="originated-qos-marking", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='oc-inet:dscp', is_config=False)


  def _get_protocol(self):
    """
    Getter method for protocol, mapped from YANG variable /telemetry_system/subscriptions/persistent_subscriptions/persistent_subscription/state/protocol (identityref)

    YANG Description: Selection of the transport protocol for the telemetry
stream.
    """
    return self.__protocol
      
  def _set_protocol(self, v, load=False):
    """
    Setter method for protocol, mapped from YANG variable /telemetry_system/subscriptions/persistent_subscriptions/persistent_subscription/state/protocol (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_protocol is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_protocol() directly.

    YANG Description: Selection of the transport protocol for the telemetry
stream.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'STREAM_SSH': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:STREAM_SSH': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'STREAM_GRPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:STREAM_GRPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'STREAM_JSON_RPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:STREAM_JSON_RPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'STREAM_THRIFT_RPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:STREAM_THRIFT_RPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'STREAM_WEBSOCKET_RPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:STREAM_WEBSOCKET_RPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}},), is_leaf=True, yang_name="protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='identityref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """protocol must be of a type compatible with identityref""",
          'defined-type': "openconfig-telemetry:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'STREAM_SSH': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:STREAM_SSH': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'STREAM_GRPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:STREAM_GRPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'STREAM_JSON_RPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:STREAM_JSON_RPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'STREAM_THRIFT_RPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:STREAM_THRIFT_RPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'STREAM_WEBSOCKET_RPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:STREAM_WEBSOCKET_RPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}},), is_leaf=True, yang_name="protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='identityref', is_config=False)""",
        })

    self.__protocol = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_protocol(self):
    self.__protocol = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'STREAM_SSH': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:STREAM_SSH': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'STREAM_GRPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:STREAM_GRPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'STREAM_JSON_RPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:STREAM_JSON_RPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'STREAM_THRIFT_RPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:STREAM_THRIFT_RPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'STREAM_WEBSOCKET_RPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:STREAM_WEBSOCKET_RPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}},), is_leaf=True, yang_name="protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='identityref', is_config=False)


  def _get_encoding(self):
    """
    Getter method for encoding, mapped from YANG variable /telemetry_system/subscriptions/persistent_subscriptions/persistent_subscription/state/encoding (identityref)

    YANG Description: Selection of the specific encoding or RPC framework
for telemetry messages to and from the network element.
    """
    return self.__encoding
      
  def _set_encoding(self, v, load=False):
    """
    Setter method for encoding, mapped from YANG variable /telemetry_system/subscriptions/persistent_subscriptions/persistent_subscription/state/encoding (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_encoding is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_encoding() directly.

    YANG Description: Selection of the specific encoding or RPC framework
for telemetry messages to and from the network element.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ENC_XML': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:ENC_XML': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'ENC_JSON_IETF': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:ENC_JSON_IETF': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'ENC_PROTO3': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:ENC_PROTO3': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}},), is_leaf=True, yang_name="encoding", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='identityref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """encoding must be of a type compatible with identityref""",
          'defined-type': "openconfig-telemetry:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ENC_XML': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:ENC_XML': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'ENC_JSON_IETF': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:ENC_JSON_IETF': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'ENC_PROTO3': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:ENC_PROTO3': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}},), is_leaf=True, yang_name="encoding", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='identityref', is_config=False)""",
        })

    self.__encoding = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_encoding(self):
    self.__encoding = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ENC_XML': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:ENC_XML': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'ENC_JSON_IETF': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:ENC_JSON_IETF': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'ENC_PROTO3': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:ENC_PROTO3': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}},), is_leaf=True, yang_name="encoding", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='identityref', is_config=False)

  name = __builtin__.property(_get_name)
  id = __builtin__.property(_get_id)
  local_source_address = __builtin__.property(_get_local_source_address)
  originated_qos_marking = __builtin__.property(_get_originated_qos_marking)
  protocol = __builtin__.property(_get_protocol)
  encoding = __builtin__.property(_get_encoding)


  _pyangbind_elements = OrderedDict([('name', name), ('id', id), ('local_source_address', local_source_address), ('originated_qos_marking', originated_qos_marking), ('protocol', protocol), ('encoding', encoding), ])


class yc_config_openconfig_telemetry__telemetry_system_subscriptions_persistent_subscriptions_persistent_subscription_sensor_profiles_sensor_profile_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-telemetry - based on the path /telemetry-system/subscriptions/persistent-subscriptions/persistent-subscription/sensor-profiles/sensor-profile/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration parameters related to the sensor
profile for a subscription
  """
  __slots__ = ('_path_helper', '_extmethods', '__sensor_group','__sample_interval','__heartbeat_interval','__suppress_redundant',)

  _yang_name = 'config'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__sensor_group = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="sensor-group", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='leafref', is_config=True)
    self.__sample_interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="sample-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='uint64', is_config=True)
    self.__heartbeat_interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="heartbeat-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='uint64', is_config=True)
    self.__suppress_redundant = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="suppress-redundant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='boolean', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['telemetry-system', 'subscriptions', 'persistent-subscriptions', 'persistent-subscription', 'sensor-profiles', 'sensor-profile', 'config']

  def _get_sensor_group(self):
    """
    Getter method for sensor_group, mapped from YANG variable /telemetry_system/subscriptions/persistent_subscriptions/persistent_subscription/sensor_profiles/sensor_profile/config/sensor_group (leafref)

    YANG Description: Reference to the sensor group which is used in the profile
    """
    return self.__sensor_group
      
  def _set_sensor_group(self, v, load=False):
    """
    Setter method for sensor_group, mapped from YANG variable /telemetry_system/subscriptions/persistent_subscriptions/persistent_subscription/sensor_profiles/sensor_profile/config/sensor_group (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_sensor_group is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_sensor_group() directly.

    YANG Description: Reference to the sensor group which is used in the profile
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="sensor-group", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """sensor_group must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="sensor-group", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='leafref', is_config=True)""",
        })

    self.__sensor_group = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_sensor_group(self):
    self.__sensor_group = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="sensor-group", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='leafref', is_config=True)


  def _get_sample_interval(self):
    """
    Getter method for sample_interval, mapped from YANG variable /telemetry_system/subscriptions/persistent_subscriptions/persistent_subscription/sensor_profiles/sensor_profile/config/sample_interval (uint64)

    YANG Description: Time in milliseconds between the device's sample of a
telemetry data source. For example, setting this to 100
would require the local device to collect the telemetry
data every 100 milliseconds. There can be latency or jitter
in transmitting the data, but the sample must occur at
the specified interval.

The timestamp must reflect the actual time when the data
was sampled, not simply the previous sample timestamp +
sample-interval.

If sample-interval is set to 0, the telemetry sensor
becomes event based. The sensor must then emit data upon
every change of the underlying data source.
    """
    return self.__sample_interval
      
  def _set_sample_interval(self, v, load=False):
    """
    Setter method for sample_interval, mapped from YANG variable /telemetry_system/subscriptions/persistent_subscriptions/persistent_subscription/sensor_profiles/sensor_profile/config/sample_interval (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_sample_interval is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_sample_interval() directly.

    YANG Description: Time in milliseconds between the device's sample of a
telemetry data source. For example, setting this to 100
would require the local device to collect the telemetry
data every 100 milliseconds. There can be latency or jitter
in transmitting the data, but the sample must occur at
the specified interval.

The timestamp must reflect the actual time when the data
was sampled, not simply the previous sample timestamp +
sample-interval.

If sample-interval is set to 0, the telemetry sensor
becomes event based. The sensor must then emit data upon
every change of the underlying data source.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="sample-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='uint64', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """sample_interval must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="sample-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='uint64', is_config=True)""",
        })

    self.__sample_interval = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_sample_interval(self):
    self.__sample_interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="sample-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='uint64', is_config=True)


  def _get_heartbeat_interval(self):
    """
    Getter method for heartbeat_interval, mapped from YANG variable /telemetry_system/subscriptions/persistent_subscriptions/persistent_subscription/sensor_profiles/sensor_profile/config/heartbeat_interval (uint64)

    YANG Description: Maximum time interval in seconds that may pass
between updates from a device to a telemetry collector.
If this interval expires, but there is no updated data to
send (such as if suppress_updates has been configured), the
device must send a telemetry message to the collector.
    """
    return self.__heartbeat_interval
      
  def _set_heartbeat_interval(self, v, load=False):
    """
    Setter method for heartbeat_interval, mapped from YANG variable /telemetry_system/subscriptions/persistent_subscriptions/persistent_subscription/sensor_profiles/sensor_profile/config/heartbeat_interval (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_heartbeat_interval is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_heartbeat_interval() directly.

    YANG Description: Maximum time interval in seconds that may pass
between updates from a device to a telemetry collector.
If this interval expires, but there is no updated data to
send (such as if suppress_updates has been configured), the
device must send a telemetry message to the collector.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="heartbeat-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='uint64', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """heartbeat_interval must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="heartbeat-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='uint64', is_config=True)""",
        })

    self.__heartbeat_interval = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_heartbeat_interval(self):
    self.__heartbeat_interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="heartbeat-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='uint64', is_config=True)


  def _get_suppress_redundant(self):
    """
    Getter method for suppress_redundant, mapped from YANG variable /telemetry_system/subscriptions/persistent_subscriptions/persistent_subscription/sensor_profiles/sensor_profile/config/suppress_redundant (boolean)

    YANG Description: Boolean flag to control suppression of redundant
telemetry updates to the collector platform. If this flag is
set to TRUE, then the collector will only send an update at
the configured interval if a subscribed data value has
changed. Otherwise, the device will not send an update to
the collector until expiration of the heartbeat interval.
    """
    return self.__suppress_redundant
      
  def _set_suppress_redundant(self, v, load=False):
    """
    Setter method for suppress_redundant, mapped from YANG variable /telemetry_system/subscriptions/persistent_subscriptions/persistent_subscription/sensor_profiles/sensor_profile/config/suppress_redundant (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_suppress_redundant is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_suppress_redundant() directly.

    YANG Description: Boolean flag to control suppression of redundant
telemetry updates to the collector platform. If this flag is
set to TRUE, then the collector will only send an update at
the configured interval if a subscribed data value has
changed. Otherwise, the device will not send an update to
the collector until expiration of the heartbeat interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="suppress-redundant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """suppress_redundant must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="suppress-redundant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='boolean', is_config=True)""",
        })

    self.__suppress_redundant = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_suppress_redundant(self):
    self.__suppress_redundant = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="suppress-redundant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='boolean', is_config=True)

  sensor_group = __builtin__.property(_get_sensor_group, _set_sensor_group)
  sample_interval = __builtin__.property(_get_sample_interval, _set_sample_interval)
  heartbeat_interval = __builtin__.property(_get_heartbeat_interval, _set_heartbeat_interval)
  suppress_redundant = __builtin__.property(_get_suppress_redundant, _set_suppress_redundant)


  _pyangbind_elements = OrderedDict([('sensor_group', sensor_group), ('sample_interval', sample_interval), ('heartbeat_interval', heartbeat_interval), ('suppress_redundant', suppress_redundant), ])


class yc_state_openconfig_telemetry__telemetry_system_subscriptions_persistent_subscriptions_persistent_subscription_sensor_profiles_sensor_profile_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-telemetry - based on the path /telemetry-system/subscriptions/persistent-subscriptions/persistent-subscription/sensor-profiles/sensor-profile/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: State information relating to the sensor profile
for a subscription
  """
  __slots__ = ('_path_helper', '_extmethods', '__sensor_group','__sample_interval','__heartbeat_interval','__suppress_redundant',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__sensor_group = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="sensor-group", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='leafref', is_config=False)
    self.__sample_interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="sample-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='uint64', is_config=False)
    self.__heartbeat_interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="heartbeat-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='uint64', is_config=False)
    self.__suppress_redundant = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="suppress-redundant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='boolean', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['telemetry-system', 'subscriptions', 'persistent-subscriptions', 'persistent-subscription', 'sensor-profiles', 'sensor-profile', 'state']

  def _get_sensor_group(self):
    """
    Getter method for sensor_group, mapped from YANG variable /telemetry_system/subscriptions/persistent_subscriptions/persistent_subscription/sensor_profiles/sensor_profile/state/sensor_group (leafref)

    YANG Description: Reference to the sensor group which is used in the profile
    """
    return self.__sensor_group
      
  def _set_sensor_group(self, v, load=False):
    """
    Setter method for sensor_group, mapped from YANG variable /telemetry_system/subscriptions/persistent_subscriptions/persistent_subscription/sensor_profiles/sensor_profile/state/sensor_group (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_sensor_group is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_sensor_group() directly.

    YANG Description: Reference to the sensor group which is used in the profile
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="sensor-group", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """sensor_group must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="sensor-group", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='leafref', is_config=False)""",
        })

    self.__sensor_group = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_sensor_group(self):
    self.__sensor_group = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="sensor-group", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='leafref', is_config=False)


  def _get_sample_interval(self):
    """
    Getter method for sample_interval, mapped from YANG variable /telemetry_system/subscriptions/persistent_subscriptions/persistent_subscription/sensor_profiles/sensor_profile/state/sample_interval (uint64)

    YANG Description: Time in milliseconds between the device's sample of a
telemetry data source. For example, setting this to 100
would require the local device to collect the telemetry
data every 100 milliseconds. There can be latency or jitter
in transmitting the data, but the sample must occur at
the specified interval.

The timestamp must reflect the actual time when the data
was sampled, not simply the previous sample timestamp +
sample-interval.

If sample-interval is set to 0, the telemetry sensor
becomes event based. The sensor must then emit data upon
every change of the underlying data source.
    """
    return self.__sample_interval
      
  def _set_sample_interval(self, v, load=False):
    """
    Setter method for sample_interval, mapped from YANG variable /telemetry_system/subscriptions/persistent_subscriptions/persistent_subscription/sensor_profiles/sensor_profile/state/sample_interval (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_sample_interval is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_sample_interval() directly.

    YANG Description: Time in milliseconds between the device's sample of a
telemetry data source. For example, setting this to 100
would require the local device to collect the telemetry
data every 100 milliseconds. There can be latency or jitter
in transmitting the data, but the sample must occur at
the specified interval.

The timestamp must reflect the actual time when the data
was sampled, not simply the previous sample timestamp +
sample-interval.

If sample-interval is set to 0, the telemetry sensor
becomes event based. The sensor must then emit data upon
every change of the underlying data source.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="sample-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """sample_interval must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="sample-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='uint64', is_config=False)""",
        })

    self.__sample_interval = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_sample_interval(self):
    self.__sample_interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="sample-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='uint64', is_config=False)


  def _get_heartbeat_interval(self):
    """
    Getter method for heartbeat_interval, mapped from YANG variable /telemetry_system/subscriptions/persistent_subscriptions/persistent_subscription/sensor_profiles/sensor_profile/state/heartbeat_interval (uint64)

    YANG Description: Maximum time interval in seconds that may pass
between updates from a device to a telemetry collector.
If this interval expires, but there is no updated data to
send (such as if suppress_updates has been configured), the
device must send a telemetry message to the collector.
    """
    return self.__heartbeat_interval
      
  def _set_heartbeat_interval(self, v, load=False):
    """
    Setter method for heartbeat_interval, mapped from YANG variable /telemetry_system/subscriptions/persistent_subscriptions/persistent_subscription/sensor_profiles/sensor_profile/state/heartbeat_interval (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_heartbeat_interval is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_heartbeat_interval() directly.

    YANG Description: Maximum time interval in seconds that may pass
between updates from a device to a telemetry collector.
If this interval expires, but there is no updated data to
send (such as if suppress_updates has been configured), the
device must send a telemetry message to the collector.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="heartbeat-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """heartbeat_interval must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="heartbeat-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='uint64', is_config=False)""",
        })

    self.__heartbeat_interval = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_heartbeat_interval(self):
    self.__heartbeat_interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="heartbeat-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='uint64', is_config=False)


  def _get_suppress_redundant(self):
    """
    Getter method for suppress_redundant, mapped from YANG variable /telemetry_system/subscriptions/persistent_subscriptions/persistent_subscription/sensor_profiles/sensor_profile/state/suppress_redundant (boolean)

    YANG Description: Boolean flag to control suppression of redundant
telemetry updates to the collector platform. If this flag is
set to TRUE, then the collector will only send an update at
the configured interval if a subscribed data value has
changed. Otherwise, the device will not send an update to
the collector until expiration of the heartbeat interval.
    """
    return self.__suppress_redundant
      
  def _set_suppress_redundant(self, v, load=False):
    """
    Setter method for suppress_redundant, mapped from YANG variable /telemetry_system/subscriptions/persistent_subscriptions/persistent_subscription/sensor_profiles/sensor_profile/state/suppress_redundant (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_suppress_redundant is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_suppress_redundant() directly.

    YANG Description: Boolean flag to control suppression of redundant
telemetry updates to the collector platform. If this flag is
set to TRUE, then the collector will only send an update at
the configured interval if a subscribed data value has
changed. Otherwise, the device will not send an update to
the collector until expiration of the heartbeat interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="suppress-redundant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """suppress_redundant must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="suppress-redundant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='boolean', is_config=False)""",
        })

    self.__suppress_redundant = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_suppress_redundant(self):
    self.__suppress_redundant = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="suppress-redundant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='boolean', is_config=False)

  sensor_group = __builtin__.property(_get_sensor_group)
  sample_interval = __builtin__.property(_get_sample_interval)
  heartbeat_interval = __builtin__.property(_get_heartbeat_interval)
  suppress_redundant = __builtin__.property(_get_suppress_redundant)


  _pyangbind_elements = OrderedDict([('sensor_group', sensor_group), ('sample_interval', sample_interval), ('heartbeat_interval', heartbeat_interval), ('suppress_redundant', suppress_redundant), ])


class yc_sensor_profile_openconfig_telemetry__telemetry_system_subscriptions_persistent_subscriptions_persistent_subscription_sensor_profiles_sensor_profile(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-telemetry - based on the path /telemetry-system/subscriptions/persistent-subscriptions/persistent-subscription/sensor-profiles/sensor-profile. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of telemetry sensor groups used
in the subscription
  """
  __slots__ = ('_path_helper', '_extmethods', '__sensor_group','__config','__state',)

  _yang_name = 'sensor-profile'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__sensor_group = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="sensor-group", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_telemetry__telemetry_system_subscriptions_persistent_subscriptions_persistent_subscription_sensor_profiles_sensor_profile_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_telemetry__telemetry_system_subscriptions_persistent_subscriptions_persistent_subscription_sensor_profiles_sensor_profile_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['telemetry-system', 'subscriptions', 'persistent-subscriptions', 'persistent-subscription', 'sensor-profiles', 'sensor-profile']

  def _get_sensor_group(self):
    """
    Getter method for sensor_group, mapped from YANG variable /telemetry_system/subscriptions/persistent_subscriptions/persistent_subscription/sensor_profiles/sensor_profile/sensor_group (leafref)

    YANG Description: Reference to the telemetry sensor group name
    """
    return self.__sensor_group
      
  def _set_sensor_group(self, v, load=False):
    """
    Setter method for sensor_group, mapped from YANG variable /telemetry_system/subscriptions/persistent_subscriptions/persistent_subscription/sensor_profiles/sensor_profile/sensor_group (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_sensor_group is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_sensor_group() directly.

    YANG Description: Reference to the telemetry sensor group name
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="sensor-group", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """sensor_group must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="sensor-group", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='leafref', is_config=True)""",
        })

    self.__sensor_group = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_sensor_group(self):
    self.__sensor_group = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="sensor-group", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /telemetry_system/subscriptions/persistent_subscriptions/persistent_subscription/sensor_profiles/sensor_profile/config (container)

    YANG Description: Configuration parameters related to the sensor
profile for a subscription
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /telemetry_system/subscriptions/persistent_subscriptions/persistent_subscription/sensor_profiles/sensor_profile/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration parameters related to the sensor
profile for a subscription
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_telemetry__telemetry_system_subscriptions_persistent_subscriptions_persistent_subscription_sensor_profiles_sensor_profile_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_telemetry__telemetry_system_subscriptions_persistent_subscriptions_persistent_subscription_sensor_profiles_sensor_profile_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_telemetry__telemetry_system_subscriptions_persistent_subscriptions_persistent_subscription_sensor_profiles_sensor_profile_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /telemetry_system/subscriptions/persistent_subscriptions/persistent_subscription/sensor_profiles/sensor_profile/state (container)

    YANG Description: State information relating to the sensor profile
for a subscription
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /telemetry_system/subscriptions/persistent_subscriptions/persistent_subscription/sensor_profiles/sensor_profile/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: State information relating to the sensor profile
for a subscription
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_telemetry__telemetry_system_subscriptions_persistent_subscriptions_persistent_subscription_sensor_profiles_sensor_profile_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_telemetry__telemetry_system_subscriptions_persistent_subscriptions_persistent_subscription_sensor_profiles_sensor_profile_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_telemetry__telemetry_system_subscriptions_persistent_subscriptions_persistent_subscription_sensor_profiles_sensor_profile_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)

  sensor_group = __builtin__.property(_get_sensor_group, _set_sensor_group)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('sensor_group', sensor_group), ('config', config), ('state', state), ])


class yc_sensor_profiles_openconfig_telemetry__telemetry_system_subscriptions_persistent_subscriptions_persistent_subscription_sensor_profiles(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-telemetry - based on the path /telemetry-system/subscriptions/persistent-subscriptions/persistent-subscription/sensor-profiles. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: A sensor profile is a set of sensor groups or
individual sensor paths which are associated with a
telemetry subscription. This is the source of the
telemetry data for the subscription to send to the
defined collectors.
  """
  __slots__ = ('_path_helper', '_extmethods', '__sensor_profile',)

  _yang_name = 'sensor-profiles'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__sensor_profile = YANGDynClass(base=YANGListType("sensor_group",yc_sensor_profile_openconfig_telemetry__telemetry_system_subscriptions_persistent_subscriptions_persistent_subscription_sensor_profiles_sensor_profile, yang_name="sensor-profile", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='sensor-group', extensions=None), is_container='list', yang_name="sensor-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['telemetry-system', 'subscriptions', 'persistent-subscriptions', 'persistent-subscription', 'sensor-profiles']

  def _get_sensor_profile(self):
    """
    Getter method for sensor_profile, mapped from YANG variable /telemetry_system/subscriptions/persistent_subscriptions/persistent_subscription/sensor_profiles/sensor_profile (list)

    YANG Description: List of telemetry sensor groups used
in the subscription
    """
    return self.__sensor_profile
      
  def _set_sensor_profile(self, v, load=False):
    """
    Setter method for sensor_profile, mapped from YANG variable /telemetry_system/subscriptions/persistent_subscriptions/persistent_subscription/sensor_profiles/sensor_profile (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_sensor_profile is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_sensor_profile() directly.

    YANG Description: List of telemetry sensor groups used
in the subscription
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("sensor_group",yc_sensor_profile_openconfig_telemetry__telemetry_system_subscriptions_persistent_subscriptions_persistent_subscription_sensor_profiles_sensor_profile, yang_name="sensor-profile", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='sensor-group', extensions=None), is_container='list', yang_name="sensor-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """sensor_profile must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("sensor_group",yc_sensor_profile_openconfig_telemetry__telemetry_system_subscriptions_persistent_subscriptions_persistent_subscription_sensor_profiles_sensor_profile, yang_name="sensor-profile", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='sensor-group', extensions=None), is_container='list', yang_name="sensor-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='list', is_config=True)""",
        })

    self.__sensor_profile = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_sensor_profile(self):
    self.__sensor_profile = YANGDynClass(base=YANGListType("sensor_group",yc_sensor_profile_openconfig_telemetry__telemetry_system_subscriptions_persistent_subscriptions_persistent_subscription_sensor_profiles_sensor_profile, yang_name="sensor-profile", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='sensor-group', extensions=None), is_container='list', yang_name="sensor-profile", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='list', is_config=True)

  sensor_profile = __builtin__.property(_get_sensor_profile, _set_sensor_profile)


  _pyangbind_elements = OrderedDict([('sensor_profile', sensor_profile), ])


class yc_config_openconfig_telemetry__telemetry_system_subscriptions_persistent_subscriptions_persistent_subscription_destination_groups_destination_group_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-telemetry - based on the path /telemetry-system/subscriptions/persistent-subscriptions/persistent-subscription/destination-groups/destination-group/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration parameters related to telemetry
destinations.
  """
  __slots__ = ('_path_helper', '_extmethods', '__group_id',)

  _yang_name = 'config'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__group_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="group-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='leafref', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['telemetry-system', 'subscriptions', 'persistent-subscriptions', 'persistent-subscription', 'destination-groups', 'destination-group', 'config']

  def _get_group_id(self):
    """
    Getter method for group_id, mapped from YANG variable /telemetry_system/subscriptions/persistent_subscriptions/persistent_subscription/destination_groups/destination_group/config/group_id (leafref)

    YANG Description: The destination group id references a reusable
group of destination addresses and ports for
the telemetry stream.
    """
    return self.__group_id
      
  def _set_group_id(self, v, load=False):
    """
    Setter method for group_id, mapped from YANG variable /telemetry_system/subscriptions/persistent_subscriptions/persistent_subscription/destination_groups/destination_group/config/group_id (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_group_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_group_id() directly.

    YANG Description: The destination group id references a reusable
group of destination addresses and ports for
the telemetry stream.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="group-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """group_id must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="group-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='leafref', is_config=True)""",
        })

    self.__group_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_group_id(self):
    self.__group_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="group-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='leafref', is_config=True)

  group_id = __builtin__.property(_get_group_id, _set_group_id)


  _pyangbind_elements = OrderedDict([('group_id', group_id), ])


class yc_state_openconfig_telemetry__telemetry_system_subscriptions_persistent_subscriptions_persistent_subscription_destination_groups_destination_group_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-telemetry - based on the path /telemetry-system/subscriptions/persistent-subscriptions/persistent-subscription/destination-groups/destination-group/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: State information related to telemetry
destinations
  """
  __slots__ = ('_path_helper', '_extmethods', '__group_id',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__group_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="group-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='leafref', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['telemetry-system', 'subscriptions', 'persistent-subscriptions', 'persistent-subscription', 'destination-groups', 'destination-group', 'state']

  def _get_group_id(self):
    """
    Getter method for group_id, mapped from YANG variable /telemetry_system/subscriptions/persistent_subscriptions/persistent_subscription/destination_groups/destination_group/state/group_id (leafref)

    YANG Description: The destination group id references a reusable
group of destination addresses and ports for
the telemetry stream.
    """
    return self.__group_id
      
  def _set_group_id(self, v, load=False):
    """
    Setter method for group_id, mapped from YANG variable /telemetry_system/subscriptions/persistent_subscriptions/persistent_subscription/destination_groups/destination_group/state/group_id (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_group_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_group_id() directly.

    YANG Description: The destination group id references a reusable
group of destination addresses and ports for
the telemetry stream.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="group-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """group_id must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="group-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='leafref', is_config=False)""",
        })

    self.__group_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_group_id(self):
    self.__group_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="group-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='leafref', is_config=False)

  group_id = __builtin__.property(_get_group_id)


  _pyangbind_elements = OrderedDict([('group_id', group_id), ])


class yc_destination_group_openconfig_telemetry__telemetry_system_subscriptions_persistent_subscriptions_persistent_subscription_destination_groups_destination_group(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-telemetry - based on the path /telemetry-system/subscriptions/persistent-subscriptions/persistent-subscription/destination-groups/destination-group. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Identifier of the previously defined destination
group
  """
  __slots__ = ('_path_helper', '_extmethods', '__group_id','__config','__state',)

  _yang_name = 'destination-group'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__group_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="group-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_telemetry__telemetry_system_subscriptions_persistent_subscriptions_persistent_subscription_destination_groups_destination_group_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_telemetry__telemetry_system_subscriptions_persistent_subscriptions_persistent_subscription_destination_groups_destination_group_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['telemetry-system', 'subscriptions', 'persistent-subscriptions', 'persistent-subscription', 'destination-groups', 'destination-group']

  def _get_group_id(self):
    """
    Getter method for group_id, mapped from YANG variable /telemetry_system/subscriptions/persistent_subscriptions/persistent_subscription/destination_groups/destination_group/group_id (leafref)

    YANG Description: The destination group id references a configured
group of destinations for the telemetry stream.
    """
    return self.__group_id
      
  def _set_group_id(self, v, load=False):
    """
    Setter method for group_id, mapped from YANG variable /telemetry_system/subscriptions/persistent_subscriptions/persistent_subscription/destination_groups/destination_group/group_id (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_group_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_group_id() directly.

    YANG Description: The destination group id references a configured
group of destinations for the telemetry stream.
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="group-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """group_id must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="group-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='leafref', is_config=True)""",
        })

    self.__group_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_group_id(self):
    self.__group_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="group-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /telemetry_system/subscriptions/persistent_subscriptions/persistent_subscription/destination_groups/destination_group/config (container)

    YANG Description: Configuration parameters related to telemetry
destinations.
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /telemetry_system/subscriptions/persistent_subscriptions/persistent_subscription/destination_groups/destination_group/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration parameters related to telemetry
destinations.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_telemetry__telemetry_system_subscriptions_persistent_subscriptions_persistent_subscription_destination_groups_destination_group_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_telemetry__telemetry_system_subscriptions_persistent_subscriptions_persistent_subscription_destination_groups_destination_group_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_telemetry__telemetry_system_subscriptions_persistent_subscriptions_persistent_subscription_destination_groups_destination_group_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /telemetry_system/subscriptions/persistent_subscriptions/persistent_subscription/destination_groups/destination_group/state (container)

    YANG Description: State information related to telemetry
destinations
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /telemetry_system/subscriptions/persistent_subscriptions/persistent_subscription/destination_groups/destination_group/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: State information related to telemetry
destinations
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_telemetry__telemetry_system_subscriptions_persistent_subscriptions_persistent_subscription_destination_groups_destination_group_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_telemetry__telemetry_system_subscriptions_persistent_subscriptions_persistent_subscription_destination_groups_destination_group_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_telemetry__telemetry_system_subscriptions_persistent_subscriptions_persistent_subscription_destination_groups_destination_group_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)

  group_id = __builtin__.property(_get_group_id, _set_group_id)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('group_id', group_id), ('config', config), ('state', state), ])


class yc_destination_groups_openconfig_telemetry__telemetry_system_subscriptions_persistent_subscriptions_persistent_subscription_destination_groups(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-telemetry - based on the path /telemetry-system/subscriptions/persistent-subscriptions/persistent-subscription/destination-groups. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: A subscription may specify destination addresses.
If the subscription supplies destination addresses,
the network element will be the initiator of the
telemetry streaming, sending it to the destination(s)
specified.

If the destination set is omitted, the subscription
preconfigures certain elements such as paths and
sample intervals under a specified subscription ID.
In this case, the network element will NOT initiate an
outbound connection for telemetry, but will wait for
an inbound connection from a network management
system.

It is expected that the network management system
connecting to the network element will reference
the preconfigured subscription ID when initiating
a subscription.
  """
  __slots__ = ('_path_helper', '_extmethods', '__destination_group',)

  _yang_name = 'destination-groups'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__destination_group = YANGDynClass(base=YANGListType("group_id",yc_destination_group_openconfig_telemetry__telemetry_system_subscriptions_persistent_subscriptions_persistent_subscription_destination_groups_destination_group, yang_name="destination-group", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='group-id', extensions=None), is_container='list', yang_name="destination-group", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['telemetry-system', 'subscriptions', 'persistent-subscriptions', 'persistent-subscription', 'destination-groups']

  def _get_destination_group(self):
    """
    Getter method for destination_group, mapped from YANG variable /telemetry_system/subscriptions/persistent_subscriptions/persistent_subscription/destination_groups/destination_group (list)

    YANG Description: Identifier of the previously defined destination
group
    """
    return self.__destination_group
      
  def _set_destination_group(self, v, load=False):
    """
    Setter method for destination_group, mapped from YANG variable /telemetry_system/subscriptions/persistent_subscriptions/persistent_subscription/destination_groups/destination_group (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_destination_group is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_destination_group() directly.

    YANG Description: Identifier of the previously defined destination
group
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("group_id",yc_destination_group_openconfig_telemetry__telemetry_system_subscriptions_persistent_subscriptions_persistent_subscription_destination_groups_destination_group, yang_name="destination-group", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='group-id', extensions=None), is_container='list', yang_name="destination-group", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """destination_group must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("group_id",yc_destination_group_openconfig_telemetry__telemetry_system_subscriptions_persistent_subscriptions_persistent_subscription_destination_groups_destination_group, yang_name="destination-group", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='group-id', extensions=None), is_container='list', yang_name="destination-group", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='list', is_config=True)""",
        })

    self.__destination_group = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_destination_group(self):
    self.__destination_group = YANGDynClass(base=YANGListType("group_id",yc_destination_group_openconfig_telemetry__telemetry_system_subscriptions_persistent_subscriptions_persistent_subscription_destination_groups_destination_group, yang_name="destination-group", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='group-id', extensions=None), is_container='list', yang_name="destination-group", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='list', is_config=True)

  destination_group = __builtin__.property(_get_destination_group, _set_destination_group)


  _pyangbind_elements = OrderedDict([('destination_group', destination_group), ])


class yc_persistent_subscription_openconfig_telemetry__telemetry_system_subscriptions_persistent_subscriptions_persistent_subscription(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-telemetry - based on the path /telemetry-system/subscriptions/persistent-subscriptions/persistent-subscription. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of telemetry subscriptions. A telemetry
subscription consists of a set of collection
destinations, stream attributes, and associated paths to
state information in the model (sensor data)
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__config','__state','__sensor_profiles','__destination_groups',)

  _yang_name = 'persistent-subscription'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_telemetry__telemetry_system_subscriptions_persistent_subscriptions_persistent_subscription_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_telemetry__telemetry_system_subscriptions_persistent_subscriptions_persistent_subscription_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)
    self.__sensor_profiles = YANGDynClass(base=yc_sensor_profiles_openconfig_telemetry__telemetry_system_subscriptions_persistent_subscriptions_persistent_subscription_sensor_profiles, is_container='container', yang_name="sensor-profiles", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)
    self.__destination_groups = YANGDynClass(base=yc_destination_groups_openconfig_telemetry__telemetry_system_subscriptions_persistent_subscriptions_persistent_subscription_destination_groups, is_container='container', yang_name="destination-groups", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['telemetry-system', 'subscriptions', 'persistent-subscriptions', 'persistent-subscription']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /telemetry_system/subscriptions/persistent_subscriptions/persistent_subscription/name (leafref)

    YANG Description: Reference to the identifier of the subscription
itself. The id will be the handle to refer to the
subscription once created
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /telemetry_system/subscriptions/persistent_subscriptions/persistent_subscription/name (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Reference to the identifier of the subscription
itself. The id will be the handle to refer to the
subscription once created
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='leafref', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /telemetry_system/subscriptions/persistent_subscriptions/persistent_subscription/config (container)

    YANG Description: Config parameters relating to the telemetry
subscriptions on the local device
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /telemetry_system/subscriptions/persistent_subscriptions/persistent_subscription/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Config parameters relating to the telemetry
subscriptions on the local device
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_telemetry__telemetry_system_subscriptions_persistent_subscriptions_persistent_subscription_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_telemetry__telemetry_system_subscriptions_persistent_subscriptions_persistent_subscription_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_telemetry__telemetry_system_subscriptions_persistent_subscriptions_persistent_subscription_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /telemetry_system/subscriptions/persistent_subscriptions/persistent_subscription/state (container)

    YANG Description: State parameters relating to the telemetry
subscriptions on the local device
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /telemetry_system/subscriptions/persistent_subscriptions/persistent_subscription/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: State parameters relating to the telemetry
subscriptions on the local device
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_telemetry__telemetry_system_subscriptions_persistent_subscriptions_persistent_subscription_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_telemetry__telemetry_system_subscriptions_persistent_subscriptions_persistent_subscription_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_telemetry__telemetry_system_subscriptions_persistent_subscriptions_persistent_subscription_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)


  def _get_sensor_profiles(self):
    """
    Getter method for sensor_profiles, mapped from YANG variable /telemetry_system/subscriptions/persistent_subscriptions/persistent_subscription/sensor_profiles (container)

    YANG Description: A sensor profile is a set of sensor groups or
individual sensor paths which are associated with a
telemetry subscription. This is the source of the
telemetry data for the subscription to send to the
defined collectors.
    """
    return self.__sensor_profiles
      
  def _set_sensor_profiles(self, v, load=False):
    """
    Setter method for sensor_profiles, mapped from YANG variable /telemetry_system/subscriptions/persistent_subscriptions/persistent_subscription/sensor_profiles (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_sensor_profiles is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_sensor_profiles() directly.

    YANG Description: A sensor profile is a set of sensor groups or
individual sensor paths which are associated with a
telemetry subscription. This is the source of the
telemetry data for the subscription to send to the
defined collectors.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_sensor_profiles_openconfig_telemetry__telemetry_system_subscriptions_persistent_subscriptions_persistent_subscription_sensor_profiles, is_container='container', yang_name="sensor-profiles", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """sensor_profiles must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_sensor_profiles_openconfig_telemetry__telemetry_system_subscriptions_persistent_subscriptions_persistent_subscription_sensor_profiles, is_container='container', yang_name="sensor-profiles", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)""",
        })

    self.__sensor_profiles = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_sensor_profiles(self):
    self.__sensor_profiles = YANGDynClass(base=yc_sensor_profiles_openconfig_telemetry__telemetry_system_subscriptions_persistent_subscriptions_persistent_subscription_sensor_profiles, is_container='container', yang_name="sensor-profiles", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)


  def _get_destination_groups(self):
    """
    Getter method for destination_groups, mapped from YANG variable /telemetry_system/subscriptions/persistent_subscriptions/persistent_subscription/destination_groups (container)

    YANG Description: A subscription may specify destination addresses.
If the subscription supplies destination addresses,
the network element will be the initiator of the
telemetry streaming, sending it to the destination(s)
specified.

If the destination set is omitted, the subscription
preconfigures certain elements such as paths and
sample intervals under a specified subscription ID.
In this case, the network element will NOT initiate an
outbound connection for telemetry, but will wait for
an inbound connection from a network management
system.

It is expected that the network management system
connecting to the network element will reference
the preconfigured subscription ID when initiating
a subscription.
    """
    return self.__destination_groups
      
  def _set_destination_groups(self, v, load=False):
    """
    Setter method for destination_groups, mapped from YANG variable /telemetry_system/subscriptions/persistent_subscriptions/persistent_subscription/destination_groups (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_destination_groups is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_destination_groups() directly.

    YANG Description: A subscription may specify destination addresses.
If the subscription supplies destination addresses,
the network element will be the initiator of the
telemetry streaming, sending it to the destination(s)
specified.

If the destination set is omitted, the subscription
preconfigures certain elements such as paths and
sample intervals under a specified subscription ID.
In this case, the network element will NOT initiate an
outbound connection for telemetry, but will wait for
an inbound connection from a network management
system.

It is expected that the network management system
connecting to the network element will reference
the preconfigured subscription ID when initiating
a subscription.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_destination_groups_openconfig_telemetry__telemetry_system_subscriptions_persistent_subscriptions_persistent_subscription_destination_groups, is_container='container', yang_name="destination-groups", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """destination_groups must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_destination_groups_openconfig_telemetry__telemetry_system_subscriptions_persistent_subscriptions_persistent_subscription_destination_groups, is_container='container', yang_name="destination-groups", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)""",
        })

    self.__destination_groups = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_destination_groups(self):
    self.__destination_groups = YANGDynClass(base=yc_destination_groups_openconfig_telemetry__telemetry_system_subscriptions_persistent_subscriptions_persistent_subscription_destination_groups, is_container='container', yang_name="destination-groups", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)
  sensor_profiles = __builtin__.property(_get_sensor_profiles, _set_sensor_profiles)
  destination_groups = __builtin__.property(_get_destination_groups, _set_destination_groups)


  _pyangbind_elements = OrderedDict([('name', name), ('config', config), ('state', state), ('sensor_profiles', sensor_profiles), ('destination_groups', destination_groups), ])


class yc_persistent_subscriptions_openconfig_telemetry__telemetry_system_subscriptions_persistent_subscriptions(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-telemetry - based on the path /telemetry-system/subscriptions/persistent-subscriptions. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This container holds information relating to persistent
telemetry subscriptions. A persistent telemetry
subscription is configued locally on the device through
configuration, and is persistent across device restarts or
other redundancy changes.
  """
  __slots__ = ('_path_helper', '_extmethods', '__persistent_subscription',)

  _yang_name = 'persistent-subscriptions'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__persistent_subscription = YANGDynClass(base=YANGListType("name",yc_persistent_subscription_openconfig_telemetry__telemetry_system_subscriptions_persistent_subscriptions_persistent_subscription, yang_name="persistent-subscription", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="persistent-subscription", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['telemetry-system', 'subscriptions', 'persistent-subscriptions']

  def _get_persistent_subscription(self):
    """
    Getter method for persistent_subscription, mapped from YANG variable /telemetry_system/subscriptions/persistent_subscriptions/persistent_subscription (list)

    YANG Description: List of telemetry subscriptions. A telemetry
subscription consists of a set of collection
destinations, stream attributes, and associated paths to
state information in the model (sensor data)
    """
    return self.__persistent_subscription
      
  def _set_persistent_subscription(self, v, load=False):
    """
    Setter method for persistent_subscription, mapped from YANG variable /telemetry_system/subscriptions/persistent_subscriptions/persistent_subscription (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_persistent_subscription is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_persistent_subscription() directly.

    YANG Description: List of telemetry subscriptions. A telemetry
subscription consists of a set of collection
destinations, stream attributes, and associated paths to
state information in the model (sensor data)
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("name",yc_persistent_subscription_openconfig_telemetry__telemetry_system_subscriptions_persistent_subscriptions_persistent_subscription, yang_name="persistent-subscription", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="persistent-subscription", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """persistent_subscription must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("name",yc_persistent_subscription_openconfig_telemetry__telemetry_system_subscriptions_persistent_subscriptions_persistent_subscription, yang_name="persistent-subscription", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="persistent-subscription", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='list', is_config=True)""",
        })

    self.__persistent_subscription = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_persistent_subscription(self):
    self.__persistent_subscription = YANGDynClass(base=YANGListType("name",yc_persistent_subscription_openconfig_telemetry__telemetry_system_subscriptions_persistent_subscriptions_persistent_subscription, yang_name="persistent-subscription", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="persistent-subscription", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='list', is_config=True)

  persistent_subscription = __builtin__.property(_get_persistent_subscription, _set_persistent_subscription)


  _pyangbind_elements = OrderedDict([('persistent_subscription', persistent_subscription), ])


class yc_state_openconfig_telemetry__telemetry_system_subscriptions_dynamic_subscriptions_dynamic_subscription_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-telemetry - based on the path /telemetry-system/subscriptions/dynamic-subscriptions/dynamic-subscription/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: State information relating to dynamic telemetry
subscriptions.
  """
  __slots__ = ('_path_helper', '_extmethods', '__id','__destination_address','__destination_port','__sample_interval','__heartbeat_interval','__suppress_redundant','__originated_qos_marking','__protocol','__encoding',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__id = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='uint64', is_config=False)
    self.__destination_address = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="destination-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='oc-inet:ip-address', is_config=False)
    self.__destination_port = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="destination-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='uint16', is_config=False)
    self.__sample_interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="sample-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='uint64', is_config=False)
    self.__heartbeat_interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="heartbeat-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='uint64', is_config=False)
    self.__suppress_redundant = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="suppress-redundant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='boolean', is_config=False)
    self.__originated_qos_marking = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="originated-qos-marking", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='oc-inet:dscp', is_config=False)
    self.__protocol = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'STREAM_SSH': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:STREAM_SSH': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'STREAM_GRPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:STREAM_GRPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'STREAM_JSON_RPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:STREAM_JSON_RPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'STREAM_THRIFT_RPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:STREAM_THRIFT_RPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'STREAM_WEBSOCKET_RPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:STREAM_WEBSOCKET_RPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}},), is_leaf=True, yang_name="protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='identityref', is_config=False)
    self.__encoding = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ENC_XML': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:ENC_XML': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'ENC_JSON_IETF': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:ENC_JSON_IETF': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'ENC_PROTO3': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:ENC_PROTO3': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}},), is_leaf=True, yang_name="encoding", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='identityref', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['telemetry-system', 'subscriptions', 'dynamic-subscriptions', 'dynamic-subscription', 'state']

  def _get_id(self):
    """
    Getter method for id, mapped from YANG variable /telemetry_system/subscriptions/dynamic_subscriptions/dynamic_subscription/state/id (uint64)

    YANG Description: System generated identifer of the telemetry
subscription.
    """
    return self.__id
      
  def _set_id(self, v, load=False):
    """
    Setter method for id, mapped from YANG variable /telemetry_system/subscriptions/dynamic_subscriptions/dynamic_subscription/state/id (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_id() directly.

    YANG Description: System generated identifer of the telemetry
subscription.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """id must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='uint64', is_config=False)""",
        })

    self.__id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_id(self):
    self.__id = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='uint64', is_config=False)


  def _get_destination_address(self):
    """
    Getter method for destination_address, mapped from YANG variable /telemetry_system/subscriptions/dynamic_subscriptions/dynamic_subscription/state/destination_address (oc-inet:ip-address)

    YANG Description: IP address of the telemetry stream destination
    """
    return self.__destination_address
      
  def _set_destination_address(self, v, load=False):
    """
    Setter method for destination_address, mapped from YANG variable /telemetry_system/subscriptions/dynamic_subscriptions/dynamic_subscription/state/destination_address (oc-inet:ip-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_destination_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_destination_address() directly.

    YANG Description: IP address of the telemetry stream destination
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="destination-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='oc-inet:ip-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """destination_address must be of a type compatible with oc-inet:ip-address""",
          'defined-type': "oc-inet:ip-address",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="destination-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='oc-inet:ip-address', is_config=False)""",
        })

    self.__destination_address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_destination_address(self):
    self.__destination_address = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="destination-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='oc-inet:ip-address', is_config=False)


  def _get_destination_port(self):
    """
    Getter method for destination_port, mapped from YANG variable /telemetry_system/subscriptions/dynamic_subscriptions/dynamic_subscription/state/destination_port (uint16)

    YANG Description: Protocol (udp or tcp) port number for the telemetry
stream destination
    """
    return self.__destination_port
      
  def _set_destination_port(self, v, load=False):
    """
    Setter method for destination_port, mapped from YANG variable /telemetry_system/subscriptions/dynamic_subscriptions/dynamic_subscription/state/destination_port (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_destination_port is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_destination_port() directly.

    YANG Description: Protocol (udp or tcp) port number for the telemetry
stream destination
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="destination-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='uint16', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """destination_port must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="destination-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='uint16', is_config=False)""",
        })

    self.__destination_port = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_destination_port(self):
    self.__destination_port = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="destination-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='uint16', is_config=False)


  def _get_sample_interval(self):
    """
    Getter method for sample_interval, mapped from YANG variable /telemetry_system/subscriptions/dynamic_subscriptions/dynamic_subscription/state/sample_interval (uint64)

    YANG Description: Time in milliseconds between the device's sample of a
telemetry data source. For example, setting this to 100
would require the local device to collect the telemetry
data every 100 milliseconds. There can be latency or jitter
in transmitting the data, but the sample must occur at
the specified interval.

The timestamp must reflect the actual time when the data
was sampled, not simply the previous sample timestamp +
sample-interval.

If sample-interval is set to 0, the telemetry sensor
becomes event based. The sensor must then emit data upon
every change of the underlying data source.
    """
    return self.__sample_interval
      
  def _set_sample_interval(self, v, load=False):
    """
    Setter method for sample_interval, mapped from YANG variable /telemetry_system/subscriptions/dynamic_subscriptions/dynamic_subscription/state/sample_interval (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_sample_interval is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_sample_interval() directly.

    YANG Description: Time in milliseconds between the device's sample of a
telemetry data source. For example, setting this to 100
would require the local device to collect the telemetry
data every 100 milliseconds. There can be latency or jitter
in transmitting the data, but the sample must occur at
the specified interval.

The timestamp must reflect the actual time when the data
was sampled, not simply the previous sample timestamp +
sample-interval.

If sample-interval is set to 0, the telemetry sensor
becomes event based. The sensor must then emit data upon
every change of the underlying data source.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="sample-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """sample_interval must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="sample-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='uint64', is_config=False)""",
        })

    self.__sample_interval = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_sample_interval(self):
    self.__sample_interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="sample-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='uint64', is_config=False)


  def _get_heartbeat_interval(self):
    """
    Getter method for heartbeat_interval, mapped from YANG variable /telemetry_system/subscriptions/dynamic_subscriptions/dynamic_subscription/state/heartbeat_interval (uint64)

    YANG Description: Maximum time interval in seconds that may pass
between updates from a device to a telemetry collector.
If this interval expires, but there is no updated data to
send (such as if suppress_updates has been configured), the
device must send a telemetry message to the collector.
    """
    return self.__heartbeat_interval
      
  def _set_heartbeat_interval(self, v, load=False):
    """
    Setter method for heartbeat_interval, mapped from YANG variable /telemetry_system/subscriptions/dynamic_subscriptions/dynamic_subscription/state/heartbeat_interval (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_heartbeat_interval is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_heartbeat_interval() directly.

    YANG Description: Maximum time interval in seconds that may pass
between updates from a device to a telemetry collector.
If this interval expires, but there is no updated data to
send (such as if suppress_updates has been configured), the
device must send a telemetry message to the collector.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="heartbeat-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """heartbeat_interval must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="heartbeat-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='uint64', is_config=False)""",
        })

    self.__heartbeat_interval = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_heartbeat_interval(self):
    self.__heartbeat_interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="heartbeat-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='uint64', is_config=False)


  def _get_suppress_redundant(self):
    """
    Getter method for suppress_redundant, mapped from YANG variable /telemetry_system/subscriptions/dynamic_subscriptions/dynamic_subscription/state/suppress_redundant (boolean)

    YANG Description: Boolean flag to control suppression of redundant
telemetry updates to the collector platform. If this flag is
set to TRUE, then the collector will only send an update at
the configured interval if a subscribed data value has
changed. Otherwise, the device will not send an update to
the collector until expiration of the heartbeat interval.
    """
    return self.__suppress_redundant
      
  def _set_suppress_redundant(self, v, load=False):
    """
    Setter method for suppress_redundant, mapped from YANG variable /telemetry_system/subscriptions/dynamic_subscriptions/dynamic_subscription/state/suppress_redundant (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_suppress_redundant is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_suppress_redundant() directly.

    YANG Description: Boolean flag to control suppression of redundant
telemetry updates to the collector platform. If this flag is
set to TRUE, then the collector will only send an update at
the configured interval if a subscribed data value has
changed. Otherwise, the device will not send an update to
the collector until expiration of the heartbeat interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="suppress-redundant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """suppress_redundant must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="suppress-redundant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='boolean', is_config=False)""",
        })

    self.__suppress_redundant = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_suppress_redundant(self):
    self.__suppress_redundant = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="suppress-redundant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='boolean', is_config=False)


  def _get_originated_qos_marking(self):
    """
    Getter method for originated_qos_marking, mapped from YANG variable /telemetry_system/subscriptions/dynamic_subscriptions/dynamic_subscription/state/originated_qos_marking (oc-inet:dscp)

    YANG Description: DSCP marking of packets generated by the telemetry
subsystem on the network device.
    """
    return self.__originated_qos_marking
      
  def _set_originated_qos_marking(self, v, load=False):
    """
    Setter method for originated_qos_marking, mapped from YANG variable /telemetry_system/subscriptions/dynamic_subscriptions/dynamic_subscription/state/originated_qos_marking (oc-inet:dscp)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_originated_qos_marking is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_originated_qos_marking() directly.

    YANG Description: DSCP marking of packets generated by the telemetry
subsystem on the network device.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="originated-qos-marking", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='oc-inet:dscp', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """originated_qos_marking must be of a type compatible with oc-inet:dscp""",
          'defined-type': "oc-inet:dscp",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="originated-qos-marking", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='oc-inet:dscp', is_config=False)""",
        })

    self.__originated_qos_marking = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_originated_qos_marking(self):
    self.__originated_qos_marking = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="originated-qos-marking", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='oc-inet:dscp', is_config=False)


  def _get_protocol(self):
    """
    Getter method for protocol, mapped from YANG variable /telemetry_system/subscriptions/dynamic_subscriptions/dynamic_subscription/state/protocol (identityref)

    YANG Description: Selection of the transport protocol for the telemetry
stream.
    """
    return self.__protocol
      
  def _set_protocol(self, v, load=False):
    """
    Setter method for protocol, mapped from YANG variable /telemetry_system/subscriptions/dynamic_subscriptions/dynamic_subscription/state/protocol (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_protocol is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_protocol() directly.

    YANG Description: Selection of the transport protocol for the telemetry
stream.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'STREAM_SSH': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:STREAM_SSH': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'STREAM_GRPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:STREAM_GRPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'STREAM_JSON_RPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:STREAM_JSON_RPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'STREAM_THRIFT_RPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:STREAM_THRIFT_RPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'STREAM_WEBSOCKET_RPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:STREAM_WEBSOCKET_RPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}},), is_leaf=True, yang_name="protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='identityref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """protocol must be of a type compatible with identityref""",
          'defined-type': "openconfig-telemetry:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'STREAM_SSH': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:STREAM_SSH': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'STREAM_GRPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:STREAM_GRPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'STREAM_JSON_RPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:STREAM_JSON_RPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'STREAM_THRIFT_RPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:STREAM_THRIFT_RPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'STREAM_WEBSOCKET_RPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:STREAM_WEBSOCKET_RPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}},), is_leaf=True, yang_name="protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='identityref', is_config=False)""",
        })

    self.__protocol = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_protocol(self):
    self.__protocol = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'STREAM_SSH': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:STREAM_SSH': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'STREAM_GRPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:STREAM_GRPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'STREAM_JSON_RPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:STREAM_JSON_RPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'STREAM_THRIFT_RPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:STREAM_THRIFT_RPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'STREAM_WEBSOCKET_RPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:STREAM_WEBSOCKET_RPC': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}},), is_leaf=True, yang_name="protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='identityref', is_config=False)


  def _get_encoding(self):
    """
    Getter method for encoding, mapped from YANG variable /telemetry_system/subscriptions/dynamic_subscriptions/dynamic_subscription/state/encoding (identityref)

    YANG Description: Selection of the specific encoding or RPC framework
for telemetry messages to and from the network element.
    """
    return self.__encoding
      
  def _set_encoding(self, v, load=False):
    """
    Setter method for encoding, mapped from YANG variable /telemetry_system/subscriptions/dynamic_subscriptions/dynamic_subscription/state/encoding (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_encoding is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_encoding() directly.

    YANG Description: Selection of the specific encoding or RPC framework
for telemetry messages to and from the network element.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ENC_XML': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:ENC_XML': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'ENC_JSON_IETF': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:ENC_JSON_IETF': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'ENC_PROTO3': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:ENC_PROTO3': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}},), is_leaf=True, yang_name="encoding", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='identityref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """encoding must be of a type compatible with identityref""",
          'defined-type': "openconfig-telemetry:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ENC_XML': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:ENC_XML': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'ENC_JSON_IETF': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:ENC_JSON_IETF': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'ENC_PROTO3': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:ENC_PROTO3': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}},), is_leaf=True, yang_name="encoding", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='identityref', is_config=False)""",
        })

    self.__encoding = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_encoding(self):
    self.__encoding = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ENC_XML': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:ENC_XML': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'ENC_JSON_IETF': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:ENC_JSON_IETF': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'ENC_PROTO3': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}, 'oc-telemetry-types:ENC_PROTO3': {'@module': 'openconfig-telemetry-types', '@namespace': 'http://openconfig.net/yang/telemetry-types'}},), is_leaf=True, yang_name="encoding", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='identityref', is_config=False)

  id = __builtin__.property(_get_id)
  destination_address = __builtin__.property(_get_destination_address)
  destination_port = __builtin__.property(_get_destination_port)
  sample_interval = __builtin__.property(_get_sample_interval)
  heartbeat_interval = __builtin__.property(_get_heartbeat_interval)
  suppress_redundant = __builtin__.property(_get_suppress_redundant)
  originated_qos_marking = __builtin__.property(_get_originated_qos_marking)
  protocol = __builtin__.property(_get_protocol)
  encoding = __builtin__.property(_get_encoding)


  _pyangbind_elements = OrderedDict([('id', id), ('destination_address', destination_address), ('destination_port', destination_port), ('sample_interval', sample_interval), ('heartbeat_interval', heartbeat_interval), ('suppress_redundant', suppress_redundant), ('originated_qos_marking', originated_qos_marking), ('protocol', protocol), ('encoding', encoding), ])


class yc_state_openconfig_telemetry__telemetry_system_subscriptions_dynamic_subscriptions_dynamic_subscription_sensor_paths_sensor_path_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-telemetry - based on the path /telemetry-system/subscriptions/dynamic-subscriptions/dynamic-subscription/sensor-paths/sensor-path/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: State information for a dynamic subscription's
paths of interest
  """
  __slots__ = ('_path_helper', '_extmethods', '__path','__exclude_filter',)

  _yang_name = 'state'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__path = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="path", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='string', is_config=False)
    self.__exclude_filter = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="exclude-filter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='string', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['telemetry-system', 'subscriptions', 'dynamic-subscriptions', 'dynamic-subscription', 'sensor-paths', 'sensor-path', 'state']

  def _get_path(self):
    """
    Getter method for path, mapped from YANG variable /telemetry_system/subscriptions/dynamic_subscriptions/dynamic_subscription/sensor_paths/sensor_path/state/path (string)

    YANG Description: Path to a section of operational state of interest
(the sensor).
    """
    return self.__path
      
  def _set_path(self, v, load=False):
    """
    Setter method for path, mapped from YANG variable /telemetry_system/subscriptions/dynamic_subscriptions/dynamic_subscription/sensor_paths/sensor_path/state/path (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_path is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_path() directly.

    YANG Description: Path to a section of operational state of interest
(the sensor).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="path", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """path must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="path", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='string', is_config=False)""",
        })

    self.__path = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_path(self):
    self.__path = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="path", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='string', is_config=False)


  def _get_exclude_filter(self):
    """
    Getter method for exclude_filter, mapped from YANG variable /telemetry_system/subscriptions/dynamic_subscriptions/dynamic_subscription/sensor_paths/sensor_path/state/exclude_filter (string)

    YANG Description: Filter to exclude certain values out of the state
values
    """
    return self.__exclude_filter
      
  def _set_exclude_filter(self, v, load=False):
    """
    Setter method for exclude_filter, mapped from YANG variable /telemetry_system/subscriptions/dynamic_subscriptions/dynamic_subscription/sensor_paths/sensor_path/state/exclude_filter (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_exclude_filter is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_exclude_filter() directly.

    YANG Description: Filter to exclude certain values out of the state
values
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="exclude-filter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """exclude_filter must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="exclude-filter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='string', is_config=False)""",
        })

    self.__exclude_filter = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_exclude_filter(self):
    self.__exclude_filter = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="exclude-filter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='string', is_config=False)

  path = __builtin__.property(_get_path)
  exclude_filter = __builtin__.property(_get_exclude_filter)


  _pyangbind_elements = OrderedDict([('path', path), ('exclude_filter', exclude_filter), ])


class yc_sensor_path_openconfig_telemetry__telemetry_system_subscriptions_dynamic_subscriptions_dynamic_subscription_sensor_paths_sensor_path(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-telemetry - based on the path /telemetry-system/subscriptions/dynamic-subscriptions/dynamic-subscription/sensor-paths/sensor-path. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of paths in the model which together
comprise a sensor grouping. Filters for each path
to exclude items are also provided.
  """
  __slots__ = ('_path_helper', '_extmethods', '__path','__state',)

  _yang_name = 'sensor-path'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__path = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="path", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='leafref', is_config=False)
    self.__state = YANGDynClass(base=yc_state_openconfig_telemetry__telemetry_system_subscriptions_dynamic_subscriptions_dynamic_subscription_sensor_paths_sensor_path_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['telemetry-system', 'subscriptions', 'dynamic-subscriptions', 'dynamic-subscription', 'sensor-paths', 'sensor-path']

  def _get_path(self):
    """
    Getter method for path, mapped from YANG variable /telemetry_system/subscriptions/dynamic_subscriptions/dynamic_subscription/sensor_paths/sensor_path/path (leafref)

    YANG Description: Reference to the path of interest
    """
    return self.__path
      
  def _set_path(self, v, load=False):
    """
    Setter method for path, mapped from YANG variable /telemetry_system/subscriptions/dynamic_subscriptions/dynamic_subscription/sensor_paths/sensor_path/path (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_path is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_path() directly.

    YANG Description: Reference to the path of interest
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="path", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """path must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="path", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='leafref', is_config=False)""",
        })

    self.__path = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_path(self):
    self.__path = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="path", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='leafref', is_config=False)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /telemetry_system/subscriptions/dynamic_subscriptions/dynamic_subscription/sensor_paths/sensor_path/state (container)

    YANG Description: State information for a dynamic subscription's
paths of interest
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /telemetry_system/subscriptions/dynamic_subscriptions/dynamic_subscription/sensor_paths/sensor_path/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: State information for a dynamic subscription's
paths of interest
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_telemetry__telemetry_system_subscriptions_dynamic_subscriptions_dynamic_subscription_sensor_paths_sensor_path_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_telemetry__telemetry_system_subscriptions_dynamic_subscriptions_dynamic_subscription_sensor_paths_sensor_path_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=False)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_telemetry__telemetry_system_subscriptions_dynamic_subscriptions_dynamic_subscription_sensor_paths_sensor_path_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=False)

  path = __builtin__.property(_get_path)
  state = __builtin__.property(_get_state)


  _pyangbind_elements = OrderedDict([('path', path), ('state', state), ])


class yc_sensor_paths_openconfig_telemetry__telemetry_system_subscriptions_dynamic_subscriptions_dynamic_subscription_sensor_paths(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-telemetry - based on the path /telemetry-system/subscriptions/dynamic-subscriptions/dynamic-subscription/sensor-paths. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Top level container to hold a set of sensor
paths grouped together
  """
  __slots__ = ('_path_helper', '_extmethods', '__sensor_path',)

  _yang_name = 'sensor-paths'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__sensor_path = YANGDynClass(base=YANGListType("path",yc_sensor_path_openconfig_telemetry__telemetry_system_subscriptions_dynamic_subscriptions_dynamic_subscription_sensor_paths_sensor_path, yang_name="sensor-path", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='path', extensions=None), is_container='list', yang_name="sensor-path", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='list', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['telemetry-system', 'subscriptions', 'dynamic-subscriptions', 'dynamic-subscription', 'sensor-paths']

  def _get_sensor_path(self):
    """
    Getter method for sensor_path, mapped from YANG variable /telemetry_system/subscriptions/dynamic_subscriptions/dynamic_subscription/sensor_paths/sensor_path (list)

    YANG Description: List of paths in the model which together
comprise a sensor grouping. Filters for each path
to exclude items are also provided.
    """
    return self.__sensor_path
      
  def _set_sensor_path(self, v, load=False):
    """
    Setter method for sensor_path, mapped from YANG variable /telemetry_system/subscriptions/dynamic_subscriptions/dynamic_subscription/sensor_paths/sensor_path (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_sensor_path is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_sensor_path() directly.

    YANG Description: List of paths in the model which together
comprise a sensor grouping. Filters for each path
to exclude items are also provided.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("path",yc_sensor_path_openconfig_telemetry__telemetry_system_subscriptions_dynamic_subscriptions_dynamic_subscription_sensor_paths_sensor_path, yang_name="sensor-path", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='path', extensions=None), is_container='list', yang_name="sensor-path", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='list', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """sensor_path must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("path",yc_sensor_path_openconfig_telemetry__telemetry_system_subscriptions_dynamic_subscriptions_dynamic_subscription_sensor_paths_sensor_path, yang_name="sensor-path", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='path', extensions=None), is_container='list', yang_name="sensor-path", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='list', is_config=False)""",
        })

    self.__sensor_path = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_sensor_path(self):
    self.__sensor_path = YANGDynClass(base=YANGListType("path",yc_sensor_path_openconfig_telemetry__telemetry_system_subscriptions_dynamic_subscriptions_dynamic_subscription_sensor_paths_sensor_path, yang_name="sensor-path", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='path', extensions=None), is_container='list', yang_name="sensor-path", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='list', is_config=False)

  sensor_path = __builtin__.property(_get_sensor_path)


  _pyangbind_elements = OrderedDict([('sensor_path', sensor_path), ])


class yc_dynamic_subscription_openconfig_telemetry__telemetry_system_subscriptions_dynamic_subscriptions_dynamic_subscription(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-telemetry - based on the path /telemetry-system/subscriptions/dynamic-subscriptions/dynamic-subscription. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List representation of telemetry subscriptions that
are configured via an inline RPC, otherwise known
as dynamic telemetry subscriptions.
  """
  __slots__ = ('_path_helper', '_extmethods', '__id','__state','__sensor_paths',)

  _yang_name = 'dynamic-subscription'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='leafref', is_config=False)
    self.__state = YANGDynClass(base=yc_state_openconfig_telemetry__telemetry_system_subscriptions_dynamic_subscriptions_dynamic_subscription_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=False)
    self.__sensor_paths = YANGDynClass(base=yc_sensor_paths_openconfig_telemetry__telemetry_system_subscriptions_dynamic_subscriptions_dynamic_subscription_sensor_paths, is_container='container', yang_name="sensor-paths", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['telemetry-system', 'subscriptions', 'dynamic-subscriptions', 'dynamic-subscription']

  def _get_id(self):
    """
    Getter method for id, mapped from YANG variable /telemetry_system/subscriptions/dynamic_subscriptions/dynamic_subscription/id (leafref)

    YANG Description: Reference to the identifier of the subscription
itself. The id will be the handle to refer to the
subscription once created
    """
    return self.__id
      
  def _set_id(self, v, load=False):
    """
    Setter method for id, mapped from YANG variable /telemetry_system/subscriptions/dynamic_subscriptions/dynamic_subscription/id (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_id() directly.

    YANG Description: Reference to the identifier of the subscription
itself. The id will be the handle to refer to the
subscription once created
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """id must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='leafref', is_config=False)""",
        })

    self.__id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_id(self):
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='leafref', is_config=False)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /telemetry_system/subscriptions/dynamic_subscriptions/dynamic_subscription/state (container)

    YANG Description: State information relating to dynamic telemetry
subscriptions.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /telemetry_system/subscriptions/dynamic_subscriptions/dynamic_subscription/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: State information relating to dynamic telemetry
subscriptions.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_telemetry__telemetry_system_subscriptions_dynamic_subscriptions_dynamic_subscription_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_telemetry__telemetry_system_subscriptions_dynamic_subscriptions_dynamic_subscription_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=False)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_telemetry__telemetry_system_subscriptions_dynamic_subscriptions_dynamic_subscription_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=False)


  def _get_sensor_paths(self):
    """
    Getter method for sensor_paths, mapped from YANG variable /telemetry_system/subscriptions/dynamic_subscriptions/dynamic_subscription/sensor_paths (container)

    YANG Description: Top level container to hold a set of sensor
paths grouped together
    """
    return self.__sensor_paths
      
  def _set_sensor_paths(self, v, load=False):
    """
    Setter method for sensor_paths, mapped from YANG variable /telemetry_system/subscriptions/dynamic_subscriptions/dynamic_subscription/sensor_paths (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_sensor_paths is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_sensor_paths() directly.

    YANG Description: Top level container to hold a set of sensor
paths grouped together
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_sensor_paths_openconfig_telemetry__telemetry_system_subscriptions_dynamic_subscriptions_dynamic_subscription_sensor_paths, is_container='container', yang_name="sensor-paths", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """sensor_paths must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_sensor_paths_openconfig_telemetry__telemetry_system_subscriptions_dynamic_subscriptions_dynamic_subscription_sensor_paths, is_container='container', yang_name="sensor-paths", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=False)""",
        })

    self.__sensor_paths = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_sensor_paths(self):
    self.__sensor_paths = YANGDynClass(base=yc_sensor_paths_openconfig_telemetry__telemetry_system_subscriptions_dynamic_subscriptions_dynamic_subscription_sensor_paths, is_container='container', yang_name="sensor-paths", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=False)

  id = __builtin__.property(_get_id)
  state = __builtin__.property(_get_state)
  sensor_paths = __builtin__.property(_get_sensor_paths)


  _pyangbind_elements = OrderedDict([('id', id), ('state', state), ('sensor_paths', sensor_paths), ])


class yc_dynamic_subscriptions_openconfig_telemetry__telemetry_system_subscriptions_dynamic_subscriptions(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-telemetry - based on the path /telemetry-system/subscriptions/dynamic-subscriptions. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This container holds information relating to dynamic
telemetry subscriptions. A dynamic subscription is
typically configured through an RPC channel, and does not
persist across device restarts, or if the RPC channel is
reset or otherwise torn down.
  """
  __slots__ = ('_path_helper', '_extmethods', '__dynamic_subscription',)

  _yang_name = 'dynamic-subscriptions'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__dynamic_subscription = YANGDynClass(base=YANGListType("id",yc_dynamic_subscription_openconfig_telemetry__telemetry_system_subscriptions_dynamic_subscriptions_dynamic_subscription, yang_name="dynamic-subscription", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='id', extensions=None), is_container='list', yang_name="dynamic-subscription", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['telemetry-system', 'subscriptions', 'dynamic-subscriptions']

  def _get_dynamic_subscription(self):
    """
    Getter method for dynamic_subscription, mapped from YANG variable /telemetry_system/subscriptions/dynamic_subscriptions/dynamic_subscription (list)

    YANG Description: List representation of telemetry subscriptions that
are configured via an inline RPC, otherwise known
as dynamic telemetry subscriptions.
    """
    return self.__dynamic_subscription
      
  def _set_dynamic_subscription(self, v, load=False):
    """
    Setter method for dynamic_subscription, mapped from YANG variable /telemetry_system/subscriptions/dynamic_subscriptions/dynamic_subscription (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dynamic_subscription is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dynamic_subscription() directly.

    YANG Description: List representation of telemetry subscriptions that
are configured via an inline RPC, otherwise known
as dynamic telemetry subscriptions.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("id",yc_dynamic_subscription_openconfig_telemetry__telemetry_system_subscriptions_dynamic_subscriptions_dynamic_subscription, yang_name="dynamic-subscription", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='id', extensions=None), is_container='list', yang_name="dynamic-subscription", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dynamic_subscription must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("id",yc_dynamic_subscription_openconfig_telemetry__telemetry_system_subscriptions_dynamic_subscriptions_dynamic_subscription, yang_name="dynamic-subscription", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='id', extensions=None), is_container='list', yang_name="dynamic-subscription", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='list', is_config=True)""",
        })

    self.__dynamic_subscription = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dynamic_subscription(self):
    self.__dynamic_subscription = YANGDynClass(base=YANGListType("id",yc_dynamic_subscription_openconfig_telemetry__telemetry_system_subscriptions_dynamic_subscriptions_dynamic_subscription, yang_name="dynamic-subscription", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='id', extensions=None), is_container='list', yang_name="dynamic-subscription", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='list', is_config=True)

  dynamic_subscription = __builtin__.property(_get_dynamic_subscription, _set_dynamic_subscription)


  _pyangbind_elements = OrderedDict([('dynamic_subscription', dynamic_subscription), ])


class yc_subscriptions_openconfig_telemetry__telemetry_system_subscriptions(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-telemetry - based on the path /telemetry-system/subscriptions. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This container holds information for both persistent
and dynamic telemetry subscriptions.
  """
  __slots__ = ('_path_helper', '_extmethods', '__persistent_subscriptions','__dynamic_subscriptions',)

  _yang_name = 'subscriptions'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__persistent_subscriptions = YANGDynClass(base=yc_persistent_subscriptions_openconfig_telemetry__telemetry_system_subscriptions_persistent_subscriptions, is_container='container', yang_name="persistent-subscriptions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)
    self.__dynamic_subscriptions = YANGDynClass(base=yc_dynamic_subscriptions_openconfig_telemetry__telemetry_system_subscriptions_dynamic_subscriptions, is_container='container', yang_name="dynamic-subscriptions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['telemetry-system', 'subscriptions']

  def _get_persistent_subscriptions(self):
    """
    Getter method for persistent_subscriptions, mapped from YANG variable /telemetry_system/subscriptions/persistent_subscriptions (container)

    YANG Description: This container holds information relating to persistent
telemetry subscriptions. A persistent telemetry
subscription is configued locally on the device through
configuration, and is persistent across device restarts or
other redundancy changes.
    """
    return self.__persistent_subscriptions
      
  def _set_persistent_subscriptions(self, v, load=False):
    """
    Setter method for persistent_subscriptions, mapped from YANG variable /telemetry_system/subscriptions/persistent_subscriptions (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_persistent_subscriptions is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_persistent_subscriptions() directly.

    YANG Description: This container holds information relating to persistent
telemetry subscriptions. A persistent telemetry
subscription is configued locally on the device through
configuration, and is persistent across device restarts or
other redundancy changes.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_persistent_subscriptions_openconfig_telemetry__telemetry_system_subscriptions_persistent_subscriptions, is_container='container', yang_name="persistent-subscriptions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """persistent_subscriptions must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_persistent_subscriptions_openconfig_telemetry__telemetry_system_subscriptions_persistent_subscriptions, is_container='container', yang_name="persistent-subscriptions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)""",
        })

    self.__persistent_subscriptions = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_persistent_subscriptions(self):
    self.__persistent_subscriptions = YANGDynClass(base=yc_persistent_subscriptions_openconfig_telemetry__telemetry_system_subscriptions_persistent_subscriptions, is_container='container', yang_name="persistent-subscriptions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)


  def _get_dynamic_subscriptions(self):
    """
    Getter method for dynamic_subscriptions, mapped from YANG variable /telemetry_system/subscriptions/dynamic_subscriptions (container)

    YANG Description: This container holds information relating to dynamic
telemetry subscriptions. A dynamic subscription is
typically configured through an RPC channel, and does not
persist across device restarts, or if the RPC channel is
reset or otherwise torn down.
    """
    return self.__dynamic_subscriptions
      
  def _set_dynamic_subscriptions(self, v, load=False):
    """
    Setter method for dynamic_subscriptions, mapped from YANG variable /telemetry_system/subscriptions/dynamic_subscriptions (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dynamic_subscriptions is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dynamic_subscriptions() directly.

    YANG Description: This container holds information relating to dynamic
telemetry subscriptions. A dynamic subscription is
typically configured through an RPC channel, and does not
persist across device restarts, or if the RPC channel is
reset or otherwise torn down.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_dynamic_subscriptions_openconfig_telemetry__telemetry_system_subscriptions_dynamic_subscriptions, is_container='container', yang_name="dynamic-subscriptions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dynamic_subscriptions must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_dynamic_subscriptions_openconfig_telemetry__telemetry_system_subscriptions_dynamic_subscriptions, is_container='container', yang_name="dynamic-subscriptions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)""",
        })

    self.__dynamic_subscriptions = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dynamic_subscriptions(self):
    self.__dynamic_subscriptions = YANGDynClass(base=yc_dynamic_subscriptions_openconfig_telemetry__telemetry_system_subscriptions_dynamic_subscriptions, is_container='container', yang_name="dynamic-subscriptions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)

  persistent_subscriptions = __builtin__.property(_get_persistent_subscriptions, _set_persistent_subscriptions)
  dynamic_subscriptions = __builtin__.property(_get_dynamic_subscriptions, _set_dynamic_subscriptions)


  _pyangbind_elements = OrderedDict([('persistent_subscriptions', persistent_subscriptions), ('dynamic_subscriptions', dynamic_subscriptions), ])


class yc_telemetry_system_openconfig_telemetry__telemetry_system(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-telemetry - based on the path /telemetry-system. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Top level configuration and state for the
device's telemetry system.
  """
  __slots__ = ('_path_helper', '_extmethods', '__sensor_groups','__destination_groups','__subscriptions',)

  _yang_name = 'telemetry-system'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__sensor_groups = YANGDynClass(base=yc_sensor_groups_openconfig_telemetry__telemetry_system_sensor_groups, is_container='container', yang_name="sensor-groups", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)
    self.__destination_groups = YANGDynClass(base=yc_destination_groups_openconfig_telemetry__telemetry_system_destination_groups, is_container='container', yang_name="destination-groups", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)
    self.__subscriptions = YANGDynClass(base=yc_subscriptions_openconfig_telemetry__telemetry_system_subscriptions, is_container='container', yang_name="subscriptions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['telemetry-system']

  def _get_sensor_groups(self):
    """
    Getter method for sensor_groups, mapped from YANG variable /telemetry_system/sensor_groups (container)

    YANG Description: Top level container for sensor-groups.
    """
    return self.__sensor_groups
      
  def _set_sensor_groups(self, v, load=False):
    """
    Setter method for sensor_groups, mapped from YANG variable /telemetry_system/sensor_groups (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_sensor_groups is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_sensor_groups() directly.

    YANG Description: Top level container for sensor-groups.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_sensor_groups_openconfig_telemetry__telemetry_system_sensor_groups, is_container='container', yang_name="sensor-groups", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """sensor_groups must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_sensor_groups_openconfig_telemetry__telemetry_system_sensor_groups, is_container='container', yang_name="sensor-groups", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)""",
        })

    self.__sensor_groups = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_sensor_groups(self):
    self.__sensor_groups = YANGDynClass(base=yc_sensor_groups_openconfig_telemetry__telemetry_system_sensor_groups, is_container='container', yang_name="sensor-groups", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)


  def _get_destination_groups(self):
    """
    Getter method for destination_groups, mapped from YANG variable /telemetry_system/destination_groups (container)

    YANG Description: Top level container for destination group configuration
and state.
    """
    return self.__destination_groups
      
  def _set_destination_groups(self, v, load=False):
    """
    Setter method for destination_groups, mapped from YANG variable /telemetry_system/destination_groups (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_destination_groups is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_destination_groups() directly.

    YANG Description: Top level container for destination group configuration
and state.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_destination_groups_openconfig_telemetry__telemetry_system_destination_groups, is_container='container', yang_name="destination-groups", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """destination_groups must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_destination_groups_openconfig_telemetry__telemetry_system_destination_groups, is_container='container', yang_name="destination-groups", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)""",
        })

    self.__destination_groups = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_destination_groups(self):
    self.__destination_groups = YANGDynClass(base=yc_destination_groups_openconfig_telemetry__telemetry_system_destination_groups, is_container='container', yang_name="destination-groups", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)


  def _get_subscriptions(self):
    """
    Getter method for subscriptions, mapped from YANG variable /telemetry_system/subscriptions (container)

    YANG Description: This container holds information for both persistent
and dynamic telemetry subscriptions.
    """
    return self.__subscriptions
      
  def _set_subscriptions(self, v, load=False):
    """
    Setter method for subscriptions, mapped from YANG variable /telemetry_system/subscriptions (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_subscriptions is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_subscriptions() directly.

    YANG Description: This container holds information for both persistent
and dynamic telemetry subscriptions.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_subscriptions_openconfig_telemetry__telemetry_system_subscriptions, is_container='container', yang_name="subscriptions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """subscriptions must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_subscriptions_openconfig_telemetry__telemetry_system_subscriptions, is_container='container', yang_name="subscriptions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)""",
        })

    self.__subscriptions = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_subscriptions(self):
    self.__subscriptions = YANGDynClass(base=yc_subscriptions_openconfig_telemetry__telemetry_system_subscriptions, is_container='container', yang_name="subscriptions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)

  sensor_groups = __builtin__.property(_get_sensor_groups, _set_sensor_groups)
  destination_groups = __builtin__.property(_get_destination_groups, _set_destination_groups)
  subscriptions = __builtin__.property(_get_subscriptions, _set_subscriptions)


  _pyangbind_elements = OrderedDict([('sensor_groups', sensor_groups), ('destination_groups', destination_groups), ('subscriptions', subscriptions), ])


class openconfig_telemetry(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-telemetry - based on the path /openconfig-telemetry. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Data model which creates the configuration for the telemetry
systems and functions on the device.
  """
  __slots__ = ('_path_helper', '_extmethods', '__telemetry_system',)

  _yang_name = 'openconfig-telemetry'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__telemetry_system = YANGDynClass(base=yc_telemetry_system_openconfig_telemetry__telemetry_system, is_container='container', yang_name="telemetry-system", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return []

  def _get_telemetry_system(self):
    """
    Getter method for telemetry_system, mapped from YANG variable /telemetry_system (container)

    YANG Description: Top level configuration and state for the
device's telemetry system.
    """
    return self.__telemetry_system
      
  def _set_telemetry_system(self, v, load=False):
    """
    Setter method for telemetry_system, mapped from YANG variable /telemetry_system (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_telemetry_system is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_telemetry_system() directly.

    YANG Description: Top level configuration and state for the
device's telemetry system.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_telemetry_system_openconfig_telemetry__telemetry_system, is_container='container', yang_name="telemetry-system", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """telemetry_system must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_telemetry_system_openconfig_telemetry__telemetry_system, is_container='container', yang_name="telemetry-system", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)""",
        })

    self.__telemetry_system = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_telemetry_system(self):
    self.__telemetry_system = YANGDynClass(base=yc_telemetry_system_openconfig_telemetry__telemetry_system, is_container='container', yang_name="telemetry-system", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/telemetry', defining_module='openconfig-telemetry', yang_type='container', is_config=True)

  telemetry_system = __builtin__.property(_get_telemetry_system, _set_telemetry_system)


  _pyangbind_elements = OrderedDict([('telemetry_system', telemetry_system), ])


