//
// Copyright 2017 Google Inc. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

// This file defines the gNOI API to be used for certificate installation and
// rotation.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.14.0
// source: cert.proto

package pb

import (
	context "context"
	proto "github.com/golang/protobuf/proto"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Types of certificates.
type CertificateType int32

const (
	// 1 - 500 for public use.
	// 501 onwards for private use.
	CertificateType_CT_UNKNOWN CertificateType = 0
	CertificateType_CT_X509    CertificateType = 1
)

// Enum value maps for CertificateType.
var (
	CertificateType_name = map[int32]string{
		0: "CT_UNKNOWN",
		1: "CT_X509",
	}
	CertificateType_value = map[string]int32{
		"CT_UNKNOWN": 0,
		"CT_X509":    1,
	}
)

func (x CertificateType) Enum() *CertificateType {
	p := new(CertificateType)
	*p = x
	return p
}

func (x CertificateType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CertificateType) Descriptor() protoreflect.EnumDescriptor {
	return file_cert_proto_enumTypes[0].Descriptor()
}

func (CertificateType) Type() protoreflect.EnumType {
	return &file_cert_proto_enumTypes[0]
}

func (x CertificateType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CertificateType.Descriptor instead.
func (CertificateType) EnumDescriptor() ([]byte, []int) {
	return file_cert_proto_rawDescGZIP(), []int{0}
}

// Algorithm to be used for generation the key pair.
type KeyType int32

const (
	// 1 - 500, for known types.
	// 501 and onwards for private use.
	KeyType_KT_UNKNOWN KeyType = 0
	KeyType_KT_RSA     KeyType = 1
)

// Enum value maps for KeyType.
var (
	KeyType_name = map[int32]string{
		0: "KT_UNKNOWN",
		1: "KT_RSA",
	}
	KeyType_value = map[string]int32{
		"KT_UNKNOWN": 0,
		"KT_RSA":     1,
	}
)

func (x KeyType) Enum() *KeyType {
	p := new(KeyType)
	*p = x
	return p
}

func (x KeyType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (KeyType) Descriptor() protoreflect.EnumDescriptor {
	return file_cert_proto_enumTypes[1].Descriptor()
}

func (KeyType) Type() protoreflect.EnumType {
	return &file_cert_proto_enumTypes[1]
}

func (x KeyType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use KeyType.Descriptor instead.
func (KeyType) EnumDescriptor() ([]byte, []int) {
	return file_cert_proto_rawDescGZIP(), []int{1}
}

// Type of endpoint that can use a cert. This list is to be extended based on
// conversation with vendors.
type Endpoint_Type int32

const (
	Endpoint_EP_UNSPECIFIED  Endpoint_Type = 0
	Endpoint_EP_IPSEC_TUNNEL Endpoint_Type = 1
	Endpoint_EP_DAEMON       Endpoint_Type = 2
)

// Enum value maps for Endpoint_Type.
var (
	Endpoint_Type_name = map[int32]string{
		0: "EP_UNSPECIFIED",
		1: "EP_IPSEC_TUNNEL",
		2: "EP_DAEMON",
	}
	Endpoint_Type_value = map[string]int32{
		"EP_UNSPECIFIED":  0,
		"EP_IPSEC_TUNNEL": 1,
		"EP_DAEMON":       2,
	}
)

func (x Endpoint_Type) Enum() *Endpoint_Type {
	p := new(Endpoint_Type)
	*p = x
	return p
}

func (x Endpoint_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Endpoint_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_cert_proto_enumTypes[2].Descriptor()
}

func (Endpoint_Type) Type() protoreflect.EnumType {
	return &file_cert_proto_enumTypes[2]
}

func (x Endpoint_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Endpoint_Type.Descriptor instead.
func (Endpoint_Type) EnumDescriptor() ([]byte, []int) {
	return file_cert_proto_rawDescGZIP(), []int{21, 0}
}

// Request messages to rotate existing certificates on the target.
type RotateCertificateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Request Messages.
	//
	// Types that are assignable to RotateRequest:
	//	*RotateCertificateRequest_GenerateCsr
	//	*RotateCertificateRequest_LoadCertificate
	//	*RotateCertificateRequest_FinalizeRotation
	RotateRequest isRotateCertificateRequest_RotateRequest `protobuf_oneof:"rotate_request"`
}

func (x *RotateCertificateRequest) Reset() {
	*x = RotateCertificateRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cert_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RotateCertificateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RotateCertificateRequest) ProtoMessage() {}

func (x *RotateCertificateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_cert_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RotateCertificateRequest.ProtoReflect.Descriptor instead.
func (*RotateCertificateRequest) Descriptor() ([]byte, []int) {
	return file_cert_proto_rawDescGZIP(), []int{0}
}

func (m *RotateCertificateRequest) GetRotateRequest() isRotateCertificateRequest_RotateRequest {
	if m != nil {
		return m.RotateRequest
	}
	return nil
}

func (x *RotateCertificateRequest) GetGenerateCsr() *GenerateCSRRequest {
	if x, ok := x.GetRotateRequest().(*RotateCertificateRequest_GenerateCsr); ok {
		return x.GenerateCsr
	}
	return nil
}

func (x *RotateCertificateRequest) GetLoadCertificate() *LoadCertificateRequest {
	if x, ok := x.GetRotateRequest().(*RotateCertificateRequest_LoadCertificate); ok {
		return x.LoadCertificate
	}
	return nil
}

func (x *RotateCertificateRequest) GetFinalizeRotation() *FinalizeRequest {
	if x, ok := x.GetRotateRequest().(*RotateCertificateRequest_FinalizeRotation); ok {
		return x.FinalizeRotation
	}
	return nil
}

type isRotateCertificateRequest_RotateRequest interface {
	isRotateCertificateRequest_RotateRequest()
}

type RotateCertificateRequest_GenerateCsr struct {
	GenerateCsr *GenerateCSRRequest `protobuf:"bytes,1,opt,name=generate_csr,json=generateCsr,proto3,oneof"`
}

type RotateCertificateRequest_LoadCertificate struct {
	LoadCertificate *LoadCertificateRequest `protobuf:"bytes,2,opt,name=load_certificate,json=loadCertificate,proto3,oneof"`
}

type RotateCertificateRequest_FinalizeRotation struct {
	FinalizeRotation *FinalizeRequest `protobuf:"bytes,3,opt,name=finalize_rotation,json=finalizeRotation,proto3,oneof"`
}

func (*RotateCertificateRequest_GenerateCsr) isRotateCertificateRequest_RotateRequest() {}

func (*RotateCertificateRequest_LoadCertificate) isRotateCertificateRequest_RotateRequest() {}

func (*RotateCertificateRequest_FinalizeRotation) isRotateCertificateRequest_RotateRequest() {}

// Response Messages from the target.
type RotateCertificateResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Response messages.
	//
	// Types that are assignable to RotateResponse:
	//	*RotateCertificateResponse_GeneratedCsr
	//	*RotateCertificateResponse_LoadCertificate
	RotateResponse isRotateCertificateResponse_RotateResponse `protobuf_oneof:"rotate_response"`
}

func (x *RotateCertificateResponse) Reset() {
	*x = RotateCertificateResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cert_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RotateCertificateResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RotateCertificateResponse) ProtoMessage() {}

func (x *RotateCertificateResponse) ProtoReflect() protoreflect.Message {
	mi := &file_cert_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RotateCertificateResponse.ProtoReflect.Descriptor instead.
func (*RotateCertificateResponse) Descriptor() ([]byte, []int) {
	return file_cert_proto_rawDescGZIP(), []int{1}
}

func (m *RotateCertificateResponse) GetRotateResponse() isRotateCertificateResponse_RotateResponse {
	if m != nil {
		return m.RotateResponse
	}
	return nil
}

func (x *RotateCertificateResponse) GetGeneratedCsr() *GenerateCSRResponse {
	if x, ok := x.GetRotateResponse().(*RotateCertificateResponse_GeneratedCsr); ok {
		return x.GeneratedCsr
	}
	return nil
}

func (x *RotateCertificateResponse) GetLoadCertificate() *LoadCertificateResponse {
	if x, ok := x.GetRotateResponse().(*RotateCertificateResponse_LoadCertificate); ok {
		return x.LoadCertificate
	}
	return nil
}

type isRotateCertificateResponse_RotateResponse interface {
	isRotateCertificateResponse_RotateResponse()
}

type RotateCertificateResponse_GeneratedCsr struct {
	GeneratedCsr *GenerateCSRResponse `protobuf:"bytes,1,opt,name=generated_csr,json=generatedCsr,proto3,oneof"`
}

type RotateCertificateResponse_LoadCertificate struct {
	LoadCertificate *LoadCertificateResponse `protobuf:"bytes,2,opt,name=load_certificate,json=loadCertificate,proto3,oneof"`
}

func (*RotateCertificateResponse_GeneratedCsr) isRotateCertificateResponse_RotateResponse() {}

func (*RotateCertificateResponse_LoadCertificate) isRotateCertificateResponse_RotateResponse() {}

// Request messages to install new certificates on the target.
type InstallCertificateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Request Messages.
	//
	// Types that are assignable to InstallRequest:
	//	*InstallCertificateRequest_GenerateCsr
	//	*InstallCertificateRequest_LoadCertificate
	InstallRequest isInstallCertificateRequest_InstallRequest `protobuf_oneof:"install_request"`
}

func (x *InstallCertificateRequest) Reset() {
	*x = InstallCertificateRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cert_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InstallCertificateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InstallCertificateRequest) ProtoMessage() {}

func (x *InstallCertificateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_cert_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InstallCertificateRequest.ProtoReflect.Descriptor instead.
func (*InstallCertificateRequest) Descriptor() ([]byte, []int) {
	return file_cert_proto_rawDescGZIP(), []int{2}
}

func (m *InstallCertificateRequest) GetInstallRequest() isInstallCertificateRequest_InstallRequest {
	if m != nil {
		return m.InstallRequest
	}
	return nil
}

func (x *InstallCertificateRequest) GetGenerateCsr() *GenerateCSRRequest {
	if x, ok := x.GetInstallRequest().(*InstallCertificateRequest_GenerateCsr); ok {
		return x.GenerateCsr
	}
	return nil
}

func (x *InstallCertificateRequest) GetLoadCertificate() *LoadCertificateRequest {
	if x, ok := x.GetInstallRequest().(*InstallCertificateRequest_LoadCertificate); ok {
		return x.LoadCertificate
	}
	return nil
}

type isInstallCertificateRequest_InstallRequest interface {
	isInstallCertificateRequest_InstallRequest()
}

type InstallCertificateRequest_GenerateCsr struct {
	GenerateCsr *GenerateCSRRequest `protobuf:"bytes,1,opt,name=generate_csr,json=generateCsr,proto3,oneof"`
}

type InstallCertificateRequest_LoadCertificate struct {
	LoadCertificate *LoadCertificateRequest `protobuf:"bytes,2,opt,name=load_certificate,json=loadCertificate,proto3,oneof"`
}

func (*InstallCertificateRequest_GenerateCsr) isInstallCertificateRequest_InstallRequest() {}

func (*InstallCertificateRequest_LoadCertificate) isInstallCertificateRequest_InstallRequest() {}

// Response Messages from the target for the InstallCertificateRequest.
type InstallCertificateResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Response messages.
	//
	// Types that are assignable to InstallResponse:
	//	*InstallCertificateResponse_GeneratedCsr
	//	*InstallCertificateResponse_LoadCertificate
	InstallResponse isInstallCertificateResponse_InstallResponse `protobuf_oneof:"install_response"`
}

func (x *InstallCertificateResponse) Reset() {
	*x = InstallCertificateResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cert_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InstallCertificateResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InstallCertificateResponse) ProtoMessage() {}

func (x *InstallCertificateResponse) ProtoReflect() protoreflect.Message {
	mi := &file_cert_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InstallCertificateResponse.ProtoReflect.Descriptor instead.
func (*InstallCertificateResponse) Descriptor() ([]byte, []int) {
	return file_cert_proto_rawDescGZIP(), []int{3}
}

func (m *InstallCertificateResponse) GetInstallResponse() isInstallCertificateResponse_InstallResponse {
	if m != nil {
		return m.InstallResponse
	}
	return nil
}

func (x *InstallCertificateResponse) GetGeneratedCsr() *GenerateCSRResponse {
	if x, ok := x.GetInstallResponse().(*InstallCertificateResponse_GeneratedCsr); ok {
		return x.GeneratedCsr
	}
	return nil
}

func (x *InstallCertificateResponse) GetLoadCertificate() *LoadCertificateResponse {
	if x, ok := x.GetInstallResponse().(*InstallCertificateResponse_LoadCertificate); ok {
		return x.LoadCertificate
	}
	return nil
}

type isInstallCertificateResponse_InstallResponse interface {
	isInstallCertificateResponse_InstallResponse()
}

type InstallCertificateResponse_GeneratedCsr struct {
	GeneratedCsr *GenerateCSRResponse `protobuf:"bytes,1,opt,name=generated_csr,json=generatedCsr,proto3,oneof"`
}

type InstallCertificateResponse_LoadCertificate struct {
	LoadCertificate *LoadCertificateResponse `protobuf:"bytes,2,opt,name=load_certificate,json=loadCertificate,proto3,oneof"`
}

func (*InstallCertificateResponse_GeneratedCsr) isInstallCertificateResponse_InstallResponse() {}

func (*InstallCertificateResponse_LoadCertificate) isInstallCertificateResponse_InstallResponse() {}

// Request to generate the CSR.
// When this request is made for rotating an existing certificate as part of the
// Rotate() RPC, then the target must ensure that the "certificate_id" is
// already created and exists on the target. If the Certificate Rotation
// proceeds to load the certificate, it must associate the new certificate with
// the previously created "certificate_id".
//
// When this request is made for installing a completely new certificate as part
// of the Install() RPC , then the target must ensure that the "certificate_id"
// is completely new and no entities on the target are should be bound to this
// certificate_id. If any existing certificate matches the certificate_id, then
// this request should fail.
//
// If there is another ongoing Rotate/Install RPC with the same certificate_id,
// the GenerateCSRRequest should fail.
type GenerateCSRRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Parameters for creating a CSR.
	CsrParams *CSRParams `protobuf:"bytes,1,opt,name=csr_params,json=csrParams,proto3" json:"csr_params,omitempty"`
	// The certificate id with which this CSR will be associated. The target
	// configuration should bind an entity which wants to use a certificate to
	// the certificate_id it should use.
	CertificateId string `protobuf:"bytes,2,opt,name=certificate_id,json=certificateId,proto3" json:"certificate_id,omitempty"`
}

func (x *GenerateCSRRequest) Reset() {
	*x = GenerateCSRRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cert_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GenerateCSRRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateCSRRequest) ProtoMessage() {}

func (x *GenerateCSRRequest) ProtoReflect() protoreflect.Message {
	mi := &file_cert_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateCSRRequest.ProtoReflect.Descriptor instead.
func (*GenerateCSRRequest) Descriptor() ([]byte, []int) {
	return file_cert_proto_rawDescGZIP(), []int{4}
}

func (x *GenerateCSRRequest) GetCsrParams() *CSRParams {
	if x != nil {
		return x.CsrParams
	}
	return nil
}

func (x *GenerateCSRRequest) GetCertificateId() string {
	if x != nil {
		return x.CertificateId
	}
	return ""
}

// Parameters to be used when generating a Certificate Signing Request.
type CSRParams struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of certificate which will be associated for this CSR.
	Type CertificateType `protobuf:"varint,1,opt,name=type,proto3,enum=gnoi.certificate.CertificateType" json:"type,omitempty"`
	// Minimum size of the key to be used by the target when generating a
	// public/private key pair.
	MinKeySize uint32 `protobuf:"varint,2,opt,name=min_key_size,json=minKeySize,proto3" json:"min_key_size,omitempty"`
	// If provided, the target must use the provided key type. If the target
	// cannot use the algorithm specified in the key_type, it should cancel the
	// stream with an Unimplemented error.
	KeyType KeyType `protobuf:"varint,3,opt,name=key_type,json=keyType,proto3,enum=gnoi.certificate.KeyType" json:"key_type,omitempty"`
	// --- common set of parameters applicable for any type of certificate --- //
	CommonName         string `protobuf:"bytes,4,opt,name=common_name,json=commonName,proto3" json:"common_name,omitempty"`                         // e.g "device.corp.google.com"
	Country            string `protobuf:"bytes,5,opt,name=country,proto3" json:"country,omitempty"`                                                 // e.g "US"
	State              string `protobuf:"bytes,6,opt,name=state,proto3" json:"state,omitempty"`                                                     // e.g "CA"
	City               string `protobuf:"bytes,7,opt,name=city,proto3" json:"city,omitempty"`                                                       // e.g "Mountain View"
	Organization       string `protobuf:"bytes,8,opt,name=organization,proto3" json:"organization,omitempty"`                                       // e.g "Google"
	OrganizationalUnit string `protobuf:"bytes,9,opt,name=organizational_unit,json=organizationalUnit,proto3" json:"organizational_unit,omitempty"` // e.g "Security"
	IpAddress          string `protobuf:"bytes,10,opt,name=ip_address,json=ipAddress,proto3" json:"ip_address,omitempty"`
	EmailId            string `protobuf:"bytes,11,opt,name=email_id,json=emailId,proto3" json:"email_id,omitempty"`
}

func (x *CSRParams) Reset() {
	*x = CSRParams{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cert_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CSRParams) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CSRParams) ProtoMessage() {}

func (x *CSRParams) ProtoReflect() protoreflect.Message {
	mi := &file_cert_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CSRParams.ProtoReflect.Descriptor instead.
func (*CSRParams) Descriptor() ([]byte, []int) {
	return file_cert_proto_rawDescGZIP(), []int{5}
}

func (x *CSRParams) GetType() CertificateType {
	if x != nil {
		return x.Type
	}
	return CertificateType_CT_UNKNOWN
}

func (x *CSRParams) GetMinKeySize() uint32 {
	if x != nil {
		return x.MinKeySize
	}
	return 0
}

func (x *CSRParams) GetKeyType() KeyType {
	if x != nil {
		return x.KeyType
	}
	return KeyType_KT_UNKNOWN
}

func (x *CSRParams) GetCommonName() string {
	if x != nil {
		return x.CommonName
	}
	return ""
}

func (x *CSRParams) GetCountry() string {
	if x != nil {
		return x.Country
	}
	return ""
}

func (x *CSRParams) GetState() string {
	if x != nil {
		return x.State
	}
	return ""
}

func (x *CSRParams) GetCity() string {
	if x != nil {
		return x.City
	}
	return ""
}

func (x *CSRParams) GetOrganization() string {
	if x != nil {
		return x.Organization
	}
	return ""
}

func (x *CSRParams) GetOrganizationalUnit() string {
	if x != nil {
		return x.OrganizationalUnit
	}
	return ""
}

func (x *CSRParams) GetIpAddress() string {
	if x != nil {
		return x.IpAddress
	}
	return ""
}

func (x *CSRParams) GetEmailId() string {
	if x != nil {
		return x.EmailId
	}
	return ""
}

// GenerateCSRResponse contains the CSR associated with the Certificate ID
// supplied in the GenerateCSRRequest. When a Certificate is subsequently
// installed on the target in the same streaming RPC session, it must be
// associated to that Certificate ID.
//
// An Unimplemented error will be returned if the target cannot generate a CSR
// as per the request. In this case, the caller must generate its own key pair.
type GenerateCSRResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Csr *CSR `protobuf:"bytes,1,opt,name=csr,proto3" json:"csr,omitempty"`
}

func (x *GenerateCSRResponse) Reset() {
	*x = GenerateCSRResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cert_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GenerateCSRResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateCSRResponse) ProtoMessage() {}

func (x *GenerateCSRResponse) ProtoReflect() protoreflect.Message {
	mi := &file_cert_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateCSRResponse.ProtoReflect.Descriptor instead.
func (*GenerateCSRResponse) Descriptor() ([]byte, []int) {
	return file_cert_proto_rawDescGZIP(), []int{6}
}

func (x *GenerateCSRResponse) GetCsr() *CSR {
	if x != nil {
		return x.Csr
	}
	return nil
}

// LoadCertificateRequest instructs the target to store the given certificate.
//
// Case 1: Target Generated CSR and Key Pair.
// If the target generated the CSR (and the public/private key pair) during the
// GenerateCSR request, then the target must associate the certificate with the
// certificate ID specified in the preceding GenerateCSR request.
//
// Case 2: Externally Generated Key Pair.
// If the target can not generate a CSR, then the public/private key pair is
// generated externally. In this case provide the target with the key pair,
// and the certificate_id to be associated with the new certificate.
//
// If there is another ongoing Rotate/Install RPC with the same certificate_id,
// the LoadCertificateRequest must fail.
type LoadCertificateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The certificate to be Loaded on the target.
	Certificate *Certificate `protobuf:"bytes,1,opt,name=certificate,proto3" json:"certificate,omitempty"`
	// The key pair to be used with the certificate. This is provided in the event
	// that the target cannot generate a CSR (and the corresponding public/private
	// keys).
	KeyPair *KeyPair `protobuf:"bytes,2,opt,name=key_pair,json=keyPair,proto3" json:"key_pair,omitempty"`
	// Certificate Id of the above certificate. This is to be provided only when
	// there is an externally generated key pair.
	CertificateId string `protobuf:"bytes,3,opt,name=certificate_id,json=certificateId,proto3" json:"certificate_id,omitempty"`
	// Optional bundle of CA certificates. When not empty, the provided
	// certificates should squash the existing bundle. This field provides a
	// simplified means to provision a CA bundle that can be used to validate
	// other peer's certificates.
	CaCertificates []*Certificate `protobuf:"bytes,4,rep,name=ca_certificates,json=caCertificates,proto3" json:"ca_certificates,omitempty"`
}

func (x *LoadCertificateRequest) Reset() {
	*x = LoadCertificateRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cert_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LoadCertificateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoadCertificateRequest) ProtoMessage() {}

func (x *LoadCertificateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_cert_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoadCertificateRequest.ProtoReflect.Descriptor instead.
func (*LoadCertificateRequest) Descriptor() ([]byte, []int) {
	return file_cert_proto_rawDescGZIP(), []int{7}
}

func (x *LoadCertificateRequest) GetCertificate() *Certificate {
	if x != nil {
		return x.Certificate
	}
	return nil
}

func (x *LoadCertificateRequest) GetKeyPair() *KeyPair {
	if x != nil {
		return x.KeyPair
	}
	return nil
}

func (x *LoadCertificateRequest) GetCertificateId() string {
	if x != nil {
		return x.CertificateId
	}
	return ""
}

func (x *LoadCertificateRequest) GetCaCertificates() []*Certificate {
	if x != nil {
		return x.CaCertificates
	}
	return nil
}

// Response from target after Loading a Certificate.
// If the target could not load the certificate, it must end the RPC stream with
// a suitable RPC error about why the Certificate was not loaded.
type LoadCertificateResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *LoadCertificateResponse) Reset() {
	*x = LoadCertificateResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cert_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LoadCertificateResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoadCertificateResponse) ProtoMessage() {}

func (x *LoadCertificateResponse) ProtoReflect() protoreflect.Message {
	mi := &file_cert_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoadCertificateResponse.ProtoReflect.Descriptor instead.
func (*LoadCertificateResponse) Descriptor() ([]byte, []int) {
	return file_cert_proto_rawDescGZIP(), []int{8}
}

// A Finalize message is sent to the target to confirm the Rotation of
// the certificate and that the certificate should not be rolled back when
// the RPC concludes. The certificate must be rolled back if the target returns
// an error after receiving a Finalize message.
type FinalizeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *FinalizeRequest) Reset() {
	*x = FinalizeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cert_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FinalizeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FinalizeRequest) ProtoMessage() {}

func (x *FinalizeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_cert_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FinalizeRequest.ProtoReflect.Descriptor instead.
func (*FinalizeRequest) Descriptor() ([]byte, []int) {
	return file_cert_proto_rawDescGZIP(), []int{9}
}

// The request to query all the certificates on the target.
type GetCertificatesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *GetCertificatesRequest) Reset() {
	*x = GetCertificatesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cert_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetCertificatesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetCertificatesRequest) ProtoMessage() {}

func (x *GetCertificatesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_cert_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetCertificatesRequest.ProtoReflect.Descriptor instead.
func (*GetCertificatesRequest) Descriptor() ([]byte, []int) {
	return file_cert_proto_rawDescGZIP(), []int{10}
}

// Response from the target about the certificates that exist on the target what
// what is using them.
type GetCertificatesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	CertificateInfo []*CertificateInfo `protobuf:"bytes,1,rep,name=certificate_info,json=certificateInfo,proto3" json:"certificate_info,omitempty"`
}

func (x *GetCertificatesResponse) Reset() {
	*x = GetCertificatesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cert_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetCertificatesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetCertificatesResponse) ProtoMessage() {}

func (x *GetCertificatesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_cert_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetCertificatesResponse.ProtoReflect.Descriptor instead.
func (*GetCertificatesResponse) Descriptor() ([]byte, []int) {
	return file_cert_proto_rawDescGZIP(), []int{11}
}

func (x *GetCertificatesResponse) GetCertificateInfo() []*CertificateInfo {
	if x != nil {
		return x.CertificateInfo
	}
	return nil
}

type CertificateInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	CertificateId string       `protobuf:"bytes,1,opt,name=certificate_id,json=certificateId,proto3" json:"certificate_id,omitempty"`
	Certificate   *Certificate `protobuf:"bytes,2,opt,name=certificate,proto3" json:"certificate,omitempty"`
	// List of endpoints using this certificate.
	Endpoints []*Endpoint `protobuf:"bytes,3,rep,name=endpoints,proto3" json:"endpoints,omitempty"`
	// System modification time when the certificate was installed/rotated in
	// nanoseconds since epoch.
	ModificationTime int64 `protobuf:"varint,4,opt,name=modification_time,json=modificationTime,proto3" json:"modification_time,omitempty"`
}

func (x *CertificateInfo) Reset() {
	*x = CertificateInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cert_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CertificateInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CertificateInfo) ProtoMessage() {}

func (x *CertificateInfo) ProtoReflect() protoreflect.Message {
	mi := &file_cert_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CertificateInfo.ProtoReflect.Descriptor instead.
func (*CertificateInfo) Descriptor() ([]byte, []int) {
	return file_cert_proto_rawDescGZIP(), []int{12}
}

func (x *CertificateInfo) GetCertificateId() string {
	if x != nil {
		return x.CertificateId
	}
	return ""
}

func (x *CertificateInfo) GetCertificate() *Certificate {
	if x != nil {
		return x.Certificate
	}
	return nil
}

func (x *CertificateInfo) GetEndpoints() []*Endpoint {
	if x != nil {
		return x.Endpoints
	}
	return nil
}

func (x *CertificateInfo) GetModificationTime() int64 {
	if x != nil {
		return x.ModificationTime
	}
	return 0
}

type RevokeCertificatesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Certificates to revoke.
	CertificateId []string `protobuf:"bytes,1,rep,name=certificate_id,json=certificateId,proto3" json:"certificate_id,omitempty"`
}

func (x *RevokeCertificatesRequest) Reset() {
	*x = RevokeCertificatesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cert_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RevokeCertificatesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RevokeCertificatesRequest) ProtoMessage() {}

func (x *RevokeCertificatesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_cert_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RevokeCertificatesRequest.ProtoReflect.Descriptor instead.
func (*RevokeCertificatesRequest) Descriptor() ([]byte, []int) {
	return file_cert_proto_rawDescGZIP(), []int{13}
}

func (x *RevokeCertificatesRequest) GetCertificateId() []string {
	if x != nil {
		return x.CertificateId
	}
	return nil
}

type RevokeCertificatesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of certificates successfully revoked.
	RevokedCertificateId []string `protobuf:"bytes,1,rep,name=revoked_certificate_id,json=revokedCertificateId,proto3" json:"revoked_certificate_id,omitempty"`
	// List of errors why certain certificates could not be revoked.
	CertificateRevocationError []*CertificateRevocationError `protobuf:"bytes,2,rep,name=certificate_revocation_error,json=certificateRevocationError,proto3" json:"certificate_revocation_error,omitempty"`
}

func (x *RevokeCertificatesResponse) Reset() {
	*x = RevokeCertificatesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cert_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RevokeCertificatesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RevokeCertificatesResponse) ProtoMessage() {}

func (x *RevokeCertificatesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_cert_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RevokeCertificatesResponse.ProtoReflect.Descriptor instead.
func (*RevokeCertificatesResponse) Descriptor() ([]byte, []int) {
	return file_cert_proto_rawDescGZIP(), []int{14}
}

func (x *RevokeCertificatesResponse) GetRevokedCertificateId() []string {
	if x != nil {
		return x.RevokedCertificateId
	}
	return nil
}

func (x *RevokeCertificatesResponse) GetCertificateRevocationError() []*CertificateRevocationError {
	if x != nil {
		return x.CertificateRevocationError
	}
	return nil
}

// An error message indicating why a certificate id could not be revoked.
type CertificateRevocationError struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	CertificateId string `protobuf:"bytes,1,opt,name=certificate_id,json=certificateId,proto3" json:"certificate_id,omitempty"`
	ErrorMessage  string `protobuf:"bytes,2,opt,name=error_message,json=errorMessage,proto3" json:"error_message,omitempty"`
}

func (x *CertificateRevocationError) Reset() {
	*x = CertificateRevocationError{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cert_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CertificateRevocationError) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CertificateRevocationError) ProtoMessage() {}

func (x *CertificateRevocationError) ProtoReflect() protoreflect.Message {
	mi := &file_cert_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CertificateRevocationError.ProtoReflect.Descriptor instead.
func (*CertificateRevocationError) Descriptor() ([]byte, []int) {
	return file_cert_proto_rawDescGZIP(), []int{15}
}

func (x *CertificateRevocationError) GetCertificateId() string {
	if x != nil {
		return x.CertificateId
	}
	return ""
}

func (x *CertificateRevocationError) GetErrorMessage() string {
	if x != nil {
		return x.ErrorMessage
	}
	return ""
}

// A request to ask the target if it can generate key pairs.
type CanGenerateCSRRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	KeyType         KeyType         `protobuf:"varint,1,opt,name=key_type,json=keyType,proto3,enum=gnoi.certificate.KeyType" json:"key_type,omitempty"`
	CertificateType CertificateType `protobuf:"varint,2,opt,name=certificate_type,json=certificateType,proto3,enum=gnoi.certificate.CertificateType" json:"certificate_type,omitempty"`
	KeySize         uint32          `protobuf:"varint,3,opt,name=key_size,json=keySize,proto3" json:"key_size,omitempty"`
}

func (x *CanGenerateCSRRequest) Reset() {
	*x = CanGenerateCSRRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cert_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CanGenerateCSRRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CanGenerateCSRRequest) ProtoMessage() {}

func (x *CanGenerateCSRRequest) ProtoReflect() protoreflect.Message {
	mi := &file_cert_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CanGenerateCSRRequest.ProtoReflect.Descriptor instead.
func (*CanGenerateCSRRequest) Descriptor() ([]byte, []int) {
	return file_cert_proto_rawDescGZIP(), []int{16}
}

func (x *CanGenerateCSRRequest) GetKeyType() KeyType {
	if x != nil {
		return x.KeyType
	}
	return KeyType_KT_UNKNOWN
}

func (x *CanGenerateCSRRequest) GetCertificateType() CertificateType {
	if x != nil {
		return x.CertificateType
	}
	return CertificateType_CT_UNKNOWN
}

func (x *CanGenerateCSRRequest) GetKeySize() uint32 {
	if x != nil {
		return x.KeySize
	}
	return 0
}

// Response from the target about whether it can generate a CSR with the given
// parameters.
type CanGenerateCSRResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	CanGenerate bool `protobuf:"varint,4,opt,name=can_generate,json=canGenerate,proto3" json:"can_generate,omitempty"`
}

func (x *CanGenerateCSRResponse) Reset() {
	*x = CanGenerateCSRResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cert_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CanGenerateCSRResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CanGenerateCSRResponse) ProtoMessage() {}

func (x *CanGenerateCSRResponse) ProtoReflect() protoreflect.Message {
	mi := &file_cert_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CanGenerateCSRResponse.ProtoReflect.Descriptor instead.
func (*CanGenerateCSRResponse) Descriptor() ([]byte, []int) {
	return file_cert_proto_rawDescGZIP(), []int{17}
}

func (x *CanGenerateCSRResponse) GetCanGenerate() bool {
	if x != nil {
		return x.CanGenerate
	}
	return false
}

// A certificate.
type Certificate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Type of certificate.
	Type CertificateType `protobuf:"varint,1,opt,name=type,proto3,enum=gnoi.certificate.CertificateType" json:"type,omitempty"`
	// Actual certificate.
	// The exact encoding depends upon the type of certificate.
	// for X509, this should be a PEM encoded Certificate.
	Certificate []byte `protobuf:"bytes,2,opt,name=certificate,proto3" json:"certificate,omitempty"`
}

func (x *Certificate) Reset() {
	*x = Certificate{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cert_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Certificate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Certificate) ProtoMessage() {}

func (x *Certificate) ProtoReflect() protoreflect.Message {
	mi := &file_cert_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Certificate.ProtoReflect.Descriptor instead.
func (*Certificate) Descriptor() ([]byte, []int) {
	return file_cert_proto_rawDescGZIP(), []int{18}
}

func (x *Certificate) GetType() CertificateType {
	if x != nil {
		return x.Type
	}
	return CertificateType_CT_UNKNOWN
}

func (x *Certificate) GetCertificate() []byte {
	if x != nil {
		return x.Certificate
	}
	return nil
}

// A Certificate Signing Request.
type CSR struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Type of certificate.
	Type CertificateType `protobuf:"varint,1,opt,name=type,proto3,enum=gnoi.certificate.CertificateType" json:"type,omitempty"`
	// Bytes representing the CSR.
	// The exact encoding depends upon the type of certificate requested.
	// for X509: This should be the PEM encoded CSR.
	Csr []byte `protobuf:"bytes,2,opt,name=csr,proto3" json:"csr,omitempty"`
}

func (x *CSR) Reset() {
	*x = CSR{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cert_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CSR) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CSR) ProtoMessage() {}

func (x *CSR) ProtoReflect() protoreflect.Message {
	mi := &file_cert_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CSR.ProtoReflect.Descriptor instead.
func (*CSR) Descriptor() ([]byte, []int) {
	return file_cert_proto_rawDescGZIP(), []int{19}
}

func (x *CSR) GetType() CertificateType {
	if x != nil {
		return x.Type
	}
	return CertificateType_CT_UNKNOWN
}

func (x *CSR) GetCsr() []byte {
	if x != nil {
		return x.Csr
	}
	return nil
}

// A message representing a pair of public/private keys.
type KeyPair struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	PrivateKey []byte `protobuf:"bytes,1,opt,name=private_key,json=privateKey,proto3" json:"private_key,omitempty"`
	PublicKey  []byte `protobuf:"bytes,2,opt,name=public_key,json=publicKey,proto3" json:"public_key,omitempty"`
}

func (x *KeyPair) Reset() {
	*x = KeyPair{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cert_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KeyPair) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KeyPair) ProtoMessage() {}

func (x *KeyPair) ProtoReflect() protoreflect.Message {
	mi := &file_cert_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KeyPair.ProtoReflect.Descriptor instead.
func (*KeyPair) Descriptor() ([]byte, []int) {
	return file_cert_proto_rawDescGZIP(), []int{20}
}

func (x *KeyPair) GetPrivateKey() []byte {
	if x != nil {
		return x.PrivateKey
	}
	return nil
}

func (x *KeyPair) GetPublicKey() []byte {
	if x != nil {
		return x.PublicKey
	}
	return nil
}

// An endpoint represents an entity on the target which can use a certificate.
type Endpoint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Type Endpoint_Type `protobuf:"varint,1,opt,name=type,proto3,enum=gnoi.certificate.Endpoint_Type" json:"type,omitempty"`
	// Human readable identifier for an endpoint.
	Endpoint string `protobuf:"bytes,2,opt,name=endpoint,proto3" json:"endpoint,omitempty"`
}

func (x *Endpoint) Reset() {
	*x = Endpoint{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cert_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Endpoint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Endpoint) ProtoMessage() {}

func (x *Endpoint) ProtoReflect() protoreflect.Message {
	mi := &file_cert_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Endpoint.ProtoReflect.Descriptor instead.
func (*Endpoint) Descriptor() ([]byte, []int) {
	return file_cert_proto_rawDescGZIP(), []int{21}
}

func (x *Endpoint) GetType() Endpoint_Type {
	if x != nil {
		return x.Type
	}
	return Endpoint_EP_UNSPECIFIED
}

func (x *Endpoint) GetEndpoint() string {
	if x != nil {
		return x.Endpoint
	}
	return ""
}

var File_cert_proto protoreflect.FileDescriptor

var file_cert_proto_rawDesc = []byte{
	0x0a, 0x0a, 0x63, 0x65, 0x72, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x10, 0x67, 0x6e,
	0x6f, 0x69, 0x2e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x22, 0xa0,
	0x02, 0x0a, 0x18, 0x52, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x0c, 0x67,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x73, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6e, 0x6f, 0x69, 0x2e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x43, 0x53, 0x52,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x00, 0x52, 0x0b, 0x67, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x65, 0x43, 0x73, 0x72, 0x12, 0x55, 0x0a, 0x10, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x63,
	0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x28, 0x2e, 0x67, 0x6e, 0x6f, 0x69, 0x2e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x2e, 0x4c, 0x6f, 0x61, 0x64, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x00, 0x52, 0x0f, 0x6c, 0x6f,
	0x61, 0x64, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x12, 0x50, 0x0a,
	0x11, 0x66, 0x69, 0x6e, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x5f, 0x72, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6e, 0x6f, 0x69, 0x2e,
	0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x2e, 0x46, 0x69, 0x6e, 0x61,
	0x6c, 0x69, 0x7a, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x00, 0x52, 0x10, 0x66,
	0x69, 0x6e, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x52, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42,
	0x10, 0x0a, 0x0e, 0x72, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x22, 0xd4, 0x01, 0x0a, 0x19, 0x52, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x43, 0x65, 0x72, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x4c, 0x0a, 0x0d, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x73, 0x72,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6e, 0x6f, 0x69, 0x2e, 0x63, 0x65,
	0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x65, 0x43, 0x53, 0x52, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x00, 0x52,
	0x0c, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x64, 0x43, 0x73, 0x72, 0x12, 0x56, 0x0a,
	0x10, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6e, 0x6f, 0x69, 0x2e, 0x63,
	0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x2e, 0x4c, 0x6f, 0x61, 0x64, 0x43,
	0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x48, 0x00, 0x52, 0x0f, 0x6c, 0x6f, 0x61, 0x64, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x42, 0x11, 0x0a, 0x0f, 0x72, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x5f,
	0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xd0, 0x01, 0x0a, 0x19, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6c, 0x6c, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x0c, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x65, 0x5f, 0x63, 0x73, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67,
	0x6e, 0x6f, 0x69, 0x2e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x2e,
	0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x43, 0x53, 0x52, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x48, 0x00, 0x52, 0x0b, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x43, 0x73,
	0x72, 0x12, 0x55, 0x0a, 0x10, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6e,
	0x6f, 0x69, 0x2e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x2e, 0x4c,
	0x6f, 0x61, 0x64, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x00, 0x52, 0x0f, 0x6c, 0x6f, 0x61, 0x64, 0x43, 0x65, 0x72,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x42, 0x11, 0x0a, 0x0f, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6c, 0x6c, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x22, 0xd6, 0x01, 0x0a, 0x1a,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4c, 0x0a, 0x0d, 0x67, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x73, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6e, 0x6f, 0x69, 0x2e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x43, 0x53, 0x52,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x00, 0x52, 0x0c, 0x67, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x65, 0x64, 0x43, 0x73, 0x72, 0x12, 0x56, 0x0a, 0x10, 0x6c, 0x6f, 0x61, 0x64,
	0x5f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6e, 0x6f, 0x69, 0x2e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x2e, 0x4c, 0x6f, 0x61, 0x64, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x00, 0x52,
	0x0f, 0x6c, 0x6f, 0x61, 0x64, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65,
	0x42, 0x12, 0x0a, 0x10, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x5f, 0x72, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x77, 0x0a, 0x12, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65,
	0x43, 0x53, 0x52, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3a, 0x0a, 0x0a, 0x63, 0x73,
	0x72, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b,
	0x2e, 0x67, 0x6e, 0x6f, 0x69, 0x2e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x2e, 0x43, 0x53, 0x52, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x52, 0x09, 0x63, 0x73, 0x72,
	0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x49, 0x64, 0x22, 0x8e, 0x03,
	0x0a, 0x09, 0x43, 0x53, 0x52, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x35, 0x0a, 0x04, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x21, 0x2e, 0x67, 0x6e, 0x6f, 0x69,
	0x2e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x2e, 0x43, 0x65, 0x72,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79,
	0x70, 0x65, 0x12, 0x20, 0x0a, 0x0c, 0x6d, 0x69, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x73, 0x69,
	0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0a, 0x6d, 0x69, 0x6e, 0x4b, 0x65, 0x79,
	0x53, 0x69, 0x7a, 0x65, 0x12, 0x34, 0x0a, 0x08, 0x6b, 0x65, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x19, 0x2e, 0x67, 0x6e, 0x6f, 0x69, 0x2e, 0x63, 0x65,
	0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x2e, 0x4b, 0x65, 0x79, 0x54, 0x79, 0x70,
	0x65, 0x52, 0x07, 0x6b, 0x65, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x63, 0x6f,
	0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0a, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x72, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x63,
	0x69, 0x74, 0x79, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x63, 0x69, 0x74, 0x79, 0x12,
	0x22, 0x0a, 0x0c, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x2f, 0x0a, 0x13, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x5f, 0x75, 0x6e, 0x69, 0x74, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x12, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c,
	0x55, 0x6e, 0x69, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x69, 0x70, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65,
	0x73, 0x73, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x69, 0x70, 0x41, 0x64, 0x64, 0x72,
	0x65, 0x73, 0x73, 0x12, 0x19, 0x0a, 0x08, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x5f, 0x69, 0x64, 0x18,
	0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x49, 0x64, 0x22, 0x3e,
	0x0a, 0x13, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x43, 0x53, 0x52, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x27, 0x0a, 0x03, 0x63, 0x73, 0x72, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x15, 0x2e, 0x67, 0x6e, 0x6f, 0x69, 0x2e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x2e, 0x43, 0x53, 0x52, 0x52, 0x03, 0x63, 0x73, 0x72, 0x22, 0xfe,
	0x01, 0x0a, 0x16, 0x4c, 0x6f, 0x61, 0x64, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x0b, 0x63, 0x65, 0x72,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d,
	0x2e, 0x67, 0x6e, 0x6f, 0x69, 0x2e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x52, 0x0b, 0x63,
	0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x12, 0x34, 0x0a, 0x08, 0x6b, 0x65,
	0x79, 0x5f, 0x70, 0x61, 0x69, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67,
	0x6e, 0x6f, 0x69, 0x2e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x2e,
	0x4b, 0x65, 0x79, 0x50, 0x61, 0x69, 0x72, 0x52, 0x07, 0x6b, 0x65, 0x79, 0x50, 0x61, 0x69, 0x72,
	0x12, 0x25, 0x0a, 0x0e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x5f,
	0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x49, 0x64, 0x12, 0x46, 0x0a, 0x0f, 0x63, 0x61, 0x5f, 0x63, 0x65,
	0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x1d, 0x2e, 0x67, 0x6e, 0x6f, 0x69, 0x2e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x52,
	0x0e, 0x63, 0x61, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x73, 0x22,
	0x19, 0x0a, 0x17, 0x4c, 0x6f, 0x61, 0x64, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x11, 0x0a, 0x0f, 0x46, 0x69,
	0x6e, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x22, 0x18, 0x0a,
	0x16, 0x47, 0x65, 0x74, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x22, 0x67, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x43, 0x65,
	0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x4c, 0x0a, 0x10, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67,
	0x6e, 0x6f, 0x69, 0x2e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x2e,
	0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52,
	0x0f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x66, 0x6f,
	0x22, 0xe0, 0x01, 0x0a, 0x0f, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65,
	0x49, 0x6e, 0x66, 0x6f, 0x12, 0x25, 0x0a, 0x0e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x63, 0x65,
	0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x49, 0x64, 0x12, 0x3f, 0x0a, 0x0b, 0x63,
	0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1d, 0x2e, 0x67, 0x6e, 0x6f, 0x69, 0x2e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x52,
	0x0b, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x12, 0x38, 0x0a, 0x09,
	0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6e, 0x6f, 0x69, 0x2e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x65, 0x2e, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x09, 0x65, 0x6e, 0x64,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x12, 0x2b, 0x0a, 0x11, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x10, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54,
	0x69, 0x6d, 0x65, 0x22, 0x42, 0x0a, 0x19, 0x52, 0x65, 0x76, 0x6f, 0x6b, 0x65, 0x43, 0x65, 0x72,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x25, 0x0a, 0x0e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x5f,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x49, 0x64, 0x22, 0xc2, 0x01, 0x0a, 0x1a, 0x52, 0x65, 0x76, 0x6f,
	0x6b, 0x65, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x34, 0x0a, 0x16, 0x72, 0x65, 0x76, 0x6f, 0x6b, 0x65,
	0x64, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x14, 0x72, 0x65, 0x76, 0x6f, 0x6b, 0x65, 0x64, 0x43,
	0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x49, 0x64, 0x12, 0x6e, 0x0a, 0x1c,
	0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x72, 0x65, 0x76, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6e, 0x6f, 0x69, 0x2e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x52, 0x65, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x72, 0x72, 0x6f, 0x72,
	0x52, 0x1a, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x52, 0x65, 0x76,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x22, 0x68, 0x0a, 0x1a,
	0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x52, 0x65, 0x76, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x25, 0x0a, 0x0e, 0x63, 0x65,
	0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x49,
	0x64, 0x12, 0x23, 0x0a, 0x0d, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x4d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22, 0xb6, 0x01, 0x0a, 0x15, 0x43, 0x61, 0x6e, 0x47, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x43, 0x53, 0x52, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x34, 0x0a, 0x08, 0x6b, 0x65, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x19, 0x2e, 0x67, 0x6e, 0x6f, 0x69, 0x2e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x2e, 0x4b, 0x65, 0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x07, 0x6b,
	0x65, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x4c, 0x0a, 0x10, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x21, 0x2e, 0x67, 0x6e, 0x6f, 0x69, 0x2e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x54,
	0x79, 0x70, 0x65, 0x52, 0x0f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x19, 0x0a, 0x08, 0x6b, 0x65, 0x79, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x07, 0x6b, 0x65, 0x79, 0x53, 0x69, 0x7a, 0x65, 0x22,
	0x3b, 0x0a, 0x16, 0x43, 0x61, 0x6e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x43, 0x53,
	0x52, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x63, 0x61, 0x6e,
	0x5f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x0b, 0x63, 0x61, 0x6e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x22, 0x66, 0x0a, 0x0b,
	0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x12, 0x35, 0x0a, 0x04, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x21, 0x2e, 0x67, 0x6e, 0x6f, 0x69,
	0x2e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x2e, 0x43, 0x65, 0x72,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79,
	0x70, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0b, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x22, 0x4e, 0x0a, 0x03, 0x43, 0x53, 0x52, 0x12, 0x35, 0x0a, 0x04, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x21, 0x2e, 0x67, 0x6e, 0x6f, 0x69,
	0x2e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x2e, 0x43, 0x65, 0x72,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79,
	0x70, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x63, 0x73, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52,
	0x03, 0x63, 0x73, 0x72, 0x22, 0x49, 0x0a, 0x07, 0x4b, 0x65, 0x79, 0x50, 0x61, 0x69, 0x72, 0x12,
	0x1f, 0x0a, 0x0b, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0c, 0x52, 0x0a, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x4b, 0x65, 0x79,
	0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0c, 0x52, 0x09, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x22,
	0x9b, 0x01, 0x0a, 0x08, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x33, 0x0a, 0x04,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1f, 0x2e, 0x67, 0x6e, 0x6f,
	0x69, 0x2e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x2e, 0x45, 0x6e,
	0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x12, 0x1a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x08, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x22, 0x3e, 0x0a,
	0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x12, 0x0a, 0x0e, 0x45, 0x50, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x13, 0x0a, 0x0f, 0x45, 0x50, 0x5f,
	0x49, 0x50, 0x53, 0x45, 0x43, 0x5f, 0x54, 0x55, 0x4e, 0x4e, 0x45, 0x4c, 0x10, 0x01, 0x12, 0x0d,
	0x0a, 0x09, 0x45, 0x50, 0x5f, 0x44, 0x41, 0x45, 0x4d, 0x4f, 0x4e, 0x10, 0x02, 0x2a, 0x2e, 0x0a,
	0x0f, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x0e, 0x0a, 0x0a, 0x43, 0x54, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00,
	0x12, 0x0b, 0x0a, 0x07, 0x43, 0x54, 0x5f, 0x58, 0x35, 0x30, 0x39, 0x10, 0x01, 0x2a, 0x25, 0x0a,
	0x07, 0x4b, 0x65, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x0e, 0x0a, 0x0a, 0x4b, 0x54, 0x5f, 0x55,
	0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x4b, 0x54, 0x5f, 0x52,
	0x53, 0x41, 0x10, 0x01, 0x32, 0xa6, 0x04, 0x0a, 0x15, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x65,
	0x0a, 0x06, 0x52, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x12, 0x2a, 0x2e, 0x67, 0x6e, 0x6f, 0x69, 0x2e,
	0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x2e, 0x52, 0x6f, 0x74, 0x61,
	0x74, 0x65, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x2b, 0x2e, 0x67, 0x6e, 0x6f, 0x69, 0x2e, 0x63, 0x65, 0x72, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x2e, 0x52, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x43, 0x65,
	0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x28, 0x01, 0x30, 0x01, 0x12, 0x68, 0x0a, 0x07, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c,
	0x12, 0x2b, 0x2e, 0x67, 0x6e, 0x6f, 0x69, 0x2e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x43, 0x65, 0x72, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e,
	0x67, 0x6e, 0x6f, 0x69, 0x2e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65,
	0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x28, 0x01, 0x30, 0x01, 0x12,
	0x66, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x73, 0x12, 0x28, 0x2e, 0x67, 0x6e, 0x6f, 0x69, 0x2e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e, 0x67,
	0x6e, 0x6f, 0x69, 0x2e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x2e,
	0x47, 0x65, 0x74, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x6f, 0x0a, 0x12, 0x52, 0x65, 0x76, 0x6f, 0x6b,
	0x65, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x73, 0x12, 0x2b, 0x2e,
	0x67, 0x6e, 0x6f, 0x69, 0x2e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65,
	0x2e, 0x52, 0x65, 0x76, 0x6f, 0x6b, 0x65, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e, 0x67, 0x6e, 0x6f,
	0x69, 0x2e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x2e, 0x52, 0x65,
	0x76, 0x6f, 0x6b, 0x65, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x63, 0x0a, 0x0e, 0x43, 0x61, 0x6e, 0x47,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x43, 0x53, 0x52, 0x12, 0x27, 0x2e, 0x67, 0x6e, 0x6f,
	0x69, 0x2e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x2e, 0x43, 0x61,
	0x6e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x43, 0x53, 0x52, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6e, 0x6f, 0x69, 0x2e, 0x63, 0x65, 0x72, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x2e, 0x43, 0x61, 0x6e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x65, 0x43, 0x53, 0x52, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x42, 0x25, 0x5a,
	0x23, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x67, 0x6e, 0x78, 0x69, 0x2f, 0x67, 0x6e, 0x6f, 0x69, 0x2f, 0x63, 0x65, 0x72,
	0x74, 0x2f, 0x70, 0x62, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_cert_proto_rawDescOnce sync.Once
	file_cert_proto_rawDescData = file_cert_proto_rawDesc
)

func file_cert_proto_rawDescGZIP() []byte {
	file_cert_proto_rawDescOnce.Do(func() {
		file_cert_proto_rawDescData = protoimpl.X.CompressGZIP(file_cert_proto_rawDescData)
	})
	return file_cert_proto_rawDescData
}

var file_cert_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_cert_proto_msgTypes = make([]protoimpl.MessageInfo, 22)
var file_cert_proto_goTypes = []interface{}{
	(CertificateType)(0),               // 0: gnoi.certificate.CertificateType
	(KeyType)(0),                       // 1: gnoi.certificate.KeyType
	(Endpoint_Type)(0),                 // 2: gnoi.certificate.Endpoint.Type
	(*RotateCertificateRequest)(nil),   // 3: gnoi.certificate.RotateCertificateRequest
	(*RotateCertificateResponse)(nil),  // 4: gnoi.certificate.RotateCertificateResponse
	(*InstallCertificateRequest)(nil),  // 5: gnoi.certificate.InstallCertificateRequest
	(*InstallCertificateResponse)(nil), // 6: gnoi.certificate.InstallCertificateResponse
	(*GenerateCSRRequest)(nil),         // 7: gnoi.certificate.GenerateCSRRequest
	(*CSRParams)(nil),                  // 8: gnoi.certificate.CSRParams
	(*GenerateCSRResponse)(nil),        // 9: gnoi.certificate.GenerateCSRResponse
	(*LoadCertificateRequest)(nil),     // 10: gnoi.certificate.LoadCertificateRequest
	(*LoadCertificateResponse)(nil),    // 11: gnoi.certificate.LoadCertificateResponse
	(*FinalizeRequest)(nil),            // 12: gnoi.certificate.FinalizeRequest
	(*GetCertificatesRequest)(nil),     // 13: gnoi.certificate.GetCertificatesRequest
	(*GetCertificatesResponse)(nil),    // 14: gnoi.certificate.GetCertificatesResponse
	(*CertificateInfo)(nil),            // 15: gnoi.certificate.CertificateInfo
	(*RevokeCertificatesRequest)(nil),  // 16: gnoi.certificate.RevokeCertificatesRequest
	(*RevokeCertificatesResponse)(nil), // 17: gnoi.certificate.RevokeCertificatesResponse
	(*CertificateRevocationError)(nil), // 18: gnoi.certificate.CertificateRevocationError
	(*CanGenerateCSRRequest)(nil),      // 19: gnoi.certificate.CanGenerateCSRRequest
	(*CanGenerateCSRResponse)(nil),     // 20: gnoi.certificate.CanGenerateCSRResponse
	(*Certificate)(nil),                // 21: gnoi.certificate.Certificate
	(*CSR)(nil),                        // 22: gnoi.certificate.CSR
	(*KeyPair)(nil),                    // 23: gnoi.certificate.KeyPair
	(*Endpoint)(nil),                   // 24: gnoi.certificate.Endpoint
}
var file_cert_proto_depIdxs = []int32{
	7,  // 0: gnoi.certificate.RotateCertificateRequest.generate_csr:type_name -> gnoi.certificate.GenerateCSRRequest
	10, // 1: gnoi.certificate.RotateCertificateRequest.load_certificate:type_name -> gnoi.certificate.LoadCertificateRequest
	12, // 2: gnoi.certificate.RotateCertificateRequest.finalize_rotation:type_name -> gnoi.certificate.FinalizeRequest
	9,  // 3: gnoi.certificate.RotateCertificateResponse.generated_csr:type_name -> gnoi.certificate.GenerateCSRResponse
	11, // 4: gnoi.certificate.RotateCertificateResponse.load_certificate:type_name -> gnoi.certificate.LoadCertificateResponse
	7,  // 5: gnoi.certificate.InstallCertificateRequest.generate_csr:type_name -> gnoi.certificate.GenerateCSRRequest
	10, // 6: gnoi.certificate.InstallCertificateRequest.load_certificate:type_name -> gnoi.certificate.LoadCertificateRequest
	9,  // 7: gnoi.certificate.InstallCertificateResponse.generated_csr:type_name -> gnoi.certificate.GenerateCSRResponse
	11, // 8: gnoi.certificate.InstallCertificateResponse.load_certificate:type_name -> gnoi.certificate.LoadCertificateResponse
	8,  // 9: gnoi.certificate.GenerateCSRRequest.csr_params:type_name -> gnoi.certificate.CSRParams
	0,  // 10: gnoi.certificate.CSRParams.type:type_name -> gnoi.certificate.CertificateType
	1,  // 11: gnoi.certificate.CSRParams.key_type:type_name -> gnoi.certificate.KeyType
	22, // 12: gnoi.certificate.GenerateCSRResponse.csr:type_name -> gnoi.certificate.CSR
	21, // 13: gnoi.certificate.LoadCertificateRequest.certificate:type_name -> gnoi.certificate.Certificate
	23, // 14: gnoi.certificate.LoadCertificateRequest.key_pair:type_name -> gnoi.certificate.KeyPair
	21, // 15: gnoi.certificate.LoadCertificateRequest.ca_certificates:type_name -> gnoi.certificate.Certificate
	15, // 16: gnoi.certificate.GetCertificatesResponse.certificate_info:type_name -> gnoi.certificate.CertificateInfo
	21, // 17: gnoi.certificate.CertificateInfo.certificate:type_name -> gnoi.certificate.Certificate
	24, // 18: gnoi.certificate.CertificateInfo.endpoints:type_name -> gnoi.certificate.Endpoint
	18, // 19: gnoi.certificate.RevokeCertificatesResponse.certificate_revocation_error:type_name -> gnoi.certificate.CertificateRevocationError
	1,  // 20: gnoi.certificate.CanGenerateCSRRequest.key_type:type_name -> gnoi.certificate.KeyType
	0,  // 21: gnoi.certificate.CanGenerateCSRRequest.certificate_type:type_name -> gnoi.certificate.CertificateType
	0,  // 22: gnoi.certificate.Certificate.type:type_name -> gnoi.certificate.CertificateType
	0,  // 23: gnoi.certificate.CSR.type:type_name -> gnoi.certificate.CertificateType
	2,  // 24: gnoi.certificate.Endpoint.type:type_name -> gnoi.certificate.Endpoint.Type
	3,  // 25: gnoi.certificate.CertificateManagement.Rotate:input_type -> gnoi.certificate.RotateCertificateRequest
	5,  // 26: gnoi.certificate.CertificateManagement.Install:input_type -> gnoi.certificate.InstallCertificateRequest
	13, // 27: gnoi.certificate.CertificateManagement.GetCertificates:input_type -> gnoi.certificate.GetCertificatesRequest
	16, // 28: gnoi.certificate.CertificateManagement.RevokeCertificates:input_type -> gnoi.certificate.RevokeCertificatesRequest
	19, // 29: gnoi.certificate.CertificateManagement.CanGenerateCSR:input_type -> gnoi.certificate.CanGenerateCSRRequest
	4,  // 30: gnoi.certificate.CertificateManagement.Rotate:output_type -> gnoi.certificate.RotateCertificateResponse
	6,  // 31: gnoi.certificate.CertificateManagement.Install:output_type -> gnoi.certificate.InstallCertificateResponse
	14, // 32: gnoi.certificate.CertificateManagement.GetCertificates:output_type -> gnoi.certificate.GetCertificatesResponse
	17, // 33: gnoi.certificate.CertificateManagement.RevokeCertificates:output_type -> gnoi.certificate.RevokeCertificatesResponse
	20, // 34: gnoi.certificate.CertificateManagement.CanGenerateCSR:output_type -> gnoi.certificate.CanGenerateCSRResponse
	30, // [30:35] is the sub-list for method output_type
	25, // [25:30] is the sub-list for method input_type
	25, // [25:25] is the sub-list for extension type_name
	25, // [25:25] is the sub-list for extension extendee
	0,  // [0:25] is the sub-list for field type_name
}

func init() { file_cert_proto_init() }
func file_cert_proto_init() {
	if File_cert_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_cert_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RotateCertificateRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cert_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RotateCertificateResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cert_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InstallCertificateRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cert_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InstallCertificateResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cert_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GenerateCSRRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cert_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CSRParams); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cert_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GenerateCSRResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cert_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LoadCertificateRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cert_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LoadCertificateResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cert_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FinalizeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cert_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetCertificatesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cert_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetCertificatesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cert_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CertificateInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cert_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RevokeCertificatesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cert_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RevokeCertificatesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cert_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CertificateRevocationError); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cert_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CanGenerateCSRRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cert_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CanGenerateCSRResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cert_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Certificate); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cert_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CSR); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cert_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KeyPair); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cert_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Endpoint); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_cert_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*RotateCertificateRequest_GenerateCsr)(nil),
		(*RotateCertificateRequest_LoadCertificate)(nil),
		(*RotateCertificateRequest_FinalizeRotation)(nil),
	}
	file_cert_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*RotateCertificateResponse_GeneratedCsr)(nil),
		(*RotateCertificateResponse_LoadCertificate)(nil),
	}
	file_cert_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*InstallCertificateRequest_GenerateCsr)(nil),
		(*InstallCertificateRequest_LoadCertificate)(nil),
	}
	file_cert_proto_msgTypes[3].OneofWrappers = []interface{}{
		(*InstallCertificateResponse_GeneratedCsr)(nil),
		(*InstallCertificateResponse_LoadCertificate)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_cert_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   22,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_cert_proto_goTypes,
		DependencyIndexes: file_cert_proto_depIdxs,
		EnumInfos:         file_cert_proto_enumTypes,
		MessageInfos:      file_cert_proto_msgTypes,
	}.Build()
	File_cert_proto = out.File
	file_cert_proto_rawDesc = nil
	file_cert_proto_goTypes = nil
	file_cert_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// CertificateManagementClient is the client API for CertificateManagement service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type CertificateManagementClient interface {
	// Rotate will replace an existing Certificate on the target by creating a
	// new CSR request and placing the new Certificate based on the CSR on the
	// target. If the stream is broken or any steps in the process fail the
	// target must rollback to the original Certificate.
	//
	// The following describes the sequence of messages that must be exchanged
	// in the Rotate() RPC.
	//
	// Sequence of expected messages:
	// Case 1: When Target generates the CSR.
	//
	//   Step 1: Start the stream
	//     Client <---- Rotate() RPC stream begin ------> Target
	//
	//   Step 2: CSR
	//     Client -----> GenerateCSRRequest----> Target
	//     Client <----- GenerateCSRResponse <--- Target
	//
	//   Step 3: Certificate Signing
	//     Client gets the certificate signed by the CA.
	//
	//   Step 4: Send Certificate to Target.
	//     Client --> LoadCertificateRequest ----> Target
	//     Client <-- LoadCertificateResponse <--- Target
	//
	//   Step 5: Test/Validation by the client.
	//     This step should be to create a new connection to the target using
	//     The new certificate and validate that the certificate works.
	//     Once verfied, the client will then proceed to finalize the rotation.
	//     If the new connection cannot be completed the client will cancel the
	//     RPC thereby forcing the target to rollback the certificate.
	//
	//   Step 6: Final commit.
	//     Client ---> FinalizeRequest ----> Target
	//
	//
	// Case 2: When Client generates the CSR.
	//   Step 1: Start the stream
	//     Client <---- Rotate() RPC stream begin ----> Target
	//
	//   Step 2: CSR
	//     Client generates its own certificate.
	//
	//   Step 3: Certificate Signing
	//     Client gets the certificate signed by the CA.
	//
	//   Step 4: Send Certificate to Target.
	//     Client ---> LoadCertificateRequest ----> Target
	//     Client <--- LoadCertificateResponse <--- Target
	//
	//   Step 5: Test/Validation by the client.
	//
	//   Step 6: Final commit.
	//     Client ---> FinalizeRequest ----> Target
	Rotate(ctx context.Context, opts ...grpc.CallOption) (CertificateManagement_RotateClient, error)
	// Install will put a new Certificate on the target by creating a new CSR
	// request and placing the new Certificate based on the CSR on the target.The
	// new Certificate will be associated with a new Certificate Id on the target.
	// If the target has a pre existing Certificate with the given Certificate Id,
	// the operation should fail.
	// If the stream is broken or any steps in the process fail the target must
	// revert any changes in state.
	//
	// The following describes the sequence of messages that must be exchanged
	// in the Install() RPC.
	//
	// Sequence of expected messages:
	// Case 1: When Target generates the CSR-------------------------:
	//
	//   Step 1: Start the stream
	//     Client <---- Install() RPC stream begin ------> Target
	//
	//   Step 2: CSR
	//     Client -----> GenerateCSRRequest() ----> Target
	//     Client <---- GenerateCSRResponse() <---- Target
	//
	//   Step 3: Certificate Signing
	//     Client gets the certificate signed by the CA.
	//
	//   Step 4: Send Certificate to Target.
	//     Client -> LoadCertificateRequest() ----> Target
	//     Client <- LoadCertificateResponse() <--- Target
	//
	// Case 2: When Client generates the CSR-------------------------:
	//   Step 1: Start the stream
	//     Client <---- Install() RPC stream begin ------> Target
	//
	//   Step 2: CSR
	//     Client generates its own certificate.
	//
	//   Step 3: Certificate Signing
	//     Client gets the certificate signed by the CA.
	//
	//   Step 4: Send Certificate to Target.
	//     Client -> LoadCertificateRequest() ----> Target
	//     Client <- LoadCertificateResponse() <--- Target
	//
	Install(ctx context.Context, opts ...grpc.CallOption) (CertificateManagement_InstallClient, error)
	// An RPC to get the certificates on the target.
	GetCertificates(ctx context.Context, in *GetCertificatesRequest, opts ...grpc.CallOption) (*GetCertificatesResponse, error)
	// An RPC to revoke specific certificates.
	// If a certificate is not present on the target, the request should silently
	// succeed. Revoking a certificate should render the existing certificate
	// unusable by any endpoints.
	RevokeCertificates(ctx context.Context, in *RevokeCertificatesRequest, opts ...grpc.CallOption) (*RevokeCertificatesResponse, error)
	// An RPC to ask a target if it can generate a Certificate.
	CanGenerateCSR(ctx context.Context, in *CanGenerateCSRRequest, opts ...grpc.CallOption) (*CanGenerateCSRResponse, error)
}

type certificateManagementClient struct {
	cc grpc.ClientConnInterface
}

func NewCertificateManagementClient(cc grpc.ClientConnInterface) CertificateManagementClient {
	return &certificateManagementClient{cc}
}

func (c *certificateManagementClient) Rotate(ctx context.Context, opts ...grpc.CallOption) (CertificateManagement_RotateClient, error) {
	stream, err := c.cc.NewStream(ctx, &_CertificateManagement_serviceDesc.Streams[0], "/gnoi.certificate.CertificateManagement/Rotate", opts...)
	if err != nil {
		return nil, err
	}
	x := &certificateManagementRotateClient{stream}
	return x, nil
}

type CertificateManagement_RotateClient interface {
	Send(*RotateCertificateRequest) error
	Recv() (*RotateCertificateResponse, error)
	grpc.ClientStream
}

type certificateManagementRotateClient struct {
	grpc.ClientStream
}

func (x *certificateManagementRotateClient) Send(m *RotateCertificateRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *certificateManagementRotateClient) Recv() (*RotateCertificateResponse, error) {
	m := new(RotateCertificateResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *certificateManagementClient) Install(ctx context.Context, opts ...grpc.CallOption) (CertificateManagement_InstallClient, error) {
	stream, err := c.cc.NewStream(ctx, &_CertificateManagement_serviceDesc.Streams[1], "/gnoi.certificate.CertificateManagement/Install", opts...)
	if err != nil {
		return nil, err
	}
	x := &certificateManagementInstallClient{stream}
	return x, nil
}

type CertificateManagement_InstallClient interface {
	Send(*InstallCertificateRequest) error
	Recv() (*InstallCertificateResponse, error)
	grpc.ClientStream
}

type certificateManagementInstallClient struct {
	grpc.ClientStream
}

func (x *certificateManagementInstallClient) Send(m *InstallCertificateRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *certificateManagementInstallClient) Recv() (*InstallCertificateResponse, error) {
	m := new(InstallCertificateResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *certificateManagementClient) GetCertificates(ctx context.Context, in *GetCertificatesRequest, opts ...grpc.CallOption) (*GetCertificatesResponse, error) {
	out := new(GetCertificatesResponse)
	err := c.cc.Invoke(ctx, "/gnoi.certificate.CertificateManagement/GetCertificates", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *certificateManagementClient) RevokeCertificates(ctx context.Context, in *RevokeCertificatesRequest, opts ...grpc.CallOption) (*RevokeCertificatesResponse, error) {
	out := new(RevokeCertificatesResponse)
	err := c.cc.Invoke(ctx, "/gnoi.certificate.CertificateManagement/RevokeCertificates", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *certificateManagementClient) CanGenerateCSR(ctx context.Context, in *CanGenerateCSRRequest, opts ...grpc.CallOption) (*CanGenerateCSRResponse, error) {
	out := new(CanGenerateCSRResponse)
	err := c.cc.Invoke(ctx, "/gnoi.certificate.CertificateManagement/CanGenerateCSR", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CertificateManagementServer is the server API for CertificateManagement service.
type CertificateManagementServer interface {
	// Rotate will replace an existing Certificate on the target by creating a
	// new CSR request and placing the new Certificate based on the CSR on the
	// target. If the stream is broken or any steps in the process fail the
	// target must rollback to the original Certificate.
	//
	// The following describes the sequence of messages that must be exchanged
	// in the Rotate() RPC.
	//
	// Sequence of expected messages:
	// Case 1: When Target generates the CSR.
	//
	//   Step 1: Start the stream
	//     Client <---- Rotate() RPC stream begin ------> Target
	//
	//   Step 2: CSR
	//     Client -----> GenerateCSRRequest----> Target
	//     Client <----- GenerateCSRResponse <--- Target
	//
	//   Step 3: Certificate Signing
	//     Client gets the certificate signed by the CA.
	//
	//   Step 4: Send Certificate to Target.
	//     Client --> LoadCertificateRequest ----> Target
	//     Client <-- LoadCertificateResponse <--- Target
	//
	//   Step 5: Test/Validation by the client.
	//     This step should be to create a new connection to the target using
	//     The new certificate and validate that the certificate works.
	//     Once verfied, the client will then proceed to finalize the rotation.
	//     If the new connection cannot be completed the client will cancel the
	//     RPC thereby forcing the target to rollback the certificate.
	//
	//   Step 6: Final commit.
	//     Client ---> FinalizeRequest ----> Target
	//
	//
	// Case 2: When Client generates the CSR.
	//   Step 1: Start the stream
	//     Client <---- Rotate() RPC stream begin ----> Target
	//
	//   Step 2: CSR
	//     Client generates its own certificate.
	//
	//   Step 3: Certificate Signing
	//     Client gets the certificate signed by the CA.
	//
	//   Step 4: Send Certificate to Target.
	//     Client ---> LoadCertificateRequest ----> Target
	//     Client <--- LoadCertificateResponse <--- Target
	//
	//   Step 5: Test/Validation by the client.
	//
	//   Step 6: Final commit.
	//     Client ---> FinalizeRequest ----> Target
	Rotate(CertificateManagement_RotateServer) error
	// Install will put a new Certificate on the target by creating a new CSR
	// request and placing the new Certificate based on the CSR on the target.The
	// new Certificate will be associated with a new Certificate Id on the target.
	// If the target has a pre existing Certificate with the given Certificate Id,
	// the operation should fail.
	// If the stream is broken or any steps in the process fail the target must
	// revert any changes in state.
	//
	// The following describes the sequence of messages that must be exchanged
	// in the Install() RPC.
	//
	// Sequence of expected messages:
	// Case 1: When Target generates the CSR-------------------------:
	//
	//   Step 1: Start the stream
	//     Client <---- Install() RPC stream begin ------> Target
	//
	//   Step 2: CSR
	//     Client -----> GenerateCSRRequest() ----> Target
	//     Client <---- GenerateCSRResponse() <---- Target
	//
	//   Step 3: Certificate Signing
	//     Client gets the certificate signed by the CA.
	//
	//   Step 4: Send Certificate to Target.
	//     Client -> LoadCertificateRequest() ----> Target
	//     Client <- LoadCertificateResponse() <--- Target
	//
	// Case 2: When Client generates the CSR-------------------------:
	//   Step 1: Start the stream
	//     Client <---- Install() RPC stream begin ------> Target
	//
	//   Step 2: CSR
	//     Client generates its own certificate.
	//
	//   Step 3: Certificate Signing
	//     Client gets the certificate signed by the CA.
	//
	//   Step 4: Send Certificate to Target.
	//     Client -> LoadCertificateRequest() ----> Target
	//     Client <- LoadCertificateResponse() <--- Target
	//
	Install(CertificateManagement_InstallServer) error
	// An RPC to get the certificates on the target.
	GetCertificates(context.Context, *GetCertificatesRequest) (*GetCertificatesResponse, error)
	// An RPC to revoke specific certificates.
	// If a certificate is not present on the target, the request should silently
	// succeed. Revoking a certificate should render the existing certificate
	// unusable by any endpoints.
	RevokeCertificates(context.Context, *RevokeCertificatesRequest) (*RevokeCertificatesResponse, error)
	// An RPC to ask a target if it can generate a Certificate.
	CanGenerateCSR(context.Context, *CanGenerateCSRRequest) (*CanGenerateCSRResponse, error)
}

// UnimplementedCertificateManagementServer can be embedded to have forward compatible implementations.
type UnimplementedCertificateManagementServer struct {
}

func (*UnimplementedCertificateManagementServer) Rotate(CertificateManagement_RotateServer) error {
	return status.Errorf(codes.Unimplemented, "method Rotate not implemented")
}
func (*UnimplementedCertificateManagementServer) Install(CertificateManagement_InstallServer) error {
	return status.Errorf(codes.Unimplemented, "method Install not implemented")
}
func (*UnimplementedCertificateManagementServer) GetCertificates(context.Context, *GetCertificatesRequest) (*GetCertificatesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCertificates not implemented")
}
func (*UnimplementedCertificateManagementServer) RevokeCertificates(context.Context, *RevokeCertificatesRequest) (*RevokeCertificatesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RevokeCertificates not implemented")
}
func (*UnimplementedCertificateManagementServer) CanGenerateCSR(context.Context, *CanGenerateCSRRequest) (*CanGenerateCSRResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CanGenerateCSR not implemented")
}

func RegisterCertificateManagementServer(s *grpc.Server, srv CertificateManagementServer) {
	s.RegisterService(&_CertificateManagement_serviceDesc, srv)
}

func _CertificateManagement_Rotate_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(CertificateManagementServer).Rotate(&certificateManagementRotateServer{stream})
}

type CertificateManagement_RotateServer interface {
	Send(*RotateCertificateResponse) error
	Recv() (*RotateCertificateRequest, error)
	grpc.ServerStream
}

type certificateManagementRotateServer struct {
	grpc.ServerStream
}

func (x *certificateManagementRotateServer) Send(m *RotateCertificateResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *certificateManagementRotateServer) Recv() (*RotateCertificateRequest, error) {
	m := new(RotateCertificateRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _CertificateManagement_Install_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(CertificateManagementServer).Install(&certificateManagementInstallServer{stream})
}

type CertificateManagement_InstallServer interface {
	Send(*InstallCertificateResponse) error
	Recv() (*InstallCertificateRequest, error)
	grpc.ServerStream
}

type certificateManagementInstallServer struct {
	grpc.ServerStream
}

func (x *certificateManagementInstallServer) Send(m *InstallCertificateResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *certificateManagementInstallServer) Recv() (*InstallCertificateRequest, error) {
	m := new(InstallCertificateRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _CertificateManagement_GetCertificates_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCertificatesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateManagementServer).GetCertificates(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gnoi.certificate.CertificateManagement/GetCertificates",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateManagementServer).GetCertificates(ctx, req.(*GetCertificatesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CertificateManagement_RevokeCertificates_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RevokeCertificatesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateManagementServer).RevokeCertificates(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gnoi.certificate.CertificateManagement/RevokeCertificates",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateManagementServer).RevokeCertificates(ctx, req.(*RevokeCertificatesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CertificateManagement_CanGenerateCSR_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CanGenerateCSRRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CertificateManagementServer).CanGenerateCSR(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gnoi.certificate.CertificateManagement/CanGenerateCSR",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CertificateManagementServer).CanGenerateCSR(ctx, req.(*CanGenerateCSRRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _CertificateManagement_serviceDesc = grpc.ServiceDesc{
	ServiceName: "gnoi.certificate.CertificateManagement",
	HandlerType: (*CertificateManagementServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetCertificates",
			Handler:    _CertificateManagement_GetCertificates_Handler,
		},
		{
			MethodName: "RevokeCertificates",
			Handler:    _CertificateManagement_RevokeCertificates_Handler,
		},
		{
			MethodName: "CanGenerateCSR",
			Handler:    _CertificateManagement_CanGenerateCSR_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Rotate",
			Handler:       _CertificateManagement_Rotate_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
		{
			StreamName:    "Install",
			Handler:       _CertificateManagement_Install_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "cert.proto",
}
