// Code generated by protoc-gen-gogo.
// source: carbonzipper.proto
// DO NOT EDIT!

/*
	Package carbonzipperpb is a generated protocol buffer package.

	It is generated from these files:
		carbonzipper.proto

	It has these top-level messages:
		FetchResponse
		MultiFetchResponse
		GlobMatch
		GlobResponse
		Retention
		InfoResponse
		ServerInfoResponse
		ZipperInfoResponse
		ListMetricsResponse
		MetricDetails
		MetricDetailsResponse
*/
package carbonzipperpb

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

type FetchResponse struct {
	Name      string    `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	StartTime int32     `protobuf:"varint,2,opt,name=startTime,proto3" json:"startTime,omitempty"`
	StopTime  int32     `protobuf:"varint,3,opt,name=stopTime,proto3" json:"stopTime,omitempty"`
	StepTime  int32     `protobuf:"varint,4,opt,name=stepTime,proto3" json:"stepTime,omitempty"`
	Values    []float64 `protobuf:"fixed64,5,rep,packed,name=values" json:"values,omitempty"`
	IsAbsent  []bool    `protobuf:"varint,6,rep,packed,name=isAbsent" json:"isAbsent,omitempty"`
}

func (m *FetchResponse) Reset()                    { *m = FetchResponse{} }
func (m *FetchResponse) String() string            { return proto.CompactTextString(m) }
func (*FetchResponse) ProtoMessage()               {}
func (*FetchResponse) Descriptor() ([]byte, []int) { return fileDescriptorCarbonzipper, []int{0} }

func (m *FetchResponse) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *FetchResponse) GetStartTime() int32 {
	if m != nil {
		return m.StartTime
	}
	return 0
}

func (m *FetchResponse) GetStopTime() int32 {
	if m != nil {
		return m.StopTime
	}
	return 0
}

func (m *FetchResponse) GetStepTime() int32 {
	if m != nil {
		return m.StepTime
	}
	return 0
}

func (m *FetchResponse) GetValues() []float64 {
	if m != nil {
		return m.Values
	}
	return nil
}

func (m *FetchResponse) GetIsAbsent() []bool {
	if m != nil {
		return m.IsAbsent
	}
	return nil
}

type MultiFetchResponse struct {
	Metrics []*FetchResponse `protobuf:"bytes,1,rep,name=metrics" json:"metrics,omitempty"`
}

func (m *MultiFetchResponse) Reset()                    { *m = MultiFetchResponse{} }
func (m *MultiFetchResponse) String() string            { return proto.CompactTextString(m) }
func (*MultiFetchResponse) ProtoMessage()               {}
func (*MultiFetchResponse) Descriptor() ([]byte, []int) { return fileDescriptorCarbonzipper, []int{1} }

func (m *MultiFetchResponse) GetMetrics() []*FetchResponse {
	if m != nil {
		return m.Metrics
	}
	return nil
}

type GlobMatch struct {
	Path   string `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	IsLeaf bool   `protobuf:"varint,2,opt,name=isLeaf,proto3" json:"isLeaf,omitempty"`
}

func (m *GlobMatch) Reset()                    { *m = GlobMatch{} }
func (m *GlobMatch) String() string            { return proto.CompactTextString(m) }
func (*GlobMatch) ProtoMessage()               {}
func (*GlobMatch) Descriptor() ([]byte, []int) { return fileDescriptorCarbonzipper, []int{2} }

func (m *GlobMatch) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

func (m *GlobMatch) GetIsLeaf() bool {
	if m != nil {
		return m.IsLeaf
	}
	return false
}

type GlobResponse struct {
	Name    string       `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Matches []*GlobMatch `protobuf:"bytes,2,rep,name=matches" json:"matches,omitempty"`
}

func (m *GlobResponse) Reset()                    { *m = GlobResponse{} }
func (m *GlobResponse) String() string            { return proto.CompactTextString(m) }
func (*GlobResponse) ProtoMessage()               {}
func (*GlobResponse) Descriptor() ([]byte, []int) { return fileDescriptorCarbonzipper, []int{3} }

func (m *GlobResponse) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *GlobResponse) GetMatches() []*GlobMatch {
	if m != nil {
		return m.Matches
	}
	return nil
}

type Retention struct {
	SecondsPerPoint int32 `protobuf:"varint,1,opt,name=secondsPerPoint,proto3" json:"secondsPerPoint,omitempty"`
	NumberOfPoints  int32 `protobuf:"varint,2,opt,name=numberOfPoints,proto3" json:"numberOfPoints,omitempty"`
}

func (m *Retention) Reset()                    { *m = Retention{} }
func (m *Retention) String() string            { return proto.CompactTextString(m) }
func (*Retention) ProtoMessage()               {}
func (*Retention) Descriptor() ([]byte, []int) { return fileDescriptorCarbonzipper, []int{4} }

func (m *Retention) GetSecondsPerPoint() int32 {
	if m != nil {
		return m.SecondsPerPoint
	}
	return 0
}

func (m *Retention) GetNumberOfPoints() int32 {
	if m != nil {
		return m.NumberOfPoints
	}
	return 0
}

type InfoResponse struct {
	Name              string       `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	AggregationMethod string       `protobuf:"bytes,2,opt,name=aggregationMethod,proto3" json:"aggregationMethod,omitempty"`
	MaxRetention      int32        `protobuf:"varint,3,opt,name=maxRetention,proto3" json:"maxRetention,omitempty"`
	XFilesFactor      float32      `protobuf:"fixed32,4,opt,name=xFilesFactor,proto3" json:"xFilesFactor,omitempty"`
	Retentions        []*Retention `protobuf:"bytes,5,rep,name=retentions" json:"retentions,omitempty"`
}

func (m *InfoResponse) Reset()                    { *m = InfoResponse{} }
func (m *InfoResponse) String() string            { return proto.CompactTextString(m) }
func (*InfoResponse) ProtoMessage()               {}
func (*InfoResponse) Descriptor() ([]byte, []int) { return fileDescriptorCarbonzipper, []int{5} }

func (m *InfoResponse) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *InfoResponse) GetAggregationMethod() string {
	if m != nil {
		return m.AggregationMethod
	}
	return ""
}

func (m *InfoResponse) GetMaxRetention() int32 {
	if m != nil {
		return m.MaxRetention
	}
	return 0
}

func (m *InfoResponse) GetXFilesFactor() float32 {
	if m != nil {
		return m.XFilesFactor
	}
	return 0
}

func (m *InfoResponse) GetRetentions() []*Retention {
	if m != nil {
		return m.Retentions
	}
	return nil
}

type ServerInfoResponse struct {
	Server string        `protobuf:"bytes,1,opt,name=server,proto3" json:"server,omitempty"`
	Info   *InfoResponse `protobuf:"bytes,2,opt,name=info" json:"info,omitempty"`
}

func (m *ServerInfoResponse) Reset()                    { *m = ServerInfoResponse{} }
func (m *ServerInfoResponse) String() string            { return proto.CompactTextString(m) }
func (*ServerInfoResponse) ProtoMessage()               {}
func (*ServerInfoResponse) Descriptor() ([]byte, []int) { return fileDescriptorCarbonzipper, []int{6} }

func (m *ServerInfoResponse) GetServer() string {
	if m != nil {
		return m.Server
	}
	return ""
}

func (m *ServerInfoResponse) GetInfo() *InfoResponse {
	if m != nil {
		return m.Info
	}
	return nil
}

type ZipperInfoResponse struct {
	Responses []*ServerInfoResponse `protobuf:"bytes,1,rep,name=responses" json:"responses,omitempty"`
}

func (m *ZipperInfoResponse) Reset()                    { *m = ZipperInfoResponse{} }
func (m *ZipperInfoResponse) String() string            { return proto.CompactTextString(m) }
func (*ZipperInfoResponse) ProtoMessage()               {}
func (*ZipperInfoResponse) Descriptor() ([]byte, []int) { return fileDescriptorCarbonzipper, []int{7} }

func (m *ZipperInfoResponse) GetResponses() []*ServerInfoResponse {
	if m != nil {
		return m.Responses
	}
	return nil
}

type ListMetricsResponse struct {
	Metrics []string `protobuf:"bytes,1,rep,name=Metrics" json:"Metrics,omitempty"`
}

func (m *ListMetricsResponse) Reset()                    { *m = ListMetricsResponse{} }
func (m *ListMetricsResponse) String() string            { return proto.CompactTextString(m) }
func (*ListMetricsResponse) ProtoMessage()               {}
func (*ListMetricsResponse) Descriptor() ([]byte, []int) { return fileDescriptorCarbonzipper, []int{8} }

func (m *ListMetricsResponse) GetMetrics() []string {
	if m != nil {
		return m.Metrics
	}
	return nil
}

type MetricDetails struct {
	Size_   int64 `protobuf:"varint,2,opt,name=Size,proto3" json:"Size,omitempty"`
	ModTime int64 `protobuf:"varint,3,opt,name=ModTime,proto3" json:"ModTime,omitempty"`
	ATime   int64 `protobuf:"varint,4,opt,name=ATime,proto3" json:"ATime,omitempty"`
	RdTime  int64 `protobuf:"varint,5,opt,name=RdTime,proto3" json:"RdTime,omitempty"`
}

func (m *MetricDetails) Reset()                    { *m = MetricDetails{} }
func (m *MetricDetails) String() string            { return proto.CompactTextString(m) }
func (*MetricDetails) ProtoMessage()               {}
func (*MetricDetails) Descriptor() ([]byte, []int) { return fileDescriptorCarbonzipper, []int{9} }

func (m *MetricDetails) GetSize_() int64 {
	if m != nil {
		return m.Size_
	}
	return 0
}

func (m *MetricDetails) GetModTime() int64 {
	if m != nil {
		return m.ModTime
	}
	return 0
}

func (m *MetricDetails) GetATime() int64 {
	if m != nil {
		return m.ATime
	}
	return 0
}

func (m *MetricDetails) GetRdTime() int64 {
	if m != nil {
		return m.RdTime
	}
	return 0
}

type MetricDetailsResponse struct {
	Metrics    map[string]*MetricDetails `protobuf:"bytes,1,rep,name=metrics" json:"metrics,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value"`
	FreeSpace  uint64                    `protobuf:"varint,2,opt,name=FreeSpace,proto3" json:"FreeSpace,omitempty"`
	TotalSpace uint64                    `protobuf:"varint,3,opt,name=TotalSpace,proto3" json:"TotalSpace,omitempty"`
}

func (m *MetricDetailsResponse) Reset()         { *m = MetricDetailsResponse{} }
func (m *MetricDetailsResponse) String() string { return proto.CompactTextString(m) }
func (*MetricDetailsResponse) ProtoMessage()    {}
func (*MetricDetailsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptorCarbonzipper, []int{10}
}

func (m *MetricDetailsResponse) GetMetrics() map[string]*MetricDetails {
	if m != nil {
		return m.Metrics
	}
	return nil
}

func (m *MetricDetailsResponse) GetFreeSpace() uint64 {
	if m != nil {
		return m.FreeSpace
	}
	return 0
}

func (m *MetricDetailsResponse) GetTotalSpace() uint64 {
	if m != nil {
		return m.TotalSpace
	}
	return 0
}

func init() {
	proto.RegisterType((*FetchResponse)(nil), "carbonzipperpb.FetchResponse")
	proto.RegisterType((*MultiFetchResponse)(nil), "carbonzipperpb.MultiFetchResponse")
	proto.RegisterType((*GlobMatch)(nil), "carbonzipperpb.GlobMatch")
	proto.RegisterType((*GlobResponse)(nil), "carbonzipperpb.GlobResponse")
	proto.RegisterType((*Retention)(nil), "carbonzipperpb.Retention")
	proto.RegisterType((*InfoResponse)(nil), "carbonzipperpb.InfoResponse")
	proto.RegisterType((*ServerInfoResponse)(nil), "carbonzipperpb.ServerInfoResponse")
	proto.RegisterType((*ZipperInfoResponse)(nil), "carbonzipperpb.ZipperInfoResponse")
	proto.RegisterType((*ListMetricsResponse)(nil), "carbonzipperpb.ListMetricsResponse")
	proto.RegisterType((*MetricDetails)(nil), "carbonzipperpb.MetricDetails")
	proto.RegisterType((*MetricDetailsResponse)(nil), "carbonzipperpb.MetricDetailsResponse")
}
func (m *FetchResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *FetchResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintCarbonzipper(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if m.StartTime != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintCarbonzipper(dAtA, i, uint64(m.StartTime))
	}
	if m.StopTime != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintCarbonzipper(dAtA, i, uint64(m.StopTime))
	}
	if m.StepTime != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintCarbonzipper(dAtA, i, uint64(m.StepTime))
	}
	if len(m.Values) > 0 {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintCarbonzipper(dAtA, i, uint64(len(m.Values)*8))
		for _, num := range m.Values {
			f1 := math.Float64bits(float64(num))
			dAtA[i] = uint8(f1)
			i++
			dAtA[i] = uint8(f1 >> 8)
			i++
			dAtA[i] = uint8(f1 >> 16)
			i++
			dAtA[i] = uint8(f1 >> 24)
			i++
			dAtA[i] = uint8(f1 >> 32)
			i++
			dAtA[i] = uint8(f1 >> 40)
			i++
			dAtA[i] = uint8(f1 >> 48)
			i++
			dAtA[i] = uint8(f1 >> 56)
			i++
		}
	}
	if len(m.IsAbsent) > 0 {
		dAtA[i] = 0x32
		i++
		i = encodeVarintCarbonzipper(dAtA, i, uint64(len(m.IsAbsent)))
		for _, b := range m.IsAbsent {
			if b {
				dAtA[i] = 1
			} else {
				dAtA[i] = 0
			}
			i++
		}
	}
	return i, nil
}

func (m *MultiFetchResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MultiFetchResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Metrics) > 0 {
		for _, msg := range m.Metrics {
			dAtA[i] = 0xa
			i++
			i = encodeVarintCarbonzipper(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *GlobMatch) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GlobMatch) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Path) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintCarbonzipper(dAtA, i, uint64(len(m.Path)))
		i += copy(dAtA[i:], m.Path)
	}
	if m.IsLeaf {
		dAtA[i] = 0x10
		i++
		if m.IsLeaf {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *GlobResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GlobResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintCarbonzipper(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if len(m.Matches) > 0 {
		for _, msg := range m.Matches {
			dAtA[i] = 0x12
			i++
			i = encodeVarintCarbonzipper(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *Retention) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Retention) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.SecondsPerPoint != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintCarbonzipper(dAtA, i, uint64(m.SecondsPerPoint))
	}
	if m.NumberOfPoints != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintCarbonzipper(dAtA, i, uint64(m.NumberOfPoints))
	}
	return i, nil
}

func (m *InfoResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *InfoResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintCarbonzipper(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if len(m.AggregationMethod) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintCarbonzipper(dAtA, i, uint64(len(m.AggregationMethod)))
		i += copy(dAtA[i:], m.AggregationMethod)
	}
	if m.MaxRetention != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintCarbonzipper(dAtA, i, uint64(m.MaxRetention))
	}
	if m.XFilesFactor != 0 {
		dAtA[i] = 0x25
		i++
		i = encodeFixed32Carbonzipper(dAtA, i, uint32(math.Float32bits(float32(m.XFilesFactor))))
	}
	if len(m.Retentions) > 0 {
		for _, msg := range m.Retentions {
			dAtA[i] = 0x2a
			i++
			i = encodeVarintCarbonzipper(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *ServerInfoResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ServerInfoResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Server) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintCarbonzipper(dAtA, i, uint64(len(m.Server)))
		i += copy(dAtA[i:], m.Server)
	}
	if m.Info != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintCarbonzipper(dAtA, i, uint64(m.Info.Size()))
		n2, err := m.Info.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	return i, nil
}

func (m *ZipperInfoResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ZipperInfoResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Responses) > 0 {
		for _, msg := range m.Responses {
			dAtA[i] = 0xa
			i++
			i = encodeVarintCarbonzipper(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *ListMetricsResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListMetricsResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Metrics) > 0 {
		for _, s := range m.Metrics {
			dAtA[i] = 0xa
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	return i, nil
}

func (m *MetricDetails) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MetricDetails) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Size_ != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintCarbonzipper(dAtA, i, uint64(m.Size_))
	}
	if m.ModTime != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintCarbonzipper(dAtA, i, uint64(m.ModTime))
	}
	if m.ATime != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintCarbonzipper(dAtA, i, uint64(m.ATime))
	}
	if m.RdTime != 0 {
		dAtA[i] = 0x28
		i++
		i = encodeVarintCarbonzipper(dAtA, i, uint64(m.RdTime))
	}
	return i, nil
}

func (m *MetricDetailsResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MetricDetailsResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Metrics) > 0 {
		for k, _ := range m.Metrics {
			dAtA[i] = 0xa
			i++
			v := m.Metrics[k]
			msgSize := 0
			if v != nil {
				msgSize = v.Size()
				msgSize += 1 + sovCarbonzipper(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovCarbonzipper(uint64(len(k))) + msgSize
			i = encodeVarintCarbonzipper(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintCarbonzipper(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			if v != nil {
				dAtA[i] = 0x12
				i++
				i = encodeVarintCarbonzipper(dAtA, i, uint64(v.Size()))
				n3, err := v.MarshalTo(dAtA[i:])
				if err != nil {
					return 0, err
				}
				i += n3
			}
		}
	}
	if m.FreeSpace != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintCarbonzipper(dAtA, i, uint64(m.FreeSpace))
	}
	if m.TotalSpace != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintCarbonzipper(dAtA, i, uint64(m.TotalSpace))
	}
	return i, nil
}

func encodeFixed64Carbonzipper(dAtA []byte, offset int, v uint64) int {
	dAtA[offset] = uint8(v)
	dAtA[offset+1] = uint8(v >> 8)
	dAtA[offset+2] = uint8(v >> 16)
	dAtA[offset+3] = uint8(v >> 24)
	dAtA[offset+4] = uint8(v >> 32)
	dAtA[offset+5] = uint8(v >> 40)
	dAtA[offset+6] = uint8(v >> 48)
	dAtA[offset+7] = uint8(v >> 56)
	return offset + 8
}
func encodeFixed32Carbonzipper(dAtA []byte, offset int, v uint32) int {
	dAtA[offset] = uint8(v)
	dAtA[offset+1] = uint8(v >> 8)
	dAtA[offset+2] = uint8(v >> 16)
	dAtA[offset+3] = uint8(v >> 24)
	return offset + 4
}
func encodeVarintCarbonzipper(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *FetchResponse) Size() (n int) {
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovCarbonzipper(uint64(l))
	}
	if m.StartTime != 0 {
		n += 1 + sovCarbonzipper(uint64(m.StartTime))
	}
	if m.StopTime != 0 {
		n += 1 + sovCarbonzipper(uint64(m.StopTime))
	}
	if m.StepTime != 0 {
		n += 1 + sovCarbonzipper(uint64(m.StepTime))
	}
	if len(m.Values) > 0 {
		n += 1 + sovCarbonzipper(uint64(len(m.Values)*8)) + len(m.Values)*8
	}
	if len(m.IsAbsent) > 0 {
		n += 1 + sovCarbonzipper(uint64(len(m.IsAbsent))) + len(m.IsAbsent)*1
	}
	return n
}

func (m *MultiFetchResponse) Size() (n int) {
	var l int
	_ = l
	if len(m.Metrics) > 0 {
		for _, e := range m.Metrics {
			l = e.Size()
			n += 1 + l + sovCarbonzipper(uint64(l))
		}
	}
	return n
}

func (m *GlobMatch) Size() (n int) {
	var l int
	_ = l
	l = len(m.Path)
	if l > 0 {
		n += 1 + l + sovCarbonzipper(uint64(l))
	}
	if m.IsLeaf {
		n += 2
	}
	return n
}

func (m *GlobResponse) Size() (n int) {
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovCarbonzipper(uint64(l))
	}
	if len(m.Matches) > 0 {
		for _, e := range m.Matches {
			l = e.Size()
			n += 1 + l + sovCarbonzipper(uint64(l))
		}
	}
	return n
}

func (m *Retention) Size() (n int) {
	var l int
	_ = l
	if m.SecondsPerPoint != 0 {
		n += 1 + sovCarbonzipper(uint64(m.SecondsPerPoint))
	}
	if m.NumberOfPoints != 0 {
		n += 1 + sovCarbonzipper(uint64(m.NumberOfPoints))
	}
	return n
}

func (m *InfoResponse) Size() (n int) {
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovCarbonzipper(uint64(l))
	}
	l = len(m.AggregationMethod)
	if l > 0 {
		n += 1 + l + sovCarbonzipper(uint64(l))
	}
	if m.MaxRetention != 0 {
		n += 1 + sovCarbonzipper(uint64(m.MaxRetention))
	}
	if m.XFilesFactor != 0 {
		n += 5
	}
	if len(m.Retentions) > 0 {
		for _, e := range m.Retentions {
			l = e.Size()
			n += 1 + l + sovCarbonzipper(uint64(l))
		}
	}
	return n
}

func (m *ServerInfoResponse) Size() (n int) {
	var l int
	_ = l
	l = len(m.Server)
	if l > 0 {
		n += 1 + l + sovCarbonzipper(uint64(l))
	}
	if m.Info != nil {
		l = m.Info.Size()
		n += 1 + l + sovCarbonzipper(uint64(l))
	}
	return n
}

func (m *ZipperInfoResponse) Size() (n int) {
	var l int
	_ = l
	if len(m.Responses) > 0 {
		for _, e := range m.Responses {
			l = e.Size()
			n += 1 + l + sovCarbonzipper(uint64(l))
		}
	}
	return n
}

func (m *ListMetricsResponse) Size() (n int) {
	var l int
	_ = l
	if len(m.Metrics) > 0 {
		for _, s := range m.Metrics {
			l = len(s)
			n += 1 + l + sovCarbonzipper(uint64(l))
		}
	}
	return n
}

func (m *MetricDetails) Size() (n int) {
	var l int
	_ = l
	if m.Size_ != 0 {
		n += 1 + sovCarbonzipper(uint64(m.Size_))
	}
	if m.ModTime != 0 {
		n += 1 + sovCarbonzipper(uint64(m.ModTime))
	}
	if m.ATime != 0 {
		n += 1 + sovCarbonzipper(uint64(m.ATime))
	}
	if m.RdTime != 0 {
		n += 1 + sovCarbonzipper(uint64(m.RdTime))
	}
	return n
}

func (m *MetricDetailsResponse) Size() (n int) {
	var l int
	_ = l
	if len(m.Metrics) > 0 {
		for k, v := range m.Metrics {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovCarbonzipper(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovCarbonzipper(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovCarbonzipper(uint64(mapEntrySize))
		}
	}
	if m.FreeSpace != 0 {
		n += 1 + sovCarbonzipper(uint64(m.FreeSpace))
	}
	if m.TotalSpace != 0 {
		n += 1 + sovCarbonzipper(uint64(m.TotalSpace))
	}
	return n
}

func sovCarbonzipper(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozCarbonzipper(x uint64) (n int) {
	return sovCarbonzipper(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *FetchResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCarbonzipper
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: FetchResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: FetchResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCarbonzipper
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCarbonzipper
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTime", wireType)
			}
			m.StartTime = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCarbonzipper
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StartTime |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StopTime", wireType)
			}
			m.StopTime = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCarbonzipper
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StopTime |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StepTime", wireType)
			}
			m.StepTime = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCarbonzipper
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StepTime |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType == 1 {
				var v uint64
				if (iNdEx + 8) > l {
					return io.ErrUnexpectedEOF
				}
				iNdEx += 8
				v = uint64(dAtA[iNdEx-8])
				v |= uint64(dAtA[iNdEx-7]) << 8
				v |= uint64(dAtA[iNdEx-6]) << 16
				v |= uint64(dAtA[iNdEx-5]) << 24
				v |= uint64(dAtA[iNdEx-4]) << 32
				v |= uint64(dAtA[iNdEx-3]) << 40
				v |= uint64(dAtA[iNdEx-2]) << 48
				v |= uint64(dAtA[iNdEx-1]) << 56
				v2 := float64(math.Float64frombits(v))
				m.Values = append(m.Values, v2)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowCarbonzipper
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthCarbonzipper
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v uint64
					if (iNdEx + 8) > l {
						return io.ErrUnexpectedEOF
					}
					iNdEx += 8
					v = uint64(dAtA[iNdEx-8])
					v |= uint64(dAtA[iNdEx-7]) << 8
					v |= uint64(dAtA[iNdEx-6]) << 16
					v |= uint64(dAtA[iNdEx-5]) << 24
					v |= uint64(dAtA[iNdEx-4]) << 32
					v |= uint64(dAtA[iNdEx-3]) << 40
					v |= uint64(dAtA[iNdEx-2]) << 48
					v |= uint64(dAtA[iNdEx-1]) << 56
					v2 := float64(math.Float64frombits(v))
					m.Values = append(m.Values, v2)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Values", wireType)
			}
		case 6:
			if wireType == 0 {
				var v int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowCarbonzipper
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.IsAbsent = append(m.IsAbsent, bool(v != 0))
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowCarbonzipper
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthCarbonzipper
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowCarbonzipper
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (int(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.IsAbsent = append(m.IsAbsent, bool(v != 0))
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field IsAbsent", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipCarbonzipper(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCarbonzipper
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MultiFetchResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCarbonzipper
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MultiFetchResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MultiFetchResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metrics", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCarbonzipper
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCarbonzipper
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Metrics = append(m.Metrics, &FetchResponse{})
			if err := m.Metrics[len(m.Metrics)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCarbonzipper(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCarbonzipper
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GlobMatch) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCarbonzipper
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GlobMatch: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GlobMatch: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Path", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCarbonzipper
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCarbonzipper
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Path = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsLeaf", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCarbonzipper
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsLeaf = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipCarbonzipper(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCarbonzipper
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GlobResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCarbonzipper
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GlobResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GlobResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCarbonzipper
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCarbonzipper
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Matches", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCarbonzipper
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCarbonzipper
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Matches = append(m.Matches, &GlobMatch{})
			if err := m.Matches[len(m.Matches)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCarbonzipper(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCarbonzipper
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Retention) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCarbonzipper
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Retention: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Retention: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SecondsPerPoint", wireType)
			}
			m.SecondsPerPoint = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCarbonzipper
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SecondsPerPoint |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NumberOfPoints", wireType)
			}
			m.NumberOfPoints = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCarbonzipper
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NumberOfPoints |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipCarbonzipper(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCarbonzipper
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *InfoResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCarbonzipper
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: InfoResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: InfoResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCarbonzipper
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCarbonzipper
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AggregationMethod", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCarbonzipper
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCarbonzipper
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AggregationMethod = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxRetention", wireType)
			}
			m.MaxRetention = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCarbonzipper
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxRetention |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 5 {
				return fmt.Errorf("proto: wrong wireType = %d for field XFilesFactor", wireType)
			}
			var v uint32
			if (iNdEx + 4) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += 4
			v = uint32(dAtA[iNdEx-4])
			v |= uint32(dAtA[iNdEx-3]) << 8
			v |= uint32(dAtA[iNdEx-2]) << 16
			v |= uint32(dAtA[iNdEx-1]) << 24
			m.XFilesFactor = float32(math.Float32frombits(v))
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Retentions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCarbonzipper
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCarbonzipper
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Retentions = append(m.Retentions, &Retention{})
			if err := m.Retentions[len(m.Retentions)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCarbonzipper(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCarbonzipper
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ServerInfoResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCarbonzipper
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ServerInfoResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ServerInfoResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Server", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCarbonzipper
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCarbonzipper
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Server = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Info", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCarbonzipper
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCarbonzipper
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Info == nil {
				m.Info = &InfoResponse{}
			}
			if err := m.Info.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCarbonzipper(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCarbonzipper
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ZipperInfoResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCarbonzipper
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ZipperInfoResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ZipperInfoResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Responses", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCarbonzipper
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCarbonzipper
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Responses = append(m.Responses, &ServerInfoResponse{})
			if err := m.Responses[len(m.Responses)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCarbonzipper(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCarbonzipper
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListMetricsResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCarbonzipper
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListMetricsResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListMetricsResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metrics", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCarbonzipper
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCarbonzipper
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Metrics = append(m.Metrics, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCarbonzipper(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCarbonzipper
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MetricDetails) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCarbonzipper
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MetricDetails: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MetricDetails: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Size_", wireType)
			}
			m.Size_ = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCarbonzipper
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Size_ |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ModTime", wireType)
			}
			m.ModTime = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCarbonzipper
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ModTime |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ATime", wireType)
			}
			m.ATime = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCarbonzipper
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ATime |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RdTime", wireType)
			}
			m.RdTime = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCarbonzipper
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RdTime |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipCarbonzipper(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCarbonzipper
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MetricDetailsResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCarbonzipper
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MetricDetailsResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MetricDetailsResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metrics", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCarbonzipper
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCarbonzipper
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			var keykey uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCarbonzipper
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				keykey |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			var stringLenmapkey uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCarbonzipper
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLenmapkey |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLenmapkey := int(stringLenmapkey)
			if intStringLenmapkey < 0 {
				return ErrInvalidLengthCarbonzipper
			}
			postStringIndexmapkey := iNdEx + intStringLenmapkey
			if postStringIndexmapkey > l {
				return io.ErrUnexpectedEOF
			}
			mapkey := string(dAtA[iNdEx:postStringIndexmapkey])
			iNdEx = postStringIndexmapkey
			if m.Metrics == nil {
				m.Metrics = make(map[string]*MetricDetails)
			}
			if iNdEx < postIndex {
				var valuekey uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowCarbonzipper
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					valuekey |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				var mapmsglen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowCarbonzipper
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					mapmsglen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if mapmsglen < 0 {
					return ErrInvalidLengthCarbonzipper
				}
				postmsgIndex := iNdEx + mapmsglen
				if mapmsglen < 0 {
					return ErrInvalidLengthCarbonzipper
				}
				if postmsgIndex > l {
					return io.ErrUnexpectedEOF
				}
				mapvalue := &MetricDetails{}
				if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
					return err
				}
				iNdEx = postmsgIndex
				m.Metrics[mapkey] = mapvalue
			} else {
				var mapvalue *MetricDetails
				m.Metrics[mapkey] = mapvalue
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FreeSpace", wireType)
			}
			m.FreeSpace = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCarbonzipper
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.FreeSpace |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TotalSpace", wireType)
			}
			m.TotalSpace = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCarbonzipper
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TotalSpace |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipCarbonzipper(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCarbonzipper
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipCarbonzipper(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowCarbonzipper
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowCarbonzipper
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowCarbonzipper
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthCarbonzipper
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowCarbonzipper
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipCarbonzipper(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthCarbonzipper = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowCarbonzipper   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("carbonzipper.proto", fileDescriptorCarbonzipper) }

var fileDescriptorCarbonzipper = []byte{
	// 623 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x7c, 0x54, 0xdd, 0x4e, 0x13, 0x41,
	0x14, 0xce, 0x76, 0xdb, 0xc2, 0x1e, 0x0a, 0xea, 0xa8, 0x64, 0x25, 0xd0, 0x34, 0x73, 0x61, 0x7a,
	0x61, 0xd0, 0xc0, 0x05, 0xea, 0x95, 0x18, 0xad, 0x31, 0xa1, 0x91, 0x0c, 0x44, 0xa3, 0x89, 0x26,
	0xd3, 0xe5, 0x94, 0x4e, 0x68, 0x77, 0x36, 0x33, 0x03, 0x01, 0xde, 0xc9, 0xf7, 0xf0, 0xd2, 0xc4,
	0x17, 0x30, 0x3c, 0x88, 0x31, 0x33, 0xb3, 0xbb, 0x74, 0x17, 0xc2, 0xdd, 0xf9, 0xbe, 0xf3, 0x33,
	0xdf, 0x99, 0x39, 0x67, 0x80, 0x24, 0x5c, 0x8d, 0x64, 0x7a, 0x29, 0xb2, 0x0c, 0xd5, 0x66, 0xa6,
	0xa4, 0x91, 0x64, 0x65, 0x9e, 0xcb, 0x46, 0xf4, 0x67, 0x00, 0xcb, 0x03, 0x34, 0xc9, 0x84, 0xa1,
	0xce, 0x64, 0xaa, 0x91, 0x10, 0x68, 0xa6, 0x7c, 0x86, 0x71, 0xd0, 0x0b, 0xfa, 0x11, 0x73, 0x36,
	0x59, 0x87, 0x48, 0x1b, 0xae, 0xcc, 0xa1, 0x98, 0x61, 0xdc, 0xe8, 0x05, 0xfd, 0x16, 0xbb, 0x26,
	0xc8, 0x1a, 0x2c, 0x6a, 0x23, 0x33, 0xe7, 0x0c, 0x9d, 0xb3, 0xc4, 0xde, 0x87, 0xde, 0xd7, 0x2c,
	0x7c, 0x1e, 0x93, 0x55, 0x68, 0x9f, 0xf1, 0xe9, 0x29, 0xea, 0xb8, 0xd5, 0x0b, 0xfb, 0x01, 0xcb,
	0x91, 0xcd, 0x11, 0x7a, 0x77, 0xa4, 0x31, 0x35, 0x71, 0xbb, 0x17, 0xf6, 0x17, 0x59, 0x89, 0xe9,
	0x10, 0xc8, 0xf0, 0x74, 0x6a, 0x44, 0x55, 0xf3, 0x0e, 0x2c, 0xcc, 0xd0, 0x28, 0x91, 0xe8, 0x38,
	0xe8, 0x85, 0xfd, 0xa5, 0xad, 0x8d, 0xcd, 0x6a, 0x9f, 0x9b, 0x95, 0x78, 0x56, 0x44, 0xd3, 0x1d,
	0x88, 0x3e, 0x4c, 0xe5, 0x68, 0xc8, 0x4d, 0x32, 0xb1, 0x9d, 0x67, 0xdc, 0x4c, 0x8a, 0xce, 0xad,
	0x6d, 0x35, 0x0a, 0xbd, 0x87, 0x7c, 0xec, 0xda, 0x5e, 0x64, 0x39, 0xa2, 0x5f, 0xa0, 0x63, 0x13,
	0xef, 0xbc, 0xb5, 0x6d, 0x58, 0x98, 0xd9, 0xc2, 0xa8, 0xe3, 0x86, 0x53, 0xf5, 0xa4, 0xae, 0xaa,
	0x3c, 0x9b, 0x15, 0x91, 0xf4, 0x3b, 0x44, 0x0c, 0x0d, 0xa6, 0x46, 0xc8, 0x94, 0xf4, 0xe1, 0x9e,
	0xc6, 0x44, 0xa6, 0x47, 0x7a, 0x1f, 0xd5, 0xbe, 0x14, 0xa9, 0x71, 0x07, 0xb4, 0x58, 0x9d, 0x26,
	0x4f, 0x61, 0x25, 0x3d, 0x9d, 0x8d, 0x50, 0x7d, 0x1a, 0x3b, 0x42, 0xe7, 0xcf, 0x54, 0x63, 0xe9,
	0x9f, 0x00, 0x3a, 0x1f, 0xd3, 0xb1, 0xbc, 0x53, 0xf8, 0x33, 0x78, 0xc0, 0x8f, 0x8f, 0x15, 0x1e,
	0x73, 0xab, 0x62, 0x88, 0x66, 0x22, 0x8f, 0x5c, 0xbd, 0x88, 0xdd, 0x74, 0x10, 0x0a, 0x9d, 0x19,
	0x3f, 0x2f, 0x45, 0xe7, 0x23, 0x50, 0xe1, 0x6c, 0xcc, 0xf9, 0x40, 0x4c, 0x51, 0x0f, 0x78, 0x62,
	0xa4, 0x72, 0xa3, 0xd0, 0x60, 0x15, 0x8e, 0xbc, 0x02, 0x50, 0x45, 0x82, 0x1f, 0x89, 0x5b, 0x6e,
	0xac, 0x2c, 0xc9, 0xe6, 0x82, 0xe9, 0x0f, 0x20, 0x07, 0xa8, 0xce, 0x50, 0x55, 0x5a, 0x5b, 0x85,
	0xb6, 0x76, 0x6c, 0xde, 0x5c, 0x8e, 0xc8, 0x0b, 0x68, 0x8a, 0x74, 0x2c, 0x5d, 0x47, 0x4b, 0x5b,
	0xeb, 0xf5, 0x23, 0xe6, 0x6b, 0x30, 0x17, 0x49, 0x3f, 0x03, 0xf9, 0xe6, 0xdc, 0x95, 0xfa, 0x6f,
	0x20, 0x52, 0xb9, 0x5d, 0xcc, 0x1d, 0xad, 0x17, 0xbb, 0x29, 0x8b, 0x5d, 0x27, 0xd1, 0xe7, 0xf0,
	0x70, 0x4f, 0x68, 0x33, 0xf4, 0xd3, 0x58, 0x16, 0x8e, 0x61, 0x61, 0x38, 0x37, 0xce, 0x11, 0x2b,
	0x20, 0x3d, 0x81, 0x65, 0x6f, 0xbe, 0x43, 0xc3, 0xc5, 0x54, 0xdb, 0xe7, 0x3b, 0x10, 0x97, 0x7e,
	0x29, 0x43, 0xe6, 0x6c, 0x97, 0x2e, 0x8f, 0xca, 0x75, 0x0c, 0x59, 0x01, 0xc9, 0x23, 0x68, 0xed,
	0x96, 0xab, 0x18, 0x32, 0x0f, 0xec, 0x3d, 0x31, 0x1f, 0xde, 0x72, 0x74, 0x8e, 0xe8, 0xbf, 0x00,
	0x1e, 0x57, 0x4e, 0x2b, 0x05, 0xee, 0xd5, 0xf7, 0x6d, 0xab, 0xde, 0xf7, 0xad, 0x79, 0x39, 0xab,
	0xdf, 0xa7, 0x46, 0x5d, 0x94, 0x4b, 0x68, 0x7f, 0x97, 0x81, 0x42, 0x3c, 0xc8, 0x78, 0xe2, 0x1b,
	0x69, 0xb2, 0x6b, 0x82, 0x74, 0x01, 0x0e, 0xa5, 0xe1, 0x53, 0xef, 0x0e, 0x9d, 0x7b, 0x8e, 0x59,
	0xfb, 0x0a, 0x9d, 0xf9, 0xb2, 0xe4, 0x3e, 0x84, 0x27, 0x78, 0x91, 0x3f, 0xb9, 0x35, 0xc9, 0x36,
	0xb4, 0xdc, 0xcf, 0x92, 0x3f, 0xf8, 0xc6, 0xdd, 0x5a, 0x7d, 0xec, 0xeb, 0xc6, 0xcb, 0xe0, 0x6d,
	0xe7, 0xd7, 0x55, 0x37, 0xf8, 0x7d, 0xd5, 0x0d, 0xfe, 0x5e, 0x75, 0x83, 0x51, 0xdb, 0xfd, 0xa0,
	0xdb, 0xff, 0x03, 0x00, 0x00, 0xff, 0xff, 0xd3, 0x62, 0x83, 0x17, 0x57, 0x05, 0x00, 0x00,
}
