# Part of the StreamDVD project
package StreamDVD::Project;

use strict;
use vars qw($VERSION @ISA @EXPORT);

require Exporter;

@ISA = qw(Exporter);
@EXPORT = qw(

);


$VERSION = '0.1';

use StreamDVD::Defs;

sub new {                                                  # create new project object
   my $class = shift;
   my $self = bless {}, $class;
   my ($name, $dir) = @_;
   $self->name($name) if(defined $name);
   $self->dir($dir) if(defined $dir);
   $self->{AUDIO} = [];
   $self->{AUDIO_OBJ} = [];
   $self->{SUB} = [];
   $self->{SUB_OBJ} = [];
   $self->{CHAPTER_SELECT} = [];
   $self->{CHAPTER_TIME} = [];
   return $self;
}



sub name {                                                 # get/set project name
   my $self = shift;
   my ($value) = @_;
   $self->{NAME} = $value if(defined $value);
   return $self->{NAME};
}



sub dir {                                                  # get/set data directory
   my $self = shift;
   my ($value) = @_;
   $self->{DATADIR} = $value if(defined $value);
   return $self->{DATADIR};
}



sub state {                                                # get/set progress state
   my $self = shift;
   my ($value) = @_;
   $self->{STATE} = $value if(defined $value);
   return $self->{STATE};
}



sub title {                                                # get/set selected dvd title number
   my $self = shift;
   my ($value) = @_;
   $self->{TITLE} = $value if(defined $value);
   return $self->{TITLE};
}



sub factor {                                               # get/set streamdvd factor
   my $self = shift;
   my ($value) = @_;
   $self->{FACTOR} = $value if(defined $value);
   return $self->{FACTOR};
}



sub chapter_first {                                        # get first selected chapter
   my $self = shift;
   for( my $i=0 ; $i<=$#{$self->{CHAPTER_SELECT}} ; $i++ ) {
      return $i if($self->chapter_selected($i)); }
   return $#{$self->{CHAPTER_SELECT}};
}



sub chapter_last {                                         # get last selected chapter
   my $self = shift;
   for( my $i=$self->chapter_first() ; $i<=$#{$self->{CHAPTER_SELECT}} ; $i++ ) {
      return ($i-1) if(not $self->chapter_selected($i)); }
   return $#{$self->{CHAPTER_SELECT}};
}



sub chapter_select {                                       # set selected chapter
   my $self = shift;
   my ($value) = @_;
   $self->{CHAPTER_SELECT}->[$value] = 1;
}



sub chapter_unselect {                                     # unset selected chapter
   my $self = shift;
   my ($value) = @_;
   $self->{CHAPTER_SELECT}->[$value] = 0;
}



sub chapter_selected {                                     # is chapter selected
   my $self = shift;
   my ($value) = @_;
   return $self->{CHAPTER_SELECT}->[$value];
}



sub audio_select {                                         # set selected audio tracks
   my $self = shift;
   my ($value) = @_;  
   $self->{AUDIO}->[$value] = 1;
}



sub audio_unselect {                                       # unset selected audio tracks
   my $self = shift;
   my ($value) = @_;
   $self->{AUDIO}->[$value] = 0;
}



sub audio_selected {                                       # is audio track selected
   my $self = shift;
   my ($value) = @_;
   return $self->{AUDIO}->[$value];
}



sub subtitle_select {                                      # set selected subtitle track
   my $self = shift;
   my ($value) = @_;
   $self->{SUB}->[$value] = 1;
}



sub subtitle_unselect {                                    # unset selected subtitle track
   my $self = shift;
   my ($value) = @_;
   $self->{SUB}->[$value] = 0;
}



sub subtitle_selected {                                    # is subtitle track selected
   my $self = shift;
   my ($value) = @_;
   return $self->{SUB}->[$value];
}



sub video_size {                                           # video stream size in bytes
   my $self = shift;
   my ($value) = @_;
   $self->{VIDEOSIZE} = $value if(defined $value);
   return $self->{VIDEOSIZE};
}




1;

