/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.Arrays;
import java.util.List;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.TwoValueNode;
import org.jruby.ast.visitor.NodeVisitor;

public class ArgsPushNode
extends Node
implements TwoValueNode {
    private Node firstNode;
    private Node secondNode;

    public ArgsPushNode(int line, Node firstNode, Node secondNode) {
        super(line, firstNode.containsVariableAssignment() || secondNode.containsVariableAssignment());
        assert (secondNode != null) : "ArgsPushNode.second == null";
        this.firstNode = firstNode;
        this.secondNode = secondNode;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.ARGSPUSHNODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> visitor) {
        return visitor.visitArgsPushNode(this);
    }

    @Override
    public Node getFirstNode() {
        return this.firstNode;
    }

    @Override
    public Node getSecondNode() {
        return this.secondNode;
    }

    @Override
    public List<Node> childNodes() {
        return Arrays.asList(this.firstNode, this.secondNode);
    }
}

