/*
 * Decompiled with CFR 0.152.
 */
package jnr.constants.platform.freebsd;

import java.util.EnumMap;
import java.util.Map;
import jnr.constants.Constant;

public enum TCP implements Constant
{
    TCP_MAX_SACK(4L),
    TCP_MSS(536L),
    TCP_MINMSS(216L),
    TCP_MAXWIN(65535L),
    TCP_MAX_WINSHIFT(14L),
    TCP_MAXBURST(4L),
    TCP_MAXHLEN(60L),
    TCP_MAXOLEN(40L),
    TCP_NODELAY(1L),
    TCP_MAXSEG(2L),
    TCP_NOPUSH(4L),
    TCP_NOOPT(8L),
    TCP_INFO(32L),
    TCP_KEEPCNT(1024L),
    TCP_KEEPIDLE(256L),
    TCP_KEEPINTVL(512L),
    TCP_MD5SIG(16L),
    TCP_FASTOPEN(1025L),
    TCP_CONGESTION(64L);

    private final long value;
    public static final long MIN_VALUE = 1L;
    public static final long MAX_VALUE = 65535L;

    private TCP(long value2) {
        this.value = value2;
    }

    public final String toString() {
        return StringTable.descriptions.get(this);
    }

    public final int value() {
        return (int)this.value;
    }

    @Override
    public final int intValue() {
        return (int)this.value;
    }

    @Override
    public final long longValue() {
        return this.value;
    }

    @Override
    public final boolean defined() {
        return true;
    }

    static final class StringTable {
        public static final Map<TCP, String> descriptions = StringTable.generateTable();

        StringTable() {
        }

        public static final Map<TCP, String> generateTable() {
            EnumMap<TCP, String> map2 = new EnumMap<TCP, String>(TCP.class);
            map2.put(TCP_MAX_SACK, "TCP_MAX_SACK");
            map2.put(TCP_MSS, "TCP_MSS");
            map2.put(TCP_MINMSS, "TCP_MINMSS");
            map2.put(TCP_MAXWIN, "TCP_MAXWIN");
            map2.put(TCP_MAX_WINSHIFT, "TCP_MAX_WINSHIFT");
            map2.put(TCP_MAXBURST, "TCP_MAXBURST");
            map2.put(TCP_MAXHLEN, "TCP_MAXHLEN");
            map2.put(TCP_MAXOLEN, "TCP_MAXOLEN");
            map2.put(TCP_NODELAY, "TCP_NODELAY");
            map2.put(TCP_MAXSEG, "TCP_MAXSEG");
            map2.put(TCP_NOPUSH, "TCP_NOPUSH");
            map2.put(TCP_NOOPT, "TCP_NOOPT");
            map2.put(TCP_INFO, "TCP_INFO");
            map2.put(TCP_KEEPCNT, "TCP_KEEPCNT");
            map2.put(TCP_KEEPIDLE, "TCP_KEEPIDLE");
            map2.put(TCP_KEEPINTVL, "TCP_KEEPINTVL");
            map2.put(TCP_MD5SIG, "TCP_MD5SIG");
            map2.put(TCP_FASTOPEN, "TCP_FASTOPEN");
            map2.put(TCP_CONGESTION, "TCP_CONGESTION");
            return map2;
        }
    }
}

