/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.reflect.validation;

import javax.annotation.Nullable;
import org.gradle.api.NonNullApi;
import org.gradle.api.problems.DocLink;
import org.gradle.api.problems.ProblemBuilder;
import org.gradle.api.problems.ProblemBuilderDefiningDocumentation;
import org.gradle.api.problems.ProblemBuilderDefiningGroup;
import org.gradle.api.problems.ProblemBuilderDefiningLabel;
import org.gradle.api.problems.ProblemBuilderDefiningLocation;
import org.gradle.api.problems.ProblemBuilderDefiningType;
import org.gradle.api.problems.ReportableProblem;
import org.gradle.api.problems.Severity;

@NonNullApi
class DelegatingProblemBuilder
implements ProblemBuilderDefiningLabel,
ProblemBuilderDefiningDocumentation,
ProblemBuilderDefiningLocation,
ProblemBuilderDefiningType,
ProblemBuilderDefiningGroup,
ProblemBuilder {
    private final Object delegate;

    DelegatingProblemBuilder(ProblemBuilderDefiningLabel delegate) {
        this.delegate = delegate;
    }

    public ProblemBuilderDefiningDocumentation label(String label, Object ... args) {
        ProblemBuilderDefiningDocumentation newDelegate = ((ProblemBuilderDefiningLabel)this.delegate).label(label, args);
        if (this.delegate != newDelegate) {
            throw new IllegalStateException("Builder pattern expected to return 'this'");
        }
        return this;
    }

    public ProblemBuilderDefiningLocation documentedAt(DocLink doc) {
        ProblemBuilderDefiningLocation newDelegate = ((ProblemBuilderDefiningDocumentation)this.delegate).documentedAt(doc);
        if (this.delegate != newDelegate) {
            throw new IllegalStateException("Builder pattern expected to return 'this'");
        }
        return this;
    }

    public ProblemBuilderDefiningLocation undocumented() {
        ProblemBuilderDefiningLocation newDelegate = ((ProblemBuilderDefiningDocumentation)this.delegate).undocumented();
        if (this.delegate != newDelegate) {
            throw new IllegalStateException("Builder pattern expected to return 'this'");
        }
        return this;
    }

    public ProblemBuilderDefiningType location(String path, Integer line) {
        ProblemBuilderDefiningType newDelegate = ((ProblemBuilderDefiningLocation)this.delegate).location(path, line);
        if (this.delegate != newDelegate) {
            throw new IllegalStateException("Builder pattern expected to return 'this'");
        }
        return this;
    }

    public ProblemBuilderDefiningType location(String path, Integer line, Integer column) {
        ProblemBuilderDefiningType newDelegate = ((ProblemBuilderDefiningLocation)this.delegate).location(path, line, column);
        if (this.delegate != newDelegate) {
            throw new IllegalStateException("Builder pattern expected to return 'this'");
        }
        return this;
    }

    public ProblemBuilderDefiningType noLocation() {
        ProblemBuilderDefiningType newDelegate = ((ProblemBuilderDefiningLocation)this.delegate).noLocation();
        if (this.delegate != newDelegate) {
            throw new IllegalStateException("Builder pattern expected to return 'this'");
        }
        return this;
    }

    public ProblemBuilderDefiningGroup type(String problemType) {
        ProblemBuilderDefiningGroup newDelegate = ((ProblemBuilderDefiningType)this.delegate).type(problemType);
        if (this.delegate != newDelegate) {
            throw new IllegalStateException("Builder pattern expected to return 'this'");
        }
        return this;
    }

    public ProblemBuilder group(String group) {
        ProblemBuilder newDelegate = ((ProblemBuilderDefiningGroup)this.delegate).group(group);
        if (this.delegate != newDelegate) {
            throw new IllegalStateException("Builder pattern expected to return 'this'");
        }
        return this;
    }

    public ProblemBuilder details(String details) {
        ProblemBuilder newDelegate = ((ProblemBuilder)this.delegate).details(details);
        if (this.delegate != newDelegate) {
            throw new IllegalStateException("Builder pattern expected to return 'this'");
        }
        return this;
    }

    public ProblemBuilder solution(@Nullable String solution) {
        ProblemBuilder newDelegate = ((ProblemBuilder)this.delegate).solution(solution);
        if (this.delegate != newDelegate) {
            throw new IllegalStateException("Builder pattern expected to return 'this'");
        }
        return this;
    }

    public ProblemBuilder additionalData(String key, String value) {
        ProblemBuilder newDelegate = ((ProblemBuilder)this.delegate).additionalData(key, value);
        if (this.delegate != newDelegate) {
            throw new IllegalStateException("Builder pattern expected to return 'this'");
        }
        return this;
    }

    public ProblemBuilder withException(RuntimeException e) {
        ProblemBuilder newDelegate = ((ProblemBuilder)this.delegate).withException(e);
        if (this.delegate != newDelegate) {
            throw new IllegalStateException("Builder pattern expected to return 'this'");
        }
        return this;
    }

    public ProblemBuilder severity(@Nullable Severity severity) {
        ProblemBuilder newDelegate = ((ProblemBuilder)this.delegate).severity(severity);
        if (this.delegate != newDelegate) {
            throw new IllegalStateException("Builder pattern expected to return 'this'");
        }
        return this;
    }

    public ReportableProblem build() {
        return ((ProblemBuilder)this.delegate).build();
    }
}

