/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.ivy.util.FileUtil;

public final class ChecksumHelper {
    private static final int BUFFER_SIZE = 2048;
    private static Map algorithms = new HashMap();
    private static final char[] CHARS;

    public static void check(File file, File file2, String string) throws IOException {
        String string2;
        int n;
        String string3 = FileUtil.readEntirely(new BufferedReader(new FileReader(file2))).trim().toLowerCase(Locale.US);
        if (string3.indexOf(32) > -1 && (string3.startsWith("md") || string3.startsWith("sha"))) {
            n = string3.lastIndexOf(32);
            string2 = string3.substring(n + 1);
        } else {
            n = string3.indexOf(32);
            if (n != -1) {
                string2 = string3.substring(0, n);
                if (string2.endsWith(":")) {
                    StringBuffer stringBuffer = new StringBuffer();
                    char[] cArray = string3.substring(n + 1).toCharArray();
                    for (int i = 0; i < cArray.length; ++i) {
                        if (Character.isWhitespace(cArray[i])) continue;
                        stringBuffer.append(cArray[i]);
                    }
                    string2 = stringBuffer.toString();
                }
            } else {
                string2 = string3;
            }
        }
        String string4 = ChecksumHelper.computeAsString(file, string).trim().toLowerCase(Locale.US);
        if (!string2.equals(string4)) {
            throw new IOException("invalid " + string + ": expected=" + string2 + " computed=" + string4);
        }
    }

    public static String computeAsString(File file, String string) throws IOException {
        return ChecksumHelper.byteArrayToHexString(ChecksumHelper.compute(file, string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] compute(File file, String string) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            MessageDigest messageDigest = ChecksumHelper.getMessageDigest(string);
            messageDigest.reset();
            byte[] byArray = new byte[2048];
            int n = 0;
            while ((n = ((InputStream)fileInputStream).read(byArray)) != -1) {
                messageDigest.update(byArray, 0, n);
            }
            byte[] byArray2 = messageDigest.digest();
            return byArray2;
        }
        finally {
            ((InputStream)fileInputStream).close();
        }
    }

    public static boolean isKnownAlgorithm(String string) {
        return algorithms.containsKey(string);
    }

    private static MessageDigest getMessageDigest(String string) {
        String string2 = (String)algorithms.get(string);
        if (string2 == null) {
            throw new IllegalArgumentException("unknown algorithm " + string);
        }
        try {
            return MessageDigest.getInstance(string2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalArgumentException("unknown algorithm " + string);
        }
    }

    public static String byteArrayToHexString(byte[] byArray) {
        byte by = 0;
        if (byArray == null || byArray.length <= 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        for (int i = 0; i < byArray.length; ++i) {
            by = (byte)(byArray[i] & 0xF0);
            by = (byte)(by >>> 4);
            by = (byte)(by & 0xF);
            stringBuffer.append(CHARS[by]);
            by = (byte)(byArray[i] & 0xF);
            stringBuffer.append(CHARS[by]);
        }
        return stringBuffer.toString();
    }

    private ChecksumHelper() {
    }

    static {
        algorithms.put("md5", "MD5");
        algorithms.put("sha1", "SHA-1");
        CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    }
}

