/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.namespace;

import java.util.ArrayList;
import java.util.List;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.plugins.namespace.NamespaceRule;
import org.apache.ivy.plugins.namespace.NamespaceTransformer;

public class Namespace {
    public static final Namespace SYSTEM_NAMESPACE = new Namespace();
    private List rules = new ArrayList();
    private String name;
    private boolean chainRules = false;
    private NamespaceTransformer fromSystemTransformer = new NamespaceTransformer(){

        @Override
        public ModuleRevisionId transform(ModuleRevisionId moduleRevisionId) {
            if (moduleRevisionId == null) {
                return null;
            }
            for (NamespaceRule namespaceRule : Namespace.this.rules) {
                ModuleRevisionId moduleRevisionId2 = namespaceRule.getFromSystem().transform(moduleRevisionId);
                if (Namespace.this.chainRules) {
                    moduleRevisionId = moduleRevisionId2;
                    continue;
                }
                if (moduleRevisionId2.equals(moduleRevisionId)) continue;
                return moduleRevisionId2;
            }
            return moduleRevisionId;
        }

        @Override
        public boolean isIdentity() {
            return Namespace.this.rules.isEmpty();
        }
    };
    private NamespaceTransformer toSystemTransformer = new NamespaceTransformer(){

        @Override
        public ModuleRevisionId transform(ModuleRevisionId moduleRevisionId) {
            if (moduleRevisionId == null) {
                return null;
            }
            for (NamespaceRule namespaceRule : Namespace.this.rules) {
                ModuleRevisionId moduleRevisionId2 = namespaceRule.getToSystem().transform(moduleRevisionId);
                if (Namespace.this.chainRules) {
                    moduleRevisionId = moduleRevisionId2;
                    continue;
                }
                if (moduleRevisionId2.equals(moduleRevisionId)) continue;
                return moduleRevisionId2;
            }
            return moduleRevisionId;
        }

        @Override
        public boolean isIdentity() {
            return Namespace.this.rules.isEmpty();
        }
    };

    public void addRule(NamespaceRule namespaceRule) {
        this.rules.add(namespaceRule);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public NamespaceTransformer getFromSystemTransformer() {
        return this.fromSystemTransformer;
    }

    public NamespaceTransformer getToSystemTransformer() {
        return this.toSystemTransformer;
    }

    public boolean isChainrules() {
        return this.chainRules;
    }

    public void setChainrules(boolean bl) {
        this.chainRules = bl;
    }
}

