//=============================================
//  wmxkbg - WM XKB groups
// --------------------------------------------
//  Michael Glickman <wmalms@yahooo.com>
//  03-Oct-03
//=============================================
#include "wmxkb.h"


#include <X11/Xutil.h>
#include <X11/Xatom.h>


#if HAVE_XSHAPES
#include <X11/extensions/shape.h>
#endif

#include <X11/xpm.h>

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>


Colormap cmap;
int	 screen;
Window wndRoot;

extern Display *disp;

extern int CurrentGroupXKBNo, CurrentGroupResNo;

extern GeometryInfo WndGeometry, TextGeometry;
static Bool WndPosExplicit;
static int WndX, WndY,WndWidth, WndHeight;
static int WndTextX, WndTextY, WndTextWidth, WndTextHeight;

extern Bool Transient, IconTitle;
extern int WndMode;

extern unsigned long BgColours[XkbNumKbdGroups];
extern unsigned long FgColours[XkbNumKbdGroups];
extern unsigned long FrColours[XkbNumKbdGroups];
extern XFontStruct *GroupFonts[XkbNumKbdGroups];

extern unsigned int  BgColourCount, FgColourCount, FrColourCount;
extern unsigned int  GroupFontCount;


static Bool hasDockletSupport;
static Window wndMain=None, wndIcon=None, wndUsed=None;
static int black, white;

static Atom  WMProtAtom,  WMDelAtom;
static GC  gc;




#if WITH_IMAGE
extern  int  ImageMode;
//extern const char *wmxkb_44_xpm[], *wmxkb_54_xpm[];
extern  char *ImageDir, *ImageFileName;

static int ImageX, ImageY;
static int ImageWidth, ImageHeight;
static int ImageTextX, ImageTextY;
static int ImageTextWidth, ImageTextHeight;

static const int ImgTextX54 = 4, ImgTextY54 = 37;
static const int ImgTextWidth54 = 45, ImgTextHeight54 = 16;

static const int ImgTextX44 = 3, ImgTextY44 = 31;
static const int ImgTextWidth44 = 38, ImgTextHeight44 = 14;

static Pixmap	pmpBkgr = None;
static Pixmap	varPmpBkgr[XkbNumKbdGroups];

//static const char *OutlineColoursText[] = {"white", "light gray", "gray", "black"}; //gra#FFFFFF", "#C0C0C0", "# "#ffffff", "#c0c0c0", "#808080", "#000000"};
static const char *OutlineColoursText[] = {"#ffffff", "#c0c0c0", "#808080", "#000000"};
#define OutlineColourCount  (sizeof(OutlineColoursText)/sizeof(const char *))
static unsigned long OutlineColours[OutlineColourCount];

extern char *SymbolNames[];
extern int GroupCount;

# if HAVE_XSHAPES
#    define MASK_BKGR_PTR &maskBkgr
#    define VAR_MASK_BKGR_PTR(index) &varMaskBkgr[index]
extern Bool UseShapes;
static Pixmap maskBkgr = None;
static Pixmap varMaskBkgr[XkbNumKbdGroups];
extern int GroupTitleSource;
# else
#    define MASK_BKGR_PTR NULL
#    #define VAR_MASK_BKGR_PTR(index) NULL
# endif

#endif

//==================================================================================
static void identifyDockletSupport(void)
{

	static const char *propNames[] = { "_WINDOWMAKER_WM_PROTOCOLS", 
	                                  "_BLACKBOX_PID", "_PWM_WORKSPACE_INFO"};
	static const int propTypes[] = { XA_ATOM,
	                                   XA_CARDINAL, XA_INTEGER};
	static const int count = sizeof(propNames) / sizeof(char *);
    Atom property;
	int i;

 	hasDockletSupport = False;

	for (i=0; i<count && hasDockletSupport==False; i++) {
	    property = XInternAtom(disp, propNames[i], True);

    	if (property != None) {

	    	Atom actual_type;
	    	int actual_format;
		    unsigned long nitems, bytes_after;
    		unsigned long *data;
    
		    XGetWindowProperty(disp, wndRoot, property, 0, 1,
                 False, propTypes[i],
                 &actual_type,  &actual_format,
                 &nitems, &bytes_after, (unsigned char **)&data);

			if (actual_type != None) hasDockletSupport = True;
		}
	}
	
}    

//==================================================================================
static void processWindowGeometry(void)
{
	int gmask = WndGeometry.mask;

	WndX = WndY = 0;
	WndWidth = WndHeight = 54;
	if (gmask & WidthValue) WndWidth = WndGeometry.w;
	if (gmask & HeightValue) WndHeight = WndGeometry.h;

	WndPosExplicit = ((gmask & (XValue | YValue)) != 0);
	
	if (WndPosExplicit) {

		if ((gmask & XValue) != 0) {
			WndX  = WndGeometry.x;
			if (gmask & XNegative) 
			  WndX += DisplayWidth(disp, screen) - WndWidth;
		}	  

		if ((gmask & YValue) != 0) {
			WndY  = WndGeometry.y;
			if (gmask & YNegative) {
			  WndY += DisplayHeight(disp, screen) - WndHeight;
			  if (Transient == False) WndY -= 15;
			}
		}	
	}	
}

static void processTextGeometry(void)
{
	int gmask = TextGeometry.mask;
	Bool explicitWidth = False;

	if (gmask & WidthValue) {
		explicitWidth = True;
		WndTextWidth = TextGeometry.w;
		if (WndTextWidth > WndWidth) WndTextWidth = WndWidth;
	}
		
	if (gmask & HeightValue) {
		WndTextHeight = TextGeometry.h;
		if (WndTextHeight > WndHeight) WndTextWidth = WndHeight;
	}	
	

	if ((gmask & XValue) != 0) {
		WndTextX  = TextGeometry.x;
		WndTextWidth = TextGeometry.w;
		
		if (gmask & XNegative) 
		  	WndTextX += WndWidth - WndTextWidth;
		else
		if (!explicitWidth)
			WndTextWidth = WndWidth- 2*WndTextX;			  
	}
	
	if ((gmask & YValue) != 0) {
		WndTextY  = TextGeometry.y;
		if (gmask & YNegative) 
		  WndTextY += WndHeight - WndTextHeight;
	}	
}
//==================================================================================
#if WITH_IMAGE
static int createPixmapForFileAndDir(const char *dirName,  const char *fileName,
                     Pixmap *targetPmp,  Pixmap *targetMask, XpmAttributes *xpma_ptr)
{
	int result;
	// 1 extra for '/' and 1 for '\0'
	char *fullFileName = malloc(strlen(dirName) + strlen(fileName) + 2);
	
	if (fullFileName == NULL)	return XpmNoMemory;
	
	result = 0;
	
	if (dirName != NULL && (result = strlen(dirName)) > 0) {
		memcpy(fullFileName, dirName, result);
		if (dirName[result-1] != '/') fullFileName[result++] = '/';
	}	
	
	strcpy(fullFileName+result, fileName);		
		
	memset(xpma_ptr, '\0', sizeof(XpmAttributes));



	xpma_ptr->valuemask =
		(targetMask == NULL) ? XpmReturnPixels
		: (XpmReturnPixels | XpmReturnExtensions) ;

	result = XpmReadFileToPixmap(disp, wndRoot, fullFileName, 
				targetPmp, targetMask, xpma_ptr);

	free(fullFileName);			
	return result;
}


static int createPixmapForFileAndAltDirs(const char *dirName, const char *alternativeDirName, const char *fileName,
                     Pixmap *targetPmp,  Pixmap *targetMask, XpmAttributes *xpma_ptr)
{
	int result = createPixmapForFileAndDir(dirName, fileName, targetPmp,  targetMask, xpma_ptr);
	if (result != XpmSuccess)
		result = createPixmapForFileAndDir(alternativeDirName, fileName, targetPmp,  targetMask, xpma_ptr);
					 
	return result;					 
}

# if HAVE_XSHAPES
static void accomodateShapeMask(Pixmap shapeMask)
{
	if (shapeMask != None && GroupTitleSource != 3) {
		  XGCValues xgcv;
		  unsigned long gcmask;
		  GC bwgc;
		  
		  xgcv.function = GXcopy;
		  xgcv.plane_mask = 1;
		  xgcv.foreground =  1;
		  xgcv.background = 0;
	 
		  gcmask = GCFunction | GCPlaneMask | GCForeground | GCBackground;
		  
		  bwgc = XCreateGC(disp, shapeMask, gcmask, &xgcv);
		  if (bwgc == None) return;

		  XFillRectangle(disp, shapeMask, bwgc,  WndTextX-1, WndTextY-1, WndTextWidth+2, WndTextHeight+2);			  
		  XFreeGC(disp, bwgc);
	}
}
# endif
#endif

static Bool createPixmaps(void)
{
#if WITH_IMAGE
//	const char **img_bytes = NULL;
	int tmp;

	if (ImageMode != 0) {

		tmp = WndWidth;
		if (WndHeight < tmp) tmp = WndHeight;

		if (tmp < 44 && WndMode == 0) 
			tmp = 44;		

		if (ImageFileName == NULL) {		
			if (tmp >= 54) {
				//img_bytes = wmxkb_54_xpm;
				ImageFileName = strdup("wmxkb_54.xpm");
			}
			else
			if (tmp >= 44) {
//				img_bytes = wmxkb_44_xpm;
				ImageFileName = strdup("wmxkb_44.xpm");
			}
			else 
				ImageMode = 0;
		}		
					
	}


	if (ImageMode != 0) {
		XpmAttributes xpma;	
	
		if (createPixmapForFileAndAltDirs(ImageDir, "pixmaps", ImageFileName, &pmpBkgr, MASK_BKGR_PTR, &xpma) != XpmSuccess) {
			fprintf (stderr, "Error creating pixmap from '%s'\n", ImageFileName);
			return False;	
		}

		
		ImageWidth = xpma.width;
		ImageHeight = xpma.height;
		
		if (WndWidth >= 54 && WndHeight >= 54) {
			ImageTextX = ImgTextX54;
			ImageTextY = ImgTextY54;
			ImageTextWidth = ImgTextWidth54;
			ImageTextHeight = ImgTextHeight54;
		} else 
		if (WndWidth >= 44 && WndHeight >= 54) {
			ImageTextX = ImgTextX44;
			ImageTextY = ImgTextY44;
			ImageTextWidth = ImgTextWidth44;
			ImageTextHeight = ImgTextHeight44;
		} else {
			ImageTextX = 0;
			ImageTextY = 0;
			ImageTextWidth = ImageWidth;
			ImageTextHeight = ImageHeight;
		}
		
		// We either centre, or right/bottom align the image	
		//ImageX = WndWidth - ImageWidth;
		//if (ImageX > 0) ImageX >>= 1;

		//ImageY = WndHeight - ImageHeight;
		//if (ImageY > 0) ImageY >>= 1;
		ImageX = 0;
		ImageY = 0;

		WndTextX = ImageTextX + ImageX;
		WndTextY = ImageTextY + ImageY;
	
		WndTextWidth = ImageTextWidth;
		WndTextHeight = ImageTextHeight;

# if HAVE_XSHAPES
		accomodateShapeMask(maskBkgr);
# endif		
		
		
	} else
#endif   // HAVE_IMAGE
	{
		WndTextX = 0;
		WndTextY = 0;
		WndTextWidth = WndWidth;
		WndTextHeight = WndHeight;
	}

	processTextGeometry();		

	return True;
				
}
#if WITH_IMAGE
void createVariablePixmaps()
{
	char *symbName, *suffix = NULL;
	char *sep;
	char RealFileName[127];
	XpmAttributes xpma;	
	Bool success;
	int i;

	for (i=0; i < XkbNumKbdGroups;  i++)	{
		varPmpBkgr[i] = None;
# if HAVE_XSHAPES
		varMaskBkgr[i] = None;
#endif		
	}	

	if (ImageMode == 2) {
		if (ImageWidth >= 54 && ImageHeight >= 54) 
			suffix = "54.xpm";
		else
		if (ImageWidth >= 44 && ImageHeight >= 44) 
			suffix = "44.xpm";
	}
	
	if (suffix == NULL)	return;
		
	
	for (i=0; i < GroupCount;  i++)	{
		symbName = SymbolNames[i];
		if (symbName == NULL) continue;
		sprintf(RealFileName, "%s%s", symbName, suffix);
	
		success = (createPixmapForFileAndAltDirs(ImageDir, "pixmaps", RealFileName, &varPmpBkgr[i], VAR_MASK_BKGR_PTR(i), &xpma) == XpmSuccess);

		if (success == False && (sep = strchr(RealFileName, '_')) != NULL) {
			strcpy(sep, suffix);
			success = (createPixmapForFileAndAltDirs(ImageDir, "pixmaps", RealFileName, &varPmpBkgr[i], VAR_MASK_BKGR_PTR(i), &xpma) == XpmSuccess);
		}

		if (success == False) {
			fprintf(stderr, "Error creating pixmap from '%s'\n", RealFileName);
			varPmpBkgr[i] = None;
# if HAVE_XSHAPES
			varMaskBkgr[i] = None;
#endif		
		}
# if HAVE_XSHAPES
		else
			accomodateShapeMask(varMaskBkgr[i]);		
#endif		
		
	}

}
#endif

//==================================================================================
#if WITH_IMAGE
void initOutlineColours(void)
{
	int i;
	XColor xc_exact, xc_screen;

	for (i=0; i<OutlineColourCount; i++) {
		if (XAllocNamedColor(disp, cmap, OutlineColoursText[i], &xc_exact, &xc_screen))
			OutlineColours[i] = xc_screen.pixel;
		else
			OutlineColours[i] = black;
			
	}	

}
#endif


Bool initX11(void)
{
	
  // wndRoot and screen	has been defined in identifyWindowMaker

//  depth = DefaultDepth(disp, screen);
	screen  = DefaultScreen(disp);
	wndRoot = RootWindow(disp, screen);
	black = BlackPixel(disp, screen);
	white = WhitePixel(disp, screen);
	cmap = DefaultColormap(disp, screen);    

	identifyDockletSupport();
#if WITH_IMAGE
	initOutlineColours();
#endif	
	return True;
}
	


Bool prepareX11(int argc, char **argv)
{


	XClassHint xch;
	XGCValues xgcv;
	XWMHints xwmh;
	XSizeHints xsh;
	XTextProperty tpname;
	char *classname;
	const char *progname;
//  int depth;

    

	//------------------------------------------------------------------------
	// Creating pixmaps and windows

	progname = argv[0];
	classname = strrchr(progname, '/');
	if (classname) progname = classname+1;

	processWindowGeometry();


	if (!createPixmaps()) return False;

#if WITH_IMAGE
	createVariablePixmaps();
#endif


	wndMain = XCreateSimpleWindow(disp, wndRoot,
			 WndX, WndY, WndWidth, WndHeight, 1, white, black);
	if (wndMain == None) return False;

	XSetCommand(disp, wndMain, argv, argc);

	if (XStringListToTextProperty((char **)&progname, 1, &tpname)) {
		XSetWMName(disp, wndMain, &tpname);
		XSetWMIconName(disp, wndMain, &tpname);
	}

	if (WndMode < 0 || WndMode > 2)
		WndMode = hasDockletSupport ? 0 : 1;
		
	if (WndMode == 0)
	{
	    wndIcon = XCreateSimpleWindow(disp, wndMain,
		          0, 0, WndWidth, WndHeight, 1, white, black);
		if (wndIcon == None) return False;
		wndUsed = wndIcon;

	} else {	  
/*	
		if (WndMode == 0) {
			Atom r;
			int data = 1;
      	
			r = XInternAtom(disp, "KWM_DOCKWINDOW", False);
			if (r != None)
 	    	   XChangeProperty(disp, wndMain, r, r, 32, 0, (unsigned char *)&data, 1);

			r = XInternAtom(disp, "_KDE_NET_WM_SYSTEM_TRAY_WINDOW_FOR", False);
			if (r != None)
	    	     XChangeProperty(disp, wndMain, r, XA_WINDOW, 32, 0, (unsigned char *)&data, 1);
		}						   
*/			   

		wndIcon = None;
		wndUsed = wndMain;
		
#if HAVE_XSHAPES 
		UseShapes = False; 
#endif

	    if (Transient)
			XSetTransientForHint(disp, wndMain, wndRoot);
	}
    	


		
	xch.res_name = (char *)progname;
	classname = strdup(progname);
	*classname = toupper(*classname);
	*(classname+1) = toupper(*(classname+1));
	xch.res_class = classname;
	XSetClassHint(disp, wndMain, &xch);
	free(classname);

	/* Create GC for drawing */
	xgcv.function = GXcopy;
	xgcv.foreground = white;
//	xgcv.background = FrColours[CurrentGroupResNo % FrColourCount];
	xgcv.background = black;

	xgcv.graphics_exposures = 0;
	gc = XCreateGC(disp, wndRoot,
	     GCFunction | GCForeground  | GCBackground | GCGraphicsExposures, &xgcv);

	//-------------------------------------------------------------------------------------

	xsh.height = WndHeight;
	xsh.width = WndWidth;
	xsh.min_height = WndHeight;
	xsh.min_width = WndWidth;
	xsh.max_height = WndHeight;
	xsh.max_width = WndWidth;
	xsh.base_height = WndHeight; 
	xsh.base_width = WndWidth;
	xsh.flags =   USSize | PMinSize | PMaxSize | PBaseSize;

	
	if (WndPosExplicit) {
		xsh.x = WndX;	/* Though it's obsolete I don't see another way */
		xsh.y = WndY;   /* of preventing wmaker & fvwm from mouse placement */
		xsh.flags |=  (USPosition | PPosition) ;
	}

  
	XSetWMNormalHints(disp, wndUsed, &xsh);

	if (WndPosExplicit)
		XMoveWindow(disp, wndUsed, WndX, WndY);	

	//-------------------------------------------------------------------------------------

	if (wndUsed == wndIcon)	{ 
		xsh.x = 0; xsh.y = 0;
		xsh.flags =  USPosition;
		XSetWMNormalHints(disp, wndMain, &xsh);
		XMoveWindow(disp, wndMain, 0, 0);
	}	
  

	WMProtAtom = XInternAtom(disp, "WM_PROTOCOLS", True);
	WMDelAtom = XInternAtom(disp, "WM_DELETE_WINDOW", True);
    
	if (WMProtAtom != (Atom)None && WMDelAtom != (Atom)None)
        XSetWMProtocols(disp, wndMain, &WMDelAtom, 1);

	if (WndMode == 2) {
		xwmh.flags =  StateHint;
    	xwmh.initial_state = IconicState;
	    XSetWMHints(disp, wndMain, &xwmh);
	}
	else
	if (wndIcon != None)  {
		xwmh.flags =  StateHint |  IconWindowHint | IconPositionHint | WindowGroupHint; 
	//	xwmh.flags =   IconWindowHint;
    	xwmh.initial_state = WithdrawnState;
    	xwmh.icon_window = wndIcon;
	    xwmh.icon_x = 0;
		xwmh.icon_y = 0;
	    xwmh.window_group = wndMain;
	
    	XSetWMHints(disp, wndMain, &xwmh);
	}	

	XSetWindowBackgroundPixmap(disp, wndUsed, None);
	XSelectInput(disp, wndUsed, ButtonPressMask | ExposureMask);
	/*ButtonReleaseMask | PointerMotionMask | StructureNotifyMask); */
    
   
	return True;
}



void deinitX11(void)
{
#if WITH_IMAGE
	int i;
#endif	


	if (wndIcon)
	{
		XDestroyWindow (disp, wndIcon);
		wndIcon = None;
	}	

	if (wndMain != None)
	{
		XDestroyWindow (disp, wndMain);
		wndMain = None;
	}	

	if (gc != None)
	{
		XFreeGC(disp, gc);
		gc = None;
	}	

#if WITH_IMAGE
	for (i=0; i < GroupCount;  i++)	{
		if (varPmpBkgr[i] != None) {
			XFreePixmap(disp, varPmpBkgr[i]);
			varPmpBkgr[i] = None;
		}
# if HAVE_XSHAPES
		if (varMaskBkgr[i] != None) {
			XFreePixmap(disp, varMaskBkgr[i]);
			varMaskBkgr[i] = None;
		}
#endif		
	}

	if (pmpBkgr != None) {
  		XFreePixmap(disp, pmpBkgr);
	  	pmpBkgr = None;
	}		

#if HAVE_XSHAPES 
	if (maskBkgr != None) {
		XFreePixmap(disp, maskBkgr);
		maskBkgr = None;
	}		
#endif
  
#endif
    
}

Bool drawGroupName(Window wnd)
{
	unsigned long bkgrColour;

	const char *str;


	
//  xfs = XLoadQueryFont(disp, FontName);
	
#if WITH_IMAGE
	if (pmpBkgr != None) {	
		XRectangle rect;

		// Draw a (sort of) 3D frame
		XSetForeground(disp, gc, OutlineColours[0]);
		XDrawPoint(disp, wnd, gc, WndTextX-1, WndTextY-1);

		XSetForeground(disp, gc, OutlineColours[1]);
		XDrawLine(disp, wnd, gc, WndTextX, WndTextY-1, WndTextX+WndTextWidth-1, WndTextY-1);	// Upper
		XDrawLine(disp, wnd, gc, WndTextX-1, WndTextY, WndTextX-1, WndTextY+WndTextHeight-1);   // Left
				
		XSetForeground(disp, gc, OutlineColours[2]);
		XDrawLine(disp, wnd, gc, WndTextX-1, WndTextY+WndTextHeight, WndTextX+WndTextWidth-1, WndTextY+WndTextHeight);	// Bottom
		XDrawLine(disp, wnd, gc, WndTextX+WndTextWidth, WndTextY-1, WndTextX+WndTextWidth, WndTextY+WndTextHeight-1);   // Right

		XSetForeground(disp, gc, OutlineColours[3]);
		XDrawPoint(disp, wnd, gc, WndTextX+WndTextWidth, WndTextY+WndTextHeight);
	
		rect.x = WndTextX; rect.y = WndTextY;
		rect.width = WndTextWidth;	
		rect.height = WndTextHeight;	
		XSetClipRectangles(disp, gc, 0, 0, &rect, 1, Unsorted);
	}	
#endif		
  //if (xfs == None) 

	bkgrColour = BgColours[CurrentGroupResNo % BgColourCount];
	XSetBackground(disp, gc, bkgrColour);
	XSetForeground(disp, gc, bkgrColour);

	XFillRectangle(disp, wnd, gc, 0, 0, WndWidth, WndHeight);


	str = getCurrentGroupName();
	if (str != NULL) {
		XFontStruct *xfs;
		int ascent, descent, height;
		int  len;
		int x, y, yoff;
	
		xfs = GroupFonts[CurrentGroupResNo % GroupFontCount];
  
		ascent = xfs->ascent;
		descent = xfs->descent;
		height = ascent + descent;
		yoff = (14 - height) / 2;
  
	
		XSetFont(disp, gc, xfs->fid);


		XSetForeground(disp, gc, FgColours[CurrentGroupResNo % FgColourCount]);

		len = strlen(str);
		x = WndTextX + (WndTextWidth - XTextWidth(xfs, str, len)) / 2; 
		y = WndTextY + (WndTextHeight-height) / 2 + ascent;

	    XDrawString(disp, wnd, gc, x, y, str, len); 
	}	

	

     
#if WITH_IMAGE
	if (pmpBkgr != None) XSetClipMask(disp, gc, None);
#endif		

  
	return True;
}

#if WITH_IMAGE
static void drawBackground(Window wnd)
{
	Pixmap pmp = varPmpBkgr[CurrentGroupXKBNo];

#if HAVE_XSHAPES 
	Pixmap pmpMask = varMaskBkgr[CurrentGroupXKBNo];
#endif
	
	if (pmp == None) { 
		pmp = pmpBkgr;	
#if HAVE_XSHAPES 
		pmpMask = maskBkgr;
#endif
	}

	if (pmp == None) return;
   	
   	if (WndWidth >= WndTextWidth || WndHeight >= WndTextHeight) {
		unsigned long bkgrColour = FrColours[CurrentGroupResNo % FrColourCount];
		XSetBackground(disp, gc, bkgrColour);
		XSetForeground(disp, gc, bkgrColour);
		XFillRectangle(disp, wndUsed, gc, 0, 0, WndWidth, WndHeight);
	}   

#if HAVE_XSHAPES 
	if (pmpMask != None) {	 
		int tmp;
		if (UseShapes && XShapeQueryExtension(disp, &tmp, &tmp)) 
			XShapeCombineMask(disp, wndUsed, ShapeBounding, 0, 0, pmpMask, ShapeSet);
	}			 
#endif

	XCopyArea(disp, pmp, wnd, gc, 0, 0,
        		 ImageWidth, ImageHeight,  ImageX, ImageY);
}				 
#endif				

static Bool processExposure(XExposeEvent *xexpose)
{

	if (xexpose->count == 0)  {
		Window wnd = xexpose->window;
		
#if WITH_IMAGE
		drawBackground(wnd);
#endif			
		drawGroupName(wnd);
	}	

	return False;		// Don't leave
	
}

static Bool processButtonPress(XButtonEvent *xbutton)
{
	int btn = xbutton->button;

	if (btn == Button2  ||
	   (btn == Button3 && (xbutton->state & ControlMask) != 0 ))
		return True;		// Terminate
		
	if (btn == Button1 || btn == Button3) {
		if (changeGroup(btn==Button3 ? 1 : -1))
			 invalidateWindow();
	}

	return False;

}
	

Bool processEventX11 (XEvent *xev)
{
	switch(xev->type) {
		case Expose:
			return processExposure((XExposeEvent *)xev);
			

		case ButtonPress:
			return processButtonPress((XButtonEvent *)xev);
							   
				
		case ClientMessage:
			if (xev->xclient.message_type == WMProtAtom &&	
    		    xev->xclient.data.l[0] == WMDelAtom)
			  return True;
	}

	return False;
}

void processGroupX11(void)
{
//	XSetBackground(disp, wndUsed, FrColours[CurrentGroupResNo % FrColourCount]);
	invalidateWindow();
}



void invalidateWindow(void)
{
	XClearArea(disp, wndUsed, 0, 0, 0, 0, True);
}

void showIt(void)
{
    if (disp != NULL && wndMain != None && wndUsed != None)
    {
    	XMapWindow(disp, wndMain);
    	drawGroupName(wndUsed);
		XFlush(disp);
    }	
}

void updateIconTitle(void)
{
	if (IconTitle) {
		const char *grpName = getCurrentGroupName();
		XTextProperty tpname;
	
		if (XStringListToTextProperty((char **) &grpName, 1, &tpname)) 
			XSetWMIconName(disp, wndMain, &tpname);
	
	}
}
