#ifndef _WNMXKB_H_
#define _WNMXKB_H_

#include "wmxkb_conf.h"

#include <X11/Xlib.h>

#if HAVE_X11_XKBLIB_H
# include <X11/XKBlib.h>
#elif HAVE_X11_EXTENSIONS_XKBLIB_H
# include <X11/extensions/XKBlib.h>
#endif

#define StoredGroupCount 100

typedef struct
{
	unsigned int scan;
	unsigned int modifier;
	Status	active;
} FunctionKey;

typedef struct
{
	int mask;
	int x, y, w, h;
} GeometryInfo;


// From wmxkbg.c
Status runScriptNow(const char * cmdline); 

// From wmxkbg_x11.c
Bool changeGroup(int increment);
Bool initX11(void);
Bool prepareX11(int argc, char **argv);
void deinitX11(void);
void processGroupX11(void);
Bool processEventX11(XEvent *xev);
void invalidateWindow(void);
void updateIconTitle(void);
void showIt();


// From wmxkbg_xkb.c
void ringBell(int volume);
Bool initXKB(void);
void deinitXKB(void);
Bool prepareXKB(void);
const char *getGroupName(int groupNo); 
const char *getCurrentGroupName(void);
Bool processEventXKB(XkbEvent *xkbev);
Bool processFunctionKey(XEvent *xkey);
void accomodateGroupXKB(void);


// From wmxkbg_xrm.c
Bool initXrm();
void deinitXrm();
Bool processNonStoredOptionsXrm(int *argc, char **argv);
Bool processOptionsXrm(int *argc, char **argv);


// From wmxkbg_fnt.c
# if HAVE_FSLIB
Bool initFontServer(void);
void deinitFontServer(void);
# endif
char **getFontPaths(int *count);
void setFontPaths(int count, char **allPaths);


#endif
