
#include <stdio.h>
#include <string.h>

#include "gamepick.h"
#include "read_line.h"
#include "edits.h"


typedef struct
{
  FILE *file;
  GString *error;
} save_struct;


void save_line (save_struct *context, const gchar *text)
{
  size_t actual, count;
  
  if (text_here (context->error))
    return;
  
  actual = strlen (text);
  if (actual <= 0)
    return;
  
  count = fwrite (text, 1, strlen (text), context->file);
  if (count != actual)
    g_string_assign (context->error, "Could not write all of buffer");
}


void save_value (save_struct *context, const gchar *key, const GString *value)
{
  GString *line;
  
  if (!text_here (value))
    return;
  
  line = g_string_new (NULL);
  g_string_sprintf (line, "%s: %s\n", key, value->str);
  save_line (context, line->str);
  g_string_free (line, TRUE);
}


gchar* bool_text (gboolean value)
{
  if (value)
    return "true";
  else
    return "false";
}


const gchar* save_all (const gamepick_info *info)
{
  tab_struct *tab;
  game_struct *game;
  save_struct context;
  gint tab_number, game_number, index;
  GString *conf_file, *line, *icon_save_dir;

  context.error = g_string_new (NULL);

  if (!text_here (info->conf_file))
    g_string_assign (context.error, "No save file");
  else
  {
    context.file = fopen (info->conf_file->str, "w");
    if (!context.file)
      g_string_assign (context.error, "No write permission");
  }

  /* if there has been an error save_line won't write any more output */
    
  line = g_string_new (NULL);
  icon_save_dir = g_string_new ("");

  for (index = 0; index < g_list_length (info->auto_find_list); index++)
  {
    conf_file = (GString*) g_list_nth (info->auto_find_list, index)->data;
    g_string_sprintf (line, "auto find: %s\n", conf_file->str);
    save_line (&context, line->str);
  }

  g_string_sprintf (line, "options: %d\n", info->options_enabled);
  save_line (&context, line->str);
  g_string_sprintf (line, "debug: %d\n", info->debug_window);
  save_line (&context, line->str);
  g_string_sprintf (line, "config fallback: %d\n", info->conf_fallback_enabled);
  save_line (&context, line->str);

  save_line (&context, "\n");
  
  for (tab_number = 0; tab_number < info->tab_count; tab_number++)
  {
    if (text_here (context.error))
      break;

    tab = (tab_struct*) g_list_nth (info->tab_list, tab_number)->data;
    g_string_sprintf (line, "tab: %s\n\n", tab->tab_name->str);
    save_line (&context, line->str);
    
    for (game_number = 0; game_number < tab->game_count; game_number++)
    {
      if (text_here (context.error))
        break;

      game = (game_struct*) g_list_nth (tab->game_list, game_number)->data;
      save_value (&context, "name", game->name);
      save_value (&context, "start dir", game->start_dir);
      save_value (&context, "cmd", game->cmd);
      
      if (text_here (game->icon))
      {
        if (strcmp (find_parent_dir (game->icon->str), icon_save_dir->str))
        {
          g_string_assign (icon_save_dir, find_parent_dir (game->icon->str));
          g_string_sprintf (line, "icon dir: %s\n", icon_save_dir->str);
          save_line (&context, line->str);
        }
        g_string_sprintf (line, "icon: %s\n", find_filename (game->icon->str));
        save_line (&context, line->str);
      }
      
      g_string_sprintf (line, "fsaa: %d\n", game->fsaa);
      save_line (&context, line->str);
      g_string_sprintf (line, "aitf: %d\n", game->aitf);
      save_line (&context, line->str);
      if (game->syncvblank)
        save_line (&context, "syncvblank: 1\n");
      else
        save_line (&context, "syncvblank: 0\n");
      save_line (&context, "\n");
    }
  }

  if (context.file) 
    fclose (context.file);
  if (!text_here (context.error))
    return NULL; /* no error */
  else
    return context.error->str;
}


void save_config (gamepick_info *info)
{
  GString *message;
  const gchar *result;

  message = g_string_new (NULL);
  
  result = save_all (info);
  if (result == NULL)
    return;

  if (info->conf_fallback_enabled && text_here (info->home_conf))
  {
    g_string_assign (info->conf_file, info->home_conf->str);
    result = save_all (info);
    if (result == NULL)
      return;
  }

  g_string_sprintf (message,
    "Error during save:\n\n%s\n\n"
    "The configuration file gamepick is using is:\n\n%s\n\n"
    "(Path may be relative to current working directory.)\n"
    , result, info->conf_file->str);
  show_notice (message->str, info->main_window);
}

