
#include <stdlib.h>

#include <gtk/gtk.h>

#include "gamepick.h"
#include "play_choice.h"
#include "load_lists.h"
#include "read_line.h"


int main (int argc, char *argv[])
{
  gamepick_info *info;
  gboolean spawn_xterm;
  GString *cmdline;
  
  gtk_init (&argc, &argv);

  info = g_malloc0 (sizeof (gamepick_info));
  info->argc = argc;
  info->argv = argv;
  
  info->warnings = g_string_new (NULL);
  find_conf (info);
  first_parse (info);
  
  spawn_xterm = FALSE;
  if (cmdline_option (info, "-d"))
    spawn_xterm = TRUE;
  else
  {
    if (info->debug_window)
      spawn_xterm = TRUE;
  }
  if (cmdline_option (info, "-e"))
    spawn_xterm = FALSE;

  if (spawn_xterm)
  {
    warnings (info, "c");
    cmdline = g_string_new (NULL);
    g_string_sprintf (cmdline,
      "xterm -r -e %s -e -c %s &", info->argv [0], info->conf_file->str);
    system (cmdline->str);
    return 0; /* not gtk_quit */
  }

  info->main_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (info->main_window), "Gamepick");

  reset_gamepick_info (info);
  play_choice (info);
  gtk_widget_show (info->main_window);
  warnings (info, "cx0");
  gtk_main();
  return 0;
}
