/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.ssl.cert;

import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.OID;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public enum PublicKeyAlgorithmIdentifier {
    RSA("1.2.840.113549.1.1.1", "RSA"),
    DSA("1.2.840.10040.4.1", "DSA"),
    DIFFIE_HELLMAN("1.2.840.10046.2.1", "DiffieHellman"),
    EC("1.2.840.10045.2.1", "EC");

    @NotNull
    private final OID oid;
    @NotNull
    private final String name;

    private PublicKeyAlgorithmIdentifier(String oidString, String name) {
        this.name = name;
        this.oid = new OID(oidString);
    }

    @NotNull
    public OID getOID() {
        return this.oid;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public static PublicKeyAlgorithmIdentifier forOID(@NotNull OID oid) {
        for (PublicKeyAlgorithmIdentifier v : PublicKeyAlgorithmIdentifier.values()) {
            if (!v.oid.equals(oid)) continue;
            return v;
        }
        return null;
    }

    @Nullable
    public static PublicKeyAlgorithmIdentifier forName(@NotNull String name) {
        String preparedName = PublicKeyAlgorithmIdentifier.prepareName(name);
        for (PublicKeyAlgorithmIdentifier v : PublicKeyAlgorithmIdentifier.values()) {
            if (!v.name.equalsIgnoreCase(preparedName)) continue;
            return v;
        }
        return null;
    }

    @NotNull
    private static String prepareName(@NotNull String name) {
        StringBuilder buffer = new StringBuilder(name.length());
        block3: for (char c : name.toCharArray()) {
            switch (c) {
                case ' ': 
                case '-': 
                case '_': {
                    continue block3;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
        return buffer.toString();
    }

    @NotNull
    public static String getNameOrOID(@NotNull OID oid) {
        PublicKeyAlgorithmIdentifier id = PublicKeyAlgorithmIdentifier.forOID(oid);
        if (id == null) {
            return oid.toString();
        }
        return id.name;
    }

    @NotNull
    public String toString() {
        return this.name;
    }
}

