/* 
    TowBowlTactics: Strategy game for X11

    Copyright (C) 2001 Pascal Bourut (toweld@rocketmail.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef SCREEN_H
#define SCREEN_H


#include "global.h"
#include "Config.h"
#include "Console.h"

#ifndef NOSOUND
#include "SoundPlayer.h"
#endif

#ifndef NONET
#include "Network.h"
#include "NetClient.h"
#include "NetServer.h"
#endif

#include <SDL/SDL.h>
#ifndef _SDL_H
	#include <SDL.h>
#endif

#include <SDL/SDL_image.h>
#ifndef _IMG_h
	#include <SDL_image.h>
#endif

#define ALL_SCREENS -2
#define SCREEN_NONE -1
#define SCREEN_TITLE 0
#define SCREEN_CREDITS 1
#define SCREEN_END 2
#define SCREEN_VS 3
#define SCREEN_TEAM_SELECTOR 4
#define SCREEN_OPTIONS 5
#define SCREEN_NETWORK 6

#define SCREEN_LOAD 10

#define SCREEN_WIDTH 800
#define SCREEN_HEIGHT 600

#define SCREEN_FPS 15

#define SCREEN_MARGIN_W ((Config::get_screen_w() - SCREEN_WIDTH)/2)
#define SCREEN_MARGIN_H ((Config::get_screen_h() - SCREEN_HEIGHT)/2)

#define TITLE_LEFT_BTN_X (8 + SCREEN_MARGIN_W) 
#define TITLE_LEFT_BTN_Y (331 + SCREEN_MARGIN_H) 
#define TITLE_LEFT_BTN_W 335
#define TITLE_LEFT_BTN_H 240

#define TITLE_RIGHT_BTN_X (451 + SCREEN_MARGIN_W)
#define TITLE_RIGHT_BTN_Y (329 + SCREEN_MARGIN_H)
#define TITLE_RIGHT_BTN_W 265
#define TITLE_RIGHT_BTN_H 220 

#define QUICK_GAME_BTN_W TITLE_LEFT_BTN_W
#define QUICK_GAME_BTN_H 38
#define QUICK_GAME_BTN_X TITLE_LEFT_BTN_X
#define QUICK_GAME_BTN_Y TITLE_LEFT_BTN_Y

#define EXHIBITION_BTN_W TITLE_LEFT_BTN_W
#define EXHIBITION_BTN_H 47
#define EXHIBITION_BTN_X TITLE_LEFT_BTN_X
#define EXHIBITION_BTN_Y QUICK_GAME_BTN_Y+QUICK_GAME_BTN_H

#define NEW_LEAGUE_BTN_W TITLE_LEFT_BTN_W
#define NEW_LEAGUE_BTN_H 66
#define NEW_LEAGUE_BTN_X TITLE_LEFT_BTN_X
#define NEW_LEAGUE_BTN_Y EXHIBITION_BTN_Y+EXHIBITION_BTN_H

#define NEW_CUP_BTN_W TITLE_LEFT_BTN_W
#define NEW_CUP_BTN_H 91
#define NEW_CUP_BTN_X TITLE_LEFT_BTN_X
#define NEW_CUP_BTN_Y NEW_LEAGUE_BTN_Y+NEW_LEAGUE_BTN_H

#define LOAD_GAME_BTN_W TITLE_RIGHT_BTN_W
#define LOAD_GAME_BTN_H 40
#define LOAD_GAME_BTN_X TITLE_RIGHT_BTN_X
#define LOAD_GAME_BTN_Y TITLE_RIGHT_BTN_Y

#define OPTIONS_BTN_W TITLE_RIGHT_BTN_W
#define OPTIONS_BTN_H 47
#define OPTIONS_BTN_X TITLE_RIGHT_BTN_X
#define OPTIONS_BTN_Y LOAD_GAME_BTN_Y+LOAD_GAME_BTN_H

#define NETWORK_BTN_W TITLE_RIGHT_BTN_W
#define NETWORK_BTN_H 61
#define NETWORK_BTN_X TITLE_RIGHT_BTN_X
#define NETWORK_BTN_Y OPTIONS_BTN_Y+OPTIONS_BTN_H

#define CREDITS_BTN_W TITLE_RIGHT_BTN_W
#define CREDITS_BTN_H 91
#define CREDITS_BTN_X TITLE_RIGHT_BTN_X
#define CREDITS_BTN_Y NETWORK_BTN_Y+NETWORK_BTN_H

#define BACK_BTN_X (368 + SCREEN_MARGIN_W)
#define BACK_BTN_Y (509 + SCREEN_MARGIN_H)
#define BACK_BTN_W 139
#define BACK_BTN_H 88

#define VS_INSTRUCTIONS_X (133 + SCREEN_MARGIN_W)
#define VS_INSTRUCTIONS_Y (511 + SCREEN_MARGIN_H)
#define VS_INSTRUCTIONS_W 527
#define VS_INSTRUCTIONS_H 89

#define VS_BTN_X (328 + SCREEN_MARGIN_W)
#define VS_BTN_Y (262 + SCREEN_MARGIN_H)
#define VS_BTN_W 142
#define VS_BTN_H 106

#define CREDITS_BACK_BTN_X (12 + SCREEN_MARGIN_W)
#define CREDITS_BACK_BTN_Y (510 + SCREEN_MARGIN_H)

#define OPTIONS_X (272 + SCREEN_MARGIN_W) 
#define OPTIONS_Y (169 + SCREEN_MARGIN_H)

#define RES_Y (OPTIONS_Y + 43)
#define RES_MIN_X (OPTIONS_X)
#define RES_MED_X (OPTIONS_X + 95)
#define RES_MAX_X (OPTIONS_X + 206) 
#define RES_SIZE (17)

#define SOUND_Y (OPTIONS_Y + 147)
#define SOUND_ENABLE_X (OPTIONS_X + 60)
#define SOUND_DISABLE_X (OPTIONS_X + 162) 
#define SOUND_SIZE (17)

#define VIDEO_Y (OPTIONS_Y + 232)
#define VIDEO_ENABLE_X (OPTIONS_X + 60)
#define VIDEO_DISABLE_X (OPTIONS_X + 162)
#define VIDEO_SIZE (17)

#define LANGUAGE_Y (OPTIONS_Y + 320)
#define LANGUAGE_FR_X (OPTIONS_X + 60)
#define LANGUAGE_EN_X (OPTIONS_X + 162)
#define LANGUAGE_SIZE (17)

#define NET_SERVER_X (232 + SCREEN_MARGIN_W)
#define NET_CLIENT_X (545 + SCREEN_MARGIN_W) 
#define NET_TYPE_Y (161 + SCREEN_MARGIN_H)
#define NET_SIZE (17)

#define EXIT_BTN_X (676 + SCREEN_MARGIN_W)
#define EXIT_BTN_Y (509 + SCREEN_MARGIN_H)
#define EXIT_BTN_W 119
#define EXIT_BTN_H 88

#define HOME_EMBLEM_X (79 + SCREEN_MARGIN_W)
#define HOME_EMBLEM_Y (184 + SCREEN_MARGIN_H)
#define VISITOR_EMBLEM_X (506 + SCREEN_MARGIN_W)
#define VISITOR_EMBLEM_Y (184 + SCREEN_MARGIN_H)
#define EMBLEM_W 210
#define EMBLEM_H 280

#define VS_HOME_X (0 + SCREEN_MARGIN_W)
#define VS_HOME_Y (470 + SCREEN_MARGIN_H)
#define VS_HOME_W 380
#define VS_HOME_H 38
#define VS_VISITOR_X (420 + SCREEN_MARGIN_W)
#define VS_VISITOR_Y (470 + SCREEN_MARGIN_H)
#define VS_VISITOR_W 380
#define VS_VISITOR_H 38

#define READY_BTN_X (356+SCREEN_MARGIN_W)
#define READY_BTN_Y (400+SCREEN_MARGIN_H)
#define READY_BTN_W 80
#define READY_BTN_H 39

#define CREDITS_MAX_HIGH 400
#define CREDITS_NAMES_W 422
#define CREDITS_NAMES_H 400
#define CREDITS_NAMES_X ((((SCREEN_WIDTH)-(CREDITS_NAMES_W))/2)+(SCREEN_MARGIN_W))
#define CREDITS_NAMES_Y (150 + SCREEN_MARGIN_H)

#define NET_CONSOLE_X (190+SCREEN_MARGIN_W)
#define NET_CONSOLE_Y (516+SCREEN_MARGIN_H)
#define NET_CONSOLE_WIDTH (574) 
#define NET_CONSOLE_HEIGHT (78)

#define NOP 0
#define QUICK_GAME 1
#define EXHIBITION 2
#define NEW_LEAGUE 3
#define NEW_CUP 4
#define LOAD_GAME 5
#define OPTIONS 6
#define NETWORK 7
#define CREDITS 8
#define EXIT 9
#define BACK 10

#define OVER_QUICK_GAME_BTN(a,b) ((a>(QUICK_GAME_BTN_X+92))&&(a<(QUICK_GAME_BTN_X+QUICK_GAME_BTN_W))&&(b>QUICK_GAME_BTN_Y)&&(b<(QUICK_GAME_BTN_Y+QUICK_GAME_BTN_H)))
#define OVER_EXHIBITION_BTN(a,b) ((a>(EXHIBITION_BTN_X+84))&&(a<(EXHIBITION_BTN_X+EXHIBITION_BTN_W))&&(b>EXHIBITION_BTN_Y)&&(b<(EXHIBITION_BTN_Y+EXHIBITION_BTN_H)))
#define OVER_NEW_LEAGUE_BTN(a,b) ((a>NEW_LEAGUE_BTN_X)&&(a<(NEW_LEAGUE_BTN_X+NEW_LEAGUE_BTN_W))&&(b>NEW_LEAGUE_BTN_Y)&&(b<(NEW_LEAGUE_BTN_Y+NEW_LEAGUE_BTN_H)))
#define OVER_NEW_CUP_BTN(a,b) ((a>(NEW_CUP_BTN_X+23))&&(a<(NEW_CUP_BTN_X+NEW_CUP_BTN_W))&&(b>NEW_CUP_BTN_Y)&&(b<(NEW_CUP_BTN_Y+NEW_CUP_BTN_H)))
#define OVER_LOAD_GAME_BTN(a,b) ((a>LOAD_GAME_BTN_X)&&(a<(LOAD_GAME_BTN_X+LOAD_GAME_BTN_W-42))&&(b>LOAD_GAME_BTN_Y)&&(b<(LOAD_GAME_BTN_Y+LOAD_GAME_BTN_H)))
#define OVER_OPTIONS_BTN(a,b) ((a>OPTIONS_BTN_X)&&(a<(OPTIONS_BTN_X+OPTIONS_BTN_W-65))&&(b>OPTIONS_BTN_Y)&&(b<(OPTIONS_BTN_Y+OPTIONS_BTN_H)))
#define OVER_NETWORK_BTN(a,b) ((a>NETWORK_BTN_X)&&(a<(NETWORK_BTN_X+NETWORK_BTN_W))&&(b>NETWORK_BTN_Y)&&(b<(NETWORK_BTN_Y+NETWORK_BTN_H)))
#define OVER_CREDITS_BTN(a,b) ((a>CREDITS_BTN_X)&&(a<(CREDITS_BTN_X+CREDITS_BTN_W))&&(b>CREDITS_BTN_Y)&&(b<(CREDITS_BTN_Y+CREDITS_BTN_H)))
#define OVER_BACK_BTN(a,b) ((a>BACK_BTN_X)&&(a<(BACK_BTN_X+BACK_BTN_W))&&(b>BACK_BTN_Y)&&(b<(BACK_BTN_Y+BACK_BTN_H)))
#define OVER_EXIT_BTN(a,b) ((a>EXIT_BTN_X)&&(a<(EXIT_BTN_X+EXIT_BTN_W))&&(b>EXIT_BTN_Y)&&(b<(EXIT_BTN_Y+EXIT_BTN_H)))
#define OVER_CREDITS_BACK_BTN(a,b) ((a>CREDITS_BACK_BTN_X)&&(a<(CREDITS_BACK_BTN_X+BACK_BTN_W))&&(b>CREDITS_BACK_BTN_Y)&&(b<(CREDITS_BACK_BTN_Y+BACK_BTN_H)))

#define OVER_RESOLUTION_MIN(a,b) ((a>RES_MIN_X)&&(a<(RES_MIN_X+RES_SIZE))&&(b>RES_Y)&&(b<(RES_Y+RES_SIZE)))
#define OVER_RESOLUTION_MED(a,b) ((a>RES_MED_X)&&(a<(RES_MED_X+RES_SIZE))&&(b>RES_Y)&&(b<(RES_Y+RES_SIZE)))
#define OVER_RESOLUTION_MAX(a,b) ((a>RES_MAX_X)&&(a<(RES_MAX_X+RES_SIZE))&&(b>RES_Y)&&(b<(RES_Y+RES_SIZE)))

#define OVER_SOUND_ENABLE(a,b) ((a>SOUND_ENABLE_X)&&(a<(SOUND_ENABLE_X+SOUND_SIZE))&&(b>SOUND_Y)&&(b<(SOUND_Y+SOUND_SIZE)))
#define OVER_SOUND_DISABLE(a,b) ((a>SOUND_DISABLE_X)&&(a<(SOUND_DISABLE_X+SOUND_SIZE))&&(b>SOUND_Y)&&(b<(SOUND_Y+SOUND_SIZE)))

#define OVER_VIDEO_ENABLE(a,b) ((a>VIDEO_ENABLE_X)&&(a<(VIDEO_ENABLE_X+VIDEO_SIZE))&&(b>VIDEO_Y)&&(b<(VIDEO_Y+VIDEO_SIZE)))
#define OVER_VIDEO_DISABLE(a,b) ((a>VIDEO_DISABLE_X)&&(a<(VIDEO_DISABLE_X+VIDEO_SIZE))&&(b>VIDEO_Y)&&(b<(VIDEO_Y+VIDEO_SIZE)))

#define OVER_LANGUAGE_FR(a,b) ((a>LANGUAGE_FR_X)&&(a<(LANGUAGE_FR_X+LANGUAGE_SIZE))&&(b>LANGUAGE_Y)&&(b<(LANGUAGE_Y+LANGUAGE_SIZE)))
#define OVER_LANGUAGE_EN(a,b) ((a>LANGUAGE_EN_X)&&(a<(LANGUAGE_EN_X+LANGUAGE_SIZE))&&(b>LANGUAGE_Y)&&(b<(LANGUAGE_Y+LANGUAGE_SIZE)))

#define OVER_SERVER(a,b) ((a>NET_SERVER_X)&&(a<(NET_SERVER_X+NET_SIZE))&&(b>NET_TYPE_Y)&&(b<(NET_TYPE_Y+NET_SIZE)))
#define OVER_CLIENT(a,b) ((a>NET_CLIENT_X)&&(a<(NET_CLIENT_X+NET_SIZE))&&(b>NET_TYPE_Y)&&(b<(NET_TYPE_Y+NET_SIZE)))

#define OVER_HOME_EMBLEM(a,b) ((a>HOME_EMBLEM_X)&&(a<(HOME_EMBLEM_X+EMBLEM_W))&&(b>HOME_EMBLEM_Y)&&(b<(HOME_EMBLEM_Y+EMBLEM_H)))
#define OVER_VISITOR_EMBLEM(a,b) ((a>VISITOR_EMBLEM_X)&&(a<(VISITOR_EMBLEM_X+EMBLEM_W))&&(b>VISITOR_EMBLEM_Y)&&(b<(VISITOR_EMBLEM_Y+EMBLEM_H)))

#define OVER_VS_BTN(a,b) ((a>VS_BTN_X)&&(a<(VS_BTN_X+VS_BTN_W))&&(b>VS_BTN_Y)&&(b<(VS_BTN_Y+VS_BTN_H)))
#define OVER_READY_BTN(a,b) ((a>READY_BTN_X)&&(a<(READY_BTN_X+READY_BTN_W))&&(b>READY_BTN_Y)&&(b<(READY_BTN_Y+READY_BTN_H)))

#define NET_MSG_CLIENT_SERVER_0 "Hello, would you want to be a client or a server ?"
#define NET_MSG_CLIENT_SERVER_1 "Please, click on the corresponding checkbox."
#define NET_MSG_SERVER_SELECTED "Server selected."
#define NET_MSG_CLIENT_SELECTED "Client selected."
#define NET_MSG_NICKNAME "Enter your nickname : "
#define NET_MSG_SERVER_ADDRESS "Enter the server address (IP or hostname) : "
#define NET_MSG_SERVER_READY "Server is ready. Waiting for connection..."
#define NET_MSG_SERVER_FAILED "Failed to create server..."
#define NET_MSG_CLIENT_CONNECTED "Client connected."
#define NET_MSG_SERVER_CONNECTED "Connected to server."
#define NET_MSG_CLIENT_CONNECTION_FAILED "Failed to connect. Trying again... (Attempt %i)"
#define NET_MSG_TRY_CONNECT "Try to connect to %s..."
#define NET_MSG_RESOLVE_FAILED "Unable to resolve server address: %s"
#define NET_MSG_ADVERSARY_IS "Today's adversary is %s"
#define NET_MSG_CHAT_FORMAT "%s: %s"
#define NET_MSG_HI "Hi %s,"
#define NET_MSG_READY "%s is ready for playing !"
#define NET_MSG_NOT_READY "%s isn't ready for playing !"


#define NICKNAME 1
#define IP_ADDRESS 2

class Screen{
 public:
  /**
   * Constructeur par defaut
   */
  Screen(SDL_Surface*);
  ~Screen(void);
  int open_title(void);
  int open_credits(void);
  int open_options(void);
  int open_end(void);
  int open_vs(team_summary_t*,team_summary_t*);
  opponent_t* open_team_selector(team_list_t*);
  opponent_t* open_network(team_list_t*,Network *&);
  char* open_load_input(char*);
  void load_images(int);
  void free_images(int);
  bool is_visible(void) {return visible;}
  void handle_input(Uint16);
  void erase_input(void);
  int get_type(void);
  void net_send_msg(char*);
  
#ifndef NOSOUND
  void set_sound_player(SoundPlayer*);
#endif

 protected:

#ifndef NOSOUND
	SoundPlayer *sp;
#endif

#ifndef NONET
  void set_nickname(char*);
  void set_ip_address(char*);
  void handle_msg(char*);
  void check_for_connection(void);
  void try_to_connect(void);
#endif
  
  void draw_string(char*,SDL_Rect*,SDL_Surface*,SDL_Surface*,SDL_Surface*);
  void select_team(int,int);
  void wait_for_next_frame(void);
  void draw(void);
  int handle_event(void);
  void init();
  SDL_Surface* load_image(char*,int);
  SDL_Surface *screen,*end_btn_img,*title_left_btn_img,*title_right_btn_img,*screen_img[SCREEN_NETWORK+1];
  int type;
  SDL_Surface *emblems_img[2];
  SDL_Surface *vs_lower_chars, *vs_upper_chars;
  SDL_Surface *vs_btn;
  SDL_Surface *vs_no_btn;
  SDL_Surface *vs_instructions_img;
  SDL_Surface *load_input_img;
  SDL_Surface *credits_names_img;
  SDL_Surface *options_img;
  SDL_Surface *tick_img, *no_emblem_img, *ready_emblem_img, *ready_img;
  int res_tick, net_tick, sound_tick, video_tick, language_tick;
  bool visible;
  bool over_quick_game_btn;
  bool over_exhibition_btn;
  bool over_new_league_btn;
  bool over_new_cup_btn;
  bool over_load_game_btn;
  bool over_options_btn;
  bool over_network_btn;
  bool over_credits_btn;
  bool over_back_btn;
  bool over_exit_btn;
  bool over_credits_back_btn;
  bool over_credits_end_btn;
  bool over_vs_btn;
  bool update;
  team_list_t* team_list;
  int pos[2];
  team_summary_t* home;
  team_summary_t* visitor;
  SDL_Rect cliprect;
  char* input_content;
 private:
	int screen_w;
	int screen_h;
	int credits_names_y;
	Network* net;
	Console* console;
	int waiting_for;
	bool adversary_is_ready;
	bool console_editable;
};

#endif



