/* 
 * Copyright (C) 2003 Tim Martin
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */


#ifndef CLIENT_H
#define CLIENT_H

#include <time.h>

#include "map.h"
#include "tiles.h"
#include "game.h"
#include "mapspot.h"

typedef struct client_s client_t;

typedef void alert_callback_t(char *msg, void *rock);

int client_init(const char *server, short port, const char *playername, 
		alert_callback_t *alert_cb, void *alert_rock, client_t **client);

void client_close(client_t *client);
void client_free(client_t *client);

map_t *client_getmap(client_t *client, tiles_t *tiles);

map_t *client_newmap(client_t *client, tiles_t *tiles, int sizex, int sizey);
player_t *client_getme(client_t *client);

int client_setspot(client_t *client, int x, int y, mapobj_t mapobj);

int client_changeheight(client_t *client, mapspot_list_t *list);

int client_buyland(client_t *client, int x, int y);
int client_sellland(client_t *client, int x, int y);

void client_checkpoint(client_t *client, int *mapchanged);


typedef int popreport_callback_t(int age, int edlevel, int size, int income, 
				 int housed, int work, int happy, void *rock);
int client_getpopreport(client_t *client, popreport_callback_t *func, void *rock);

typedef int finances_callback_t(char *title, int *amounts, void *rock);

typedef int finances_loan_callback_t(int num, char *string, void *rock);

int client_getfinances(client_t *client, finances_callback_t *func, void *rock,
		       finances_loan_callback_t *loan_func, void *loan_rock);

int client_setspeed(client_t *client, game_speeds_t speed);

void updatemoney(void);

typedef void spotinfo_callback_t(char *name, char *value, void *rock);

int client_getspot_info(client_t *client, int x, int y, spotinfo_callback_t *cb, void *rock);

int client_borrow(client_t *client, int amount);

typedef void gameinfo_callback_t(char *name, void *rock);

int client_listgames(client_t *client, gameinfo_callback_t *cb, void *rock);

typedef void stats_callback_t(char *name, char *value, void *rock);

int client_getstats(client_t *client, stats_callback_t *cb, void *rock);

int client_selectgame(client_t *client, const char *name);

char *client_getgoal(client_t *client);

int client_txn_start(client_t *client);

int client_txn_commit(client_t *client);

int client_payoff_loan(client_t *client, int num);

int client_gettaxrate(client_t *client, char *name);
void client_settaxrate(client_t *client, char *name, int rate);
char *client_gethappiness(client_t *client);

#endif /* CLIENT_H */
