/* 
 * Copyright (C) 2003 Tim Martin
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */


#ifndef COMPANIES_H
#define COMPANIES_H

#include "map.h"
#include "mapspot.h"

#define HIRECOST 5000

typedef struct company_s {
    mapobj_t obj;
    int x;
    int y;

    labor_t labor;
    int cash; /* in 100's of $ */
    int lastprofit;
    float margin;

    struct company_s *next;
} company_t;

typedef struct companies_s companies_t;

int companies_init(companies_t **companies);

int companies_add(companies_t *companies, int x, int y, int obj);
int companies_remove(companies_t *companies, int x, int y);

company_t* companies_find(companies_t *companies, int x, int y);

int companies_hasopening(companies_t *companies, int x, int y, 
			 enum labor_skill skill);
int companies_takejob(companies_t *companies, int x, int y,
		      enum labor_skill skill);
int companies_quitjob(companies_t *companies, int x, int y,
		      enum labor_skill skill);
labor_t *companies_employ(companies_t *companies, int x, int y);
labor_t *companies_maxemploy(companies_t *companies, int x, int y);

mapspot_list_t *companies_find_openings_list(companies_t *companies);
int companies_gettotalsalary(companies_t *companies, int x, int y);

int companies_getsalary(companies_t *companies, int x, int y, enum labor_skill skill);

void companies_positions_avail(companies_t *companies, labor_t *labor);
int companies_total_positions(companies_t *companies);

typedef void revenue_iterate_callback(company_t *c,
				      int owner, int revenue, 
				      int costs, float food_production, 
				      void *rock);

void companies_revenue_iterate(companies_t *companies, 
			       revenue_iterate_callback *callback, 
			       void *rock);
int companies_get_revenue(companies_t *companies, int x, int y);
int companies_get_cash(companies_t *companies, int x, int y);
int companies_get_lastprofit(companies_t *companies, int x, int y);

int companies_out_of_business(companies_t *companies);

int companies_work_denisty(companies_t *companies, int x, int y);
extern int company_numemploy(company_t *c);

#endif /* COMPANIES_H */
