Test 7137 - Ensure state updates generate internal events
=======

# Purpose:
Internal state updates for containers can occur both via events generated by vSphere or
via explicit updates when performing actions such as an inspect.
This ensures that the state updates also generate appropriate internal events to trigger
actions such as network unbind. 

# References:
* https://github.com/vmware/vic/issues/7137

# Environment:
This test requires that a vSphere server is running and available

# Test Steps:
1. Create VCH through vic-machine create
2. Create container that will stop after a brief delay
3. Tight loop on container inspect to force state updates
4. Confirm that a container started event was generated when the container fully initialized
5. Confirm that a container die event was generated when the container stopped
6. Confirm that the bridge endpoint was removed via the `network inspect bridge` output


# Expected Outcome:
All steps should succeed. This test will not fail reliably if there is an issue but
should show failures within a few runs.
