package iothub

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"net/http"
)

// AccessRightsDescription enumerates the values for access rights description.
type AccessRightsDescription string

const (
	// DeviceConnect ...
	DeviceConnect AccessRightsDescription = "DeviceConnect"
	// EnrollmentRead ...
	EnrollmentRead AccessRightsDescription = "EnrollmentRead"
	// EnrollmentWrite ...
	EnrollmentWrite AccessRightsDescription = "EnrollmentWrite"
	// RegistrationStatusRead ...
	RegistrationStatusRead AccessRightsDescription = "RegistrationStatusRead"
	// RegistrationStatusWrite ...
	RegistrationStatusWrite AccessRightsDescription = "RegistrationStatusWrite"
	// ServiceConfig ...
	ServiceConfig AccessRightsDescription = "ServiceConfig"
)

// PossibleAccessRightsDescriptionValues returns an array of possible values for the AccessRightsDescription const type.
func PossibleAccessRightsDescriptionValues() []AccessRightsDescription {
	return []AccessRightsDescription{DeviceConnect, EnrollmentRead, EnrollmentWrite, RegistrationStatusRead, RegistrationStatusWrite, ServiceConfig}
}

// AllocationPolicy enumerates the values for allocation policy.
type AllocationPolicy string

const (
	// GeoLatency ...
	GeoLatency AllocationPolicy = "GeoLatency"
	// Hashed ...
	Hashed AllocationPolicy = "Hashed"
	// Static ...
	Static AllocationPolicy = "Static"
)

// PossibleAllocationPolicyValues returns an array of possible values for the AllocationPolicy const type.
func PossibleAllocationPolicyValues() []AllocationPolicy {
	return []AllocationPolicy{GeoLatency, Hashed, Static}
}

// CertificatePurpose enumerates the values for certificate purpose.
type CertificatePurpose string

const (
	// ClientAuthentication ...
	ClientAuthentication CertificatePurpose = "clientAuthentication"
	// ServerAuthentication ...
	ServerAuthentication CertificatePurpose = "serverAuthentication"
)

// PossibleCertificatePurposeValues returns an array of possible values for the CertificatePurpose const type.
func PossibleCertificatePurposeValues() []CertificatePurpose {
	return []CertificatePurpose{ClientAuthentication, ServerAuthentication}
}

// IotDpsSku enumerates the values for iot dps sku.
type IotDpsSku string

const (
	// S1 ...
	S1 IotDpsSku = "S1"
)

// PossibleIotDpsSkuValues returns an array of possible values for the IotDpsSku const type.
func PossibleIotDpsSkuValues() []IotDpsSku {
	return []IotDpsSku{S1}
}

// NameUnavailabilityReason enumerates the values for name unavailability reason.
type NameUnavailabilityReason string

const (
	// AlreadyExists ...
	AlreadyExists NameUnavailabilityReason = "AlreadyExists"
	// Invalid ...
	Invalid NameUnavailabilityReason = "Invalid"
)

// PossibleNameUnavailabilityReasonValues returns an array of possible values for the NameUnavailabilityReason const type.
func PossibleNameUnavailabilityReasonValues() []NameUnavailabilityReason {
	return []NameUnavailabilityReason{AlreadyExists, Invalid}
}

// State enumerates the values for state.
type State string

const (
	// Activating ...
	Activating State = "Activating"
	// ActivationFailed ...
	ActivationFailed State = "ActivationFailed"
	// Active ...
	Active State = "Active"
	// Deleted ...
	Deleted State = "Deleted"
	// Deleting ...
	Deleting State = "Deleting"
	// DeletionFailed ...
	DeletionFailed State = "DeletionFailed"
	// FailingOver ...
	FailingOver State = "FailingOver"
	// FailoverFailed ...
	FailoverFailed State = "FailoverFailed"
	// Resuming ...
	Resuming State = "Resuming"
	// Suspended ...
	Suspended State = "Suspended"
	// Suspending ...
	Suspending State = "Suspending"
	// Transitioning ...
	Transitioning State = "Transitioning"
)

// PossibleStateValues returns an array of possible values for the State const type.
func PossibleStateValues() []State {
	return []State{Activating, ActivationFailed, Active, Deleted, Deleting, DeletionFailed, FailingOver, FailoverFailed, Resuming, Suspended, Suspending, Transitioning}
}

// AsyncOperationResult result of a long running operation.
type AsyncOperationResult struct {
	autorest.Response `json:"-"`
	// Status - current status of a long running operation.
	Status *string `json:"status,omitempty"`
	// Error - Error message containing code, description and details
	Error *ErrorMesssage `json:"error,omitempty"`
}

// CertificateBodyDescription the JSON-serialized X509 Certificate.
type CertificateBodyDescription struct {
	// Certificate - Base-64 representation of the X509 leaf certificate .cer file or just .pem file content.
	Certificate *string `json:"certificate,omitempty"`
}

// CertificateListDescription the JSON-serialized array of Certificate objects.
type CertificateListDescription struct {
	autorest.Response `json:"-"`
	// Value - The array of Certificate objects.
	Value *[]CertificateResponse `json:"value,omitempty"`
}

// CertificateProperties the description of an X509 CA Certificate.
type CertificateProperties struct {
	// Subject - The certificate's subject name.
	Subject *string `json:"subject,omitempty"`
	// Expiry - The certificate's expiration date and time.
	Expiry *date.TimeRFC1123 `json:"expiry,omitempty"`
	// Thumbprint - The certificate's thumbprint.
	Thumbprint *string `json:"thumbprint,omitempty"`
	// IsVerified - Determines whether certificate has been verified.
	IsVerified *bool `json:"isVerified,omitempty"`
	// Created - The certificate's creation date and time.
	Created *date.TimeRFC1123 `json:"created,omitempty"`
	// Updated - The certificate's last update date and time.
	Updated *date.TimeRFC1123 `json:"updated,omitempty"`
}

// CertificateResponse the X509 Certificate.
type CertificateResponse struct {
	autorest.Response `json:"-"`
	// Properties - properties of a certificate
	Properties *CertificateProperties `json:"properties,omitempty"`
	// ID - The resource identifier.
	ID *string `json:"id,omitempty"`
	// Name - The name of the certificate.
	Name *string `json:"name,omitempty"`
	// Etag - The entity tag.
	Etag *string `json:"etag,omitempty"`
	// Type - The resource type.
	Type *string `json:"type,omitempty"`
}

// DefinitionDescription description of the IoT hub.
type DefinitionDescription struct {
	// ApplyAllocationPolicy - flag for applying allocationPolicy or not for a given iot hub.
	ApplyAllocationPolicy *bool `json:"applyAllocationPolicy,omitempty"`
	// AllocationWeight - weight to apply for a given iot h.
	AllocationWeight *int32 `json:"allocationWeight,omitempty"`
	// Name - Host name of the IoT hub.
	Name *string `json:"name,omitempty"`
	// ConnectionString - Connection string og the IoT hub.
	ConnectionString *string `json:"connectionString,omitempty"`
	// Location - ARM region of the IoT hub.
	Location *string `json:"location,omitempty"`
}

// ErrorDetails error details.
type ErrorDetails struct {
	// Code - The error code.
	Code *string `json:"code,omitempty"`
	// HTTPStatusCode - The HTTP status code.
	HTTPStatusCode *string `json:"httpStatusCode,omitempty"`
	// Message - The error message.
	Message *string `json:"message,omitempty"`
	// Details - The error details.
	Details *string `json:"details,omitempty"`
}

// ErrorMesssage error response containing message and code.
type ErrorMesssage struct {
	// Code - standard error code
	Code *string `json:"code,omitempty"`
	// Message - standard error description
	Message *string `json:"message,omitempty"`
	// Details - detailed summary of error
	Details *string `json:"details,omitempty"`
}

// IotDpsPropertiesDescription the service specific properties of a provisoning service, including keys, linked iot
// hubs, current state, and system generated properties such as hostname and idScope
type IotDpsPropertiesDescription struct {
	// State - Current state of the provisioning service. Possible values include: 'Activating', 'Active', 'Deleting', 'Deleted', 'ActivationFailed', 'DeletionFailed', 'Transitioning', 'Suspending', 'Suspended', 'Resuming', 'FailingOver', 'FailoverFailed'
	State State `json:"state,omitempty"`
	// ProvisioningState - The ARM provisioning state of the provisioning service.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// IotHubs - List of IoT hubs assosciated with this provisioning service.
	IotHubs *[]DefinitionDescription `json:"iotHubs,omitempty"`
	// AllocationPolicy - Allocation policy to be used by this provisioning service. Possible values include: 'Hashed', 'GeoLatency', 'Static'
	AllocationPolicy AllocationPolicy `json:"allocationPolicy,omitempty"`
	// ServiceOperationsHostName - Service endpoint for provisioning service.
	ServiceOperationsHostName *string `json:"serviceOperationsHostName,omitempty"`
	// DeviceProvisioningHostName - Device endpoint for this provisioning service.
	DeviceProvisioningHostName *string `json:"deviceProvisioningHostName,omitempty"`
	// IDScope - Unique identifier of this provisioning service.
	IDScope *string `json:"idScope,omitempty"`
	// AuthorizationPolicies - List of authorization keys for a provisioning service.
	AuthorizationPolicies *[]SharedAccessSignatureAuthorizationRuleAccessRightsDescription `json:"authorizationPolicies,omitempty"`
}

// IotDpsResourceCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type IotDpsResourceCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *IotDpsResourceCreateOrUpdateFuture) Result(client IotDpsResourceClient) (psd ProvisioningServiceDescription, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.IotDpsResourceCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("iothub.IotDpsResourceCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if psd.Response.Response, err = future.GetResult(sender); err == nil && psd.Response.Response.StatusCode != http.StatusNoContent {
		psd, err = client.CreateOrUpdateResponder(psd.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "iothub.IotDpsResourceCreateOrUpdateFuture", "Result", psd.Response.Response, "Failure responding to request")
		}
	}
	return
}

// IotDpsResourceDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type IotDpsResourceDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *IotDpsResourceDeleteFuture) Result(client IotDpsResourceClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.IotDpsResourceDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("iothub.IotDpsResourceDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// IotDpsResourceUpdateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type IotDpsResourceUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *IotDpsResourceUpdateFuture) Result(client IotDpsResourceClient) (psd ProvisioningServiceDescription, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.IotDpsResourceUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("iothub.IotDpsResourceUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if psd.Response.Response, err = future.GetResult(sender); err == nil && psd.Response.Response.StatusCode != http.StatusNoContent {
		psd, err = client.UpdateResponder(psd.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "iothub.IotDpsResourceUpdateFuture", "Result", psd.Response.Response, "Failure responding to request")
		}
	}
	return
}

// IotDpsSkuDefinition available Sku's of tier and units.
type IotDpsSkuDefinition struct {
	// Name - Sku name. Possible values include: 'S1'
	Name IotDpsSku `json:"name,omitempty"`
}

// IotDpsSkuDefinitionListResult list of available SKUs.
type IotDpsSkuDefinitionListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of SKU's
	Value *[]IotDpsSkuDefinition `json:"value,omitempty"`
	// NextLink - The next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// IotDpsSkuDefinitionListResultIterator provides access to a complete listing of IotDpsSkuDefinition values.
type IotDpsSkuDefinitionListResultIterator struct {
	i    int
	page IotDpsSkuDefinitionListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *IotDpsSkuDefinitionListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter IotDpsSkuDefinitionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter IotDpsSkuDefinitionListResultIterator) Response() IotDpsSkuDefinitionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter IotDpsSkuDefinitionListResultIterator) Value() IotDpsSkuDefinition {
	if !iter.page.NotDone() {
		return IotDpsSkuDefinition{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (idsdlr IotDpsSkuDefinitionListResult) IsEmpty() bool {
	return idsdlr.Value == nil || len(*idsdlr.Value) == 0
}

// iotDpsSkuDefinitionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (idsdlr IotDpsSkuDefinitionListResult) iotDpsSkuDefinitionListResultPreparer() (*http.Request, error) {
	if idsdlr.NextLink == nil || len(to.String(idsdlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(idsdlr.NextLink)))
}

// IotDpsSkuDefinitionListResultPage contains a page of IotDpsSkuDefinition values.
type IotDpsSkuDefinitionListResultPage struct {
	fn     func(IotDpsSkuDefinitionListResult) (IotDpsSkuDefinitionListResult, error)
	idsdlr IotDpsSkuDefinitionListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *IotDpsSkuDefinitionListResultPage) Next() error {
	next, err := page.fn(page.idsdlr)
	if err != nil {
		return err
	}
	page.idsdlr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page IotDpsSkuDefinitionListResultPage) NotDone() bool {
	return !page.idsdlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page IotDpsSkuDefinitionListResultPage) Response() IotDpsSkuDefinitionListResult {
	return page.idsdlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page IotDpsSkuDefinitionListResultPage) Values() []IotDpsSkuDefinition {
	if page.idsdlr.IsEmpty() {
		return nil
	}
	return *page.idsdlr.Value
}

// IotDpsSkuInfo list of possible provisoning service SKUs.
type IotDpsSkuInfo struct {
	// Name - Sku name. Possible values include: 'S1'
	Name IotDpsSku `json:"name,omitempty"`
	// Tier - Pricing tier name of the provisioning service.
	Tier *string `json:"tier,omitempty"`
	// Capacity - The number of units to provision
	Capacity *int64 `json:"capacity,omitempty"`
}

// NameAvailabilityInfo description of name availability.
type NameAvailabilityInfo struct {
	autorest.Response `json:"-"`
	// NameAvailable - specifies if a name is available or not
	NameAvailable *bool `json:"nameAvailable,omitempty"`
	// Reason - specifies the reason a name is unavailable. Possible values include: 'Invalid', 'AlreadyExists'
	Reason NameUnavailabilityReason `json:"reason,omitempty"`
	// Message - message containing a etailed reason name is unavailable
	Message *string `json:"message,omitempty"`
}

// Operation ioT Hub REST API operation.
type Operation struct {
	// Name - Operation name: {provider}/{resource}/{read | write | action | delete}
	Name *string `json:"name,omitempty"`
	// Display - The object that represents the operation.
	Display *OperationDisplay `json:"display,omitempty"`
}

// OperationDisplay the object that represents the operation.
type OperationDisplay struct {
	// Provider - Service provider: Microsoft Devices.
	Provider *string `json:"provider,omitempty"`
	// Resource - Resource Type: ProvisioningServices.
	Resource *string `json:"resource,omitempty"`
	// Operation - Name of the operation.
	Operation *string `json:"operation,omitempty"`
}

// OperationInputs input values for operation results call.
type OperationInputs struct {
	// Name - The name of the Provisioning Service to check.
	Name *string `json:"name,omitempty"`
}

// OperationListResult result of the request to list IoT Hub operations. It contains a list of operations and a URL
// link to get the next set of results.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - List of IoT Hub operations supported by the Microsoft.Devices resource provider.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationListResultIterator provides access to a complete listing of Operation values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer() (*http.Request, error) {
	if olr.NextLink == nil || len(to.String(olr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of Operation values.
type OperationListResultPage struct {
	fn  func(OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) Next() error {
	next, err := page.fn(page.olr)
	if err != nil {
		return err
	}
	page.olr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []Operation {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// ProvisioningServiceDescription the description of the provisioning service.
type ProvisioningServiceDescription struct {
	autorest.Response `json:"-"`
	// Etag - The Etag field is *not* required. If it is provided in the response body, it must also be provided as a header per the normal ETag convention.
	Etag *string `json:"etag,omitempty"`
	// Properties - Service specific properties for a provisioning service
	Properties *IotDpsPropertiesDescription `json:"properties,omitempty"`
	// Sku - Sku info for a provisioning Service.
	Sku *IotDpsSkuInfo `json:"sku,omitempty"`
	// ID - The resource identifier.
	ID *string `json:"id,omitempty"`
	// Name - The resource name.
	Name *string `json:"name,omitempty"`
	// Type - The resource type.
	Type *string `json:"type,omitempty"`
	// Location - The resource location.
	Location *string `json:"location,omitempty"`
	// Tags - The resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ProvisioningServiceDescription.
func (psd ProvisioningServiceDescription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if psd.Etag != nil {
		objectMap["etag"] = psd.Etag
	}
	if psd.Properties != nil {
		objectMap["properties"] = psd.Properties
	}
	if psd.Sku != nil {
		objectMap["sku"] = psd.Sku
	}
	if psd.ID != nil {
		objectMap["id"] = psd.ID
	}
	if psd.Name != nil {
		objectMap["name"] = psd.Name
	}
	if psd.Type != nil {
		objectMap["type"] = psd.Type
	}
	if psd.Location != nil {
		objectMap["location"] = psd.Location
	}
	if psd.Tags != nil {
		objectMap["tags"] = psd.Tags
	}
	return json.Marshal(objectMap)
}

// ProvisioningServiceDescriptionListResult list of provisioning service descriptions.
type ProvisioningServiceDescriptionListResult struct {
	autorest.Response `json:"-"`
	// Value - List of provisioning service descriptions.
	Value *[]ProvisioningServiceDescription `json:"value,omitempty"`
	// NextLink - the next link
	NextLink *string `json:"nextLink,omitempty"`
}

// ProvisioningServiceDescriptionListResultIterator provides access to a complete listing of
// ProvisioningServiceDescription values.
type ProvisioningServiceDescriptionListResultIterator struct {
	i    int
	page ProvisioningServiceDescriptionListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ProvisioningServiceDescriptionListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ProvisioningServiceDescriptionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ProvisioningServiceDescriptionListResultIterator) Response() ProvisioningServiceDescriptionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ProvisioningServiceDescriptionListResultIterator) Value() ProvisioningServiceDescription {
	if !iter.page.NotDone() {
		return ProvisioningServiceDescription{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (psdlr ProvisioningServiceDescriptionListResult) IsEmpty() bool {
	return psdlr.Value == nil || len(*psdlr.Value) == 0
}

// provisioningServiceDescriptionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (psdlr ProvisioningServiceDescriptionListResult) provisioningServiceDescriptionListResultPreparer() (*http.Request, error) {
	if psdlr.NextLink == nil || len(to.String(psdlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(psdlr.NextLink)))
}

// ProvisioningServiceDescriptionListResultPage contains a page of ProvisioningServiceDescription values.
type ProvisioningServiceDescriptionListResultPage struct {
	fn    func(ProvisioningServiceDescriptionListResult) (ProvisioningServiceDescriptionListResult, error)
	psdlr ProvisioningServiceDescriptionListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ProvisioningServiceDescriptionListResultPage) Next() error {
	next, err := page.fn(page.psdlr)
	if err != nil {
		return err
	}
	page.psdlr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ProvisioningServiceDescriptionListResultPage) NotDone() bool {
	return !page.psdlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ProvisioningServiceDescriptionListResultPage) Response() ProvisioningServiceDescriptionListResult {
	return page.psdlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ProvisioningServiceDescriptionListResultPage) Values() []ProvisioningServiceDescription {
	if page.psdlr.IsEmpty() {
		return nil
	}
	return *page.psdlr.Value
}

// Resource the common properties of an Azure resource.
type Resource struct {
	// ID - The resource identifier.
	ID *string `json:"id,omitempty"`
	// Name - The resource name.
	Name *string `json:"name,omitempty"`
	// Type - The resource type.
	Type *string `json:"type,omitempty"`
	// Location - The resource location.
	Location *string `json:"location,omitempty"`
	// Tags - The resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.ID != nil {
		objectMap["id"] = r.ID
	}
	if r.Name != nil {
		objectMap["name"] = r.Name
	}
	if r.Type != nil {
		objectMap["type"] = r.Type
	}
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	return json.Marshal(objectMap)
}

// SharedAccessSignatureAuthorizationRuleAccessRightsDescription description of the shared access key.
type SharedAccessSignatureAuthorizationRuleAccessRightsDescription struct {
	autorest.Response `json:"-"`
	// KeyName - Name of the key.
	KeyName *string `json:"keyName,omitempty"`
	// PrimaryKey - Primary SAS key value.
	PrimaryKey *string `json:"primaryKey,omitempty"`
	// SecondaryKey - Secondary SAS key value.
	SecondaryKey *string `json:"secondaryKey,omitempty"`
	// Rights - Rights that this key has. Possible values include: 'ServiceConfig', 'EnrollmentRead', 'EnrollmentWrite', 'DeviceConnect', 'RegistrationStatusRead', 'RegistrationStatusWrite'
	Rights AccessRightsDescription `json:"rights,omitempty"`
}

// SharedAccessSignatureAuthorizationRuleListResult list of shared access keys.
type SharedAccessSignatureAuthorizationRuleListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of shared access policies.
	Value *[]SharedAccessSignatureAuthorizationRuleAccessRightsDescription `json:"value,omitempty"`
	// NextLink - The next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// SharedAccessSignatureAuthorizationRuleListResultIterator provides access to a complete listing of
// SharedAccessSignatureAuthorizationRuleAccessRightsDescription values.
type SharedAccessSignatureAuthorizationRuleListResultIterator struct {
	i    int
	page SharedAccessSignatureAuthorizationRuleListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SharedAccessSignatureAuthorizationRuleListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SharedAccessSignatureAuthorizationRuleListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SharedAccessSignatureAuthorizationRuleListResultIterator) Response() SharedAccessSignatureAuthorizationRuleListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SharedAccessSignatureAuthorizationRuleListResultIterator) Value() SharedAccessSignatureAuthorizationRuleAccessRightsDescription {
	if !iter.page.NotDone() {
		return SharedAccessSignatureAuthorizationRuleAccessRightsDescription{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (sasarlr SharedAccessSignatureAuthorizationRuleListResult) IsEmpty() bool {
	return sasarlr.Value == nil || len(*sasarlr.Value) == 0
}

// sharedAccessSignatureAuthorizationRuleListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sasarlr SharedAccessSignatureAuthorizationRuleListResult) sharedAccessSignatureAuthorizationRuleListResultPreparer() (*http.Request, error) {
	if sasarlr.NextLink == nil || len(to.String(sasarlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sasarlr.NextLink)))
}

// SharedAccessSignatureAuthorizationRuleListResultPage contains a page of
// SharedAccessSignatureAuthorizationRuleAccessRightsDescription values.
type SharedAccessSignatureAuthorizationRuleListResultPage struct {
	fn      func(SharedAccessSignatureAuthorizationRuleListResult) (SharedAccessSignatureAuthorizationRuleListResult, error)
	sasarlr SharedAccessSignatureAuthorizationRuleListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SharedAccessSignatureAuthorizationRuleListResultPage) Next() error {
	next, err := page.fn(page.sasarlr)
	if err != nil {
		return err
	}
	page.sasarlr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SharedAccessSignatureAuthorizationRuleListResultPage) NotDone() bool {
	return !page.sasarlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SharedAccessSignatureAuthorizationRuleListResultPage) Response() SharedAccessSignatureAuthorizationRuleListResult {
	return page.sasarlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SharedAccessSignatureAuthorizationRuleListResultPage) Values() []SharedAccessSignatureAuthorizationRuleAccessRightsDescription {
	if page.sasarlr.IsEmpty() {
		return nil
	}
	return *page.sasarlr.Value
}

// TagsResource a container holding only the Tags for a resource, allowing the user to update the tags on a
// Provisioning Service instance.
type TagsResource struct {
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for TagsResource.
func (tr TagsResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	return json.Marshal(objectMap)
}

// VerificationCodeRequest the JSON-serialized leaf certificate
type VerificationCodeRequest struct {
	// Certificate - base-64 representation of X509 certificate .cer file or just .pem file content.
	Certificate *string `json:"certificate,omitempty"`
}

// VerificationCodeResponse description of the response of the verification code.
type VerificationCodeResponse struct {
	autorest.Response `json:"-"`
	// Name - Name of certificate.
	Name *string `json:"name,omitempty"`
	// Etag - Request etag.
	Etag *string `json:"etag,omitempty"`
	// ID - The resource identifier.
	ID *string `json:"id,omitempty"`
	// Type - The resource type.
	Type       *string                             `json:"type,omitempty"`
	Properties *VerificationCodeResponseProperties `json:"properties,omitempty"`
}

// VerificationCodeResponseProperties ...
type VerificationCodeResponseProperties struct {
	// VerificationCode - Verification code.
	VerificationCode *string `json:"verificationCode,omitempty"`
	// Subject - Certificate subject.
	Subject *string `json:"subject,omitempty"`
	// Expiry - Code expiry.
	Expiry *string `json:"expiry,omitempty"`
	// Thumbprint - Certificate thumbprint.
	Thumbprint *string `json:"thumbprint,omitempty"`
	// IsVerified - Indicate if the certificate is verified by owner of private key.
	IsVerified *bool `json:"isVerified,omitempty"`
	// Created - Certificate created time.
	Created *string `json:"created,omitempty"`
	// Updated - Certificate updated time.
	Updated *string `json:"updated,omitempty"`
}
