package web

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"net/http"
)

// AppServicePlansClient is the webSite Management Client
type AppServicePlansClient struct {
	BaseClient
}

// NewAppServicePlansClient creates an instance of the AppServicePlansClient client.
func NewAppServicePlansClient(subscriptionID string) AppServicePlansClient {
	return NewAppServicePlansClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewAppServicePlansClientWithBaseURI creates an instance of the AppServicePlansClient client.
func NewAppServicePlansClientWithBaseURI(baseURI string, subscriptionID string) AppServicePlansClient {
	return AppServicePlansClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// CreateOrUpdate creates or updates an App Service Plan.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the App Service plan.
// appServicePlan - details of the App Service plan.
func (client AppServicePlansClient) CreateOrUpdate(ctx context.Context, resourceGroupName string, name string, appServicePlan AppServicePlan) (result AppServicePlansCreateOrUpdateFuture, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServicePlansClient", "CreateOrUpdate", err.Error())
	}

	req, err := client.CreateOrUpdatePreparer(ctx, resourceGroupName, name, appServicePlan)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "CreateOrUpdate", nil, "Failure preparing request")
		return
	}

	result, err = client.CreateOrUpdateSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "CreateOrUpdate", result.Response(), "Failure sending request")
		return
	}

	return
}

// CreateOrUpdatePreparer prepares the CreateOrUpdate request.
func (client AppServicePlansClient) CreateOrUpdatePreparer(ctx context.Context, resourceGroupName string, name string, appServicePlan AppServicePlan) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}", pathParameters),
		autorest.WithJSON(appServicePlan),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateSender sends the CreateOrUpdate request. The method will close the
// http.Response Body if it receives an error.
func (client AppServicePlansClient) CreateOrUpdateSender(req *http.Request) (future AppServicePlansCreateOrUpdateFuture, err error) {
	var resp *http.Response
	resp, err = autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	err = autorest.Respond(resp, azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted))
	if err != nil {
		return
	}
	future.Future, err = azure.NewFutureFromResponse(resp)
	return
}

// CreateOrUpdateResponder handles the response to the CreateOrUpdate request. The method always
// closes the http.Response Body.
func (client AppServicePlansClient) CreateOrUpdateResponder(resp *http.Response) (result AppServicePlan, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateVnetRoute create or update a Virtual Network route in an App Service plan.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the App Service plan.
// vnetName - name of the Virtual Network.
// routeName - name of the Virtual Network route.
// route - definition of the Virtual Network route.
func (client AppServicePlansClient) CreateOrUpdateVnetRoute(ctx context.Context, resourceGroupName string, name string, vnetName string, routeName string, route VnetRoute) (result VnetRoute, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServicePlansClient", "CreateOrUpdateVnetRoute", err.Error())
	}

	req, err := client.CreateOrUpdateVnetRoutePreparer(ctx, resourceGroupName, name, vnetName, routeName, route)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "CreateOrUpdateVnetRoute", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateVnetRouteSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "CreateOrUpdateVnetRoute", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateVnetRouteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "CreateOrUpdateVnetRoute", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateVnetRoutePreparer prepares the CreateOrUpdateVnetRoute request.
func (client AppServicePlansClient) CreateOrUpdateVnetRoutePreparer(ctx context.Context, resourceGroupName string, name string, vnetName string, routeName string, route VnetRoute) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"routeName":         autorest.Encode("path", routeName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections/{vnetName}/routes/{routeName}", pathParameters),
		autorest.WithJSON(route),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateVnetRouteSender sends the CreateOrUpdateVnetRoute request. The method will close the
// http.Response Body if it receives an error.
func (client AppServicePlansClient) CreateOrUpdateVnetRouteSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateVnetRouteResponder handles the response to the CreateOrUpdateVnetRoute request. The method always
// closes the http.Response Body.
func (client AppServicePlansClient) CreateOrUpdateVnetRouteResponder(resp *http.Response) (result VnetRoute, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusBadRequest, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Delete delete an App Service plan.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the App Service plan.
func (client AppServicePlansClient) Delete(ctx context.Context, resourceGroupName string, name string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServicePlansClient", "Delete", err.Error())
	}

	req, err := client.DeletePreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "Delete", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "Delete", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "Delete", resp, "Failure responding to request")
	}

	return
}

// DeletePreparer prepares the Delete request.
func (client AppServicePlansClient) DeletePreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSender sends the Delete request. The method will close the
// http.Response Body if it receives an error.
func (client AppServicePlansClient) DeleteSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// DeleteResponder handles the response to the Delete request. The method always
// closes the http.Response Body.
func (client AppServicePlansClient) DeleteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteHybridConnection delete a Hybrid Connection in use in an App Service plan.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the App Service plan.
// namespaceName - name of the Service Bus namespace.
// relayName - name of the Service Bus relay.
func (client AppServicePlansClient) DeleteHybridConnection(ctx context.Context, resourceGroupName string, name string, namespaceName string, relayName string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServicePlansClient", "DeleteHybridConnection", err.Error())
	}

	req, err := client.DeleteHybridConnectionPreparer(ctx, resourceGroupName, name, namespaceName, relayName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "DeleteHybridConnection", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteHybridConnectionSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "DeleteHybridConnection", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteHybridConnectionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "DeleteHybridConnection", resp, "Failure responding to request")
	}

	return
}

// DeleteHybridConnectionPreparer prepares the DeleteHybridConnection request.
func (client AppServicePlansClient) DeleteHybridConnectionPreparer(ctx context.Context, resourceGroupName string, name string, namespaceName string, relayName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"namespaceName":     autorest.Encode("path", namespaceName),
		"relayName":         autorest.Encode("path", relayName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteHybridConnectionSender sends the DeleteHybridConnection request. The method will close the
// http.Response Body if it receives an error.
func (client AppServicePlansClient) DeleteHybridConnectionSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// DeleteHybridConnectionResponder handles the response to the DeleteHybridConnection request. The method always
// closes the http.Response Body.
func (client AppServicePlansClient) DeleteHybridConnectionResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteVnetRoute delete a Virtual Network route in an App Service plan.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the App Service plan.
// vnetName - name of the Virtual Network.
// routeName - name of the Virtual Network route.
func (client AppServicePlansClient) DeleteVnetRoute(ctx context.Context, resourceGroupName string, name string, vnetName string, routeName string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServicePlansClient", "DeleteVnetRoute", err.Error())
	}

	req, err := client.DeleteVnetRoutePreparer(ctx, resourceGroupName, name, vnetName, routeName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "DeleteVnetRoute", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteVnetRouteSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "DeleteVnetRoute", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteVnetRouteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "DeleteVnetRoute", resp, "Failure responding to request")
	}

	return
}

// DeleteVnetRoutePreparer prepares the DeleteVnetRoute request.
func (client AppServicePlansClient) DeleteVnetRoutePreparer(ctx context.Context, resourceGroupName string, name string, vnetName string, routeName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"routeName":         autorest.Encode("path", routeName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections/{vnetName}/routes/{routeName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteVnetRouteSender sends the DeleteVnetRoute request. The method will close the
// http.Response Body if it receives an error.
func (client AppServicePlansClient) DeleteVnetRouteSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// DeleteVnetRouteResponder handles the response to the DeleteVnetRoute request. The method always
// closes the http.Response Body.
func (client AppServicePlansClient) DeleteVnetRouteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Get get an App Service plan.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the App Service plan.
func (client AppServicePlansClient) Get(ctx context.Context, resourceGroupName string, name string) (result AppServicePlan, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServicePlansClient", "Get", err.Error())
	}

	req, err := client.GetPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "Get", resp, "Failure responding to request")
	}

	return
}

// GetPreparer prepares the Get request.
func (client AppServicePlansClient) GetPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client AppServicePlansClient) GetSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client AppServicePlansClient) GetResponder(resp *http.Response) (result AppServicePlan, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetHybridConnection retrieve a Hybrid Connection in use in an App Service plan.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the App Service plan.
// namespaceName - name of the Service Bus namespace.
// relayName - name of the Service Bus relay.
func (client AppServicePlansClient) GetHybridConnection(ctx context.Context, resourceGroupName string, name string, namespaceName string, relayName string) (result HybridConnection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServicePlansClient", "GetHybridConnection", err.Error())
	}

	req, err := client.GetHybridConnectionPreparer(ctx, resourceGroupName, name, namespaceName, relayName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "GetHybridConnection", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetHybridConnectionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "GetHybridConnection", resp, "Failure sending request")
		return
	}

	result, err = client.GetHybridConnectionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "GetHybridConnection", resp, "Failure responding to request")
	}

	return
}

// GetHybridConnectionPreparer prepares the GetHybridConnection request.
func (client AppServicePlansClient) GetHybridConnectionPreparer(ctx context.Context, resourceGroupName string, name string, namespaceName string, relayName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"namespaceName":     autorest.Encode("path", namespaceName),
		"relayName":         autorest.Encode("path", relayName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetHybridConnectionSender sends the GetHybridConnection request. The method will close the
// http.Response Body if it receives an error.
func (client AppServicePlansClient) GetHybridConnectionSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetHybridConnectionResponder handles the response to the GetHybridConnection request. The method always
// closes the http.Response Body.
func (client AppServicePlansClient) GetHybridConnectionResponder(resp *http.Response) (result HybridConnection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetHybridConnectionPlanLimit get the maximum number of Hybrid Connections allowed in an App Service plan.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the App Service plan.
func (client AppServicePlansClient) GetHybridConnectionPlanLimit(ctx context.Context, resourceGroupName string, name string) (result HybridConnectionLimits, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServicePlansClient", "GetHybridConnectionPlanLimit", err.Error())
	}

	req, err := client.GetHybridConnectionPlanLimitPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "GetHybridConnectionPlanLimit", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetHybridConnectionPlanLimitSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "GetHybridConnectionPlanLimit", resp, "Failure sending request")
		return
	}

	result, err = client.GetHybridConnectionPlanLimitResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "GetHybridConnectionPlanLimit", resp, "Failure responding to request")
	}

	return
}

// GetHybridConnectionPlanLimitPreparer prepares the GetHybridConnectionPlanLimit request.
func (client AppServicePlansClient) GetHybridConnectionPlanLimitPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/hybridConnectionPlanLimits/limit", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetHybridConnectionPlanLimitSender sends the GetHybridConnectionPlanLimit request. The method will close the
// http.Response Body if it receives an error.
func (client AppServicePlansClient) GetHybridConnectionPlanLimitSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetHybridConnectionPlanLimitResponder handles the response to the GetHybridConnectionPlanLimit request. The method always
// closes the http.Response Body.
func (client AppServicePlansClient) GetHybridConnectionPlanLimitResponder(resp *http.Response) (result HybridConnectionLimits, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetRouteForVnet get a Virtual Network route in an App Service plan.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the App Service plan.
// vnetName - name of the Virtual Network.
// routeName - name of the Virtual Network route.
func (client AppServicePlansClient) GetRouteForVnet(ctx context.Context, resourceGroupName string, name string, vnetName string, routeName string) (result ListVnetRoute, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServicePlansClient", "GetRouteForVnet", err.Error())
	}

	req, err := client.GetRouteForVnetPreparer(ctx, resourceGroupName, name, vnetName, routeName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "GetRouteForVnet", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetRouteForVnetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "GetRouteForVnet", resp, "Failure sending request")
		return
	}

	result, err = client.GetRouteForVnetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "GetRouteForVnet", resp, "Failure responding to request")
	}

	return
}

// GetRouteForVnetPreparer prepares the GetRouteForVnet request.
func (client AppServicePlansClient) GetRouteForVnetPreparer(ctx context.Context, resourceGroupName string, name string, vnetName string, routeName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"routeName":         autorest.Encode("path", routeName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections/{vnetName}/routes/{routeName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetRouteForVnetSender sends the GetRouteForVnet request. The method will close the
// http.Response Body if it receives an error.
func (client AppServicePlansClient) GetRouteForVnetSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetRouteForVnetResponder handles the response to the GetRouteForVnet request. The method always
// closes the http.Response Body.
func (client AppServicePlansClient) GetRouteForVnetResponder(resp *http.Response) (result ListVnetRoute, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetServerFarmSkus gets all selectable sku's for a given App Service Plan
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of App Service Plan
func (client AppServicePlansClient) GetServerFarmSkus(ctx context.Context, resourceGroupName string, name string) (result SetObject, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServicePlansClient", "GetServerFarmSkus", err.Error())
	}

	req, err := client.GetServerFarmSkusPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "GetServerFarmSkus", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetServerFarmSkusSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "GetServerFarmSkus", resp, "Failure sending request")
		return
	}

	result, err = client.GetServerFarmSkusResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "GetServerFarmSkus", resp, "Failure responding to request")
	}

	return
}

// GetServerFarmSkusPreparer prepares the GetServerFarmSkus request.
func (client AppServicePlansClient) GetServerFarmSkusPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/skus", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetServerFarmSkusSender sends the GetServerFarmSkus request. The method will close the
// http.Response Body if it receives an error.
func (client AppServicePlansClient) GetServerFarmSkusSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetServerFarmSkusResponder handles the response to the GetServerFarmSkus request. The method always
// closes the http.Response Body.
func (client AppServicePlansClient) GetServerFarmSkusResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetVnetFromServerFarm get a Virtual Network associated with an App Service plan.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the App Service plan.
// vnetName - name of the Virtual Network.
func (client AppServicePlansClient) GetVnetFromServerFarm(ctx context.Context, resourceGroupName string, name string, vnetName string) (result VnetInfo, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServicePlansClient", "GetVnetFromServerFarm", err.Error())
	}

	req, err := client.GetVnetFromServerFarmPreparer(ctx, resourceGroupName, name, vnetName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "GetVnetFromServerFarm", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetVnetFromServerFarmSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "GetVnetFromServerFarm", resp, "Failure sending request")
		return
	}

	result, err = client.GetVnetFromServerFarmResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "GetVnetFromServerFarm", resp, "Failure responding to request")
	}

	return
}

// GetVnetFromServerFarmPreparer prepares the GetVnetFromServerFarm request.
func (client AppServicePlansClient) GetVnetFromServerFarmPreparer(ctx context.Context, resourceGroupName string, name string, vnetName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections/{vnetName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetVnetFromServerFarmSender sends the GetVnetFromServerFarm request. The method will close the
// http.Response Body if it receives an error.
func (client AppServicePlansClient) GetVnetFromServerFarmSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetVnetFromServerFarmResponder handles the response to the GetVnetFromServerFarm request. The method always
// closes the http.Response Body.
func (client AppServicePlansClient) GetVnetFromServerFarmResponder(resp *http.Response) (result VnetInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetVnetGateway get a Virtual Network gateway.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the App Service plan.
// vnetName - name of the Virtual Network.
// gatewayName - name of the gateway. Only the 'primary' gateway is supported.
func (client AppServicePlansClient) GetVnetGateway(ctx context.Context, resourceGroupName string, name string, vnetName string, gatewayName string) (result VnetGateway, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServicePlansClient", "GetVnetGateway", err.Error())
	}

	req, err := client.GetVnetGatewayPreparer(ctx, resourceGroupName, name, vnetName, gatewayName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "GetVnetGateway", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetVnetGatewaySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "GetVnetGateway", resp, "Failure sending request")
		return
	}

	result, err = client.GetVnetGatewayResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "GetVnetGateway", resp, "Failure responding to request")
	}

	return
}

// GetVnetGatewayPreparer prepares the GetVnetGateway request.
func (client AppServicePlansClient) GetVnetGatewayPreparer(ctx context.Context, resourceGroupName string, name string, vnetName string, gatewayName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"gatewayName":       autorest.Encode("path", gatewayName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetVnetGatewaySender sends the GetVnetGateway request. The method will close the
// http.Response Body if it receives an error.
func (client AppServicePlansClient) GetVnetGatewaySender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetVnetGatewayResponder handles the response to the GetVnetGateway request. The method always
// closes the http.Response Body.
func (client AppServicePlansClient) GetVnetGatewayResponder(resp *http.Response) (result VnetGateway, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// List get all App Service plans for a subcription.
// Parameters:
// detailed - specify <code>true</code> to return all App Service plan properties. The default is
// <code>false</code>, which returns a subset of the properties.
// Retrieval of all properties may increase the API latency.
func (client AppServicePlansClient) List(ctx context.Context, detailed *bool) (result AppServicePlanCollectionPage, err error) {
	result.fn = client.listNextResults
	req, err := client.ListPreparer(ctx, detailed)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.aspc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "List", resp, "Failure sending request")
		return
	}

	result.aspc, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "List", resp, "Failure responding to request")
	}

	return
}

// ListPreparer prepares the List request.
func (client AppServicePlansClient) ListPreparer(ctx context.Context, detailed *bool) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if detailed != nil {
		queryParameters["detailed"] = autorest.Encode("query", *detailed)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Web/serverfarms", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client AppServicePlansClient) ListSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client AppServicePlansClient) ListResponder(resp *http.Response) (result AppServicePlanCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listNextResults retrieves the next set of results, if any.
func (client AppServicePlansClient) listNextResults(lastResults AppServicePlanCollection) (result AppServicePlanCollection, err error) {
	req, err := lastResults.appServicePlanCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppServicePlansClient", "listNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppServicePlansClient", "listNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "listNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListComplete enumerates all values, automatically crossing page boundaries as required.
func (client AppServicePlansClient) ListComplete(ctx context.Context, detailed *bool) (result AppServicePlanCollectionIterator, err error) {
	result.page, err = client.List(ctx, detailed)
	return
}

// ListByResourceGroup get all App Service plans in a resource group.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
func (client AppServicePlansClient) ListByResourceGroup(ctx context.Context, resourceGroupName string) (result AppServicePlanCollectionPage, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServicePlansClient", "ListByResourceGroup", err.Error())
	}

	result.fn = client.listByResourceGroupNextResults
	req, err := client.ListByResourceGroupPreparer(ctx, resourceGroupName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListByResourceGroup", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByResourceGroupSender(req)
	if err != nil {
		result.aspc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListByResourceGroup", resp, "Failure sending request")
		return
	}

	result.aspc, err = client.ListByResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListByResourceGroup", resp, "Failure responding to request")
	}

	return
}

// ListByResourceGroupPreparer prepares the ListByResourceGroup request.
func (client AppServicePlansClient) ListByResourceGroupPreparer(ctx context.Context, resourceGroupName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByResourceGroupSender sends the ListByResourceGroup request. The method will close the
// http.Response Body if it receives an error.
func (client AppServicePlansClient) ListByResourceGroupSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListByResourceGroupResponder handles the response to the ListByResourceGroup request. The method always
// closes the http.Response Body.
func (client AppServicePlansClient) ListByResourceGroupResponder(resp *http.Response) (result AppServicePlanCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listByResourceGroupNextResults retrieves the next set of results, if any.
func (client AppServicePlansClient) listByResourceGroupNextResults(lastResults AppServicePlanCollection) (result AppServicePlanCollection, err error) {
	req, err := lastResults.appServicePlanCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppServicePlansClient", "listByResourceGroupNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListByResourceGroupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppServicePlansClient", "listByResourceGroupNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListByResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "listByResourceGroupNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListByResourceGroupComplete enumerates all values, automatically crossing page boundaries as required.
func (client AppServicePlansClient) ListByResourceGroupComplete(ctx context.Context, resourceGroupName string) (result AppServicePlanCollectionIterator, err error) {
	result.page, err = client.ListByResourceGroup(ctx, resourceGroupName)
	return
}

// ListCapabilities list all capabilities of an App Service plan.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the App Service plan.
func (client AppServicePlansClient) ListCapabilities(ctx context.Context, resourceGroupName string, name string) (result ListCapability, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServicePlansClient", "ListCapabilities", err.Error())
	}

	req, err := client.ListCapabilitiesPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListCapabilities", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListCapabilitiesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListCapabilities", resp, "Failure sending request")
		return
	}

	result, err = client.ListCapabilitiesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListCapabilities", resp, "Failure responding to request")
	}

	return
}

// ListCapabilitiesPreparer prepares the ListCapabilities request.
func (client AppServicePlansClient) ListCapabilitiesPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/capabilities", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListCapabilitiesSender sends the ListCapabilities request. The method will close the
// http.Response Body if it receives an error.
func (client AppServicePlansClient) ListCapabilitiesSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListCapabilitiesResponder handles the response to the ListCapabilities request. The method always
// closes the http.Response Body.
func (client AppServicePlansClient) ListCapabilitiesResponder(resp *http.Response) (result ListCapability, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListHybridConnectionKeys get the send key name and value of a Hybrid Connection.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the App Service plan.
// namespaceName - the name of the Service Bus namespace.
// relayName - the name of the Service Bus relay.
func (client AppServicePlansClient) ListHybridConnectionKeys(ctx context.Context, resourceGroupName string, name string, namespaceName string, relayName string) (result HybridConnectionKey, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServicePlansClient", "ListHybridConnectionKeys", err.Error())
	}

	req, err := client.ListHybridConnectionKeysPreparer(ctx, resourceGroupName, name, namespaceName, relayName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListHybridConnectionKeys", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListHybridConnectionKeysSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListHybridConnectionKeys", resp, "Failure sending request")
		return
	}

	result, err = client.ListHybridConnectionKeysResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListHybridConnectionKeys", resp, "Failure responding to request")
	}

	return
}

// ListHybridConnectionKeysPreparer prepares the ListHybridConnectionKeys request.
func (client AppServicePlansClient) ListHybridConnectionKeysPreparer(ctx context.Context, resourceGroupName string, name string, namespaceName string, relayName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"namespaceName":     autorest.Encode("path", namespaceName),
		"relayName":         autorest.Encode("path", relayName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}/listKeys", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListHybridConnectionKeysSender sends the ListHybridConnectionKeys request. The method will close the
// http.Response Body if it receives an error.
func (client AppServicePlansClient) ListHybridConnectionKeysSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListHybridConnectionKeysResponder handles the response to the ListHybridConnectionKeys request. The method always
// closes the http.Response Body.
func (client AppServicePlansClient) ListHybridConnectionKeysResponder(resp *http.Response) (result HybridConnectionKey, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListHybridConnections retrieve all Hybrid Connections in use in an App Service plan.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the App Service plan.
func (client AppServicePlansClient) ListHybridConnections(ctx context.Context, resourceGroupName string, name string) (result HybridConnectionCollectionPage, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServicePlansClient", "ListHybridConnections", err.Error())
	}

	result.fn = client.listHybridConnectionsNextResults
	req, err := client.ListHybridConnectionsPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListHybridConnections", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListHybridConnectionsSender(req)
	if err != nil {
		result.hcc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListHybridConnections", resp, "Failure sending request")
		return
	}

	result.hcc, err = client.ListHybridConnectionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListHybridConnections", resp, "Failure responding to request")
	}

	return
}

// ListHybridConnectionsPreparer prepares the ListHybridConnections request.
func (client AppServicePlansClient) ListHybridConnectionsPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/hybridConnectionRelays", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListHybridConnectionsSender sends the ListHybridConnections request. The method will close the
// http.Response Body if it receives an error.
func (client AppServicePlansClient) ListHybridConnectionsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListHybridConnectionsResponder handles the response to the ListHybridConnections request. The method always
// closes the http.Response Body.
func (client AppServicePlansClient) ListHybridConnectionsResponder(resp *http.Response) (result HybridConnectionCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listHybridConnectionsNextResults retrieves the next set of results, if any.
func (client AppServicePlansClient) listHybridConnectionsNextResults(lastResults HybridConnectionCollection) (result HybridConnectionCollection, err error) {
	req, err := lastResults.hybridConnectionCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppServicePlansClient", "listHybridConnectionsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListHybridConnectionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppServicePlansClient", "listHybridConnectionsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListHybridConnectionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "listHybridConnectionsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListHybridConnectionsComplete enumerates all values, automatically crossing page boundaries as required.
func (client AppServicePlansClient) ListHybridConnectionsComplete(ctx context.Context, resourceGroupName string, name string) (result HybridConnectionCollectionIterator, err error) {
	result.page, err = client.ListHybridConnections(ctx, resourceGroupName, name)
	return
}

// ListMetricDefintions get metrics that can be queried for an App Service plan, and their definitions.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the App Service plan.
func (client AppServicePlansClient) ListMetricDefintions(ctx context.Context, resourceGroupName string, name string) (result ResourceMetricDefinitionCollectionPage, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServicePlansClient", "ListMetricDefintions", err.Error())
	}

	result.fn = client.listMetricDefintionsNextResults
	req, err := client.ListMetricDefintionsPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListMetricDefintions", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListMetricDefintionsSender(req)
	if err != nil {
		result.rmdc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListMetricDefintions", resp, "Failure sending request")
		return
	}

	result.rmdc, err = client.ListMetricDefintionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListMetricDefintions", resp, "Failure responding to request")
	}

	return
}

// ListMetricDefintionsPreparer prepares the ListMetricDefintions request.
func (client AppServicePlansClient) ListMetricDefintionsPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/metricdefinitions", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListMetricDefintionsSender sends the ListMetricDefintions request. The method will close the
// http.Response Body if it receives an error.
func (client AppServicePlansClient) ListMetricDefintionsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListMetricDefintionsResponder handles the response to the ListMetricDefintions request. The method always
// closes the http.Response Body.
func (client AppServicePlansClient) ListMetricDefintionsResponder(resp *http.Response) (result ResourceMetricDefinitionCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listMetricDefintionsNextResults retrieves the next set of results, if any.
func (client AppServicePlansClient) listMetricDefintionsNextResults(lastResults ResourceMetricDefinitionCollection) (result ResourceMetricDefinitionCollection, err error) {
	req, err := lastResults.resourceMetricDefinitionCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppServicePlansClient", "listMetricDefintionsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListMetricDefintionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppServicePlansClient", "listMetricDefintionsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListMetricDefintionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "listMetricDefintionsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListMetricDefintionsComplete enumerates all values, automatically crossing page boundaries as required.
func (client AppServicePlansClient) ListMetricDefintionsComplete(ctx context.Context, resourceGroupName string, name string) (result ResourceMetricDefinitionCollectionIterator, err error) {
	result.page, err = client.ListMetricDefintions(ctx, resourceGroupName, name)
	return
}

// ListMetrics get metrics for an App Serice plan.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the App Service plan.
// details - specify <code>true</code> to include instance details. The default is <code>false</code>.
// filter - return only usages/metrics specified in the filter. Filter conforms to odata syntax. Example:
// $filter=(name.value eq 'Metric1' or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and
// endTime eq '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
func (client AppServicePlansClient) ListMetrics(ctx context.Context, resourceGroupName string, name string, details *bool, filter string) (result ResourceMetricCollectionPage, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServicePlansClient", "ListMetrics", err.Error())
	}

	result.fn = client.listMetricsNextResults
	req, err := client.ListMetricsPreparer(ctx, resourceGroupName, name, details, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListMetrics", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListMetricsSender(req)
	if err != nil {
		result.rmc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListMetrics", resp, "Failure sending request")
		return
	}

	result.rmc, err = client.ListMetricsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListMetrics", resp, "Failure responding to request")
	}

	return
}

// ListMetricsPreparer prepares the ListMetrics request.
func (client AppServicePlansClient) ListMetricsPreparer(ctx context.Context, resourceGroupName string, name string, details *bool, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if details != nil {
		queryParameters["details"] = autorest.Encode("query", *details)
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = filter
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/metrics", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListMetricsSender sends the ListMetrics request. The method will close the
// http.Response Body if it receives an error.
func (client AppServicePlansClient) ListMetricsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListMetricsResponder handles the response to the ListMetrics request. The method always
// closes the http.Response Body.
func (client AppServicePlansClient) ListMetricsResponder(resp *http.Response) (result ResourceMetricCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listMetricsNextResults retrieves the next set of results, if any.
func (client AppServicePlansClient) listMetricsNextResults(lastResults ResourceMetricCollection) (result ResourceMetricCollection, err error) {
	req, err := lastResults.resourceMetricCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppServicePlansClient", "listMetricsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListMetricsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppServicePlansClient", "listMetricsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListMetricsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "listMetricsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListMetricsComplete enumerates all values, automatically crossing page boundaries as required.
func (client AppServicePlansClient) ListMetricsComplete(ctx context.Context, resourceGroupName string, name string, details *bool, filter string) (result ResourceMetricCollectionIterator, err error) {
	result.page, err = client.ListMetrics(ctx, resourceGroupName, name, details, filter)
	return
}

// ListRoutesForVnet get all routes that are associated with a Virtual Network in an App Service plan.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the App Service plan.
// vnetName - name of the Virtual Network.
func (client AppServicePlansClient) ListRoutesForVnet(ctx context.Context, resourceGroupName string, name string, vnetName string) (result ListVnetRoute, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServicePlansClient", "ListRoutesForVnet", err.Error())
	}

	req, err := client.ListRoutesForVnetPreparer(ctx, resourceGroupName, name, vnetName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListRoutesForVnet", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListRoutesForVnetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListRoutesForVnet", resp, "Failure sending request")
		return
	}

	result, err = client.ListRoutesForVnetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListRoutesForVnet", resp, "Failure responding to request")
	}

	return
}

// ListRoutesForVnetPreparer prepares the ListRoutesForVnet request.
func (client AppServicePlansClient) ListRoutesForVnetPreparer(ctx context.Context, resourceGroupName string, name string, vnetName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections/{vnetName}/routes", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListRoutesForVnetSender sends the ListRoutesForVnet request. The method will close the
// http.Response Body if it receives an error.
func (client AppServicePlansClient) ListRoutesForVnetSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListRoutesForVnetResponder handles the response to the ListRoutesForVnet request. The method always
// closes the http.Response Body.
func (client AppServicePlansClient) ListRoutesForVnetResponder(resp *http.Response) (result ListVnetRoute, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListUsages gets server farm usage information
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of App Service Plan
// filter - return only usages/metrics specified in the filter. Filter conforms to odata syntax. Example:
// $filter=(name.value eq 'Metric1' or name.value eq 'Metric2').
func (client AppServicePlansClient) ListUsages(ctx context.Context, resourceGroupName string, name string, filter string) (result CsmUsageQuotaCollectionPage, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServicePlansClient", "ListUsages", err.Error())
	}

	result.fn = client.listUsagesNextResults
	req, err := client.ListUsagesPreparer(ctx, resourceGroupName, name, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListUsages", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListUsagesSender(req)
	if err != nil {
		result.cuqc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListUsages", resp, "Failure sending request")
		return
	}

	result.cuqc, err = client.ListUsagesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListUsages", resp, "Failure responding to request")
	}

	return
}

// ListUsagesPreparer prepares the ListUsages request.
func (client AppServicePlansClient) ListUsagesPreparer(ctx context.Context, resourceGroupName string, name string, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = filter
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/usages", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListUsagesSender sends the ListUsages request. The method will close the
// http.Response Body if it receives an error.
func (client AppServicePlansClient) ListUsagesSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListUsagesResponder handles the response to the ListUsages request. The method always
// closes the http.Response Body.
func (client AppServicePlansClient) ListUsagesResponder(resp *http.Response) (result CsmUsageQuotaCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listUsagesNextResults retrieves the next set of results, if any.
func (client AppServicePlansClient) listUsagesNextResults(lastResults CsmUsageQuotaCollection) (result CsmUsageQuotaCollection, err error) {
	req, err := lastResults.csmUsageQuotaCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppServicePlansClient", "listUsagesNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListUsagesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppServicePlansClient", "listUsagesNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListUsagesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "listUsagesNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListUsagesComplete enumerates all values, automatically crossing page boundaries as required.
func (client AppServicePlansClient) ListUsagesComplete(ctx context.Context, resourceGroupName string, name string, filter string) (result CsmUsageQuotaCollectionIterator, err error) {
	result.page, err = client.ListUsages(ctx, resourceGroupName, name, filter)
	return
}

// ListVnets get all Virtual Networks associated with an App Service plan.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the App Service plan.
func (client AppServicePlansClient) ListVnets(ctx context.Context, resourceGroupName string, name string) (result ListVnetInfo, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServicePlansClient", "ListVnets", err.Error())
	}

	req, err := client.ListVnetsPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListVnets", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListVnetsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListVnets", resp, "Failure sending request")
		return
	}

	result, err = client.ListVnetsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListVnets", resp, "Failure responding to request")
	}

	return
}

// ListVnetsPreparer prepares the ListVnets request.
func (client AppServicePlansClient) ListVnetsPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListVnetsSender sends the ListVnets request. The method will close the
// http.Response Body if it receives an error.
func (client AppServicePlansClient) ListVnetsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListVnetsResponder handles the response to the ListVnets request. The method always
// closes the http.Response Body.
func (client AppServicePlansClient) ListVnetsResponder(resp *http.Response) (result ListVnetInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListWebApps get all apps associated with an App Service plan.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the App Service plan.
// skipToken - skip to a web app in the list of webapps associated with app service plan. If specified, the
// resulting list will contain web apps starting from (including) the skipToken. Otherwise, the resulting list
// contains web apps from the start of the list
// filter - supported filter: $filter=state eq running. Returns only web apps that are currently running
// top - list page size. If specified, results are paged.
func (client AppServicePlansClient) ListWebApps(ctx context.Context, resourceGroupName string, name string, skipToken string, filter string, top string) (result AppCollectionPage, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServicePlansClient", "ListWebApps", err.Error())
	}

	result.fn = client.listWebAppsNextResults
	req, err := client.ListWebAppsPreparer(ctx, resourceGroupName, name, skipToken, filter, top)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListWebApps", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListWebAppsSender(req)
	if err != nil {
		result.ac.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListWebApps", resp, "Failure sending request")
		return
	}

	result.ac, err = client.ListWebAppsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListWebApps", resp, "Failure responding to request")
	}

	return
}

// ListWebAppsPreparer prepares the ListWebApps request.
func (client AppServicePlansClient) ListWebAppsPreparer(ctx context.Context, resourceGroupName string, name string, skipToken string, filter string, top string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(skipToken) > 0 {
		queryParameters["$skipToken"] = autorest.Encode("query", skipToken)
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = filter
	}
	if len(top) > 0 {
		queryParameters["$top"] = autorest.Encode("query", top)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/sites", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListWebAppsSender sends the ListWebApps request. The method will close the
// http.Response Body if it receives an error.
func (client AppServicePlansClient) ListWebAppsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListWebAppsResponder handles the response to the ListWebApps request. The method always
// closes the http.Response Body.
func (client AppServicePlansClient) ListWebAppsResponder(resp *http.Response) (result AppCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listWebAppsNextResults retrieves the next set of results, if any.
func (client AppServicePlansClient) listWebAppsNextResults(lastResults AppCollection) (result AppCollection, err error) {
	req, err := lastResults.appCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppServicePlansClient", "listWebAppsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListWebAppsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppServicePlansClient", "listWebAppsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListWebAppsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "listWebAppsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListWebAppsComplete enumerates all values, automatically crossing page boundaries as required.
func (client AppServicePlansClient) ListWebAppsComplete(ctx context.Context, resourceGroupName string, name string, skipToken string, filter string, top string) (result AppCollectionIterator, err error) {
	result.page, err = client.ListWebApps(ctx, resourceGroupName, name, skipToken, filter, top)
	return
}

// ListWebAppsByHybridConnection get all apps that use a Hybrid Connection in an App Service Plan.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the App Service plan.
// namespaceName - name of the Hybrid Connection namespace.
// relayName - name of the Hybrid Connection relay.
func (client AppServicePlansClient) ListWebAppsByHybridConnection(ctx context.Context, resourceGroupName string, name string, namespaceName string, relayName string) (result ResourceCollectionPage, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServicePlansClient", "ListWebAppsByHybridConnection", err.Error())
	}

	result.fn = client.listWebAppsByHybridConnectionNextResults
	req, err := client.ListWebAppsByHybridConnectionPreparer(ctx, resourceGroupName, name, namespaceName, relayName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListWebAppsByHybridConnection", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListWebAppsByHybridConnectionSender(req)
	if err != nil {
		result.rc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListWebAppsByHybridConnection", resp, "Failure sending request")
		return
	}

	result.rc, err = client.ListWebAppsByHybridConnectionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListWebAppsByHybridConnection", resp, "Failure responding to request")
	}

	return
}

// ListWebAppsByHybridConnectionPreparer prepares the ListWebAppsByHybridConnection request.
func (client AppServicePlansClient) ListWebAppsByHybridConnectionPreparer(ctx context.Context, resourceGroupName string, name string, namespaceName string, relayName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"namespaceName":     autorest.Encode("path", namespaceName),
		"relayName":         autorest.Encode("path", relayName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}/sites", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListWebAppsByHybridConnectionSender sends the ListWebAppsByHybridConnection request. The method will close the
// http.Response Body if it receives an error.
func (client AppServicePlansClient) ListWebAppsByHybridConnectionSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListWebAppsByHybridConnectionResponder handles the response to the ListWebAppsByHybridConnection request. The method always
// closes the http.Response Body.
func (client AppServicePlansClient) ListWebAppsByHybridConnectionResponder(resp *http.Response) (result ResourceCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listWebAppsByHybridConnectionNextResults retrieves the next set of results, if any.
func (client AppServicePlansClient) listWebAppsByHybridConnectionNextResults(lastResults ResourceCollection) (result ResourceCollection, err error) {
	req, err := lastResults.resourceCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppServicePlansClient", "listWebAppsByHybridConnectionNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListWebAppsByHybridConnectionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppServicePlansClient", "listWebAppsByHybridConnectionNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListWebAppsByHybridConnectionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "listWebAppsByHybridConnectionNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListWebAppsByHybridConnectionComplete enumerates all values, automatically crossing page boundaries as required.
func (client AppServicePlansClient) ListWebAppsByHybridConnectionComplete(ctx context.Context, resourceGroupName string, name string, namespaceName string, relayName string) (result ResourceCollectionIterator, err error) {
	result.page, err = client.ListWebAppsByHybridConnection(ctx, resourceGroupName, name, namespaceName, relayName)
	return
}

// RebootWorker reboot a worker machine in an App Service plan.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the App Service plan.
// workerName - name of worker machine, which typically starts with RD.
func (client AppServicePlansClient) RebootWorker(ctx context.Context, resourceGroupName string, name string, workerName string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServicePlansClient", "RebootWorker", err.Error())
	}

	req, err := client.RebootWorkerPreparer(ctx, resourceGroupName, name, workerName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "RebootWorker", nil, "Failure preparing request")
		return
	}

	resp, err := client.RebootWorkerSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "RebootWorker", resp, "Failure sending request")
		return
	}

	result, err = client.RebootWorkerResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "RebootWorker", resp, "Failure responding to request")
	}

	return
}

// RebootWorkerPreparer prepares the RebootWorker request.
func (client AppServicePlansClient) RebootWorkerPreparer(ctx context.Context, resourceGroupName string, name string, workerName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"workerName":        autorest.Encode("path", workerName),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/workers/{workerName}/reboot", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// RebootWorkerSender sends the RebootWorker request. The method will close the
// http.Response Body if it receives an error.
func (client AppServicePlansClient) RebootWorkerSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// RebootWorkerResponder handles the response to the RebootWorker request. The method always
// closes the http.Response Body.
func (client AppServicePlansClient) RebootWorkerResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// RestartWebApps restart all apps in an App Service plan.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the App Service plan.
// softRestart - specify <code>true</code> to performa a soft restart, applies the configuration settings and
// restarts the apps if necessary. The default is <code>false</code>, which always restarts and reprovisions
// the apps
func (client AppServicePlansClient) RestartWebApps(ctx context.Context, resourceGroupName string, name string, softRestart *bool) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServicePlansClient", "RestartWebApps", err.Error())
	}

	req, err := client.RestartWebAppsPreparer(ctx, resourceGroupName, name, softRestart)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "RestartWebApps", nil, "Failure preparing request")
		return
	}

	resp, err := client.RestartWebAppsSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "RestartWebApps", resp, "Failure sending request")
		return
	}

	result, err = client.RestartWebAppsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "RestartWebApps", resp, "Failure responding to request")
	}

	return
}

// RestartWebAppsPreparer prepares the RestartWebApps request.
func (client AppServicePlansClient) RestartWebAppsPreparer(ctx context.Context, resourceGroupName string, name string, softRestart *bool) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if softRestart != nil {
		queryParameters["softRestart"] = autorest.Encode("query", *softRestart)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/restartSites", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// RestartWebAppsSender sends the RestartWebApps request. The method will close the
// http.Response Body if it receives an error.
func (client AppServicePlansClient) RestartWebAppsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// RestartWebAppsResponder handles the response to the RestartWebApps request. The method always
// closes the http.Response Body.
func (client AppServicePlansClient) RestartWebAppsResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Update creates or updates an App Service Plan.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the App Service plan.
// appServicePlan - details of the App Service plan.
func (client AppServicePlansClient) Update(ctx context.Context, resourceGroupName string, name string, appServicePlan AppServicePlanPatchResource) (result AppServicePlan, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServicePlansClient", "Update", err.Error())
	}

	req, err := client.UpdatePreparer(ctx, resourceGroupName, name, appServicePlan)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "Update", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "Update", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "Update", resp, "Failure responding to request")
	}

	return
}

// UpdatePreparer prepares the Update request.
func (client AppServicePlansClient) UpdatePreparer(ctx context.Context, resourceGroupName string, name string, appServicePlan AppServicePlanPatchResource) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}", pathParameters),
		autorest.WithJSON(appServicePlan),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateSender sends the Update request. The method will close the
// http.Response Body if it receives an error.
func (client AppServicePlansClient) UpdateSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// UpdateResponder handles the response to the Update request. The method always
// closes the http.Response Body.
func (client AppServicePlansClient) UpdateResponder(resp *http.Response) (result AppServicePlan, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateVnetGateway update a Virtual Network gateway.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the App Service plan.
// vnetName - name of the Virtual Network.
// gatewayName - name of the gateway. Only the 'primary' gateway is supported.
// connectionEnvelope - definition of the gateway.
func (client AppServicePlansClient) UpdateVnetGateway(ctx context.Context, resourceGroupName string, name string, vnetName string, gatewayName string, connectionEnvelope VnetGateway) (result VnetGateway, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}},
		{TargetValue: connectionEnvelope,
			Constraints: []validation.Constraint{{Target: "connectionEnvelope.VnetGatewayProperties", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "connectionEnvelope.VnetGatewayProperties.VpnPackageURI", Name: validation.Null, Rule: true, Chain: nil}}}}}}); err != nil {
		return result, validation.NewError("web.AppServicePlansClient", "UpdateVnetGateway", err.Error())
	}

	req, err := client.UpdateVnetGatewayPreparer(ctx, resourceGroupName, name, vnetName, gatewayName, connectionEnvelope)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "UpdateVnetGateway", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateVnetGatewaySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "UpdateVnetGateway", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateVnetGatewayResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "UpdateVnetGateway", resp, "Failure responding to request")
	}

	return
}

// UpdateVnetGatewayPreparer prepares the UpdateVnetGateway request.
func (client AppServicePlansClient) UpdateVnetGatewayPreparer(ctx context.Context, resourceGroupName string, name string, vnetName string, gatewayName string, connectionEnvelope VnetGateway) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"gatewayName":       autorest.Encode("path", gatewayName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}", pathParameters),
		autorest.WithJSON(connectionEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateVnetGatewaySender sends the UpdateVnetGateway request. The method will close the
// http.Response Body if it receives an error.
func (client AppServicePlansClient) UpdateVnetGatewaySender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// UpdateVnetGatewayResponder handles the response to the UpdateVnetGateway request. The method always
// closes the http.Response Body.
func (client AppServicePlansClient) UpdateVnetGatewayResponder(resp *http.Response) (result VnetGateway, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateVnetRoute create or update a Virtual Network route in an App Service plan.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the App Service plan.
// vnetName - name of the Virtual Network.
// routeName - name of the Virtual Network route.
// route - definition of the Virtual Network route.
func (client AppServicePlansClient) UpdateVnetRoute(ctx context.Context, resourceGroupName string, name string, vnetName string, routeName string, route VnetRoute) (result VnetRoute, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.AppServicePlansClient", "UpdateVnetRoute", err.Error())
	}

	req, err := client.UpdateVnetRoutePreparer(ctx, resourceGroupName, name, vnetName, routeName, route)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "UpdateVnetRoute", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateVnetRouteSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "UpdateVnetRoute", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateVnetRouteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "UpdateVnetRoute", resp, "Failure responding to request")
	}

	return
}

// UpdateVnetRoutePreparer prepares the UpdateVnetRoute request.
func (client AppServicePlansClient) UpdateVnetRoutePreparer(ctx context.Context, resourceGroupName string, name string, vnetName string, routeName string, route VnetRoute) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"routeName":         autorest.Encode("path", routeName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	const APIVersion = "2018-02-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections/{vnetName}/routes/{routeName}", pathParameters),
		autorest.WithJSON(route),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateVnetRouteSender sends the UpdateVnetRoute request. The method will close the
// http.Response Body if it receives an error.
func (client AppServicePlansClient) UpdateVnetRouteSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// UpdateVnetRouteResponder handles the response to the UpdateVnetRoute request. The method always
// closes the http.Response Body.
func (client AppServicePlansClient) UpdateVnetRouteResponder(resp *http.Response) (result VnetRoute, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusBadRequest, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
