package devices

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"net/http"
)

// AccessRights enumerates the values for access rights.
type AccessRights string

const (
	// DeviceConnect ...
	DeviceConnect AccessRights = "DeviceConnect"
	// RegistryRead ...
	RegistryRead AccessRights = "RegistryRead"
	// RegistryReadDeviceConnect ...
	RegistryReadDeviceConnect AccessRights = "RegistryRead, DeviceConnect"
	// RegistryReadRegistryWrite ...
	RegistryReadRegistryWrite AccessRights = "RegistryRead, RegistryWrite"
	// RegistryReadRegistryWriteDeviceConnect ...
	RegistryReadRegistryWriteDeviceConnect AccessRights = "RegistryRead, RegistryWrite, DeviceConnect"
	// RegistryReadRegistryWriteServiceConnect ...
	RegistryReadRegistryWriteServiceConnect AccessRights = "RegistryRead, RegistryWrite, ServiceConnect"
	// RegistryReadRegistryWriteServiceConnectDeviceConnect ...
	RegistryReadRegistryWriteServiceConnectDeviceConnect AccessRights = "RegistryRead, RegistryWrite, ServiceConnect, DeviceConnect"
	// RegistryReadServiceConnect ...
	RegistryReadServiceConnect AccessRights = "RegistryRead, ServiceConnect"
	// RegistryReadServiceConnectDeviceConnect ...
	RegistryReadServiceConnectDeviceConnect AccessRights = "RegistryRead, ServiceConnect, DeviceConnect"
	// RegistryWrite ...
	RegistryWrite AccessRights = "RegistryWrite"
	// RegistryWriteDeviceConnect ...
	RegistryWriteDeviceConnect AccessRights = "RegistryWrite, DeviceConnect"
	// RegistryWriteServiceConnect ...
	RegistryWriteServiceConnect AccessRights = "RegistryWrite, ServiceConnect"
	// RegistryWriteServiceConnectDeviceConnect ...
	RegistryWriteServiceConnectDeviceConnect AccessRights = "RegistryWrite, ServiceConnect, DeviceConnect"
	// ServiceConnect ...
	ServiceConnect AccessRights = "ServiceConnect"
	// ServiceConnectDeviceConnect ...
	ServiceConnectDeviceConnect AccessRights = "ServiceConnect, DeviceConnect"
)

// PossibleAccessRightsValues returns an array of possible values for the AccessRights const type.
func PossibleAccessRightsValues() []AccessRights {
	return []AccessRights{DeviceConnect, RegistryRead, RegistryReadDeviceConnect, RegistryReadRegistryWrite, RegistryReadRegistryWriteDeviceConnect, RegistryReadRegistryWriteServiceConnect, RegistryReadRegistryWriteServiceConnectDeviceConnect, RegistryReadServiceConnect, RegistryReadServiceConnectDeviceConnect, RegistryWrite, RegistryWriteDeviceConnect, RegistryWriteServiceConnect, RegistryWriteServiceConnectDeviceConnect, ServiceConnect, ServiceConnectDeviceConnect}
}

// Capabilities enumerates the values for capabilities.
type Capabilities string

const (
	// DeviceManagement ...
	DeviceManagement Capabilities = "DeviceManagement"
	// None ...
	None Capabilities = "None"
)

// PossibleCapabilitiesValues returns an array of possible values for the Capabilities const type.
func PossibleCapabilitiesValues() []Capabilities {
	return []Capabilities{DeviceManagement, None}
}

// IotHubNameUnavailabilityReason enumerates the values for iot hub name unavailability reason.
type IotHubNameUnavailabilityReason string

const (
	// AlreadyExists ...
	AlreadyExists IotHubNameUnavailabilityReason = "AlreadyExists"
	// Invalid ...
	Invalid IotHubNameUnavailabilityReason = "Invalid"
)

// PossibleIotHubNameUnavailabilityReasonValues returns an array of possible values for the IotHubNameUnavailabilityReason const type.
func PossibleIotHubNameUnavailabilityReasonValues() []IotHubNameUnavailabilityReason {
	return []IotHubNameUnavailabilityReason{AlreadyExists, Invalid}
}

// IotHubScaleType enumerates the values for iot hub scale type.
type IotHubScaleType string

const (
	// IotHubScaleTypeAutomatic ...
	IotHubScaleTypeAutomatic IotHubScaleType = "Automatic"
	// IotHubScaleTypeManual ...
	IotHubScaleTypeManual IotHubScaleType = "Manual"
	// IotHubScaleTypeNone ...
	IotHubScaleTypeNone IotHubScaleType = "None"
)

// PossibleIotHubScaleTypeValues returns an array of possible values for the IotHubScaleType const type.
func PossibleIotHubScaleTypeValues() []IotHubScaleType {
	return []IotHubScaleType{IotHubScaleTypeAutomatic, IotHubScaleTypeManual, IotHubScaleTypeNone}
}

// IotHubSku enumerates the values for iot hub sku.
type IotHubSku string

const (
	// F1 ...
	F1 IotHubSku = "F1"
	// S1 ...
	S1 IotHubSku = "S1"
	// S2 ...
	S2 IotHubSku = "S2"
	// S3 ...
	S3 IotHubSku = "S3"
)

// PossibleIotHubSkuValues returns an array of possible values for the IotHubSku const type.
func PossibleIotHubSkuValues() []IotHubSku {
	return []IotHubSku{F1, S1, S2, S3}
}

// IotHubSkuTier enumerates the values for iot hub sku tier.
type IotHubSkuTier string

const (
	// Free ...
	Free IotHubSkuTier = "Free"
	// Standard ...
	Standard IotHubSkuTier = "Standard"
)

// PossibleIotHubSkuTierValues returns an array of possible values for the IotHubSkuTier const type.
func PossibleIotHubSkuTierValues() []IotHubSkuTier {
	return []IotHubSkuTier{Free, Standard}
}

// IPFilterActionType enumerates the values for ip filter action type.
type IPFilterActionType string

const (
	// Accept ...
	Accept IPFilterActionType = "Accept"
	// Reject ...
	Reject IPFilterActionType = "Reject"
)

// PossibleIPFilterActionTypeValues returns an array of possible values for the IPFilterActionType const type.
func PossibleIPFilterActionTypeValues() []IPFilterActionType {
	return []IPFilterActionType{Accept, Reject}
}

// JobStatus enumerates the values for job status.
type JobStatus string

const (
	// Cancelled ...
	Cancelled JobStatus = "cancelled"
	// Completed ...
	Completed JobStatus = "completed"
	// Enqueued ...
	Enqueued JobStatus = "enqueued"
	// Failed ...
	Failed JobStatus = "failed"
	// Running ...
	Running JobStatus = "running"
	// Unknown ...
	Unknown JobStatus = "unknown"
)

// PossibleJobStatusValues returns an array of possible values for the JobStatus const type.
func PossibleJobStatusValues() []JobStatus {
	return []JobStatus{Cancelled, Completed, Enqueued, Failed, Running, Unknown}
}

// JobType enumerates the values for job type.
type JobType string

const (
	// JobTypeBackup ...
	JobTypeBackup JobType = "backup"
	// JobTypeExport ...
	JobTypeExport JobType = "export"
	// JobTypeFactoryResetDevice ...
	JobTypeFactoryResetDevice JobType = "factoryResetDevice"
	// JobTypeFirmwareUpdate ...
	JobTypeFirmwareUpdate JobType = "firmwareUpdate"
	// JobTypeImport ...
	JobTypeImport JobType = "import"
	// JobTypeReadDeviceProperties ...
	JobTypeReadDeviceProperties JobType = "readDeviceProperties"
	// JobTypeRebootDevice ...
	JobTypeRebootDevice JobType = "rebootDevice"
	// JobTypeUnknown ...
	JobTypeUnknown JobType = "unknown"
	// JobTypeUpdateDeviceConfiguration ...
	JobTypeUpdateDeviceConfiguration JobType = "updateDeviceConfiguration"
	// JobTypeWriteDeviceProperties ...
	JobTypeWriteDeviceProperties JobType = "writeDeviceProperties"
)

// PossibleJobTypeValues returns an array of possible values for the JobType const type.
func PossibleJobTypeValues() []JobType {
	return []JobType{JobTypeBackup, JobTypeExport, JobTypeFactoryResetDevice, JobTypeFirmwareUpdate, JobTypeImport, JobTypeReadDeviceProperties, JobTypeRebootDevice, JobTypeUnknown, JobTypeUpdateDeviceConfiguration, JobTypeWriteDeviceProperties}
}

// OperationMonitoringLevel enumerates the values for operation monitoring level.
type OperationMonitoringLevel string

const (
	// OperationMonitoringLevelError ...
	OperationMonitoringLevelError OperationMonitoringLevel = "Error"
	// OperationMonitoringLevelErrorInformation ...
	OperationMonitoringLevelErrorInformation OperationMonitoringLevel = "Error, Information"
	// OperationMonitoringLevelInformation ...
	OperationMonitoringLevelInformation OperationMonitoringLevel = "Information"
	// OperationMonitoringLevelNone ...
	OperationMonitoringLevelNone OperationMonitoringLevel = "None"
)

// PossibleOperationMonitoringLevelValues returns an array of possible values for the OperationMonitoringLevel const type.
func PossibleOperationMonitoringLevelValues() []OperationMonitoringLevel {
	return []OperationMonitoringLevel{OperationMonitoringLevelError, OperationMonitoringLevelErrorInformation, OperationMonitoringLevelInformation, OperationMonitoringLevelNone}
}

// RoutingSource enumerates the values for routing source.
type RoutingSource string

const (
	// DeviceJobLifecycleEvents ...
	DeviceJobLifecycleEvents RoutingSource = "DeviceJobLifecycleEvents"
	// DeviceLifecycleEvents ...
	DeviceLifecycleEvents RoutingSource = "DeviceLifecycleEvents"
	// DeviceMessages ...
	DeviceMessages RoutingSource = "DeviceMessages"
	// TwinChangeEvents ...
	TwinChangeEvents RoutingSource = "TwinChangeEvents"
)

// PossibleRoutingSourceValues returns an array of possible values for the RoutingSource const type.
func PossibleRoutingSourceValues() []RoutingSource {
	return []RoutingSource{DeviceJobLifecycleEvents, DeviceLifecycleEvents, DeviceMessages, TwinChangeEvents}
}

// CloudToDeviceProperties the IoT hub cloud-to-device messaging properties.
type CloudToDeviceProperties struct {
	// MaxDeliveryCount - The max delivery count for cloud-to-device messages in the device queue. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
	MaxDeliveryCount *int32 `json:"maxDeliveryCount,omitempty"`
	// DefaultTTLAsIso8601 - The default time to live for cloud-to-device messages in the device queue. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
	DefaultTTLAsIso8601 *string             `json:"defaultTtlAsIso8601,omitempty"`
	Feedback            *FeedbackProperties `json:"feedback,omitempty"`
}

// ErrorDetails error details.
type ErrorDetails struct {
	// Code - The error code.
	Code *string `json:"Code,omitempty"`
	// HTTPStatusCode - The HTTP status code.
	HTTPStatusCode *string `json:"HttpStatusCode,omitempty"`
	// Message - The error message.
	Message *string `json:"Message,omitempty"`
	// Details - The error details.
	Details *string `json:"Details,omitempty"`
}

// EventHubConsumerGroupInfo the properties of the EventHubConsumerGroupInfo object.
type EventHubConsumerGroupInfo struct {
	autorest.Response `json:"-"`
	// Tags - The tags.
	Tags map[string]*string `json:"tags"`
	// ID - The Event Hub-compatible consumer group identifier.
	ID *string `json:"id,omitempty"`
	// Name - The Event Hub-compatible consumer group name.
	Name *string `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for EventHubConsumerGroupInfo.
func (ehcgi EventHubConsumerGroupInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ehcgi.Tags != nil {
		objectMap["tags"] = ehcgi.Tags
	}
	if ehcgi.ID != nil {
		objectMap["id"] = ehcgi.ID
	}
	if ehcgi.Name != nil {
		objectMap["name"] = ehcgi.Name
	}
	return json.Marshal(objectMap)
}

// EventHubConsumerGroupsListResult the JSON-serialized array of Event Hub-compatible consumer group names with a
// next link.
type EventHubConsumerGroupsListResult struct {
	autorest.Response `json:"-"`
	// Value - The array of Event Hub-compatible consumer group names.
	Value *[]string `json:"value,omitempty"`
	// NextLink - The next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// EventHubConsumerGroupsListResultIterator provides access to a complete listing of string values.
type EventHubConsumerGroupsListResultIterator struct {
	i    int
	page EventHubConsumerGroupsListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *EventHubConsumerGroupsListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter EventHubConsumerGroupsListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter EventHubConsumerGroupsListResultIterator) Response() EventHubConsumerGroupsListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter EventHubConsumerGroupsListResultIterator) Value() string {
	if !iter.page.NotDone() {
		return ""
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (ehcglr EventHubConsumerGroupsListResult) IsEmpty() bool {
	return ehcglr.Value == nil || len(*ehcglr.Value) == 0
}

// eventHubConsumerGroupsListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ehcglr EventHubConsumerGroupsListResult) eventHubConsumerGroupsListResultPreparer() (*http.Request, error) {
	if ehcglr.NextLink == nil || len(to.String(ehcglr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ehcglr.NextLink)))
}

// EventHubConsumerGroupsListResultPage contains a page of string values.
type EventHubConsumerGroupsListResultPage struct {
	fn     func(EventHubConsumerGroupsListResult) (EventHubConsumerGroupsListResult, error)
	ehcglr EventHubConsumerGroupsListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *EventHubConsumerGroupsListResultPage) Next() error {
	next, err := page.fn(page.ehcglr)
	if err != nil {
		return err
	}
	page.ehcglr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page EventHubConsumerGroupsListResultPage) NotDone() bool {
	return !page.ehcglr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page EventHubConsumerGroupsListResultPage) Response() EventHubConsumerGroupsListResult {
	return page.ehcglr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page EventHubConsumerGroupsListResultPage) Values() []string {
	if page.ehcglr.IsEmpty() {
		return nil
	}
	return *page.ehcglr.Value
}

// EventHubProperties the properties of the provisioned Event Hub-compatible endpoint used by the IoT hub.
type EventHubProperties struct {
	// RetentionTimeInDays - The retention time for device-to-cloud messages in days. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#device-to-cloud-messages
	RetentionTimeInDays *int64 `json:"retentionTimeInDays,omitempty"`
	// PartitionCount - The number of paritions for receiving device-to-cloud messages in the Event Hub-compatible endpoint. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#device-to-cloud-messages.
	PartitionCount *int32 `json:"partitionCount,omitempty"`
	// PartitionIds - The partition ids in the Event Hub-compatible endpoint.
	PartitionIds *[]string `json:"partitionIds,omitempty"`
	// Path - The Event Hub-compatible name.
	Path *string `json:"path,omitempty"`
	// Endpoint - The Event Hub-compatible endpoint.
	Endpoint *string `json:"endpoint,omitempty"`
}

// ExportDevicesRequest use to provide parameters when requesting an export of all devices in the IoT hub.
type ExportDevicesRequest struct {
	// ExportBlobContainerURI - The export blob container URI.
	ExportBlobContainerURI *string `json:"ExportBlobContainerUri,omitempty"`
	// ExcludeKeys - The value indicating whether keys should be excluded during export.
	ExcludeKeys *bool `json:"ExcludeKeys,omitempty"`
}

// FallbackRouteProperties the properties related to the fallback route based on which the IoT hub routes messages
// to the fallback endpoint.
type FallbackRouteProperties struct {
	// Source - The source to which the routing rule is to be applied to. e.g. DeviceMessages
	Source *string `json:"source,omitempty"`
	// Condition - The condition which is evaluated in order to apply the fallback route. If the condition is not provided it will evaluate to true by default. For grammar, See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-query-language
	Condition *string `json:"condition,omitempty"`
	// EndpointNames - The list of endpoints to which the messages that satisfy the condition are routed to. Currently only 1 endpoint is allowed.
	EndpointNames *[]string `json:"endpointNames,omitempty"`
	// IsEnabled - Used to specify whether the fallback route is enabled or not.
	IsEnabled *bool `json:"isEnabled,omitempty"`
}

// FeedbackProperties the properties of the feedback queue for cloud-to-device messages.
type FeedbackProperties struct {
	// LockDurationAsIso8601 - The lock duration for the feedback queue. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
	LockDurationAsIso8601 *string `json:"lockDurationAsIso8601,omitempty"`
	// TTLAsIso8601 - The period of time for which a message is available to consume before it is expired by the IoT hub. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
	TTLAsIso8601 *string `json:"ttlAsIso8601,omitempty"`
	// MaxDeliveryCount - The number of times the IoT hub attempts to deliver a message on the feedback queue. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
	MaxDeliveryCount *int32 `json:"maxDeliveryCount,omitempty"`
}

// ImportDevicesRequest use to provide parameters when requesting an import of all devices in the hub.
type ImportDevicesRequest struct {
	// InputBlobContainerURI - The input blob container URI.
	InputBlobContainerURI *string `json:"InputBlobContainerUri,omitempty"`
	// OutputBlobContainerURI - The output blob container URI.
	OutputBlobContainerURI *string `json:"OutputBlobContainerUri,omitempty"`
}

// IotHubCapacity ioT Hub capacity information.
type IotHubCapacity struct {
	// Minimum - The minimum number of units.
	Minimum *int64 `json:"minimum,omitempty"`
	// Maximum - The maximum number of units.
	Maximum *int64 `json:"maximum,omitempty"`
	// Default - The default number of units.
	Default *int64 `json:"default,omitempty"`
	// ScaleType - The type of the scaling enabled. Possible values include: 'IotHubScaleTypeAutomatic', 'IotHubScaleTypeManual', 'IotHubScaleTypeNone'
	ScaleType IotHubScaleType `json:"scaleType,omitempty"`
}

// IotHubDescription the description of the IoT hub.
type IotHubDescription struct {
	autorest.Response `json:"-"`
	// Subscriptionid - The subscription identifier.
	Subscriptionid *string `json:"subscriptionid,omitempty"`
	// Resourcegroup - The name of the resource group that contains the IoT hub. A resource group name uniquely identifies the resource group within the subscription.
	Resourcegroup *string `json:"resourcegroup,omitempty"`
	// Etag - The Etag field is *not* required. If it is provided in the response body, it must also be provided as a header per the normal ETag convention.
	Etag       *string           `json:"etag,omitempty"`
	Properties *IotHubProperties `json:"properties,omitempty"`
	Sku        *IotHubSkuInfo    `json:"sku,omitempty"`
	// ID - The resource identifier.
	ID *string `json:"id,omitempty"`
	// Name - The resource name.
	Name *string `json:"name,omitempty"`
	// Type - The resource type.
	Type *string `json:"type,omitempty"`
	// Location - The resource location.
	Location *string `json:"location,omitempty"`
	// Tags - The resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for IotHubDescription.
func (ihd IotHubDescription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ihd.Subscriptionid != nil {
		objectMap["subscriptionid"] = ihd.Subscriptionid
	}
	if ihd.Resourcegroup != nil {
		objectMap["resourcegroup"] = ihd.Resourcegroup
	}
	if ihd.Etag != nil {
		objectMap["etag"] = ihd.Etag
	}
	if ihd.Properties != nil {
		objectMap["properties"] = ihd.Properties
	}
	if ihd.Sku != nil {
		objectMap["sku"] = ihd.Sku
	}
	if ihd.ID != nil {
		objectMap["id"] = ihd.ID
	}
	if ihd.Name != nil {
		objectMap["name"] = ihd.Name
	}
	if ihd.Type != nil {
		objectMap["type"] = ihd.Type
	}
	if ihd.Location != nil {
		objectMap["location"] = ihd.Location
	}
	if ihd.Tags != nil {
		objectMap["tags"] = ihd.Tags
	}
	return json.Marshal(objectMap)
}

// IotHubDescriptionListResult the JSON-serialized array of IotHubDescription objects with a next link.
type IotHubDescriptionListResult struct {
	autorest.Response `json:"-"`
	// Value - The array of IotHubDescription objects.
	Value *[]IotHubDescription `json:"value,omitempty"`
	// NextLink - The next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// IotHubDescriptionListResultIterator provides access to a complete listing of IotHubDescription values.
type IotHubDescriptionListResultIterator struct {
	i    int
	page IotHubDescriptionListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *IotHubDescriptionListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter IotHubDescriptionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter IotHubDescriptionListResultIterator) Response() IotHubDescriptionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter IotHubDescriptionListResultIterator) Value() IotHubDescription {
	if !iter.page.NotDone() {
		return IotHubDescription{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (ihdlr IotHubDescriptionListResult) IsEmpty() bool {
	return ihdlr.Value == nil || len(*ihdlr.Value) == 0
}

// iotHubDescriptionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ihdlr IotHubDescriptionListResult) iotHubDescriptionListResultPreparer() (*http.Request, error) {
	if ihdlr.NextLink == nil || len(to.String(ihdlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ihdlr.NextLink)))
}

// IotHubDescriptionListResultPage contains a page of IotHubDescription values.
type IotHubDescriptionListResultPage struct {
	fn    func(IotHubDescriptionListResult) (IotHubDescriptionListResult, error)
	ihdlr IotHubDescriptionListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *IotHubDescriptionListResultPage) Next() error {
	next, err := page.fn(page.ihdlr)
	if err != nil {
		return err
	}
	page.ihdlr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page IotHubDescriptionListResultPage) NotDone() bool {
	return !page.ihdlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page IotHubDescriptionListResultPage) Response() IotHubDescriptionListResult {
	return page.ihdlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page IotHubDescriptionListResultPage) Values() []IotHubDescription {
	if page.ihdlr.IsEmpty() {
		return nil
	}
	return *page.ihdlr.Value
}

// IotHubNameAvailabilityInfo the properties indicating whether a given IoT hub name is available.
type IotHubNameAvailabilityInfo struct {
	autorest.Response `json:"-"`
	// NameAvailable - The value which indicates whether the provided name is available.
	NameAvailable *bool `json:"nameAvailable,omitempty"`
	// Reason - The reason for unavailability. Possible values include: 'Invalid', 'AlreadyExists'
	Reason IotHubNameUnavailabilityReason `json:"reason,omitempty"`
	// Message - The detailed reason message.
	Message *string `json:"message,omitempty"`
}

// IotHubProperties the properties of an IoT hub.
type IotHubProperties struct {
	// AuthorizationPolicies - The shared access policies you can use to secure a connection to the IoT hub.
	AuthorizationPolicies *[]SharedAccessSignatureAuthorizationRule `json:"authorizationPolicies,omitempty"`
	// IPFilterRules - The IP filter rules.
	IPFilterRules *[]IPFilterRule `json:"ipFilterRules,omitempty"`
	// ProvisioningState - The provisioning state.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// HostName - The name of the host.
	HostName *string `json:"hostName,omitempty"`
	// EventHubEndpoints - The Event Hub-compatible endpoint properties. The possible keys to this dictionary are events and operationsMonitoringEvents. Both of these keys have to be present in the dictionary while making create or update calls for the IoT hub.
	EventHubEndpoints map[string]*EventHubProperties `json:"eventHubEndpoints"`
	Routing           *RoutingProperties             `json:"routing,omitempty"`
	// StorageEndpoints - The list of Azure Storage endpoints where you can upload files. Currently you can configure only one Azure Storage account and that MUST have its key as $default. Specifying more than one storage account causes an error to be thrown. Not specifying a value for this property when the enableFileUploadNotifications property is set to True, causes an error to be thrown.
	StorageEndpoints map[string]*StorageEndpointProperties `json:"storageEndpoints"`
	// MessagingEndpoints - The messaging endpoint properties for the file upload notification queue.
	MessagingEndpoints map[string]*MessagingEndpointProperties `json:"messagingEndpoints"`
	// EnableFileUploadNotifications - If True, file upload notifications are enabled.
	EnableFileUploadNotifications *bool                    `json:"enableFileUploadNotifications,omitempty"`
	CloudToDevice                 *CloudToDeviceProperties `json:"cloudToDevice,omitempty"`
	// Comments - Comments.
	Comments                       *string                         `json:"comments,omitempty"`
	OperationsMonitoringProperties *OperationsMonitoringProperties `json:"operationsMonitoringProperties,omitempty"`
	// Features - The capabilities and features enabled for the IoT hub. Possible values include: 'None', 'DeviceManagement'
	Features Capabilities `json:"features,omitempty"`
}

// MarshalJSON is the custom marshaler for IotHubProperties.
func (ihp IotHubProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ihp.AuthorizationPolicies != nil {
		objectMap["authorizationPolicies"] = ihp.AuthorizationPolicies
	}
	if ihp.IPFilterRules != nil {
		objectMap["ipFilterRules"] = ihp.IPFilterRules
	}
	if ihp.ProvisioningState != nil {
		objectMap["provisioningState"] = ihp.ProvisioningState
	}
	if ihp.HostName != nil {
		objectMap["hostName"] = ihp.HostName
	}
	if ihp.EventHubEndpoints != nil {
		objectMap["eventHubEndpoints"] = ihp.EventHubEndpoints
	}
	if ihp.Routing != nil {
		objectMap["routing"] = ihp.Routing
	}
	if ihp.StorageEndpoints != nil {
		objectMap["storageEndpoints"] = ihp.StorageEndpoints
	}
	if ihp.MessagingEndpoints != nil {
		objectMap["messagingEndpoints"] = ihp.MessagingEndpoints
	}
	if ihp.EnableFileUploadNotifications != nil {
		objectMap["enableFileUploadNotifications"] = ihp.EnableFileUploadNotifications
	}
	if ihp.CloudToDevice != nil {
		objectMap["cloudToDevice"] = ihp.CloudToDevice
	}
	if ihp.Comments != nil {
		objectMap["comments"] = ihp.Comments
	}
	if ihp.OperationsMonitoringProperties != nil {
		objectMap["operationsMonitoringProperties"] = ihp.OperationsMonitoringProperties
	}
	if ihp.Features != "" {
		objectMap["features"] = ihp.Features
	}
	return json.Marshal(objectMap)
}

// IotHubQuotaMetricInfo quota metrics properties.
type IotHubQuotaMetricInfo struct {
	// Name - The name of the quota metric.
	Name *string `json:"Name,omitempty"`
	// CurrentValue - The current value for the quota metric.
	CurrentValue *int64 `json:"CurrentValue,omitempty"`
	// MaxValue - The maximum value of the quota metric.
	MaxValue *int64 `json:"MaxValue,omitempty"`
}

// IotHubQuotaMetricInfoListResult the JSON-serialized array of IotHubQuotaMetricInfo objects with a next link.
type IotHubQuotaMetricInfoListResult struct {
	autorest.Response `json:"-"`
	// Value - The array of quota metrics objects.
	Value *[]IotHubQuotaMetricInfo `json:"value,omitempty"`
	// NextLink - The next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// IotHubQuotaMetricInfoListResultIterator provides access to a complete listing of IotHubQuotaMetricInfo values.
type IotHubQuotaMetricInfoListResultIterator struct {
	i    int
	page IotHubQuotaMetricInfoListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *IotHubQuotaMetricInfoListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter IotHubQuotaMetricInfoListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter IotHubQuotaMetricInfoListResultIterator) Response() IotHubQuotaMetricInfoListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter IotHubQuotaMetricInfoListResultIterator) Value() IotHubQuotaMetricInfo {
	if !iter.page.NotDone() {
		return IotHubQuotaMetricInfo{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (ihqmilr IotHubQuotaMetricInfoListResult) IsEmpty() bool {
	return ihqmilr.Value == nil || len(*ihqmilr.Value) == 0
}

// iotHubQuotaMetricInfoListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ihqmilr IotHubQuotaMetricInfoListResult) iotHubQuotaMetricInfoListResultPreparer() (*http.Request, error) {
	if ihqmilr.NextLink == nil || len(to.String(ihqmilr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ihqmilr.NextLink)))
}

// IotHubQuotaMetricInfoListResultPage contains a page of IotHubQuotaMetricInfo values.
type IotHubQuotaMetricInfoListResultPage struct {
	fn      func(IotHubQuotaMetricInfoListResult) (IotHubQuotaMetricInfoListResult, error)
	ihqmilr IotHubQuotaMetricInfoListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *IotHubQuotaMetricInfoListResultPage) Next() error {
	next, err := page.fn(page.ihqmilr)
	if err != nil {
		return err
	}
	page.ihqmilr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page IotHubQuotaMetricInfoListResultPage) NotDone() bool {
	return !page.ihqmilr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page IotHubQuotaMetricInfoListResultPage) Response() IotHubQuotaMetricInfoListResult {
	return page.ihqmilr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page IotHubQuotaMetricInfoListResultPage) Values() []IotHubQuotaMetricInfo {
	if page.ihqmilr.IsEmpty() {
		return nil
	}
	return *page.ihqmilr.Value
}

// IotHubResourceCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type IotHubResourceCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *IotHubResourceCreateOrUpdateFuture) Result(client IotHubResourceClient) (ihd IotHubDescription, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "devices.IotHubResourceCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("devices.IotHubResourceCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ihd.Response.Response, err = future.GetResult(sender); err == nil && ihd.Response.Response.StatusCode != http.StatusNoContent {
		ihd, err = client.CreateOrUpdateResponder(ihd.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "devices.IotHubResourceCreateOrUpdateFuture", "Result", ihd.Response.Response, "Failure responding to request")
		}
	}
	return
}

// IotHubResourceDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type IotHubResourceDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *IotHubResourceDeleteFuture) Result(client IotHubResourceClient) (so SetObject, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "devices.IotHubResourceDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("devices.IotHubResourceDeleteFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if so.Response.Response, err = future.GetResult(sender); err == nil && so.Response.Response.StatusCode != http.StatusNoContent {
		so, err = client.DeleteResponder(so.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "devices.IotHubResourceDeleteFuture", "Result", so.Response.Response, "Failure responding to request")
		}
	}
	return
}

// IotHubSkuDescription SKU properties.
type IotHubSkuDescription struct {
	// ResourceType - The type of the resource.
	ResourceType *string         `json:"resourceType,omitempty"`
	Sku          *IotHubSkuInfo  `json:"sku,omitempty"`
	Capacity     *IotHubCapacity `json:"capacity,omitempty"`
}

// IotHubSkuDescriptionListResult the JSON-serialized array of IotHubSkuDescription objects with a next link.
type IotHubSkuDescriptionListResult struct {
	autorest.Response `json:"-"`
	// Value - The array of IotHubSkuDescription.
	Value *[]IotHubSkuDescription `json:"value,omitempty"`
	// NextLink - The next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// IotHubSkuDescriptionListResultIterator provides access to a complete listing of IotHubSkuDescription values.
type IotHubSkuDescriptionListResultIterator struct {
	i    int
	page IotHubSkuDescriptionListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *IotHubSkuDescriptionListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter IotHubSkuDescriptionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter IotHubSkuDescriptionListResultIterator) Response() IotHubSkuDescriptionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter IotHubSkuDescriptionListResultIterator) Value() IotHubSkuDescription {
	if !iter.page.NotDone() {
		return IotHubSkuDescription{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (ihsdlr IotHubSkuDescriptionListResult) IsEmpty() bool {
	return ihsdlr.Value == nil || len(*ihsdlr.Value) == 0
}

// iotHubSkuDescriptionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ihsdlr IotHubSkuDescriptionListResult) iotHubSkuDescriptionListResultPreparer() (*http.Request, error) {
	if ihsdlr.NextLink == nil || len(to.String(ihsdlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ihsdlr.NextLink)))
}

// IotHubSkuDescriptionListResultPage contains a page of IotHubSkuDescription values.
type IotHubSkuDescriptionListResultPage struct {
	fn     func(IotHubSkuDescriptionListResult) (IotHubSkuDescriptionListResult, error)
	ihsdlr IotHubSkuDescriptionListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *IotHubSkuDescriptionListResultPage) Next() error {
	next, err := page.fn(page.ihsdlr)
	if err != nil {
		return err
	}
	page.ihsdlr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page IotHubSkuDescriptionListResultPage) NotDone() bool {
	return !page.ihsdlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page IotHubSkuDescriptionListResultPage) Response() IotHubSkuDescriptionListResult {
	return page.ihsdlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page IotHubSkuDescriptionListResultPage) Values() []IotHubSkuDescription {
	if page.ihsdlr.IsEmpty() {
		return nil
	}
	return *page.ihsdlr.Value
}

// IotHubSkuInfo information about the SKU of the IoT hub.
type IotHubSkuInfo struct {
	// Name - The name of the SKU. Possible values include: 'F1', 'S1', 'S2', 'S3'
	Name IotHubSku `json:"name,omitempty"`
	// Tier - The billing tier for the IoT hub. Possible values include: 'Free', 'Standard'
	Tier IotHubSkuTier `json:"tier,omitempty"`
	// Capacity - The number of provisioned IoT Hub units. See: https://docs.microsoft.com/azure/azure-subscription-service-limits#iot-hub-limits.
	Capacity *int64 `json:"capacity,omitempty"`
}

// IPFilterRule the IP filter rules for the IoT hub.
type IPFilterRule struct {
	// FilterName - The name of the IP filter rule.
	FilterName *string `json:"filterName,omitempty"`
	// Action - The desired action for requests captured by this rule. Possible values include: 'Accept', 'Reject'
	Action IPFilterActionType `json:"action,omitempty"`
	// IPMask - A string that contains the IP address range in CIDR notation for the rule.
	IPMask *string `json:"ipMask,omitempty"`
}

// JobResponse the properties of the Job Response object.
type JobResponse struct {
	autorest.Response `json:"-"`
	// JobID - The job identifier.
	JobID *string `json:"jobId,omitempty"`
	// StartTimeUtc - The start time of the job.
	StartTimeUtc *date.TimeRFC1123 `json:"startTimeUtc,omitempty"`
	// EndTimeUtc - The time the job stopped processing.
	EndTimeUtc *date.TimeRFC1123 `json:"endTimeUtc,omitempty"`
	// Type - The type of the job. Possible values include: 'JobTypeUnknown', 'JobTypeExport', 'JobTypeImport', 'JobTypeBackup', 'JobTypeReadDeviceProperties', 'JobTypeWriteDeviceProperties', 'JobTypeUpdateDeviceConfiguration', 'JobTypeRebootDevice', 'JobTypeFactoryResetDevice', 'JobTypeFirmwareUpdate'
	Type JobType `json:"type,omitempty"`
	// Status - The status of the job. Possible values include: 'Unknown', 'Enqueued', 'Running', 'Completed', 'Failed', 'Cancelled'
	Status JobStatus `json:"status,omitempty"`
	// FailureReason - If status == failed, this string containing the reason for the failure.
	FailureReason *string `json:"failureReason,omitempty"`
	// StatusMessage - The status message for the job.
	StatusMessage *string `json:"statusMessage,omitempty"`
	// ParentJobID - The job identifier of the parent job, if any.
	ParentJobID *string `json:"parentJobId,omitempty"`
}

// JobResponseListResult the JSON-serialized array of JobResponse objects with a next link.
type JobResponseListResult struct {
	autorest.Response `json:"-"`
	// Value - The array of JobResponse objects.
	Value *[]JobResponse `json:"value,omitempty"`
	// NextLink - The next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// JobResponseListResultIterator provides access to a complete listing of JobResponse values.
type JobResponseListResultIterator struct {
	i    int
	page JobResponseListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *JobResponseListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter JobResponseListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter JobResponseListResultIterator) Response() JobResponseListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter JobResponseListResultIterator) Value() JobResponse {
	if !iter.page.NotDone() {
		return JobResponse{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (jrlr JobResponseListResult) IsEmpty() bool {
	return jrlr.Value == nil || len(*jrlr.Value) == 0
}

// jobResponseListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (jrlr JobResponseListResult) jobResponseListResultPreparer() (*http.Request, error) {
	if jrlr.NextLink == nil || len(to.String(jrlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(jrlr.NextLink)))
}

// JobResponseListResultPage contains a page of JobResponse values.
type JobResponseListResultPage struct {
	fn   func(JobResponseListResult) (JobResponseListResult, error)
	jrlr JobResponseListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *JobResponseListResultPage) Next() error {
	next, err := page.fn(page.jrlr)
	if err != nil {
		return err
	}
	page.jrlr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page JobResponseListResultPage) NotDone() bool {
	return !page.jrlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page JobResponseListResultPage) Response() JobResponseListResult {
	return page.jrlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page JobResponseListResultPage) Values() []JobResponse {
	if page.jrlr.IsEmpty() {
		return nil
	}
	return *page.jrlr.Value
}

// MessagingEndpointProperties the properties of the messaging endpoints used by this IoT hub.
type MessagingEndpointProperties struct {
	// LockDurationAsIso8601 - The lock duration. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-file-upload.
	LockDurationAsIso8601 *string `json:"lockDurationAsIso8601,omitempty"`
	// TTLAsIso8601 - The period of time for which a message is available to consume before it is expired by the IoT hub. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-file-upload.
	TTLAsIso8601 *string `json:"ttlAsIso8601,omitempty"`
	// MaxDeliveryCount - The number of times the IoT hub attempts to deliver a message. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-file-upload.
	MaxDeliveryCount *int32 `json:"maxDeliveryCount,omitempty"`
}

// OperationInputs input values.
type OperationInputs struct {
	// Name - The name of the IoT hub to check.
	Name *string `json:"Name,omitempty"`
}

// OperationsMonitoringProperties the operations monitoring properties for the IoT hub. The possible keys to the
// dictionary are Connections, DeviceTelemetry, C2DCommands, DeviceIdentityOperations, FileUploadOperations,
// Routes, D2CTwinOperations, C2DTwinOperations, TwinQueries, JobsOperations, DirectMethods.
type OperationsMonitoringProperties struct {
	Events map[string]*OperationMonitoringLevel `json:"events"`
}

// MarshalJSON is the custom marshaler for OperationsMonitoringProperties.
func (omp OperationsMonitoringProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if omp.Events != nil {
		objectMap["events"] = omp.Events
	}
	return json.Marshal(objectMap)
}

// RegistryStatistics identity registry statistics.
type RegistryStatistics struct {
	autorest.Response `json:"-"`
	// TotalDeviceCount - The total count of devices in the identity registry.
	TotalDeviceCount *int64 `json:"totalDeviceCount,omitempty"`
	// EnabledDeviceCount - The count of enabled devices in the identity registry.
	EnabledDeviceCount *int64 `json:"enabledDeviceCount,omitempty"`
	// DisabledDeviceCount - The count of disabled devices in the identity registry.
	DisabledDeviceCount *int64 `json:"disabledDeviceCount,omitempty"`
}

// Resource the common properties of an Azure resource.
type Resource struct {
	// ID - The resource identifier.
	ID *string `json:"id,omitempty"`
	// Name - The resource name.
	Name *string `json:"name,omitempty"`
	// Type - The resource type.
	Type *string `json:"type,omitempty"`
	// Location - The resource location.
	Location *string `json:"location,omitempty"`
	// Tags - The resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.ID != nil {
		objectMap["id"] = r.ID
	}
	if r.Name != nil {
		objectMap["name"] = r.Name
	}
	if r.Type != nil {
		objectMap["type"] = r.Type
	}
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	return json.Marshal(objectMap)
}

// RouteProperties the properties of a routing rule that your IoT hub uses to route messages to endpoints.
type RouteProperties struct {
	// Name - The name of the route. The name can only include alphanumeric characters, periods, underscores, hyphens, has a maximum length of 64 characters,  and must be unique.
	Name *string `json:"name,omitempty"`
	// Source - The source that the routing rule is to be applied to, such as DeviceMessages. Possible values include: 'DeviceMessages', 'TwinChangeEvents', 'DeviceLifecycleEvents', 'DeviceJobLifecycleEvents'
	Source RoutingSource `json:"source,omitempty"`
	// Condition - The condition that is evaluated to apply the routing rule. If no condition is provided, it evaluates to true by default. For grammar, See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-query-language
	Condition *string `json:"condition,omitempty"`
	// EndpointNames - The list of endpoints to which messages that satisfy the condition are routed. Currently only one endpoint is allowed.
	EndpointNames *[]string `json:"endpointNames,omitempty"`
	// IsEnabled - Used to specify whether a route is enabled.
	IsEnabled *bool `json:"isEnabled,omitempty"`
}

// RoutingEndpoints the properties related to the custom endpoints to which your IoT hub routes messages based on
// the routing rules. A maximum of 10 custom endpoints are allowed across all endpoint types for paid hubs and only
// 1 custom endpoint is allowed across all endpoint types for free hubs.
type RoutingEndpoints struct {
	// ServiceBusQueues - The list of Service Bus queue endpoints that IoT hub routes the messages to, based on the routing rules.
	ServiceBusQueues *[]RoutingServiceBusQueueEndpointProperties `json:"serviceBusQueues,omitempty"`
	// ServiceBusTopics - The list of Service Bus topic endpoints that the IoT hub routes the messages to, based on the routing rules.
	ServiceBusTopics *[]RoutingServiceBusTopicEndpointProperties `json:"serviceBusTopics,omitempty"`
	// EventHubs - The list of Event Hubs endpoints that IoT hub routes messages to, based on the routing rules. This list does not include the built-in Event Hubs endpoint.
	EventHubs *[]RoutingEventHubProperties `json:"eventHubs,omitempty"`
}

// RoutingEventHubProperties the properties related to an event hub endpoint.
type RoutingEventHubProperties struct {
	// ConnectionString - The connection string of the event hub endpoint.
	ConnectionString *string `json:"connectionString,omitempty"`
	// Name - The name of the event hub endpoint. The name can only include alphanumeric characters, periods, underscores, hyphens and has a maximum length of 64 characters. The following names are reserved;  events, operationsMonitoringEvents, fileNotifications, $default. Endpoint names must be unique across endpoint types.
	Name *string `json:"name,omitempty"`
	// SubscriptionID - The subscription identifier of the event hub endpoint.
	SubscriptionID *string `json:"subscriptionId,omitempty"`
	// ResourceGroup - The name of the resource group of the event hub endpoint.
	ResourceGroup *string `json:"resourceGroup,omitempty"`
}

// RoutingProperties the routing related properties of the IoT hub. See:
// https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging
type RoutingProperties struct {
	Endpoints *RoutingEndpoints `json:"endpoints,omitempty"`
	// Routes - The list of user-provided routing rules that the IoT hub uses to route messages to built-in and custom endpoints. A maximum of 100 routing rules are allowed for paid hubs and a maximum of 5 routing rules are allowed for free hubs.
	Routes *[]RouteProperties `json:"routes,omitempty"`
	// FallbackRoute - The properties of the route that is used as a fall-back route when none of the conditions specified in the 'routes' section are met. This is an optional parameter. When this property is not set, the messages which do not meet any of the conditions specified in the 'routes' section get routed to the built-in eventhub endpoint.
	FallbackRoute *FallbackRouteProperties `json:"fallbackRoute,omitempty"`
}

// RoutingServiceBusQueueEndpointProperties the properties related to service bus queue endpoint types.
type RoutingServiceBusQueueEndpointProperties struct {
	// ConnectionString - The connection string of the service bus queue endpoint.
	ConnectionString *string `json:"connectionString,omitempty"`
	// Name - The name of the service bus queue endpoint. The name can only include alphanumeric characters, periods, underscores, hyphens and has a maximum length of 64 characters. The following names are reserved;  events, operationsMonitoringEvents, fileNotifications, $default. Endpoint names must be unique across endpoint types. The name need not be the same as the actual queue name.
	Name *string `json:"name,omitempty"`
	// SubscriptionID - The subscription identifier of the service bus queue endpoint.
	SubscriptionID *string `json:"subscriptionId,omitempty"`
	// ResourceGroup - The name of the resource group of the service bus queue endpoint.
	ResourceGroup *string `json:"resourceGroup,omitempty"`
}

// RoutingServiceBusTopicEndpointProperties the properties related to service bus topic endpoint types.
type RoutingServiceBusTopicEndpointProperties struct {
	// ConnectionString - The connection string of the service bus topic endpoint.
	ConnectionString *string `json:"connectionString,omitempty"`
	// Name - The name of the service bus topic endpoint. The name can only include alphanumeric characters, periods, underscores, hyphens and has a maximum length of 64 characters. The following names are reserved;  events, operationsMonitoringEvents, fileNotifications, $default. Endpoint names must be unique across endpoint types.  The name need not be the same as the actual topic name.
	Name *string `json:"name,omitempty"`
	// SubscriptionID - The subscription identifier of the service bus topic endpoint.
	SubscriptionID *string `json:"subscriptionId,omitempty"`
	// ResourceGroup - The name of the resource group of the service bus topic endpoint.
	ResourceGroup *string `json:"resourceGroup,omitempty"`
}

// SetObject ...
type SetObject struct {
	autorest.Response `json:"-"`
	Value             interface{} `json:"value,omitempty"`
}

// SharedAccessSignatureAuthorizationRule the properties of an IoT hub shared access policy.
type SharedAccessSignatureAuthorizationRule struct {
	autorest.Response `json:"-"`
	// KeyName - The name of the shared access policy.
	KeyName *string `json:"keyName,omitempty"`
	// PrimaryKey - The primary key.
	PrimaryKey *string `json:"primaryKey,omitempty"`
	// SecondaryKey - The secondary key.
	SecondaryKey *string `json:"secondaryKey,omitempty"`
	// Rights - The permissions assigned to the shared access policy. Possible values include: 'RegistryRead', 'RegistryWrite', 'ServiceConnect', 'DeviceConnect', 'RegistryReadRegistryWrite', 'RegistryReadServiceConnect', 'RegistryReadDeviceConnect', 'RegistryWriteServiceConnect', 'RegistryWriteDeviceConnect', 'ServiceConnectDeviceConnect', 'RegistryReadRegistryWriteServiceConnect', 'RegistryReadRegistryWriteDeviceConnect', 'RegistryReadServiceConnectDeviceConnect', 'RegistryWriteServiceConnectDeviceConnect', 'RegistryReadRegistryWriteServiceConnectDeviceConnect'
	Rights AccessRights `json:"rights,omitempty"`
}

// SharedAccessSignatureAuthorizationRuleListResult the list of shared access policies with a next link.
type SharedAccessSignatureAuthorizationRuleListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of shared access policies.
	Value *[]SharedAccessSignatureAuthorizationRule `json:"value,omitempty"`
	// NextLink - The next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// SharedAccessSignatureAuthorizationRuleListResultIterator provides access to a complete listing of
// SharedAccessSignatureAuthorizationRule values.
type SharedAccessSignatureAuthorizationRuleListResultIterator struct {
	i    int
	page SharedAccessSignatureAuthorizationRuleListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SharedAccessSignatureAuthorizationRuleListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SharedAccessSignatureAuthorizationRuleListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SharedAccessSignatureAuthorizationRuleListResultIterator) Response() SharedAccessSignatureAuthorizationRuleListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SharedAccessSignatureAuthorizationRuleListResultIterator) Value() SharedAccessSignatureAuthorizationRule {
	if !iter.page.NotDone() {
		return SharedAccessSignatureAuthorizationRule{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (sasarlr SharedAccessSignatureAuthorizationRuleListResult) IsEmpty() bool {
	return sasarlr.Value == nil || len(*sasarlr.Value) == 0
}

// sharedAccessSignatureAuthorizationRuleListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sasarlr SharedAccessSignatureAuthorizationRuleListResult) sharedAccessSignatureAuthorizationRuleListResultPreparer() (*http.Request, error) {
	if sasarlr.NextLink == nil || len(to.String(sasarlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sasarlr.NextLink)))
}

// SharedAccessSignatureAuthorizationRuleListResultPage contains a page of SharedAccessSignatureAuthorizationRule
// values.
type SharedAccessSignatureAuthorizationRuleListResultPage struct {
	fn      func(SharedAccessSignatureAuthorizationRuleListResult) (SharedAccessSignatureAuthorizationRuleListResult, error)
	sasarlr SharedAccessSignatureAuthorizationRuleListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SharedAccessSignatureAuthorizationRuleListResultPage) Next() error {
	next, err := page.fn(page.sasarlr)
	if err != nil {
		return err
	}
	page.sasarlr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SharedAccessSignatureAuthorizationRuleListResultPage) NotDone() bool {
	return !page.sasarlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SharedAccessSignatureAuthorizationRuleListResultPage) Response() SharedAccessSignatureAuthorizationRuleListResult {
	return page.sasarlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SharedAccessSignatureAuthorizationRuleListResultPage) Values() []SharedAccessSignatureAuthorizationRule {
	if page.sasarlr.IsEmpty() {
		return nil
	}
	return *page.sasarlr.Value
}

// StorageEndpointProperties the properties of the Azure Storage endpoint for file upload.
type StorageEndpointProperties struct {
	// SasTTLAsIso8601 - The period of time for which the the SAS URI generated by IoT Hub for file upload is valid. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-file-upload#file-upload-notification-configuration-options.
	SasTTLAsIso8601 *string `json:"sasTtlAsIso8601,omitempty"`
	// ConnectionString - The connection string for the Azure Storage account to which files are uploaded.
	ConnectionString *string `json:"connectionString,omitempty"`
	// ContainerName - The name of the root container where you upload files. The container need not exist but should be creatable using the connectionString specified.
	ContainerName *string `json:"containerName,omitempty"`
}
