// +build go1.9

// Copyright 2018 Microsoft Corporation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package servicefabric

import original "github.com/Azure/azure-sdk-for-go/services/servicefabric/1.0.0/servicefabric"

type ApplicationHealthsClient = original.ApplicationHealthsClient
type ApplicationManifestsClient = original.ApplicationManifestsClient
type ApplicationsClient = original.ApplicationsClient
type ApplicationTypesClient = original.ApplicationTypesClient
type ApplicationUpgradeRollbacksClient = original.ApplicationUpgradeRollbacksClient
type ApplicationUpgradesClient = original.ApplicationUpgradesClient

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type BaseClient = original.BaseClient
type ClusterHealthsClient = original.ClusterHealthsClient
type ClusterLoadInformationsClient = original.ClusterLoadInformationsClient
type ClusterManifestsClient = original.ClusterManifestsClient
type ClusterPackagesClient = original.ClusterPackagesClient
type ClusterUpgradesClient = original.ClusterUpgradesClient
type DeployedApplicationHealthsClient = original.DeployedApplicationHealthsClient
type DeployedApplicationsClient = original.DeployedApplicationsClient
type DeployedCodePackagesClient = original.DeployedCodePackagesClient
type DeployedReplicaDetailsClient = original.DeployedReplicaDetailsClient
type DeployedReplicasClient = original.DeployedReplicasClient
type DeployedServicePackageHealthsClient = original.DeployedServicePackageHealthsClient
type DeployedServicePackagesClient = original.DeployedServicePackagesClient
type DeployedServiceTypesClient = original.DeployedServiceTypesClient
type AggregatedHealthState = original.AggregatedHealthState

const (
	Error   AggregatedHealthState = original.Error
	Invalid AggregatedHealthState = original.Invalid
	Ok      AggregatedHealthState = original.Ok
	Unknown AggregatedHealthState = original.Unknown
	Warning AggregatedHealthState = original.Warning
)

type AggregatedHealthState1 = original.AggregatedHealthState1

const (
	AggregatedHealthState1Error   AggregatedHealthState1 = original.AggregatedHealthState1Error
	AggregatedHealthState1Invalid AggregatedHealthState1 = original.AggregatedHealthState1Invalid
	AggregatedHealthState1Ok      AggregatedHealthState1 = original.AggregatedHealthState1Ok
	AggregatedHealthState1Unknown AggregatedHealthState1 = original.AggregatedHealthState1Unknown
	AggregatedHealthState1Warning AggregatedHealthState1 = original.AggregatedHealthState1Warning
)

type AggregatedHealthState10 = original.AggregatedHealthState10

const (
	AggregatedHealthState10Error   AggregatedHealthState10 = original.AggregatedHealthState10Error
	AggregatedHealthState10Invalid AggregatedHealthState10 = original.AggregatedHealthState10Invalid
	AggregatedHealthState10Ok      AggregatedHealthState10 = original.AggregatedHealthState10Ok
	AggregatedHealthState10Unknown AggregatedHealthState10 = original.AggregatedHealthState10Unknown
	AggregatedHealthState10Warning AggregatedHealthState10 = original.AggregatedHealthState10Warning
)

type AggregatedHealthState11 = original.AggregatedHealthState11

const (
	AggregatedHealthState11Error   AggregatedHealthState11 = original.AggregatedHealthState11Error
	AggregatedHealthState11Invalid AggregatedHealthState11 = original.AggregatedHealthState11Invalid
	AggregatedHealthState11Ok      AggregatedHealthState11 = original.AggregatedHealthState11Ok
	AggregatedHealthState11Unknown AggregatedHealthState11 = original.AggregatedHealthState11Unknown
	AggregatedHealthState11Warning AggregatedHealthState11 = original.AggregatedHealthState11Warning
)

type AggregatedHealthState12 = original.AggregatedHealthState12

const (
	AggregatedHealthState12Error   AggregatedHealthState12 = original.AggregatedHealthState12Error
	AggregatedHealthState12Invalid AggregatedHealthState12 = original.AggregatedHealthState12Invalid
	AggregatedHealthState12Ok      AggregatedHealthState12 = original.AggregatedHealthState12Ok
	AggregatedHealthState12Unknown AggregatedHealthState12 = original.AggregatedHealthState12Unknown
	AggregatedHealthState12Warning AggregatedHealthState12 = original.AggregatedHealthState12Warning
)

type AggregatedHealthState13 = original.AggregatedHealthState13

const (
	AggregatedHealthState13Error   AggregatedHealthState13 = original.AggregatedHealthState13Error
	AggregatedHealthState13Invalid AggregatedHealthState13 = original.AggregatedHealthState13Invalid
	AggregatedHealthState13Ok      AggregatedHealthState13 = original.AggregatedHealthState13Ok
	AggregatedHealthState13Unknown AggregatedHealthState13 = original.AggregatedHealthState13Unknown
	AggregatedHealthState13Warning AggregatedHealthState13 = original.AggregatedHealthState13Warning
)

type AggregatedHealthState14 = original.AggregatedHealthState14

const (
	AggregatedHealthState14Error   AggregatedHealthState14 = original.AggregatedHealthState14Error
	AggregatedHealthState14Invalid AggregatedHealthState14 = original.AggregatedHealthState14Invalid
	AggregatedHealthState14Ok      AggregatedHealthState14 = original.AggregatedHealthState14Ok
	AggregatedHealthState14Unknown AggregatedHealthState14 = original.AggregatedHealthState14Unknown
	AggregatedHealthState14Warning AggregatedHealthState14 = original.AggregatedHealthState14Warning
)

type AggregatedHealthState15 = original.AggregatedHealthState15

const (
	AggregatedHealthState15Error   AggregatedHealthState15 = original.AggregatedHealthState15Error
	AggregatedHealthState15Invalid AggregatedHealthState15 = original.AggregatedHealthState15Invalid
	AggregatedHealthState15Ok      AggregatedHealthState15 = original.AggregatedHealthState15Ok
	AggregatedHealthState15Unknown AggregatedHealthState15 = original.AggregatedHealthState15Unknown
	AggregatedHealthState15Warning AggregatedHealthState15 = original.AggregatedHealthState15Warning
)

type AggregatedHealthState2 = original.AggregatedHealthState2

const (
	AggregatedHealthState2Error   AggregatedHealthState2 = original.AggregatedHealthState2Error
	AggregatedHealthState2Invalid AggregatedHealthState2 = original.AggregatedHealthState2Invalid
	AggregatedHealthState2Ok      AggregatedHealthState2 = original.AggregatedHealthState2Ok
	AggregatedHealthState2Unknown AggregatedHealthState2 = original.AggregatedHealthState2Unknown
	AggregatedHealthState2Warning AggregatedHealthState2 = original.AggregatedHealthState2Warning
)

type AggregatedHealthState3 = original.AggregatedHealthState3

const (
	AggregatedHealthState3Error   AggregatedHealthState3 = original.AggregatedHealthState3Error
	AggregatedHealthState3Invalid AggregatedHealthState3 = original.AggregatedHealthState3Invalid
	AggregatedHealthState3Ok      AggregatedHealthState3 = original.AggregatedHealthState3Ok
	AggregatedHealthState3Unknown AggregatedHealthState3 = original.AggregatedHealthState3Unknown
	AggregatedHealthState3Warning AggregatedHealthState3 = original.AggregatedHealthState3Warning
)

type AggregatedHealthState4 = original.AggregatedHealthState4

const (
	AggregatedHealthState4Error   AggregatedHealthState4 = original.AggregatedHealthState4Error
	AggregatedHealthState4Invalid AggregatedHealthState4 = original.AggregatedHealthState4Invalid
	AggregatedHealthState4Ok      AggregatedHealthState4 = original.AggregatedHealthState4Ok
	AggregatedHealthState4Unknown AggregatedHealthState4 = original.AggregatedHealthState4Unknown
	AggregatedHealthState4Warning AggregatedHealthState4 = original.AggregatedHealthState4Warning
)

type AggregatedHealthState5 = original.AggregatedHealthState5

const (
	AggregatedHealthState5Error   AggregatedHealthState5 = original.AggregatedHealthState5Error
	AggregatedHealthState5Invalid AggregatedHealthState5 = original.AggregatedHealthState5Invalid
	AggregatedHealthState5Ok      AggregatedHealthState5 = original.AggregatedHealthState5Ok
	AggregatedHealthState5Unknown AggregatedHealthState5 = original.AggregatedHealthState5Unknown
	AggregatedHealthState5Warning AggregatedHealthState5 = original.AggregatedHealthState5Warning
)

type AggregatedHealthState6 = original.AggregatedHealthState6

const (
	AggregatedHealthState6Error   AggregatedHealthState6 = original.AggregatedHealthState6Error
	AggregatedHealthState6Invalid AggregatedHealthState6 = original.AggregatedHealthState6Invalid
	AggregatedHealthState6Ok      AggregatedHealthState6 = original.AggregatedHealthState6Ok
	AggregatedHealthState6Unknown AggregatedHealthState6 = original.AggregatedHealthState6Unknown
	AggregatedHealthState6Warning AggregatedHealthState6 = original.AggregatedHealthState6Warning
)

type AggregatedHealthState7 = original.AggregatedHealthState7

const (
	AggregatedHealthState7Error   AggregatedHealthState7 = original.AggregatedHealthState7Error
	AggregatedHealthState7Invalid AggregatedHealthState7 = original.AggregatedHealthState7Invalid
	AggregatedHealthState7Ok      AggregatedHealthState7 = original.AggregatedHealthState7Ok
	AggregatedHealthState7Unknown AggregatedHealthState7 = original.AggregatedHealthState7Unknown
	AggregatedHealthState7Warning AggregatedHealthState7 = original.AggregatedHealthState7Warning
)

type AggregatedHealthState8 = original.AggregatedHealthState8

const (
	AggregatedHealthState8Error   AggregatedHealthState8 = original.AggregatedHealthState8Error
	AggregatedHealthState8Invalid AggregatedHealthState8 = original.AggregatedHealthState8Invalid
	AggregatedHealthState8Ok      AggregatedHealthState8 = original.AggregatedHealthState8Ok
	AggregatedHealthState8Unknown AggregatedHealthState8 = original.AggregatedHealthState8Unknown
	AggregatedHealthState8Warning AggregatedHealthState8 = original.AggregatedHealthState8Warning
)

type AggregatedHealthState9 = original.AggregatedHealthState9

const (
	AggregatedHealthState9Error   AggregatedHealthState9 = original.AggregatedHealthState9Error
	AggregatedHealthState9Invalid AggregatedHealthState9 = original.AggregatedHealthState9Invalid
	AggregatedHealthState9Ok      AggregatedHealthState9 = original.AggregatedHealthState9Ok
	AggregatedHealthState9Unknown AggregatedHealthState9 = original.AggregatedHealthState9Unknown
	AggregatedHealthState9Warning AggregatedHealthState9 = original.AggregatedHealthState9Warning
)

type DeactivationIntent = original.DeactivationIntent

const (
	Pause      DeactivationIntent = original.Pause
	RemoveData DeactivationIntent = original.RemoveData
	RemoveNode DeactivationIntent = original.RemoveNode
	Restart    DeactivationIntent = original.Restart
)

type DefaultMoveCost = original.DefaultMoveCost

const (
	High   DefaultMoveCost = original.High
	Low    DefaultMoveCost = original.Low
	Medium DefaultMoveCost = original.Medium
	Zero   DefaultMoveCost = original.Zero
)

type DefaultMoveCost1 = original.DefaultMoveCost1

const (
	DefaultMoveCost1High   DefaultMoveCost1 = original.DefaultMoveCost1High
	DefaultMoveCost1Low    DefaultMoveCost1 = original.DefaultMoveCost1Low
	DefaultMoveCost1Medium DefaultMoveCost1 = original.DefaultMoveCost1Medium
	DefaultMoveCost1Zero   DefaultMoveCost1 = original.DefaultMoveCost1Zero
)

type DefaultMoveCost2 = original.DefaultMoveCost2

const (
	DefaultMoveCost2High   DefaultMoveCost2 = original.DefaultMoveCost2High
	DefaultMoveCost2Low    DefaultMoveCost2 = original.DefaultMoveCost2Low
	DefaultMoveCost2Medium DefaultMoveCost2 = original.DefaultMoveCost2Medium
	DefaultMoveCost2Zero   DefaultMoveCost2 = original.DefaultMoveCost2Zero
)

type DefaultMoveCost3 = original.DefaultMoveCost3

const (
	DefaultMoveCost3High   DefaultMoveCost3 = original.DefaultMoveCost3High
	DefaultMoveCost3Low    DefaultMoveCost3 = original.DefaultMoveCost3Low
	DefaultMoveCost3Medium DefaultMoveCost3 = original.DefaultMoveCost3Medium
	DefaultMoveCost3Zero   DefaultMoveCost3 = original.DefaultMoveCost3Zero
)

type FailureReason = original.FailureReason

const (
	FailureReasonHealthCheck           FailureReason = original.FailureReasonHealthCheck
	FailureReasonInterrupted           FailureReason = original.FailureReasonInterrupted
	FailureReasonInvalid               FailureReason = original.FailureReasonInvalid
	FailureReasonOverallUpgradeTimeout FailureReason = original.FailureReasonOverallUpgradeTimeout
	FailureReasonUpgradeDomainTimeout  FailureReason = original.FailureReasonUpgradeDomainTimeout
)

type FailureReason1 = original.FailureReason1

const (
	FailureReason1HealthCheck           FailureReason1 = original.FailureReason1HealthCheck
	FailureReason1Interrupted           FailureReason1 = original.FailureReason1Interrupted
	FailureReason1Invalid               FailureReason1 = original.FailureReason1Invalid
	FailureReason1OverallUpgradeTimeout FailureReason1 = original.FailureReason1OverallUpgradeTimeout
	FailureReason1UpgradeDomainTimeout  FailureReason1 = original.FailureReason1UpgradeDomainTimeout
)

type HealthState = original.HealthState

const (
	HealthStateError   HealthState = original.HealthStateError
	HealthStateInvalid HealthState = original.HealthStateInvalid
	HealthStateOk      HealthState = original.HealthStateOk
	HealthStateUnknown HealthState = original.HealthStateUnknown
	HealthStateWarning HealthState = original.HealthStateWarning
)

type HealthState1 = original.HealthState1

const (
	HealthState1Error   HealthState1 = original.HealthState1Error
	HealthState1Invalid HealthState1 = original.HealthState1Invalid
	HealthState1Ok      HealthState1 = original.HealthState1Ok
	HealthState1Unknown HealthState1 = original.HealthState1Unknown
	HealthState1Warning HealthState1 = original.HealthState1Warning
)

type HealthState2 = original.HealthState2

const (
	HealthState2Error   HealthState2 = original.HealthState2Error
	HealthState2Invalid HealthState2 = original.HealthState2Invalid
	HealthState2Ok      HealthState2 = original.HealthState2Ok
	HealthState2Unknown HealthState2 = original.HealthState2Unknown
	HealthState2Warning HealthState2 = original.HealthState2Warning
)

type HealthState3 = original.HealthState3

const (
	HealthState3Error   HealthState3 = original.HealthState3Error
	HealthState3Invalid HealthState3 = original.HealthState3Invalid
	HealthState3Ok      HealthState3 = original.HealthState3Ok
	HealthState3Unknown HealthState3 = original.HealthState3Unknown
	HealthState3Warning HealthState3 = original.HealthState3Warning
)

type HealthState4 = original.HealthState4

const (
	HealthState4Error   HealthState4 = original.HealthState4Error
	HealthState4Invalid HealthState4 = original.HealthState4Invalid
	HealthState4Ok      HealthState4 = original.HealthState4Ok
	HealthState4Unknown HealthState4 = original.HealthState4Unknown
	HealthState4Warning HealthState4 = original.HealthState4Warning
)

type HealthState5 = original.HealthState5

const (
	HealthState5Error   HealthState5 = original.HealthState5Error
	HealthState5Invalid HealthState5 = original.HealthState5Invalid
	HealthState5Ok      HealthState5 = original.HealthState5Ok
	HealthState5Unknown HealthState5 = original.HealthState5Unknown
	HealthState5Warning HealthState5 = original.HealthState5Warning
)

type HealthState6 = original.HealthState6

const (
	HealthState6Error   HealthState6 = original.HealthState6Error
	HealthState6Invalid HealthState6 = original.HealthState6Invalid
	HealthState6Ok      HealthState6 = original.HealthState6Ok
	HealthState6Unknown HealthState6 = original.HealthState6Unknown
	HealthState6Warning HealthState6 = original.HealthState6Warning
)

type Kind = original.Kind

const (
	KindApplication                       Kind = original.KindApplication
	KindApplications                      Kind = original.KindApplications
	KindApplicationType                   Kind = original.KindApplicationType
	KindDeltaNodesCheck                   Kind = original.KindDeltaNodesCheck
	KindDeployedApplication               Kind = original.KindDeployedApplication
	KindDeployedApplications              Kind = original.KindDeployedApplications
	KindDeployedServicePackage            Kind = original.KindDeployedServicePackage
	KindDeployedServicePackages           Kind = original.KindDeployedServicePackages
	KindEvent                             Kind = original.KindEvent
	KindHealthEvaluation                  Kind = original.KindHealthEvaluation
	KindNode                              Kind = original.KindNode
	KindNodes                             Kind = original.KindNodes
	KindPartition                         Kind = original.KindPartition
	KindPartitions                        Kind = original.KindPartitions
	KindReplica                           Kind = original.KindReplica
	KindReplicas                          Kind = original.KindReplicas
	KindService                           Kind = original.KindService
	KindServices                          Kind = original.KindServices
	KindSystemApplication                 Kind = original.KindSystemApplication
	KindUpgradeDomainDeltaNodesCheck      Kind = original.KindUpgradeDomainDeltaNodesCheck
	KindUpgradeDomainDeployedApplications Kind = original.KindUpgradeDomainDeployedApplications
	KindUpgradeDomainNodes                Kind = original.KindUpgradeDomainNodes
)

type NodeDeactivationIntent = original.NodeDeactivationIntent

const (
	NodeDeactivationIntentInvalid    NodeDeactivationIntent = original.NodeDeactivationIntentInvalid
	NodeDeactivationIntentPause      NodeDeactivationIntent = original.NodeDeactivationIntentPause
	NodeDeactivationIntentRemoveData NodeDeactivationIntent = original.NodeDeactivationIntentRemoveData
	NodeDeactivationIntentRestart    NodeDeactivationIntent = original.NodeDeactivationIntentRestart
)

type NodeDeactivationStatus = original.NodeDeactivationStatus

const (
	NodeDeactivationStatusCompleted             NodeDeactivationStatus = original.NodeDeactivationStatusCompleted
	NodeDeactivationStatusInvalid               NodeDeactivationStatus = original.NodeDeactivationStatusInvalid
	NodeDeactivationStatusSafetyCheckComplete   NodeDeactivationStatus = original.NodeDeactivationStatusSafetyCheckComplete
	NodeDeactivationStatusSafetyCheckInProgress NodeDeactivationStatus = original.NodeDeactivationStatusSafetyCheckInProgress
)

type NodeStatus = original.NodeStatus

const (
	NodeStatusDisabled  NodeStatus = original.NodeStatusDisabled
	NodeStatusDisabling NodeStatus = original.NodeStatusDisabling
	NodeStatusDown      NodeStatus = original.NodeStatusDown
	NodeStatusEnabling  NodeStatus = original.NodeStatusEnabling
	NodeStatusInvalid   NodeStatus = original.NodeStatusInvalid
	NodeStatusRemoved   NodeStatus = original.NodeStatusRemoved
	NodeStatusUnknown   NodeStatus = original.NodeStatusUnknown
	NodeStatusUp        NodeStatus = original.NodeStatusUp
)

type PartitionScheme = original.PartitionScheme

const (
	PartitionSchemeInvalid      PartitionScheme = original.PartitionSchemeInvalid
	PartitionSchemeNamed        PartitionScheme = original.PartitionSchemeNamed
	PartitionSchemeSingleton    PartitionScheme = original.PartitionSchemeSingleton
	PartitionSchemeUniformInt64 PartitionScheme = original.PartitionSchemeUniformInt64
)

type PartitionStatus = original.PartitionStatus

const (
	PartitionStatusDeleting      PartitionStatus = original.PartitionStatusDeleting
	PartitionStatusInQuorumLoss  PartitionStatus = original.PartitionStatusInQuorumLoss
	PartitionStatusInvalid       PartitionStatus = original.PartitionStatusInvalid
	PartitionStatusNotReady      PartitionStatus = original.PartitionStatusNotReady
	PartitionStatusReady         PartitionStatus = original.PartitionStatusReady
	PartitionStatusReconfiguring PartitionStatus = original.PartitionStatusReconfiguring
)

type ReplicaRole = original.ReplicaRole

const (
	ReplicaRoleActiveSecondary ReplicaRole = original.ReplicaRoleActiveSecondary
	ReplicaRoleIdleSecondary   ReplicaRole = original.ReplicaRoleIdleSecondary
	ReplicaRoleInvalid         ReplicaRole = original.ReplicaRoleInvalid
	ReplicaRoleNone            ReplicaRole = original.ReplicaRoleNone
	ReplicaRolePrimary         ReplicaRole = original.ReplicaRolePrimary
)

type ReplicaRole1 = original.ReplicaRole1

const (
	ReplicaRole1ActiveSecondary ReplicaRole1 = original.ReplicaRole1ActiveSecondary
	ReplicaRole1IdleSecondary   ReplicaRole1 = original.ReplicaRole1IdleSecondary
	ReplicaRole1Invalid         ReplicaRole1 = original.ReplicaRole1Invalid
	ReplicaRole1None            ReplicaRole1 = original.ReplicaRole1None
	ReplicaRole1Primary         ReplicaRole1 = original.ReplicaRole1Primary
)

type ReplicaStatus = original.ReplicaStatus

const (
	ReplicaStatusDown    ReplicaStatus = original.ReplicaStatusDown
	ReplicaStatusDropped ReplicaStatus = original.ReplicaStatusDropped
	ReplicaStatusInBuild ReplicaStatus = original.ReplicaStatusInBuild
	ReplicaStatusInvalid ReplicaStatus = original.ReplicaStatusInvalid
	ReplicaStatusReady   ReplicaStatus = original.ReplicaStatusReady
	ReplicaStatusStandby ReplicaStatus = original.ReplicaStatusStandby
)

type ReplicaStatus1 = original.ReplicaStatus1

const (
	ReplicaStatus1Down    ReplicaStatus1 = original.ReplicaStatus1Down
	ReplicaStatus1Dropped ReplicaStatus1 = original.ReplicaStatus1Dropped
	ReplicaStatus1InBuild ReplicaStatus1 = original.ReplicaStatus1InBuild
	ReplicaStatus1Invalid ReplicaStatus1 = original.ReplicaStatus1Invalid
	ReplicaStatus1Ready   ReplicaStatus1 = original.ReplicaStatus1Ready
	ReplicaStatus1Standby ReplicaStatus1 = original.ReplicaStatus1Standby
)

type RollingUpgradeMode = original.RollingUpgradeMode

const (
	RollingUpgradeModeInvalid           RollingUpgradeMode = original.RollingUpgradeModeInvalid
	RollingUpgradeModeMonitored         RollingUpgradeMode = original.RollingUpgradeModeMonitored
	RollingUpgradeModeUnmonitoredAuto   RollingUpgradeMode = original.RollingUpgradeModeUnmonitoredAuto
	RollingUpgradeModeUnmonitoredManual RollingUpgradeMode = original.RollingUpgradeModeUnmonitoredManual
)

type RollingUpgradeMode1 = original.RollingUpgradeMode1

const (
	RollingUpgradeMode1Invalid           RollingUpgradeMode1 = original.RollingUpgradeMode1Invalid
	RollingUpgradeMode1Monitored         RollingUpgradeMode1 = original.RollingUpgradeMode1Monitored
	RollingUpgradeMode1UnmonitoredAuto   RollingUpgradeMode1 = original.RollingUpgradeMode1UnmonitoredAuto
	RollingUpgradeMode1UnmonitoredManual RollingUpgradeMode1 = original.RollingUpgradeMode1UnmonitoredManual
)

type RollingUpgradeMode2 = original.RollingUpgradeMode2

const (
	RollingUpgradeMode2Invalid           RollingUpgradeMode2 = original.RollingUpgradeMode2Invalid
	RollingUpgradeMode2Monitored         RollingUpgradeMode2 = original.RollingUpgradeMode2Monitored
	RollingUpgradeMode2UnmonitoredAuto   RollingUpgradeMode2 = original.RollingUpgradeMode2UnmonitoredAuto
	RollingUpgradeMode2UnmonitoredManual RollingUpgradeMode2 = original.RollingUpgradeMode2UnmonitoredManual
)

type RollingUpgradeMode3 = original.RollingUpgradeMode3

const (
	RollingUpgradeMode3Invalid           RollingUpgradeMode3 = original.RollingUpgradeMode3Invalid
	RollingUpgradeMode3Monitored         RollingUpgradeMode3 = original.RollingUpgradeMode3Monitored
	RollingUpgradeMode3UnmonitoredAuto   RollingUpgradeMode3 = original.RollingUpgradeMode3UnmonitoredAuto
	RollingUpgradeMode3UnmonitoredManual RollingUpgradeMode3 = original.RollingUpgradeMode3UnmonitoredManual
)

type RollingUpgradeMode4 = original.RollingUpgradeMode4

const (
	RollingUpgradeMode4Invalid           RollingUpgradeMode4 = original.RollingUpgradeMode4Invalid
	RollingUpgradeMode4Monitored         RollingUpgradeMode4 = original.RollingUpgradeMode4Monitored
	RollingUpgradeMode4UnmonitoredAuto   RollingUpgradeMode4 = original.RollingUpgradeMode4UnmonitoredAuto
	RollingUpgradeMode4UnmonitoredManual RollingUpgradeMode4 = original.RollingUpgradeMode4UnmonitoredManual
)

type RollingUpgradeMode5 = original.RollingUpgradeMode5

const (
	RollingUpgradeMode5Invalid           RollingUpgradeMode5 = original.RollingUpgradeMode5Invalid
	RollingUpgradeMode5Monitored         RollingUpgradeMode5 = original.RollingUpgradeMode5Monitored
	RollingUpgradeMode5UnmonitoredAuto   RollingUpgradeMode5 = original.RollingUpgradeMode5UnmonitoredAuto
	RollingUpgradeMode5UnmonitoredManual RollingUpgradeMode5 = original.RollingUpgradeMode5UnmonitoredManual
)

type ServiceCorrelationScheme = original.ServiceCorrelationScheme

const (
	ServiceCorrelationSchemeAffinity           ServiceCorrelationScheme = original.ServiceCorrelationSchemeAffinity
	ServiceCorrelationSchemeAlignedAffinity    ServiceCorrelationScheme = original.ServiceCorrelationSchemeAlignedAffinity
	ServiceCorrelationSchemeInvalid            ServiceCorrelationScheme = original.ServiceCorrelationSchemeInvalid
	ServiceCorrelationSchemeNonAlignedAffinity ServiceCorrelationScheme = original.ServiceCorrelationSchemeNonAlignedAffinity
)

type ServiceKind = original.ServiceKind

const (
	ServiceKindInvalid   ServiceKind = original.ServiceKindInvalid
	ServiceKindStateful  ServiceKind = original.ServiceKindStateful
	ServiceKindStateless ServiceKind = original.ServiceKindStateless
)

type ServiceKind1 = original.ServiceKind1

const (
	ServiceKind1Invalid   ServiceKind1 = original.ServiceKind1Invalid
	ServiceKind1Stateful  ServiceKind1 = original.ServiceKind1Stateful
	ServiceKind1Stateless ServiceKind1 = original.ServiceKind1Stateless
)

type ServiceKind2 = original.ServiceKind2

const (
	ServiceKind2Invalid   ServiceKind2 = original.ServiceKind2Invalid
	ServiceKind2Stateful  ServiceKind2 = original.ServiceKind2Stateful
	ServiceKind2Stateless ServiceKind2 = original.ServiceKind2Stateless
)

type ServiceKind3 = original.ServiceKind3

const (
	ServiceKind3Invalid   ServiceKind3 = original.ServiceKind3Invalid
	ServiceKind3Stateful  ServiceKind3 = original.ServiceKind3Stateful
	ServiceKind3Stateless ServiceKind3 = original.ServiceKind3Stateless
)

type ServiceKind4 = original.ServiceKind4

const (
	ServiceKind4Invalid   ServiceKind4 = original.ServiceKind4Invalid
	ServiceKind4Stateful  ServiceKind4 = original.ServiceKind4Stateful
	ServiceKind4Stateless ServiceKind4 = original.ServiceKind4Stateless
)

type ServiceKind5 = original.ServiceKind5

const (
	ServiceKind5Invalid   ServiceKind5 = original.ServiceKind5Invalid
	ServiceKind5Stateful  ServiceKind5 = original.ServiceKind5Stateful
	ServiceKind5Stateless ServiceKind5 = original.ServiceKind5Stateless
)

type ServiceKind6 = original.ServiceKind6

const (
	ServiceKind6Invalid   ServiceKind6 = original.ServiceKind6Invalid
	ServiceKind6Stateful  ServiceKind6 = original.ServiceKind6Stateful
	ServiceKind6Stateless ServiceKind6 = original.ServiceKind6Stateless
)

type ServiceKindBasicCreateServiceDescription = original.ServiceKindBasicCreateServiceDescription

const (
	ServiceKindCreateServiceDescription ServiceKindBasicCreateServiceDescription = original.ServiceKindCreateServiceDescription
	ServiceKindStateful1                ServiceKindBasicCreateServiceDescription = original.ServiceKindStateful1
	ServiceKindStateless1               ServiceKindBasicCreateServiceDescription = original.ServiceKindStateless1
)

type ServiceKindBasicCreateServiceGroupDescription = original.ServiceKindBasicCreateServiceGroupDescription

const (
	ServiceKindBasicCreateServiceGroupDescriptionServiceKindCreateServiceGroupDescription ServiceKindBasicCreateServiceGroupDescription = original.ServiceKindBasicCreateServiceGroupDescriptionServiceKindCreateServiceGroupDescription
	ServiceKindBasicCreateServiceGroupDescriptionServiceKindStateful                      ServiceKindBasicCreateServiceGroupDescription = original.ServiceKindBasicCreateServiceGroupDescriptionServiceKindStateful
	ServiceKindBasicCreateServiceGroupDescriptionServiceKindStateless                     ServiceKindBasicCreateServiceGroupDescription = original.ServiceKindBasicCreateServiceGroupDescriptionServiceKindStateless
)

type ServiceKindBasicServiceDescription = original.ServiceKindBasicServiceDescription

const (
	ServiceKindBasicServiceDescriptionServiceKindServiceDescription ServiceKindBasicServiceDescription = original.ServiceKindBasicServiceDescriptionServiceKindServiceDescription
	ServiceKindBasicServiceDescriptionServiceKindStateful           ServiceKindBasicServiceDescription = original.ServiceKindBasicServiceDescriptionServiceKindStateful
	ServiceKindBasicServiceDescriptionServiceKindStateless          ServiceKindBasicServiceDescription = original.ServiceKindBasicServiceDescriptionServiceKindStateless
)

type ServiceKindBasicServiceGroupDescription = original.ServiceKindBasicServiceGroupDescription

const (
	ServiceKindBasicServiceGroupDescriptionServiceKindServiceGroupDescription ServiceKindBasicServiceGroupDescription = original.ServiceKindBasicServiceGroupDescriptionServiceKindServiceGroupDescription
	ServiceKindBasicServiceGroupDescriptionServiceKindStateful                ServiceKindBasicServiceGroupDescription = original.ServiceKindBasicServiceGroupDescriptionServiceKindStateful
	ServiceKindBasicServiceGroupDescriptionServiceKindStateless               ServiceKindBasicServiceGroupDescription = original.ServiceKindBasicServiceGroupDescriptionServiceKindStateless
)

type ServiceKindBasicUpdateServiceDescription = original.ServiceKindBasicUpdateServiceDescription

const (
	ServiceKindBasicUpdateServiceDescriptionServiceKindStateful                 ServiceKindBasicUpdateServiceDescription = original.ServiceKindBasicUpdateServiceDescriptionServiceKindStateful
	ServiceKindBasicUpdateServiceDescriptionServiceKindStateless                ServiceKindBasicUpdateServiceDescription = original.ServiceKindBasicUpdateServiceDescriptionServiceKindStateless
	ServiceKindBasicUpdateServiceDescriptionServiceKindUpdateServiceDescription ServiceKindBasicUpdateServiceDescription = original.ServiceKindBasicUpdateServiceDescriptionServiceKindUpdateServiceDescription
)

type ServiceKindBasicUpdateServiceGroupDescription = original.ServiceKindBasicUpdateServiceGroupDescription

const (
	ServiceKindBasicUpdateServiceGroupDescriptionServiceKindStateful                      ServiceKindBasicUpdateServiceGroupDescription = original.ServiceKindBasicUpdateServiceGroupDescriptionServiceKindStateful
	ServiceKindBasicUpdateServiceGroupDescriptionServiceKindStateless                     ServiceKindBasicUpdateServiceGroupDescription = original.ServiceKindBasicUpdateServiceGroupDescriptionServiceKindStateless
	ServiceKindBasicUpdateServiceGroupDescriptionServiceKindUpdateServiceGroupDescription ServiceKindBasicUpdateServiceGroupDescription = original.ServiceKindBasicUpdateServiceGroupDescriptionServiceKindUpdateServiceGroupDescription
)

type ServiceLoadMetricWeight = original.ServiceLoadMetricWeight

const (
	ServiceLoadMetricWeightHigh   ServiceLoadMetricWeight = original.ServiceLoadMetricWeightHigh
	ServiceLoadMetricWeightLow    ServiceLoadMetricWeight = original.ServiceLoadMetricWeightLow
	ServiceLoadMetricWeightMedium ServiceLoadMetricWeight = original.ServiceLoadMetricWeightMedium
	ServiceLoadMetricWeightZero   ServiceLoadMetricWeight = original.ServiceLoadMetricWeightZero
)

type ServicePartitionKind = original.ServicePartitionKind

const (
	ServicePartitionKindInt64Range ServicePartitionKind = original.ServicePartitionKindInt64Range
	ServicePartitionKindInvalid    ServicePartitionKind = original.ServicePartitionKindInvalid
	ServicePartitionKindNamed      ServicePartitionKind = original.ServicePartitionKindNamed
	ServicePartitionKindSingleton  ServicePartitionKind = original.ServicePartitionKindSingleton
)

type ServiceStatus = original.ServiceStatus

const (
	ServiceStatusActive    ServiceStatus = original.ServiceStatusActive
	ServiceStatusCreating  ServiceStatus = original.ServiceStatusCreating
	ServiceStatusDeleting  ServiceStatus = original.ServiceStatusDeleting
	ServiceStatusFaile     ServiceStatus = original.ServiceStatusFaile
	ServiceStatusInvalid   ServiceStatus = original.ServiceStatusInvalid
	ServiceStatusUpgrading ServiceStatus = original.ServiceStatusUpgrading
)

type UpgradeKind = original.UpgradeKind

const (
	UpgradeKindInvalid UpgradeKind = original.UpgradeKindInvalid
	UpgradeKindRolling UpgradeKind = original.UpgradeKindRolling
)

type UpgradeState = original.UpgradeState

const (
	UpgradeStateInvalid                  UpgradeState = original.UpgradeStateInvalid
	UpgradeStateRollingBackCompleted     UpgradeState = original.UpgradeStateRollingBackCompleted
	UpgradeStateRollingBackInProgress    UpgradeState = original.UpgradeStateRollingBackInProgress
	UpgradeStateRollingForwardCompleted  UpgradeState = original.UpgradeStateRollingForwardCompleted
	UpgradeStateRollingForwardInProgress UpgradeState = original.UpgradeStateRollingForwardInProgress
	UpgradeStateRollingForwardPending    UpgradeState = original.UpgradeStateRollingForwardPending
)

type UpgradeState1 = original.UpgradeState1

const (
	UpgradeState1Invalid                  UpgradeState1 = original.UpgradeState1Invalid
	UpgradeState1RollingBackCompleted     UpgradeState1 = original.UpgradeState1RollingBackCompleted
	UpgradeState1RollingBackInProgress    UpgradeState1 = original.UpgradeState1RollingBackInProgress
	UpgradeState1RollingForwardCompleted  UpgradeState1 = original.UpgradeState1RollingForwardCompleted
	UpgradeState1RollingForwardInProgress UpgradeState1 = original.UpgradeState1RollingForwardInProgress
	UpgradeState1RollingForwardPending    UpgradeState1 = original.UpgradeState1RollingForwardPending
)

type Application = original.Application
type ApplicationDescription = original.ApplicationDescription
type ApplicationDescriptionParameterListItem = original.ApplicationDescriptionParameterListItem
type ApplicationHealth = original.ApplicationHealth
type ApplicationHealthDeployedApplicationHealthStatesItem = original.ApplicationHealthDeployedApplicationHealthStatesItem
type ApplicationHealthEvaluation = original.ApplicationHealthEvaluation
type ApplicationHealthPolicy = original.ApplicationHealthPolicy
type ApplicationHealthPolicyDefaultServiceTypeHealthPolicy = original.ApplicationHealthPolicyDefaultServiceTypeHealthPolicy
type ApplicationHealthPolicyMap = original.ApplicationHealthPolicyMap
type ApplicationHealthReport = original.ApplicationHealthReport
type ApplicationHealthServiceHealthStatesItem = original.ApplicationHealthServiceHealthStatesItem
type ApplicationList = original.ApplicationList
type ApplicationManifest = original.ApplicationManifest
type ApplicationParametersItem = original.ApplicationParametersItem
type ApplicationsHealthEvaluation = original.ApplicationsHealthEvaluation
type ApplicationType = original.ApplicationType
type ApplicationTypeDefaultParameterListItem = original.ApplicationTypeDefaultParameterListItem
type ApplicationTypeHealthEvaluation = original.ApplicationTypeHealthEvaluation
type ApplicationUpgrade = original.ApplicationUpgrade
type ApplicationUpgradeCurrentUpgradeDomainProgress = original.ApplicationUpgradeCurrentUpgradeDomainProgress
type ApplicationUpgradeDeployedApplicationHealthStates = original.ApplicationUpgradeDeployedApplicationHealthStates
type ClusterHealth = original.ClusterHealth
type ClusterHealthApplicationHealthStateItem = original.ClusterHealthApplicationHealthStateItem
type ClusterHealthNodeHealthStatesItem = original.ClusterHealthNodeHealthStatesItem
type ClusterHealthNodeHealthStatesItemID = original.ClusterHealthNodeHealthStatesItemID
type ClusterHealthPolicy = original.ClusterHealthPolicy
type ClusterHealthReport = original.ClusterHealthReport
type ClusterLoadInformation = original.ClusterLoadInformation
type ClusterUpgradeHealthPolicy = original.ClusterUpgradeHealthPolicy
type ClusterUpgradeProgress = original.ClusterUpgradeProgress
type ClusterUpgradeProgressCurrentUpgradeDomainProgress = original.ClusterUpgradeProgressCurrentUpgradeDomainProgress
type ClusterUpgradeProgressUpgradeDomainProgressAtFailure = original.ClusterUpgradeProgressUpgradeDomainProgressAtFailure
type CodePackageEntryPointStatistics = original.CodePackageEntryPointStatistics
type BasicCreateServiceDescription = original.BasicCreateServiceDescription
type CreateServiceDescription = original.CreateServiceDescription
type BasicCreateServiceGroupDescription = original.BasicCreateServiceGroupDescription
type CreateServiceGroupDescription = original.CreateServiceGroupDescription
type DeltaNodesCheckHealthEvaluation = original.DeltaNodesCheckHealthEvaluation
type DeployedApplication = original.DeployedApplication
type DeployedApplicationHealth = original.DeployedApplicationHealth
type DeployedApplicationHealthEvaluation = original.DeployedApplicationHealthEvaluation
type DeployedApplicationHealthReport = original.DeployedApplicationHealthReport
type DeployedApplicationsHealthEvaluation = original.DeployedApplicationsHealthEvaluation
type DeployedCodePackage = original.DeployedCodePackage
type DeployedReplica = original.DeployedReplica
type DeployedReplicaDetail = original.DeployedReplicaDetail
type DeployedReplicaDetailReplicatorStatus = original.DeployedReplicaDetailReplicatorStatus
type DeployedReplicaDetailReplicatorStatusReplicationQueueStatus = original.DeployedReplicaDetailReplicatorStatusReplicationQueueStatus
type DeployedServiceHealthReport = original.DeployedServiceHealthReport
type DeployedServicePackage = original.DeployedServicePackage
type DeployedServicePackageHealth = original.DeployedServicePackageHealth
type DeployedServicePackageHealthEvaluation = original.DeployedServicePackageHealthEvaluation
type DeployedServicePackageHealthState = original.DeployedServicePackageHealthState
type DeployedServicePackagesHealthEvaluation = original.DeployedServicePackagesHealthEvaluation
type DeployedServiceType = original.DeployedServiceType
type DisableNode = original.DisableNode
type EntryPoint = original.EntryPoint
type ErrorModel = original.ErrorModel
type ErrorModelError = original.ErrorModelError
type EventHealthEvaluation = original.EventHealthEvaluation
type BasicHealthEvaluation = original.BasicHealthEvaluation
type HealthEvaluation = original.HealthEvaluation
type HealthEvent = original.HealthEvent
type HealthReport = original.HealthReport
type ListApplicationType = original.ListApplicationType
type ListDeployedApplication = original.ListDeployedApplication
type ListDeployedCodePackage = original.ListDeployedCodePackage
type ListDeployedReplica = original.ListDeployedReplica
type ListDeployedServicePackage = original.ListDeployedServicePackage
type ListDeployedServiceType = original.ListDeployedServiceType
type ListServiceType = original.ListServiceType
type LoadMetricInformation = original.LoadMetricInformation
type LoadMetricInformationMaxNodeLoadID = original.LoadMetricInformationMaxNodeLoadID
type LoadMetricInformationMinNodeLoadID = original.LoadMetricInformationMinNodeLoadID
type MonitoringPolicy = original.MonitoringPolicy
type Node = original.Node
type NodeHealth = original.NodeHealth
type NodeHealthEvaluation = original.NodeHealthEvaluation
type NodeHealthReport = original.NodeHealthReport
type NodeID = original.NodeID
type NodeList = original.NodeList
type NodeLoadInformation = original.NodeLoadInformation
type NodeLoadMetricInformation = original.NodeLoadMetricInformation
type NodeNodeDeactivationInfo = original.NodeNodeDeactivationInfo
type NodesHealthEvaluation = original.NodesHealthEvaluation
type Partition = original.Partition
type PartitionCurrentConfigurationEpoch = original.PartitionCurrentConfigurationEpoch
type PartitionDescription = original.PartitionDescription
type PartitionHealth = original.PartitionHealth
type PartitionHealthEvaluation = original.PartitionHealthEvaluation
type PartitionHealthReplicaHealthStatesItem = original.PartitionHealthReplicaHealthStatesItem
type PartitionHealthReport = original.PartitionHealthReport
type PartitionInformation = original.PartitionInformation
type PartitionList = original.PartitionList
type PartitionLoadInformation = original.PartitionLoadInformation
type PartitionsHealthEvaluation = original.PartitionsHealthEvaluation
type RegisterApplicationType = original.RegisterApplicationType
type RegisterClusterPackage = original.RegisterClusterPackage
type Replica = original.Replica
type ReplicaHealth = original.ReplicaHealth
type ReplicaHealthEvaluation = original.ReplicaHealthEvaluation
type ReplicaHealthReport = original.ReplicaHealthReport
type ReplicaList = original.ReplicaList
type ReplicaLoadInformation = original.ReplicaLoadInformation
type ReplicasHealthEvaluation = original.ReplicasHealthEvaluation
type ResolvedServicePartition = original.ResolvedServicePartition
type ResolvedServicePartitionEndpointsItem = original.ResolvedServicePartitionEndpointsItem
type ResumeApplicationUpgrade = original.ResumeApplicationUpgrade
type ResumeClusterUpgrade = original.ResumeClusterUpgrade
type Service = original.Service
type ServiceCorrelationDescription = original.ServiceCorrelationDescription
type BasicServiceDescription = original.BasicServiceDescription
type ServiceDescription = original.ServiceDescription
type ServiceDescriptionModel = original.ServiceDescriptionModel
type ServiceDescriptionTemplate = original.ServiceDescriptionTemplate
type BasicServiceGroupDescription = original.BasicServiceGroupDescription
type ServiceGroupDescription = original.ServiceGroupDescription
type ServiceGroupDescriptionModel = original.ServiceGroupDescriptionModel
type ServiceGroupMember = original.ServiceGroupMember
type ServiceGroupMemberDescription = original.ServiceGroupMemberDescription
type ServiceHealth = original.ServiceHealth
type ServiceHealthEvaluation = original.ServiceHealthEvaluation
type ServiceHealthPartitionHealthStatesItem = original.ServiceHealthPartitionHealthStatesItem
type ServiceHealthReport = original.ServiceHealthReport
type ServiceList = original.ServiceList
type ServiceLoadMetricDescription = original.ServiceLoadMetricDescription
type ServiceManifest = original.ServiceManifest
type ServicePlacementPolicyDescription = original.ServicePlacementPolicyDescription
type ServicesHealthEvaluation = original.ServicesHealthEvaluation
type ServiceType = original.ServiceType
type ServiceTypeServiceTypeDescription = original.ServiceTypeServiceTypeDescription
type StartApplicationUpgrade = original.StartApplicationUpgrade
type StartApplicationUpgradeParametersItem = original.StartApplicationUpgradeParametersItem
type StartClusterUpgrade = original.StartClusterUpgrade
type StatefulCreateServiceDescription = original.StatefulCreateServiceDescription
type StatefulCreateServiceGroupDescription = original.StatefulCreateServiceGroupDescription
type StatefulServiceDescription = original.StatefulServiceDescription
type StatefulServiceGroupDescription = original.StatefulServiceGroupDescription
type StatefulUpdateServiceDescription = original.StatefulUpdateServiceDescription
type StatefulUpdateServiceGroupDescription = original.StatefulUpdateServiceGroupDescription
type StatelessCreateServiceDescription = original.StatelessCreateServiceDescription
type StatelessCreateServiceGroupDescription = original.StatelessCreateServiceGroupDescription
type StatelessServiceDescription = original.StatelessServiceDescription
type StatelessServiceGroupDescription = original.StatelessServiceGroupDescription
type StatelessUpdateServiceDescription = original.StatelessUpdateServiceDescription
type StatelessUpdateServiceGroupDescription = original.StatelessUpdateServiceGroupDescription
type String = original.String
type SystemApplicationHealthEvaluation = original.SystemApplicationHealthEvaluation
type UnhealthyEvaluation = original.UnhealthyEvaluation
type UnregisterApplicationType = original.UnregisterApplicationType
type UnregisterClusterPackage = original.UnregisterClusterPackage
type UpdateApplicationUpgrade = original.UpdateApplicationUpgrade
type UpdateClusterUpgrade = original.UpdateClusterUpgrade
type UpdateDescription = original.UpdateDescription
type BasicUpdateServiceDescription = original.BasicUpdateServiceDescription
type UpdateServiceDescription = original.UpdateServiceDescription
type BasicUpdateServiceGroupDescription = original.BasicUpdateServiceGroupDescription
type UpdateServiceGroupDescription = original.UpdateServiceGroupDescription
type UpgradeDomainDeltaNodesCheckHealthEvaluation = original.UpgradeDomainDeltaNodesCheckHealthEvaluation
type UpgradeDomainDeployedApplicationsHealthEvaluation = original.UpgradeDomainDeployedApplicationsHealthEvaluation
type UpgradeDomainNodesHealthEvaluation = original.UpgradeDomainNodesHealthEvaluation
type NodeHealthsClient = original.NodeHealthsClient
type NodeLoadInformationsClient = original.NodeLoadInformationsClient
type NodesClient = original.NodesClient
type NodeStatesClient = original.NodeStatesClient
type PartitionHealthsClient = original.PartitionHealthsClient
type PartitionListsClient = original.PartitionListsClient
type PartitionLoadInformationsClient = original.PartitionLoadInformationsClient
type PartitionLoadsClient = original.PartitionLoadsClient
type PartitionsClient = original.PartitionsClient
type ReplicaHealthsClient = original.ReplicaHealthsClient
type ReplicaLoadInformationsClient = original.ReplicaLoadInformationsClient
type ReplicasClient = original.ReplicasClient
type ServiceDescriptionsClient = original.ServiceDescriptionsClient
type ServiceFromTemplatesClient = original.ServiceFromTemplatesClient
type ServiceGroupDescriptionsClient = original.ServiceGroupDescriptionsClient
type ServiceGroupFromTemplatesClient = original.ServiceGroupFromTemplatesClient
type ServiceGroupMembersClient = original.ServiceGroupMembersClient
type ServiceGroupsClient = original.ServiceGroupsClient
type ServiceHealthsClient = original.ServiceHealthsClient
type ServiceManifestsClient = original.ServiceManifestsClient
type ServicesClient = original.ServicesClient
type ServiceTypesClient = original.ServiceTypesClient
type UpgradeProgressesClient = original.UpgradeProgressesClient

func NewApplicationHealthsClient(timeout *int32) ApplicationHealthsClient {
	return original.NewApplicationHealthsClient(timeout)
}
func NewApplicationHealthsClientWithBaseURI(baseURI string, timeout *int32) ApplicationHealthsClient {
	return original.NewApplicationHealthsClientWithBaseURI(baseURI, timeout)
}
func NewApplicationManifestsClient(timeout *int32) ApplicationManifestsClient {
	return original.NewApplicationManifestsClient(timeout)
}
func NewApplicationManifestsClientWithBaseURI(baseURI string, timeout *int32) ApplicationManifestsClient {
	return original.NewApplicationManifestsClientWithBaseURI(baseURI, timeout)
}
func NewApplicationsClient(timeout *int32) ApplicationsClient {
	return original.NewApplicationsClient(timeout)
}
func NewApplicationsClientWithBaseURI(baseURI string, timeout *int32) ApplicationsClient {
	return original.NewApplicationsClientWithBaseURI(baseURI, timeout)
}
func NewApplicationTypesClient(timeout *int32) ApplicationTypesClient {
	return original.NewApplicationTypesClient(timeout)
}
func NewApplicationTypesClientWithBaseURI(baseURI string, timeout *int32) ApplicationTypesClient {
	return original.NewApplicationTypesClientWithBaseURI(baseURI, timeout)
}
func NewApplicationUpgradeRollbacksClient(timeout *int32) ApplicationUpgradeRollbacksClient {
	return original.NewApplicationUpgradeRollbacksClient(timeout)
}
func NewApplicationUpgradeRollbacksClientWithBaseURI(baseURI string, timeout *int32) ApplicationUpgradeRollbacksClient {
	return original.NewApplicationUpgradeRollbacksClientWithBaseURI(baseURI, timeout)
}
func NewApplicationUpgradesClient(timeout *int32) ApplicationUpgradesClient {
	return original.NewApplicationUpgradesClient(timeout)
}
func NewApplicationUpgradesClientWithBaseURI(baseURI string, timeout *int32) ApplicationUpgradesClient {
	return original.NewApplicationUpgradesClientWithBaseURI(baseURI, timeout)
}
func New(timeout *int32) BaseClient {
	return original.New(timeout)
}
func NewWithBaseURI(baseURI string, timeout *int32) BaseClient {
	return original.NewWithBaseURI(baseURI, timeout)
}
func NewClusterHealthsClient(timeout *int32) ClusterHealthsClient {
	return original.NewClusterHealthsClient(timeout)
}
func NewClusterHealthsClientWithBaseURI(baseURI string, timeout *int32) ClusterHealthsClient {
	return original.NewClusterHealthsClientWithBaseURI(baseURI, timeout)
}
func NewClusterLoadInformationsClient(timeout *int32) ClusterLoadInformationsClient {
	return original.NewClusterLoadInformationsClient(timeout)
}
func NewClusterLoadInformationsClientWithBaseURI(baseURI string, timeout *int32) ClusterLoadInformationsClient {
	return original.NewClusterLoadInformationsClientWithBaseURI(baseURI, timeout)
}
func NewClusterManifestsClient(timeout *int32) ClusterManifestsClient {
	return original.NewClusterManifestsClient(timeout)
}
func NewClusterManifestsClientWithBaseURI(baseURI string, timeout *int32) ClusterManifestsClient {
	return original.NewClusterManifestsClientWithBaseURI(baseURI, timeout)
}
func NewClusterPackagesClient(timeout *int32) ClusterPackagesClient {
	return original.NewClusterPackagesClient(timeout)
}
func NewClusterPackagesClientWithBaseURI(baseURI string, timeout *int32) ClusterPackagesClient {
	return original.NewClusterPackagesClientWithBaseURI(baseURI, timeout)
}
func NewClusterUpgradesClient(timeout *int32) ClusterUpgradesClient {
	return original.NewClusterUpgradesClient(timeout)
}
func NewClusterUpgradesClientWithBaseURI(baseURI string, timeout *int32) ClusterUpgradesClient {
	return original.NewClusterUpgradesClientWithBaseURI(baseURI, timeout)
}
func NewDeployedApplicationHealthsClient(timeout *int32) DeployedApplicationHealthsClient {
	return original.NewDeployedApplicationHealthsClient(timeout)
}
func NewDeployedApplicationHealthsClientWithBaseURI(baseURI string, timeout *int32) DeployedApplicationHealthsClient {
	return original.NewDeployedApplicationHealthsClientWithBaseURI(baseURI, timeout)
}
func NewDeployedApplicationsClient(timeout *int32) DeployedApplicationsClient {
	return original.NewDeployedApplicationsClient(timeout)
}
func NewDeployedApplicationsClientWithBaseURI(baseURI string, timeout *int32) DeployedApplicationsClient {
	return original.NewDeployedApplicationsClientWithBaseURI(baseURI, timeout)
}
func NewDeployedCodePackagesClient(timeout *int32) DeployedCodePackagesClient {
	return original.NewDeployedCodePackagesClient(timeout)
}
func NewDeployedCodePackagesClientWithBaseURI(baseURI string, timeout *int32) DeployedCodePackagesClient {
	return original.NewDeployedCodePackagesClientWithBaseURI(baseURI, timeout)
}
func NewDeployedReplicaDetailsClient(timeout *int32) DeployedReplicaDetailsClient {
	return original.NewDeployedReplicaDetailsClient(timeout)
}
func NewDeployedReplicaDetailsClientWithBaseURI(baseURI string, timeout *int32) DeployedReplicaDetailsClient {
	return original.NewDeployedReplicaDetailsClientWithBaseURI(baseURI, timeout)
}
func NewDeployedReplicasClient(timeout *int32) DeployedReplicasClient {
	return original.NewDeployedReplicasClient(timeout)
}
func NewDeployedReplicasClientWithBaseURI(baseURI string, timeout *int32) DeployedReplicasClient {
	return original.NewDeployedReplicasClientWithBaseURI(baseURI, timeout)
}
func NewDeployedServicePackageHealthsClient(timeout *int32) DeployedServicePackageHealthsClient {
	return original.NewDeployedServicePackageHealthsClient(timeout)
}
func NewDeployedServicePackageHealthsClientWithBaseURI(baseURI string, timeout *int32) DeployedServicePackageHealthsClient {
	return original.NewDeployedServicePackageHealthsClientWithBaseURI(baseURI, timeout)
}
func NewDeployedServicePackagesClient(timeout *int32) DeployedServicePackagesClient {
	return original.NewDeployedServicePackagesClient(timeout)
}
func NewDeployedServicePackagesClientWithBaseURI(baseURI string, timeout *int32) DeployedServicePackagesClient {
	return original.NewDeployedServicePackagesClientWithBaseURI(baseURI, timeout)
}
func NewDeployedServiceTypesClient(timeout *int32) DeployedServiceTypesClient {
	return original.NewDeployedServiceTypesClient(timeout)
}
func NewDeployedServiceTypesClientWithBaseURI(baseURI string, timeout *int32) DeployedServiceTypesClient {
	return original.NewDeployedServiceTypesClientWithBaseURI(baseURI, timeout)
}
func PossibleAggregatedHealthStateValues() []AggregatedHealthState {
	return original.PossibleAggregatedHealthStateValues()
}
func PossibleAggregatedHealthState1Values() []AggregatedHealthState1 {
	return original.PossibleAggregatedHealthState1Values()
}
func PossibleAggregatedHealthState10Values() []AggregatedHealthState10 {
	return original.PossibleAggregatedHealthState10Values()
}
func PossibleAggregatedHealthState11Values() []AggregatedHealthState11 {
	return original.PossibleAggregatedHealthState11Values()
}
func PossibleAggregatedHealthState12Values() []AggregatedHealthState12 {
	return original.PossibleAggregatedHealthState12Values()
}
func PossibleAggregatedHealthState13Values() []AggregatedHealthState13 {
	return original.PossibleAggregatedHealthState13Values()
}
func PossibleAggregatedHealthState14Values() []AggregatedHealthState14 {
	return original.PossibleAggregatedHealthState14Values()
}
func PossibleAggregatedHealthState15Values() []AggregatedHealthState15 {
	return original.PossibleAggregatedHealthState15Values()
}
func PossibleAggregatedHealthState2Values() []AggregatedHealthState2 {
	return original.PossibleAggregatedHealthState2Values()
}
func PossibleAggregatedHealthState3Values() []AggregatedHealthState3 {
	return original.PossibleAggregatedHealthState3Values()
}
func PossibleAggregatedHealthState4Values() []AggregatedHealthState4 {
	return original.PossibleAggregatedHealthState4Values()
}
func PossibleAggregatedHealthState5Values() []AggregatedHealthState5 {
	return original.PossibleAggregatedHealthState5Values()
}
func PossibleAggregatedHealthState6Values() []AggregatedHealthState6 {
	return original.PossibleAggregatedHealthState6Values()
}
func PossibleAggregatedHealthState7Values() []AggregatedHealthState7 {
	return original.PossibleAggregatedHealthState7Values()
}
func PossibleAggregatedHealthState8Values() []AggregatedHealthState8 {
	return original.PossibleAggregatedHealthState8Values()
}
func PossibleAggregatedHealthState9Values() []AggregatedHealthState9 {
	return original.PossibleAggregatedHealthState9Values()
}
func PossibleDeactivationIntentValues() []DeactivationIntent {
	return original.PossibleDeactivationIntentValues()
}
func PossibleDefaultMoveCostValues() []DefaultMoveCost {
	return original.PossibleDefaultMoveCostValues()
}
func PossibleDefaultMoveCost1Values() []DefaultMoveCost1 {
	return original.PossibleDefaultMoveCost1Values()
}
func PossibleDefaultMoveCost2Values() []DefaultMoveCost2 {
	return original.PossibleDefaultMoveCost2Values()
}
func PossibleDefaultMoveCost3Values() []DefaultMoveCost3 {
	return original.PossibleDefaultMoveCost3Values()
}
func PossibleFailureReasonValues() []FailureReason {
	return original.PossibleFailureReasonValues()
}
func PossibleFailureReason1Values() []FailureReason1 {
	return original.PossibleFailureReason1Values()
}
func PossibleHealthStateValues() []HealthState {
	return original.PossibleHealthStateValues()
}
func PossibleHealthState1Values() []HealthState1 {
	return original.PossibleHealthState1Values()
}
func PossibleHealthState2Values() []HealthState2 {
	return original.PossibleHealthState2Values()
}
func PossibleHealthState3Values() []HealthState3 {
	return original.PossibleHealthState3Values()
}
func PossibleHealthState4Values() []HealthState4 {
	return original.PossibleHealthState4Values()
}
func PossibleHealthState5Values() []HealthState5 {
	return original.PossibleHealthState5Values()
}
func PossibleHealthState6Values() []HealthState6 {
	return original.PossibleHealthState6Values()
}
func PossibleKindValues() []Kind {
	return original.PossibleKindValues()
}
func PossibleNodeDeactivationIntentValues() []NodeDeactivationIntent {
	return original.PossibleNodeDeactivationIntentValues()
}
func PossibleNodeDeactivationStatusValues() []NodeDeactivationStatus {
	return original.PossibleNodeDeactivationStatusValues()
}
func PossibleNodeStatusValues() []NodeStatus {
	return original.PossibleNodeStatusValues()
}
func PossiblePartitionSchemeValues() []PartitionScheme {
	return original.PossiblePartitionSchemeValues()
}
func PossiblePartitionStatusValues() []PartitionStatus {
	return original.PossiblePartitionStatusValues()
}
func PossibleReplicaRoleValues() []ReplicaRole {
	return original.PossibleReplicaRoleValues()
}
func PossibleReplicaRole1Values() []ReplicaRole1 {
	return original.PossibleReplicaRole1Values()
}
func PossibleReplicaStatusValues() []ReplicaStatus {
	return original.PossibleReplicaStatusValues()
}
func PossibleReplicaStatus1Values() []ReplicaStatus1 {
	return original.PossibleReplicaStatus1Values()
}
func PossibleRollingUpgradeModeValues() []RollingUpgradeMode {
	return original.PossibleRollingUpgradeModeValues()
}
func PossibleRollingUpgradeMode1Values() []RollingUpgradeMode1 {
	return original.PossibleRollingUpgradeMode1Values()
}
func PossibleRollingUpgradeMode2Values() []RollingUpgradeMode2 {
	return original.PossibleRollingUpgradeMode2Values()
}
func PossibleRollingUpgradeMode3Values() []RollingUpgradeMode3 {
	return original.PossibleRollingUpgradeMode3Values()
}
func PossibleRollingUpgradeMode4Values() []RollingUpgradeMode4 {
	return original.PossibleRollingUpgradeMode4Values()
}
func PossibleRollingUpgradeMode5Values() []RollingUpgradeMode5 {
	return original.PossibleRollingUpgradeMode5Values()
}
func PossibleServiceCorrelationSchemeValues() []ServiceCorrelationScheme {
	return original.PossibleServiceCorrelationSchemeValues()
}
func PossibleServiceKindValues() []ServiceKind {
	return original.PossibleServiceKindValues()
}
func PossibleServiceKind1Values() []ServiceKind1 {
	return original.PossibleServiceKind1Values()
}
func PossibleServiceKind2Values() []ServiceKind2 {
	return original.PossibleServiceKind2Values()
}
func PossibleServiceKind3Values() []ServiceKind3 {
	return original.PossibleServiceKind3Values()
}
func PossibleServiceKind4Values() []ServiceKind4 {
	return original.PossibleServiceKind4Values()
}
func PossibleServiceKind5Values() []ServiceKind5 {
	return original.PossibleServiceKind5Values()
}
func PossibleServiceKind6Values() []ServiceKind6 {
	return original.PossibleServiceKind6Values()
}
func PossibleServiceKindBasicCreateServiceDescriptionValues() []ServiceKindBasicCreateServiceDescription {
	return original.PossibleServiceKindBasicCreateServiceDescriptionValues()
}
func PossibleServiceKindBasicCreateServiceGroupDescriptionValues() []ServiceKindBasicCreateServiceGroupDescription {
	return original.PossibleServiceKindBasicCreateServiceGroupDescriptionValues()
}
func PossibleServiceKindBasicServiceDescriptionValues() []ServiceKindBasicServiceDescription {
	return original.PossibleServiceKindBasicServiceDescriptionValues()
}
func PossibleServiceKindBasicServiceGroupDescriptionValues() []ServiceKindBasicServiceGroupDescription {
	return original.PossibleServiceKindBasicServiceGroupDescriptionValues()
}
func PossibleServiceKindBasicUpdateServiceDescriptionValues() []ServiceKindBasicUpdateServiceDescription {
	return original.PossibleServiceKindBasicUpdateServiceDescriptionValues()
}
func PossibleServiceKindBasicUpdateServiceGroupDescriptionValues() []ServiceKindBasicUpdateServiceGroupDescription {
	return original.PossibleServiceKindBasicUpdateServiceGroupDescriptionValues()
}
func PossibleServiceLoadMetricWeightValues() []ServiceLoadMetricWeight {
	return original.PossibleServiceLoadMetricWeightValues()
}
func PossibleServicePartitionKindValues() []ServicePartitionKind {
	return original.PossibleServicePartitionKindValues()
}
func PossibleServiceStatusValues() []ServiceStatus {
	return original.PossibleServiceStatusValues()
}
func PossibleUpgradeKindValues() []UpgradeKind {
	return original.PossibleUpgradeKindValues()
}
func PossibleUpgradeStateValues() []UpgradeState {
	return original.PossibleUpgradeStateValues()
}
func PossibleUpgradeState1Values() []UpgradeState1 {
	return original.PossibleUpgradeState1Values()
}
func NewNodeHealthsClient(timeout *int32) NodeHealthsClient {
	return original.NewNodeHealthsClient(timeout)
}
func NewNodeHealthsClientWithBaseURI(baseURI string, timeout *int32) NodeHealthsClient {
	return original.NewNodeHealthsClientWithBaseURI(baseURI, timeout)
}
func NewNodeLoadInformationsClient(timeout *int32) NodeLoadInformationsClient {
	return original.NewNodeLoadInformationsClient(timeout)
}
func NewNodeLoadInformationsClientWithBaseURI(baseURI string, timeout *int32) NodeLoadInformationsClient {
	return original.NewNodeLoadInformationsClientWithBaseURI(baseURI, timeout)
}
func NewNodesClient(timeout *int32) NodesClient {
	return original.NewNodesClient(timeout)
}
func NewNodesClientWithBaseURI(baseURI string, timeout *int32) NodesClient {
	return original.NewNodesClientWithBaseURI(baseURI, timeout)
}
func NewNodeStatesClient(timeout *int32) NodeStatesClient {
	return original.NewNodeStatesClient(timeout)
}
func NewNodeStatesClientWithBaseURI(baseURI string, timeout *int32) NodeStatesClient {
	return original.NewNodeStatesClientWithBaseURI(baseURI, timeout)
}
func NewPartitionHealthsClient(timeout *int32) PartitionHealthsClient {
	return original.NewPartitionHealthsClient(timeout)
}
func NewPartitionHealthsClientWithBaseURI(baseURI string, timeout *int32) PartitionHealthsClient {
	return original.NewPartitionHealthsClientWithBaseURI(baseURI, timeout)
}
func NewPartitionListsClient(timeout *int32) PartitionListsClient {
	return original.NewPartitionListsClient(timeout)
}
func NewPartitionListsClientWithBaseURI(baseURI string, timeout *int32) PartitionListsClient {
	return original.NewPartitionListsClientWithBaseURI(baseURI, timeout)
}
func NewPartitionLoadInformationsClient(timeout *int32) PartitionLoadInformationsClient {
	return original.NewPartitionLoadInformationsClient(timeout)
}
func NewPartitionLoadInformationsClientWithBaseURI(baseURI string, timeout *int32) PartitionLoadInformationsClient {
	return original.NewPartitionLoadInformationsClientWithBaseURI(baseURI, timeout)
}
func NewPartitionLoadsClient(timeout *int32) PartitionLoadsClient {
	return original.NewPartitionLoadsClient(timeout)
}
func NewPartitionLoadsClientWithBaseURI(baseURI string, timeout *int32) PartitionLoadsClient {
	return original.NewPartitionLoadsClientWithBaseURI(baseURI, timeout)
}
func NewPartitionsClient(timeout *int32) PartitionsClient {
	return original.NewPartitionsClient(timeout)
}
func NewPartitionsClientWithBaseURI(baseURI string, timeout *int32) PartitionsClient {
	return original.NewPartitionsClientWithBaseURI(baseURI, timeout)
}
func NewReplicaHealthsClient(timeout *int32) ReplicaHealthsClient {
	return original.NewReplicaHealthsClient(timeout)
}
func NewReplicaHealthsClientWithBaseURI(baseURI string, timeout *int32) ReplicaHealthsClient {
	return original.NewReplicaHealthsClientWithBaseURI(baseURI, timeout)
}
func NewReplicaLoadInformationsClient(timeout *int32) ReplicaLoadInformationsClient {
	return original.NewReplicaLoadInformationsClient(timeout)
}
func NewReplicaLoadInformationsClientWithBaseURI(baseURI string, timeout *int32) ReplicaLoadInformationsClient {
	return original.NewReplicaLoadInformationsClientWithBaseURI(baseURI, timeout)
}
func NewReplicasClient(timeout *int32) ReplicasClient {
	return original.NewReplicasClient(timeout)
}
func NewReplicasClientWithBaseURI(baseURI string, timeout *int32) ReplicasClient {
	return original.NewReplicasClientWithBaseURI(baseURI, timeout)
}
func NewServiceDescriptionsClient(timeout *int32) ServiceDescriptionsClient {
	return original.NewServiceDescriptionsClient(timeout)
}
func NewServiceDescriptionsClientWithBaseURI(baseURI string, timeout *int32) ServiceDescriptionsClient {
	return original.NewServiceDescriptionsClientWithBaseURI(baseURI, timeout)
}
func NewServiceFromTemplatesClient(timeout *int32) ServiceFromTemplatesClient {
	return original.NewServiceFromTemplatesClient(timeout)
}
func NewServiceFromTemplatesClientWithBaseURI(baseURI string, timeout *int32) ServiceFromTemplatesClient {
	return original.NewServiceFromTemplatesClientWithBaseURI(baseURI, timeout)
}
func NewServiceGroupDescriptionsClient(timeout *int32) ServiceGroupDescriptionsClient {
	return original.NewServiceGroupDescriptionsClient(timeout)
}
func NewServiceGroupDescriptionsClientWithBaseURI(baseURI string, timeout *int32) ServiceGroupDescriptionsClient {
	return original.NewServiceGroupDescriptionsClientWithBaseURI(baseURI, timeout)
}
func NewServiceGroupFromTemplatesClient(timeout *int32) ServiceGroupFromTemplatesClient {
	return original.NewServiceGroupFromTemplatesClient(timeout)
}
func NewServiceGroupFromTemplatesClientWithBaseURI(baseURI string, timeout *int32) ServiceGroupFromTemplatesClient {
	return original.NewServiceGroupFromTemplatesClientWithBaseURI(baseURI, timeout)
}
func NewServiceGroupMembersClient(timeout *int32) ServiceGroupMembersClient {
	return original.NewServiceGroupMembersClient(timeout)
}
func NewServiceGroupMembersClientWithBaseURI(baseURI string, timeout *int32) ServiceGroupMembersClient {
	return original.NewServiceGroupMembersClientWithBaseURI(baseURI, timeout)
}
func NewServiceGroupsClient(timeout *int32) ServiceGroupsClient {
	return original.NewServiceGroupsClient(timeout)
}
func NewServiceGroupsClientWithBaseURI(baseURI string, timeout *int32) ServiceGroupsClient {
	return original.NewServiceGroupsClientWithBaseURI(baseURI, timeout)
}
func NewServiceHealthsClient(timeout *int32) ServiceHealthsClient {
	return original.NewServiceHealthsClient(timeout)
}
func NewServiceHealthsClientWithBaseURI(baseURI string, timeout *int32) ServiceHealthsClient {
	return original.NewServiceHealthsClientWithBaseURI(baseURI, timeout)
}
func NewServiceManifestsClient(timeout *int32) ServiceManifestsClient {
	return original.NewServiceManifestsClient(timeout)
}
func NewServiceManifestsClientWithBaseURI(baseURI string, timeout *int32) ServiceManifestsClient {
	return original.NewServiceManifestsClientWithBaseURI(baseURI, timeout)
}
func NewServicesClient(timeout *int32) ServicesClient {
	return original.NewServicesClient(timeout)
}
func NewServicesClientWithBaseURI(baseURI string, timeout *int32) ServicesClient {
	return original.NewServicesClientWithBaseURI(baseURI, timeout)
}
func NewServiceTypesClient(timeout *int32) ServiceTypesClient {
	return original.NewServiceTypesClient(timeout)
}
func NewServiceTypesClientWithBaseURI(baseURI string, timeout *int32) ServiceTypesClient {
	return original.NewServiceTypesClientWithBaseURI(baseURI, timeout)
}
func NewUpgradeProgressesClient(timeout *int32) UpgradeProgressesClient {
	return original.NewUpgradeProgressesClient(timeout)
}
func NewUpgradeProgressesClientWithBaseURI(baseURI string, timeout *int32) UpgradeProgressesClient {
	return original.NewUpgradeProgressesClientWithBaseURI(baseURI, timeout)
}
func UserAgent() string {
	return original.UserAgent() + " profiles/latest"
}
func Version() string {
	return original.Version()
}
